# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class GetInstanceSerialPortResult:
    """
    A collection of values returned by getInstanceSerialPort.
    """
    def __init__(__self__, contents=None, id=None, instance=None, port=None, project=None, zone=None):
        if contents and not isinstance(contents, str):
            raise TypeError("Expected argument 'contents' to be a str")
        __self__.contents = contents
        """
        The output of the serial port. Serial port output is available only when the VM instance is running, and logs are limited to the most recent 1 MB of output per port.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if instance and not isinstance(instance, str):
            raise TypeError("Expected argument 'instance' to be a str")
        __self__.instance = instance
        if port and not isinstance(port, float):
            raise TypeError("Expected argument 'port' to be a float")
        __self__.port = port
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        __self__.project = project
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        __self__.zone = zone
class AwaitableGetInstanceSerialPortResult(GetInstanceSerialPortResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceSerialPortResult(
            contents=self.contents,
            id=self.id,
            instance=self.instance,
            port=self.port,
            project=self.project,
            zone=self.zone)

def get_instance_serial_port(instance=None,port=None,project=None,zone=None,opts=None):
    """
    Get the serial port output from a Compute Instance. For more information see
    the official [API](https://cloud.google.com/compute/docs/instances/viewing-serial-port-output) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    serial = gcp.compute.get_instance_serial_port(instance="my-instance",
        zone="us-central1-a",
        port=1)
    pulumi.export("serialOut", serial.contents)
    ```

    Using the serial port output to generate a windows password, derived from the [official guide](https://cloud.google.com/compute/docs/instances/windows/automate-pw-generation):

    ```python
    import pulumi
    import json
    import pulumi_gcp as gcp

    windows = gcp.compute.Instance("windows",
        machine_type="n1-standard-1",
        zone="us-central1-a",
        boot_disk={
            "initialize_params": {
                "image": "gce-uefi-images/windows-2019",
            },
        },
        network_interface=[{
            "network": "default",
            "access_config": [{}],
        }],
        metadata={
            "serial-port-logging-enable": "TRUE",
            "windows-keys": json.dumps({
                "email": "example.user@example.com",
                "expireOn": "2020-04-14T01:37:19Z",
                "exponent": "AQAB",
                "modulus": "wgsquN4IBNPqIUnu+h/5Za1kujb2YRhX1vCQVQAkBwnWigcCqOBVfRa5JoZfx6KIvEXjWqa77jPvlsxM4WPqnDIM2qiK36up3SKkYwFjff6F2ni/ry8vrwXCX3sGZ1hbIHlK0O012HpA3ISeEswVZmX2X67naOvJXfY5v0hGPWqCADao+xVxrmxsZD4IWnKl1UaZzI5lhAzr8fw6utHwx1EZ/MSgsEki6tujcZfN+GUDRnmJGQSnPTXmsf7Q4DKreTZk49cuyB3prV91S0x3DYjCUpSXrkVy1Ha5XicGD/q+ystuFsJnrrhbNXJbpSjM6sjo/aduAkZJl4FmOt0R7Q==",
                "userName": "example-user",
            }),
        },
        service_account={
            "scopes": [
                "userinfo-email",
                "compute-ro",
                "storage-ro",
            ],
        })
    serial = pulumi.Output.all(windows.name, windows.zone).apply(lambda name, zone: gcp.compute.get_instance_serial_port(instance=name,
        zone=zone,
        port=4))
    pulumi.export("serialOut", serial.contents)
    ```


    :param str instance: The name of the Compute Instance to read output from.
    :param float port: The number of the serial port to read output from. Possible values are 1-4.
    :param str project: The project in which the Compute Instance exists. If it
           is not provided, the provider project is used.
    :param str zone: The zone in which the Compute Instance exists.
           If it is not provided, the provider zone is used.
    """
    __args__ = dict()


    __args__['instance'] = instance
    __args__['port'] = port
    __args__['project'] = project
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:compute/getInstanceSerialPort:getInstanceSerialPort', __args__, opts=opts).value

    return AwaitableGetInstanceSerialPortResult(
        contents=__ret__.get('contents'),
        id=__ret__.get('id'),
        instance=__ret__.get('instance'),
        port=__ret__.get('port'),
        project=__ret__.get('project'),
        zone=__ret__.get('zone'))
