# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class Project(pulumi.CustomResource):
    display_name: pulumi.Output[str]
    """
    The GCP project display name
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    project_number: pulumi.Output[str]
    """
    The number of the google project that firebase is enabled on.
    """
    def __init__(__self__, resource_name, opts=None, project=None, __props__=None, __name__=None, __opts__=None):
        """
        A Google Cloud Firebase instance. This enables Firebase resources on a given google project.
        Since a FirebaseProject is actually also a GCP Project, a FirebaseProject uses underlying GCP
        identifiers (most importantly, the projectId) as its own for easy interop with GCP APIs.

        Once Firebase has been added to a Google Project it cannot be removed.

        To get more information about Project, see:

        * [API documentation](https://firebase.google.com/docs/projects/api/reference/rest/v1beta1/projects)
        * How-to Guides
            * [Official Documentation](https://firebase.google.com/)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['project'] = project
            __props__['display_name'] = None
            __props__['project_number'] = None
        super(Project, __self__).__init__(
            'gcp:firebase/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, display_name=None, project=None, project_number=None):
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: The GCP project display name
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] project_number: The number of the google project that firebase is enabled on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["display_name"] = display_name
        __props__["project"] = project
        __props__["project_number"] = project_number
        return Project(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
