# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class Instance(pulumi.CustomResource):
    accelerator_config: pulumi.Output[dict]
    """
    The hardware accelerator used on this instance. If you use accelerators,
    make sure that your configuration has enough vCPUs and memory to support the
    machineType you have selected.  Structure is documented below.

      * `coreCount` (`float`) - Count of cores of this accelerator.
      * `type` (`str`) - Type of this accelerator.
    """
    boot_disk_size_gb: pulumi.Output[float]
    """
    The size of the boot disk in GB attached to this instance,
    up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
    If not specified, this defaults to 100.
    """
    boot_disk_type: pulumi.Output[str]
    """
    Possible disk types for notebook instances.
    """
    container_image: pulumi.Output[dict]
    """
    Use a container image to start the notebook instance.  Structure is documented below.

      * `repository` (`str`) - The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
      * `tag` (`str`) - The tag of the container image. If not specified, this defaults to the latest tag.
    """
    create_time: pulumi.Output[str]
    """
    Instance creation time
    """
    custom_gpu_driver_path: pulumi.Output[str]
    """
    Specify a custom Cloud Storage path where the GPU driver is stored.
    If not specified, we'll automatically choose from official GPU drivers.
    """
    data_disk_size_gb: pulumi.Output[float]
    """
    The size of the data disk in GB attached to this instance,
    up to a maximum of 64000 GB (64 TB).
    You can choose the size of the data disk based on how big your notebooks and data are.
    If not specified, this defaults to 100.
    """
    data_disk_type: pulumi.Output[str]
    """
    Possible disk types for notebook instances.
    """
    disk_encryption: pulumi.Output[str]
    """
    Disk encryption method used on the boot and data disks, defaults to GMEK.
    """
    install_gpu_driver: pulumi.Output[bool]
    """
    Indicates that this is a boot disk. The virtual machine will
    use the first partition of the disk for its root filesystem.
    """
    instance_owners: pulumi.Output[str]
    """
    The owner of this instance after creation.
    Format: alias@example.com.
    Currently supports one owner only.
    If not specified, all of the service account users of
    your VM instance's service account can use the instance.
    """
    kms_key: pulumi.Output[str]
    """
    The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
    Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
    """
    labels: pulumi.Output[dict]
    """
    Labels to apply to this instance. These can be later modified by the setLabels method.
    An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    """
    location: pulumi.Output[str]
    """
    A reference to the zone where the machine resides.
    """
    machine_type: pulumi.Output[str]
    """
    A reference to a machine type which defines VM kind.
    """
    metadata: pulumi.Output[dict]
    """
    Custom metadata to apply to this instance.
    An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    """
    name: pulumi.Output[str]
    """
    The name specified for the Notebook instance.
    """
    network: pulumi.Output[str]
    """
    The name of the VPC that this instance is in.
    Format: projects/{project_id}/global/networks/{network_id}
    """
    no_proxy_access: pulumi.Output[bool]
    """
    the notebook instance will not register with the proxy..
    """
    no_public_ip: pulumi.Output[bool]
    """
    no public IP will be assigned to this instance.
    """
    no_remove_data_disk: pulumi.Output[bool]
    """
    If true, the data disk will not be auto deleted when deleting the instance.
    """
    post_startup_script: pulumi.Output[str]
    """
    Path to a Bash script that automatically runs after a
    notebook instance fully boots up. The path must be a URL
    or Cloud Storage path (gs://path-to-file/file-name).
    """
    project: pulumi.Output[str]
    """
    The name of the Google Cloud project that this VM image belongs to.
    Format: projects/{project_id}
    """
    proxy_uri: pulumi.Output[str]
    """
    The proxy endpoint that is used to access the Jupyter notebook.
    """
    service_account: pulumi.Output[str]
    """
    The service account on this instance, giving access to other
    Google Cloud services. You can use any service account within
    the same project, but you must have the service account user
    permission to use the instance. If not specified,
    the Compute Engine default service account is used.
    """
    state: pulumi.Output[str]
    """
    The state of this instance.
    """
    subnet: pulumi.Output[str]
    """
    The name of the subnet that this instance is in.
    Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
    """
    update_time: pulumi.Output[str]
    """
    Instance update time.
    """
    vm_image: pulumi.Output[dict]
    """
    Use a Compute Engine VM image to start the notebook instance.  Structure is documented below.

      * `imageFamily` (`str`) - Use this VM image family to find the image; the newest image in this family will be used.
      * `imageName` (`str`) - Use VM image name to find the image.
      * `project` (`str`) - The name of the Google Cloud project that this VM image belongs to.
        Format: projects/{project_id}
    """
    def __init__(__self__, resource_name, opts=None, accelerator_config=None, boot_disk_size_gb=None, boot_disk_type=None, container_image=None, create_time=None, custom_gpu_driver_path=None, data_disk_size_gb=None, data_disk_type=None, disk_encryption=None, install_gpu_driver=None, instance_owners=None, kms_key=None, labels=None, location=None, machine_type=None, metadata=None, name=None, network=None, no_proxy_access=None, no_public_ip=None, no_remove_data_disk=None, post_startup_script=None, project=None, service_account=None, subnet=None, update_time=None, vm_image=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] accelerator_config: The hardware accelerator used on this instance. If you use accelerators,
               make sure that your configuration has enough vCPUs and memory to support the
               machineType you have selected.  Structure is documented below.
        :param pulumi.Input[float] boot_disk_size_gb: The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Possible disk types for notebook instances.
        :param pulumi.Input[dict] container_image: Use a container image to start the notebook instance.  Structure is documented below.
        :param pulumi.Input[str] create_time: Instance creation time
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[float] data_disk_size_gb: The size of the data disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB).
               You can choose the size of the data disk based on how big your notebooks and data are.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Possible disk types for notebook instances.
        :param pulumi.Input[str] disk_encryption: Disk encryption method used on the boot and data disks, defaults to GMEK.
        :param pulumi.Input[bool] install_gpu_driver: Indicates that this is a boot disk. The virtual machine will
               use the first partition of the disk for its root filesystem.
        :param pulumi.Input[str] instance_owners: The owner of this instance after creation.
               Format: alias@example.com.
               Currently supports one owner only.
               If not specified, all of the service account users of
               your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
               Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        :param pulumi.Input[dict] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
        :param pulumi.Input[str] machine_type: A reference to a machine type which defines VM kind.
        :param pulumi.Input[dict] metadata: Custom metadata to apply to this instance.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The name specified for the Notebook instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in.
               Format: projects/{project_id}/global/networks/{network_id}
        :param pulumi.Input[bool] no_proxy_access: the notebook instance will not register with the proxy..
        :param pulumi.Input[bool] no_public_ip: no public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a
               notebook instance fully boots up. The path must be a URL
               or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other
               Google Cloud services. You can use any service account within
               the same project, but you must have the service account user
               permission to use the instance. If not specified,
               the Compute Engine default service account is used.
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in.
               Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        :param pulumi.Input[str] update_time: Instance update time.
        :param pulumi.Input[dict] vm_image: Use a Compute Engine VM image to start the notebook instance.  Structure is documented below.

        The **accelerator_config** object supports the following:

          * `coreCount` (`pulumi.Input[float]`) - Count of cores of this accelerator.
          * `type` (`pulumi.Input[str]`) - Type of this accelerator.

        The **container_image** object supports the following:

          * `repository` (`pulumi.Input[str]`) - The path to the container image repository.
            For example: gcr.io/{project_id}/{imageName}
          * `tag` (`pulumi.Input[str]`) - The tag of the container image. If not specified, this defaults to the latest tag.

        The **vm_image** object supports the following:

          * `imageFamily` (`pulumi.Input[str]`) - Use this VM image family to find the image; the newest image in this family will be used.
          * `imageName` (`pulumi.Input[str]`) - Use VM image name to find the image.
          * `project` (`pulumi.Input[str]`) - The name of the Google Cloud project that this VM image belongs to.
            Format: projects/{project_id}
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accelerator_config'] = accelerator_config
            __props__['boot_disk_size_gb'] = boot_disk_size_gb
            __props__['boot_disk_type'] = boot_disk_type
            __props__['container_image'] = container_image
            __props__['create_time'] = create_time
            __props__['custom_gpu_driver_path'] = custom_gpu_driver_path
            __props__['data_disk_size_gb'] = data_disk_size_gb
            __props__['data_disk_type'] = data_disk_type
            __props__['disk_encryption'] = disk_encryption
            __props__['install_gpu_driver'] = install_gpu_driver
            __props__['instance_owners'] = instance_owners
            __props__['kms_key'] = kms_key
            __props__['labels'] = labels
            if location is None:
                raise TypeError("Missing required property 'location'")
            __props__['location'] = location
            if machine_type is None:
                raise TypeError("Missing required property 'machine_type'")
            __props__['machine_type'] = machine_type
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['network'] = network
            __props__['no_proxy_access'] = no_proxy_access
            __props__['no_public_ip'] = no_public_ip
            __props__['no_remove_data_disk'] = no_remove_data_disk
            __props__['post_startup_script'] = post_startup_script
            __props__['project'] = project
            __props__['service_account'] = service_account
            __props__['subnet'] = subnet
            __props__['update_time'] = update_time
            __props__['vm_image'] = vm_image
            __props__['proxy_uri'] = None
            __props__['state'] = None
        super(Instance, __self__).__init__(
            'gcp:notebooks/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, accelerator_config=None, boot_disk_size_gb=None, boot_disk_type=None, container_image=None, create_time=None, custom_gpu_driver_path=None, data_disk_size_gb=None, data_disk_type=None, disk_encryption=None, install_gpu_driver=None, instance_owners=None, kms_key=None, labels=None, location=None, machine_type=None, metadata=None, name=None, network=None, no_proxy_access=None, no_public_ip=None, no_remove_data_disk=None, post_startup_script=None, project=None, proxy_uri=None, service_account=None, state=None, subnet=None, update_time=None, vm_image=None):
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] accelerator_config: The hardware accelerator used on this instance. If you use accelerators,
               make sure that your configuration has enough vCPUs and memory to support the
               machineType you have selected.  Structure is documented below.
        :param pulumi.Input[float] boot_disk_size_gb: The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Possible disk types for notebook instances.
        :param pulumi.Input[dict] container_image: Use a container image to start the notebook instance.  Structure is documented below.
        :param pulumi.Input[str] create_time: Instance creation time
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored.
               If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[float] data_disk_size_gb: The size of the data disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB).
               You can choose the size of the data disk based on how big your notebooks and data are.
               If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Possible disk types for notebook instances.
        :param pulumi.Input[str] disk_encryption: Disk encryption method used on the boot and data disks, defaults to GMEK.
        :param pulumi.Input[bool] install_gpu_driver: Indicates that this is a boot disk. The virtual machine will
               use the first partition of the disk for its root filesystem.
        :param pulumi.Input[str] instance_owners: The owner of this instance after creation.
               Format: alias@example.com.
               Currently supports one owner only.
               If not specified, all of the service account users of
               your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
               Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
        :param pulumi.Input[dict] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] location: A reference to the zone where the machine resides.
        :param pulumi.Input[str] machine_type: A reference to a machine type which defines VM kind.
        :param pulumi.Input[dict] metadata: Custom metadata to apply to this instance.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The name specified for the Notebook instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in.
               Format: projects/{project_id}/global/networks/{network_id}
        :param pulumi.Input[bool] no_proxy_access: the notebook instance will not register with the proxy..
        :param pulumi.Input[bool] no_public_ip: no public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a
               notebook instance fully boots up. The path must be a URL
               or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] project: The name of the Google Cloud project that this VM image belongs to.
               Format: projects/{project_id}
        :param pulumi.Input[str] proxy_uri: The proxy endpoint that is used to access the Jupyter notebook.
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other
               Google Cloud services. You can use any service account within
               the same project, but you must have the service account user
               permission to use the instance. If not specified,
               the Compute Engine default service account is used.
        :param pulumi.Input[str] state: The state of this instance.
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in.
               Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
        :param pulumi.Input[str] update_time: Instance update time.
        :param pulumi.Input[dict] vm_image: Use a Compute Engine VM image to start the notebook instance.  Structure is documented below.

        The **accelerator_config** object supports the following:

          * `coreCount` (`pulumi.Input[float]`) - Count of cores of this accelerator.
          * `type` (`pulumi.Input[str]`) - Type of this accelerator.

        The **container_image** object supports the following:

          * `repository` (`pulumi.Input[str]`) - The path to the container image repository.
            For example: gcr.io/{project_id}/{imageName}
          * `tag` (`pulumi.Input[str]`) - The tag of the container image. If not specified, this defaults to the latest tag.

        The **vm_image** object supports the following:

          * `imageFamily` (`pulumi.Input[str]`) - Use this VM image family to find the image; the newest image in this family will be used.
          * `imageName` (`pulumi.Input[str]`) - Use VM image name to find the image.
          * `project` (`pulumi.Input[str]`) - The name of the Google Cloud project that this VM image belongs to.
            Format: projects/{project_id}
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accelerator_config"] = accelerator_config
        __props__["boot_disk_size_gb"] = boot_disk_size_gb
        __props__["boot_disk_type"] = boot_disk_type
        __props__["container_image"] = container_image
        __props__["create_time"] = create_time
        __props__["custom_gpu_driver_path"] = custom_gpu_driver_path
        __props__["data_disk_size_gb"] = data_disk_size_gb
        __props__["data_disk_type"] = data_disk_type
        __props__["disk_encryption"] = disk_encryption
        __props__["install_gpu_driver"] = install_gpu_driver
        __props__["instance_owners"] = instance_owners
        __props__["kms_key"] = kms_key
        __props__["labels"] = labels
        __props__["location"] = location
        __props__["machine_type"] = machine_type
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["network"] = network
        __props__["no_proxy_access"] = no_proxy_access
        __props__["no_public_ip"] = no_public_ip
        __props__["no_remove_data_disk"] = no_remove_data_disk
        __props__["post_startup_script"] = post_startup_script
        __props__["project"] = project
        __props__["proxy_uri"] = proxy_uri
        __props__["service_account"] = service_account
        __props__["state"] = state
        __props__["subnet"] = subnet
        __props__["update_time"] = update_time
        __props__["vm_image"] = vm_image
        return Instance(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
