# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/vision.ipynb (unless otherwise specified).

__all__ = ['arr2im', 'im2bytes', 'check_im', 'open_im']

# Cell
import PIL,io
from ..utils import bytes_encode

# Cell
def arr2im(arr):
    "Convert array to PIL image"
    return PIL.Image.fromarray(arr,mode='RGB')

# Cell
def im2bytes(im,rt=0,format='png'):
    "Convert image to bytes/encoded bytes"
    bites=io.BytesIO()
    im.save(bites,format=format)
    bites.seek(0)
    enc=(bytes_encode(bites.read()))
    if rt==0:return enc
    if rt==1:return bites
    if rt==2:return (enc,bites)

# Cell
def check_im(im,sz=256):
    "Check size of image is same as sz"
    return im if im.size==(sz,sz) else im.resize((sz,sz))

# Cell
def open_im(im):
    "Open image"
    return PIL.Image.open(im)