## a simple example for slovene news.


from mrakun import RakunDetector
from nltk.corpus import stopwords


#blob_of_text = "Slovenska nogometna reprezentanca se je s porazom 2:3 na gostovanju na Poljskem poslovila od kvalifikacij za evropsko prvenstvo 2020. Poljska je na razprodanem stadionu v Varšavi proslavila prestižno zmago v skupini G in četrto zaporedno uvrstitev na največje tekmovanje stare celine. Slovenija znova ni izpolnila cilja – kvalifikacije je končala na skromnem četrtem mestu, daleč od uvrstitve na veliko tekmovanje.Slovenija v Varšavi ni zgolj sklenila neuspešnih kvalifikacij, ampak je hkrati odprla priprave za ligo narodov 2020. V ta namen je selektor Matjaž Kek iskal odgovore o selekciji igralcev že danes na Poljskem, ko je na igrišče poslal premešano začetno postavo in osvežil različne položaje. V obrambi je kaznovanega štoperja Aljaža Struno zamenjal Miha Blažič, na levem boku pa je namesto Bojana Jokića zaigral Jure Balkovec. Napadalec Tim Matavž je iz udarne enajsterice izrinil Andraža Šporarja, priložnost od prve minute je na sredini igrišča dobil Jaka Bijol. Prenovljena izbrana vrsta se je tako kot v celotnih kvalifikacijah tudi v Varšavi predstavila z veliko nihanji.Začelo se je z neodgovornim prekrškom Kurtića za rumeni karton že po minuti igre in hitrim vodstvom Poljske po podaji iz kota. Nič ni pomagalo, da je slovenska vrsta protestirala, da je bil v vratarjevem prostoru storjen prekršek nad Janom Oblakom, ki je začutil bolečine v ramenu. Slovenija je po zaostanku poskušala igrati in izenačila po domiselni akciji Kurtića in Iličića, ki sta izigrala Poljake, da je Matavž hladnokrvno zadel za izenačenje. Nasprotnika sta se do konca polčasa izmenjavala v premoči, na stadionu pa je najbolj završalo pred odmorom, ko je na vnaprej dogovorjeno menjavo odšel poljski branilec Piszczek in se čustveno poslovil od nastopanja za reprezentanco.Tekma v Varšavi je minila brez posebnega tekmovalnega naboja na najvišji ravni. Poteza večera je uspela prvemu zvezdniku Poljske Robertu Lewandowskemu, ki je na začetku drugega polčasa zlahka preigral vso slovensko obrambo in zadel za drugo vodstvo domačih. Slovenija je popustila v disciplini, a se je po hitri akciji natančnih podaj in zadetku Iličića vrnila v igro. V odprtem boju za zmago so bili drznejši Poljaki, ki so v zmagoviti akciji izigrali gostujočo obrambo in se oddolžili navijačem za edini poraz kvalifikacij v Stožicah. Slovenija je tekmo končala z deseterico, saj je drugi rumeni karton prejel Kurtić, Keku pa se je ponesrečila menjava Bijola z Zajcem.»V Varšavi sem videl veliko dobrih stvari, a tudi veliko neodločnosti in neodgovornosti. Prelahko smo dopustili, da so Poljaki zabili tri gole. Posamezniki bodo morali razčistiti sami pri sebi. Preslabi smo bili v hitrih reakcijah. Škoda zapravljene točke,« je za nacionalno televizijo povedal selektor Matjaž Kek."

blob_of_text = "Prehrambni trendi se v zadnjih letih obračajo h koreninam. Vedno večja skupina ozaveščenih potrošnikov goji pričakovanja po naravnih, lokalno pridelanih in preprostih izdelkih, ki ne vsebujejo dodanih sladkorjev, barvil, arom ali drugih aditivov. Potrošniki se kot odgovor na svoj življenjski slog na trgu ozirajo po avtentičnih in naravnih živilih, strokovnjaki pa to obliko nakupnega vedenja opredeljujejo kot enega najpomembnejših prehranskih trendov v letu 2019. V tujini trend opisujejo z izrazom clean label oziroma čisto označevanje: »Jasno je, da gre za potrošniško zahtevo po čistih izdelkih, ki se nanaša na preglednost označb v smislu razumljivosti. Čedalje več potrošnikov si namreč želi uživati izdelke iz naravnih in enostavnih sestavin, ki jih razumejo in jim zaupajo. Clean label pomeni kratek seznam sestavin in njihovo razumljivost. Pomeni odsotnost umetnih dodatkov,« pojasnjujejo v Ljubljanskih mlekarnah.Razvoj izdelkov mora slediti zahtevam potrošnikov V Ljubljanskih mlekarnah so pred tremi leti pričeli s projektom clean label, v okviru katerega so med drugim prenovili vse sadne jogurte blagovne znamke Mu. Pred dobrim letom pa so storili še korak naprej in predstavili novo linijo izdelkov, jogurte Mu Natur. Njihova edinstvena prednost je, da so sestavljeni zgolj iz dveh sestavin – jogurta in sadja in so trenutno edini jogurti s sadjem brez dodanega sladkorja na slovenskem tržišču. Vendar pa je razvoj izdelkov po načelu manj je več zelo zahteven. Kot pojasnjujejo v Ljubljanskih mlekarnah, je bilo ključno vprašanje pri razvoju prvega tovrstnega izdelka, kako združiti samo dve sestavini, naravni jogurt in sadje brez vseh ostalih dodatkov, hkrati pa potrošnikom predstaviti kakovosten in okusen izdelek s primerno dolgim rokom uporabe. Da jim je to uspelo, je na koncu potrdila tudi Biotehniška fakulteta Univerze v Ljubljani s certifikatom 100 % naravno. Ugledni certifikat predstavlja jamstvo potrošnikom, da bodo zaužili pristne in kakovostne izdelke, ki vsebujejo le naravno prisotna sladkorja fruktozo in galaktozo, sestavini v sadju in mleku. Biotehniška fakulteta pa je vključena tudi pri sami proizvodnji jogurtov Mu Natur, in sicer v obliki rednega preverjanja ustreznosti izdelkov. Slovenke in Slovenci izbrali nov okus jogurtov Mu Natur breskev/mango Pozitiven odziv potrošnikov na jogurte Mu Natur je na Ljubljanskih mlekarnah botroval odločitvi, da na trgu predstavijo nov okus, ki se bo pridružil jagodi in borovnici. Pri razvoju okusa so želeli narediti korak naprej, zato so vanj vključili tudi potrošnike in jih povabili, da pomagajo pri sprejemu ključne odločitve v fazi razvoja izdelka – kakšen naj bo nov okus jogurta Mu Natur? Da bi preverili mnenje potrošnikov, so v Ljubljanskih mlekarnah konec avgusta v različnih slovenskih krajih organizirali degustacije, na katerih so imeli potrošniki možnost poskusiti tri okuse jogurta Mu Natur in glasovati za najljubšega. V sproščenem vzdušju so mladi in mladi po srcu okušali vzorce, med seboj delili mnenja in se zabavali ob stand-up vložkih komika Jana Kreuzerja z ekipo. »Pripravljenost ljudi, da nam pomagajo sprejeti odločitev glede novega okusa jogurta Mu Natur, je bila nad vsemi pričakovanji. To priložnost bi izkoristili, da se zahvalimo vsem sodelujočim in jim sporočimo, da smo njihovo mnenje seveda spoštovali. Največ glasov je prejel okus Mu Natur breskev/mango, ki je v teh dneh že na voljo na prodajnih mestih po Sloveniji,« so še sporočili iz Ljubljanskih mlekarn."

hyperparameters = {"distance_threshold":5,
                   "distance_method": "editdistance",
                   "num_keywords" : 20,
                   "pair_diff_length":2,
                   "bigram_count_threshold":1,
                   "max_occurrence" : 1,
                   "max_similar" : 1,
                   "num_tokens":[1,2,3]}

keyword_detector = RakunDetector(hyperparameters)
keywords = keyword_detector.find_keywords(blob_of_text, input_type = "text")
print(keywords)
keyword_detector.default_visualization_parameters = {"top_n":15,"max_node_size":12,"min_node_size":2,"label_font_size":10,"text_color":"red","num_layout_iterations":100,"edge_width":0.08,"alpha_channel":0.5}
#keyword_detector.visualize_network()
