# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cf_clearance']

package_data = \
{'': ['*'], 'cf_clearance': ['js/*']}

install_requires = \
['playwright']

setup_kwargs = {
    'name': 'cf-clearance',
    'version': '0.29.0',
    'description': 'Purpose To make a cloudflare v2 challenge pass successfully, Can be use cf_clearance bypassed by cloudflare, However, with the cf_clearance, make sure you use the same IP and UA as when you got it.',
    'long_description': '# cf-clearance\n\n[![OSCS Status](https://www.oscs1024.com/platform/badge/vvanglro/cf_clearance.svg?size=small)](https://www.oscs1024.com/project/vvanglro/cf_clearance?ref=badge_small)\n[![Package version](https://img.shields.io/pypi/v/cf_clearance?color=%2334D058&label=pypi%20package)](https://pypi.python.org/pypi/cf_clearance)\n[![Supported Python versions](https://img.shields.io/pypi/pyversions/cf_clearance.svg?color=%2334D058)](https://pypi.python.org/pypi/cf_clearance)\n[![Docker Image versions](https://img.shields.io/docker/v/vvanglro/cf-clearance?color=%2334D058&label=docker%20version)](https://hub.docker.com/r/vvanglro/cf-clearance)\n\n\nPurpose To make a cloudflare v2 challenge pass successfully, Can be use cf_clearance bypassed by cloudflare, However, with\nthe cf_clearance, make sure you use the same IP and UA as when you got it.\n\n## Warning\n\nPlease use interface mode, You must add headless=False.\nIf you use it on linux or docker, use XVFB.\n\nChallenge are not always successful. Please try more and handle exceptions.\n\n\n## Docker Usage\n\nRecommended to install using Docker container on Ubuntu server.\nDockerHub => https://hub.docker.com/r/vvanglro/cf-clearance\n\n```shell\ndocker run -d --restart always --network host --name cf-clearance vvanglro/cf-clearance:latest \\\n--host 0.0.0.0 --port 8000 --workers 1\n```\n\n```shell\ncurl http://localhost:8000/challenge -H "Content-Type:application/json" -X POST \\\n-d \'{"proxy": {"server": "socks5://localhost:7890"}, "timeout":20, "url": "https://nowsecure.nl"}\'\n```\n\n```python\nimport requests\n\nproxy = "socks5://localhost:7890"\nresp = requests.post("http://localhost:8000/challenge",\n                     json={"proxy": {"server": proxy}, "timeout": 20,\n                           "url": "https://nowsecure.nl"})\nif resp.json().get("success"):\n    ua = resp.json().get("user_agent")\n    cf_clearance_value = resp.json().get("cookies").get("cf_clearance")\n    # use cf_clearance, must be same IP and UA\n    headers = {"user-agent": ua}\n    cookies = {"cf_clearance": cf_clearance_value}\n    res = requests.get(\'https://nowsecure.nl\', proxies={\n        "all": proxy\n    }, headers=headers, cookies=cookies)\n    if \'<title>Just a moment...</title>\' not in res.text:\n        print("cf challenge success")\n```\n\n## Install\n\n```\npip install cf-clearance==0.28.2\n```\n\n## Usage\n\nPlease make sure it is the latest package.\n\n```\npip install --upgrade cf-clearance\n```\nor\n```shell\npip install git+https://github.com/vvanglro/cf-clearance.git@main\n```\n\n### sync\n\n```python\nfrom playwright.sync_api import sync_playwright\nfrom cf_clearance import sync_cf_retry, sync_stealth\nimport requests\n\n# not use cf_clearance, cf challenge is fail\nproxies = {\n    "all": "socks5://localhost:7890"\n}\nres = requests.get(\'https://nowsecure.nl\', proxies=proxies)\nif \'<title>Just a moment...</title>\' in res.text:\n    print("cf challenge fail")\n# get cf_clearance\nwith sync_playwright() as p:\n    browser = p.chromium.launch(headless=False, proxy={"server": "socks5://localhost:7890"})\n    page = browser.new_page()\n    sync_stealth(page, pure=True)\n    page.goto(\'https://nowsecure.nl\')\n    res = sync_cf_retry(page)\n    if res:\n        cookies = page.context.cookies()\n        for cookie in cookies:\n            if cookie.get(\'name\') == \'cf_clearance\':\n                cf_clearance_value = cookie.get(\'value\')\n                print(cf_clearance_value)\n        ua = page.evaluate(\'() => {return navigator.userAgent}\')\n        print(ua)\n    else:\n        print("cf challenge fail")\n    browser.close()\n# use cf_clearance, must be same IP and UA\nheaders = {"user-agent": ua}\ncookies = {"cf_clearance": cf_clearance_value}\nres = requests.get(\'https://nowsecure.nl\', proxies=proxies, headers=headers, cookies=cookies)\nif \'<title>Just a moment...</title>\' not in res.text:\n    print("cf challenge success")\n```\n\n### async\n\n```python\nimport asyncio\nfrom playwright.async_api import async_playwright\nfrom cf_clearance import async_cf_retry, async_stealth\nimport requests\n\n\nasync def main():\n    # not use cf_clearance, cf challenge is fail\n    proxies = {\n        "all": "socks5://localhost:7890"\n    }\n    res = requests.get(\'https://nowsecure.nl\', proxies=proxies)\n    if \'<title>Just a moment...</title>\' in res.text:\n        print("cf challenge fail")\n    # get cf_clearance\n    async with async_playwright() as p:\n        browser = await p.chromium.launch(headless=False, proxy={"server": "socks5://localhost:7890"})\n        page = await browser.new_page()\n        await async_stealth(page, pure=True)\n        await page.goto(\'https://nowsecure.nl\')\n        res = await async_cf_retry(page)\n        if res:\n            cookies = await page.context.cookies()\n            for cookie in cookies:\n                if cookie.get(\'name\') == \'cf_clearance\':\n                    cf_clearance_value = cookie.get(\'value\')\n                    print(cf_clearance_value)\n            ua = await page.evaluate(\'() => {return navigator.userAgent}\')\n            print(ua)\n        else:\n            print("cf challenge fail")\n        await browser.close()\n    # use cf_clearance, must be same IP and UA\n    headers = {"user-agent": ua}\n    cookies = {"cf_clearance": cf_clearance_value}\n    res = requests.get(\'https://nowsecure.nl\', proxies=proxies, headers=headers, cookies=cookies)\n    if \'<title>Just a moment...</title>\' not in res.text:\n        print("cf challenge success")\n\n\nasyncio.get_event_loop().run_until_complete(main())\n```\n',
    'author': 'vvanglro',
    'author_email': 'you@example.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/vvanglro/cf_clearance',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
