# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['qary',
 'qary.actions',
 'qary.chat',
 'qary.data',
 'qary.data.constants',
 'qary.eda',
 'qary.etl',
 'qary.executives',
 'qary.orm',
 'qary.plugins',
 'qary.qa',
 'qary.scores',
 'qary.skills']

package_data = \
{'': ['*'],
 'qary.data': ['book_smarts/*',
               'chat/*',
               'corpora/*',
               'corpora/rss_feeds/*',
               'corpora/web_pages/*',
               'corpora/wikipedia/README.md',
               'corpora/wikipedia/README.md',
               'corpora/wikipedia/george_floyd_karma.yml',
               'corpora/wikipedia/george_floyd_karma.yml',
               'factquest/*',
               'faq/*',
               'glossaries/*',
               'gpt-j-6b/*',
               'interview/*',
               'life_coach/*',
               'life_coach/moderating/*',
               'log/*',
               'models/qa/*',
               'nlpia/*',
               'parul/*',
               'prosocial/*',
               'quiz/*',
               'rap/*',
               'search/*',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/.gitignore',
               'testsets/dialog/*',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/dialog_parser.input.v2.dialog.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/quiz_intern.yml',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/summary_accuracy_report.gz',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.input.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_qa.solution.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.input.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/test_quiz.solution.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-test-data.txt',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit-tests-data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.gz',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'testsets/unit_test_data.json',
               'thinking/*',
               'training_sets/*',
               'tutor-bot/*',
               'unittests/*',
               'wikipedia/*',
               'writing/*',
               'yes_no/*'],
 'qary.skills': ['writing/*']}

install_requires = \
['ConfigArgParse==1.5.3',
 'Cython>=0.29.28',
 'Sphinx>=4.4.0,<5.0.0',
 'beautifulsoup4==4.11.1',
 'boto3==1.22.2',
 'botocore==1.25.3',
 'django==4.0.4',
 'edit-distance==1.0.4',
 'elasticsearch==7.17.3',
 'environment==1.0.0',
 'gitpython==3.1.27',
 'graphviz>=0.20,<0.21',
 'h5py==3.6.0',
 'html2text>=2020.1.16,<2021.0.0',
 'html5lib==1.1',
 'jedi==0.18.1',
 'jupyter-client>=7.3.0',
 'jupyter-console>=6.4.2',
 'jupyter==1.0.0',
 'lxml==4.6.3',
 'm2r==0.2.1',
 'matplotlib-inline==0.1.3',
 'matplotlib==3.5.1',
 'meilisearch==0.18.2',
 'mistune==0.8.4',
 'nltk==3.6.7',
 'pandas==1.1.3',
 'pillow==9.1.0',
 'pip==22.0.4',
 'poetry>=1.1.13,<2.0.0',
 'pre-commit>=2.18.1,<3.0.0',
 'pronouncing==0.2.0',
 'psutil>=5.8.0,<6.0.0',
 'pytest-cov>=3.0.0,<4.0.0',
 'pytest>=6.2.4,<7.0.0',
 'python-dotenv>=0.13.0,<0.14.0',
 'python-slugify==4.0.0',
 'pyyaml==6.0',
 'rapidfuzz==0.9.1',
 'recommonmark==0.6.0',
 'scikit-image>=0.17.2',
 'scikit-learn>=1.0.2',
 'scipy==1.8.0',
 'seaborn>=0.11.2,<0.12.0',
 'sentence_transformers>=2.2.0,<3.0.0',
 'spacy==3.2.4',
 'torch==1.11.0',
 'tox>=3.25.0,<4.0.0',
 'tqdm>=4.60.0,<5.0.0',
 'wikipedia>=1.4.0,<2.0.0']

entry_points = \
{'console_scripts': ['qary = qary.clibot:main']}

setup_kwargs = {
    'name': 'qary',
    'version': '0.7.17',
    'description': 'A chatbot that assists rather than manipulates.',
    'long_description': '[![Buy Us Tea](https://github.com/nlpia/nlpia-bot/raw/develop/docs/media/small-leaf-and-name-screenshot-31x80.png)](https://buymeacoffee.com/hobs)\n[![PyPI version](https://img.shields.io/pypi/pyversions/qary.svg)](https://pypi.org/project/qary/)\n[![License](https://img.shields.io/pypi/l/qary.svg)](https://pypi.python.org/pypi/qary/)\n[![codecov](https://codecov.io/gl/tangibleai/qary/branch/master/graph/badge.svg)](https://codecov.io/gl/tangibleai/qary)\n[![DigitalOcean Referral Badge](https://web-platforms.sfo2.digitaloceanspaces.com/WWW/Badge%202.svg)](https://www.digitalocean.com/?refcode=5bc34fba1bee&utm_campaign=Referral_Invite&utm_medium=Referral_Program&utm_source=badge)\n\n\n# `qary`\n\nThe `qary` package is both a chatbot framework and a working "reference implementation" virtual assistant that actually assists! Most bots manipulate you to make money for their corporate masters. With qary, you can build **your** bot to protect you and amplify your intelligence and prosocial instincts.\n\n`qary` was conceived as part of [NLP in Action](https://www.manning.com/books/natural-language-processing-in-action) book, is maintained by an [active developer community](/docs/wiki/contributors.md) and is supported by [San Diego Python User Group](https://www.pythonsd.org/index.html) (some qary talks [here](https://www.youtube.com/playlist?list=PLOa5qP-zwt22Noym1Nf8BeL24NeE__ofj) and in `docs/`) and [San Diego Machine Learning Group](https://www.meetup.com/San-Diego-Machine-Learning/).\n\n## Install\n\n### Install from source\n\nRetrieve the source code from GitLab:\n\n```bash\ngit clone git@gitlab.com:tangibleai/qary\ncd qary\n```\n\nThen, install and use the `conda` python package manager within the [Anaconda](https://www.anaconda.com/products/individual#Downloads) software package.\n\n```bash\nconda update -y -n base -c defaults conda\nconda create -y -n qaryenv \'python==3.9.7\'\nconda env update -n qaryenv -f ./scripts/environment.yml\nconda activate qaryenv || source activate qaryenv\npip install --editable .\n```\n\n**Windows Users**: [docs/README-windows-install.md](docs/README-windows-install.md)\n\n### PyPi package\n`qary` is on [PyPi](https://pypi.org/project/qary/) but this install is unlikely to work, unless you\'ve already installed all the dependencies:\n\n```bash\npip install qary\n```\n\n## Usage\n\n```bash\n$ qary --help\nusage: qary [-h] [--version] [--name STR] [-p] [-s STR] [-v] [-vv] [words [words ...]]\n```\n\n### Running `qary` for just one skill\n\n```bash\n$ qary -s qa\n# ... (logging messages)\nYOU: When was Barack Obama born?\n# ... (logging messages)\nqary: August 4, 1961\n```\n\n### `qary` skills\n\n`qary`\'s probabilistic conversation manager chooses a reply from the possiblities generated by the different personalities:\n\n- `pattern` (`skills/pattern.py`): example skill using regex patterns to reply to greetings like "hi"\n- `qa` (`skills/qa.py`): BERT and ALBERT Wikipedia Question Answering (WikiQA reading comprehension tests)\n- `faq` (`skills/faq.py`): answers to frequently asked questions using data/faq/*.yml\n- `glossary` (`skills/glossary.py`): definitions from glossary yml files in data/faq/glossary-*.yml\n- `eliza` (`eliza.py`): a python port of the ELIZA therapist bot\n\n### Configuring default personalities\n\nBy default, `qary` runs with `qa` personality. Check out the config file in `qary.ini` to change the default skills loaded for your own custom skill in the skills directory.\n\n## Approach\n\n`qary`\'s chatbot framework allows you to combine many approaches to give you state-of-the-art capability to answer questions and carry on a conversation:\n\n1. search: [chatterbot](https://github.com/gunthercox/ChatterBot), [will](https://github.com/skoczen/will)\n2. pattern matching and response templates: Alexa, [AIML](https://github.com/keiffster/program-y)\n3. generative deep learning: [robot-bernie](https://github.com/nlpia/robot-bernie), [movie-bot](https://github.com/totalgood/nlpia/blob/master/src/nlpia/book/examples/ch10_movie_dialog_chatbot.py)\n4. grounding: [snips](https://github.com/snipsco/snips-nlu)\n\nIt\'s all explained in detail at [NLP in Action](https://www.manning.com/books/natural-language-processing-in-action).\n\nPresentations for San Diego Python User Group are in [docs/](/docs/2019-08-22--San Diego Python User Group -- How to Build a Chatbot.odp) and on the web at [http://totalgood.org/midata/talks](http://totalgood.org/midata/talks/)\n\n## Contributing pattern for developers\n\nDM @hobs if you\'d like to join us for weekly Zoom collaborative-coding sessions.\n\n1. [Create a fork](https://docs.gitlab.com/ee/user/project/repository/forking_workflow.html#creating-a-fork) of the [main qary repository](https://gitlab.com/tangibleai/qary) on Gitlab.\n2. Make your changes in a branch named something different from `master`, e.g. create\n   a new branch `my-pull-request`.\n3. [Create a merge request](https://docs.gitlab.com/ee/user/project/merge_requests/creating_merge_requests.html).\n4. Help your fellow contributors out by:\n  - Follow the [PEP-8 style guide](https://www.python.org/dev/peps/pep-0008/).\n  - Try to include a docstring, at least a single line, in any function, method, or class\n  - Bonus points for adding a [doctest](https://docs.python.org/3/library/doctest.html) as part of your contribution.\n  - If you add a new feature, write some quick docs in the README.\n  - Add your name and attribution to the AUTHORS file.\n  - Know we are grateful for your contribution! You\'ve made the chatbot world a little better!\n\n',
    'author': 'ProAI',
    'author_email': 'hobs@proai.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/tangibleai/qary',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8.3,<3.10.0',
}


setup(**setup_kwargs)
