import numpy as np
import pandas as pd
import spacy
nlp = spacy.load('en_core_web_md')
words = 'red orange yellow green blue indigo violet purple cyan magenta chartreuse pink lavender brown black white beige eggshell'.split()

vectors300d = pd.DataFrame({w: nlp(w).vector for w in words}).T
vectors300d.round(1)
#               0    1    2    3    4    5    6    7    8    9   10   11   12   13   14   15   16   17   18   19   20   21   22   23   24   25
# red        -0.2 -0.2 -0.0 -0.1  0.3  0.2 -0.3  0.0 -0.3  1.0 -0.3  0.1 -0.3 -0.7  0.1 -0.1  0.1  1.9 -0.1 -0.7  0.2 -0.6 -0.1  0.2 -0.4 -0.1
# orange     -0.1  0.2  0.0 -0.1  0.3 -0.1 -0.4  0.0  0.1  0.7 -0.4 -0.2 -0.4 -0.1 -0.0 -0.2  0.4  1.9  0.0 -1.0  0.3 -0.1  0.0  0.3 -0.2 -0.1
# yellow     -0.2  0.2 -0.0 -0.2  0.3 -0.1 -0.4 -0.1 -0.7  0.7 -0.2 -0.3 -0.2 -0.3  0.0  0.1  0.4  2.0  0.1 -0.9  0.4 -0.5 -0.3  0.3  0.1 -0.4
# green      -0.1  0.2  0.1 -0.2  0.2  0.3 -0.2 -0.1 -0.5  1.3 -0.9 -0.1 -0.6 -0.3 -0.2 -0.0  0.5  2.1  0.0 -0.5  0.4 -0.0 -0.3  0.0 -0.1 -0.4
# blue        0.1  0.0  0.0 -0.1  0.4 -0.1 -0.5  0.1 -0.4  0.8 -0.2 -0.1 -0.4 -0.4  0.1  0.2  0.2  2.1 -0.1 -1.1 -0.1 -0.3 -0.4  0.2 -0.3 -0.3
# indigo      0.1  0.0  0.0 -0.1  0.4 -0.1 -0.5  0.1 -0.4  0.8 -0.2 -0.1 -0.4 -0.4  0.1  0.2  0.2  2.1 -0.1 -1.1 -0.1 -0.3 -0.4  0.2 -0.3 -0.3
# violet     -0.1 -0.2 -0.1 -0.4  0.3 -0.1 -0.2 -0.2 -0.4  0.3 -0.0 -0.3 -0.0 -0.4  0.3  0.1  0.2  1.5  0.1 -0.8  0.2 -0.2 -0.7  0.2 -0.5  0.2
# purple     -0.1 -0.2 -0.1 -0.4  0.3 -0.1 -0.2 -0.2 -0.4  0.3 -0.0 -0.3 -0.0 -0.4  0.3  0.1  0.2  1.5  0.1 -0.8  0.2 -0.2 -0.7  0.2 -0.5  0.2
# cyan       -0.4  0.6 -0.2 -0.5 -0.3  0.1 -0.9  0.3  0.1  0.3  0.1 -0.5 -0.1 -0.6 -0.1 -0.1 -0.3  2.4 -0.2 -0.1  0.4  0.4  0.0  0.4  0.7 -0.2
# magenta    -0.1 -0.2 -0.1 -0.4  0.3 -0.1 -0.2 -0.2 -0.4  0.3 -0.0 -0.3 -0.0 -0.4  0.3  0.1  0.2  1.5  0.1 -0.8  0.2 -0.2 -0.7  0.2 -0.5  0.2
# chartreuse -0.1  0.2  0.0 -0.1  0.3 -0.1 -0.4  0.0  0.1  0.7 -0.4 -0.2 -0.4 -0.1 -0.0 -0.2  0.4  1.9  0.0 -1.0  0.3 -0.1  0.0  0.3 -0.2 -0.1
# pink       -0.0 -0.2 -0.1 -0.1  0.3 -0.5 -0.2 -0.3 -0.1  0.6  0.1 -0.3 -0.1 -0.3  0.2  0.2 -0.2  1.9  0.2 -0.8  0.2 -0.3 -0.6  0.1 -0.4  0.2
# lavender   -0.4  0.6 -0.1 -0.1 -0.1 -0.0 -0.9  0.1  0.3  0.5 -0.7  0.3 -1.0  0.1 -0.4 -0.3 -0.0  1.3 -0.1 -0.4  0.7 -0.1  0.2  0.1  0.1 -0.5
# brown      -0.4 -0.1  0.1  0.2  0.0  0.2 -0.6  0.1 -0.1  0.6 -0.7 -0.1 -0.1 -0.7  0.1  0.2  0.6  1.8  0.3 -0.6 -0.1 -0.2 -0.4  0.3  0.0 -0.7
# black      -0.3 -0.0  0.1 -0.1  0.3  0.1 -0.5  0.1 -0.2  1.1 -0.4  0.2 -0.2 -0.8 -0.1  0.2  0.2  1.8 -0.3 -0.5 -0.1 -0.8  0.1  0.1 -0.1 -0.4
# white      -0.4 -0.1  0.0 -0.2  0.2 -0.3 -0.5  0.0 -0.4  1.2 -0.2  0.0 -0.3 -0.3  0.0 -0.1  0.2  2.0 -0.0 -0.6  0.1 -0.6 -0.1  0.4 -0.4 -0.4
# beige       0.3  0.2  0.1 -0.1  0.1 -0.3 -0.3 -0.1 -0.2  0.3 -0.4 -0.0 -0.4 -0.7  0.0  0.4  0.2  1.7  0.1 -0.9 -0.6 -0.2 -0.3  0.6 -0.1 -0.5
# eggshell   -0.3 -0.1  0.1  0.1 -0.6  0.3 -0.4  0.1  0.9  1.0 -1.0 -0.2 -0.2  0.5  0.4  0.0 -0.3  1.6  0.1 -0.1  0.1  0.3 -0.4 -0.1 -0.1 -0.3

X = vectors300d
A = X.dot(X.T) / np.linalg.norm(X, axis=1) ** 2
A[A < .75] = 0
A.round(1)
#             red  orange  yellow  green  blue  indigo  violet  purple  cyan  magenta  chartreuse  pink  lavender  brown  black  white  beige  eggshell
# red         1.0     0.8     0.8    0.8   0.8     0.8     0.8     0.8   0.0      0.8         0.8   0.0       0.0    0.0    0.0    0.0    0.0       0.0
# orange      0.8     1.0     0.8    0.8   0.8     0.8     0.8     0.8   0.0      0.8         1.0   0.0       0.0    0.0    0.0    0.0    0.0       0.0
# yellow      0.9     0.8     1.0    0.8   0.9     0.9     0.8     0.8   0.0      0.8         0.8   0.8       0.0    0.0    0.0    0.8    0.0       0.0
# green       0.8     0.0     0.0    1.0   0.8     0.8     0.0     0.0   0.0      0.0         0.0   0.0       0.0    0.0    0.0    0.0    0.0       0.0
# blue        0.9     0.8     0.8    0.8   1.0     1.0     0.8     0.8   0.0      0.8         0.8   0.8       0.0    0.0    0.0    0.8    0.8       0.0
# indigo      0.9     0.8     0.8    0.8   1.0     1.0     0.8     0.8   0.0      0.8         0.8   0.8       0.0    0.0    0.0    0.8    0.8       0.0
# violet      0.8     0.8     0.8    0.0   0.9     0.9     1.0     1.0   0.0      1.0         0.8   0.9       0.0    0.0    0.0    0.0    0.0       0.0
# purple      0.8     0.8     0.8    0.0   0.9     0.9     1.0     1.0   0.0      1.0         0.8   0.9       0.0    0.0    0.0    0.0    0.0       0.0
# cyan        0.0     0.0     0.0    0.0   0.0     0.0     0.0     0.0   1.0      0.0         0.0   0.0       0.0    0.0    0.0    0.0    0.0       0.0
# magenta     0.8     0.8     0.8    0.0   0.9     0.9     1.0     1.0   0.0      1.0         0.8   0.9       0.0    0.0    0.0    0.0    0.0       0.0
# chartreuse  0.8     1.0     0.8    0.8   0.8     0.8     0.8     0.8   0.0      0.8         1.0   0.0       0.0    0.0    0.0    0.0    0.0       0.0
# pink        0.8     0.8     0.8    0.0   0.9     0.9     0.9     0.9   0.0      0.9         0.8   1.0       0.0    0.0    0.0    0.0    0.0       0.0
# lavender    0.0     0.8     0.0    0.0   0.0     0.0     0.0     0.0   0.0      0.0         0.8   0.0       1.0    0.0    0.0    0.0    0.0       0.0
# brown       0.8     0.0     0.0    0.0   0.0     0.0     0.0     0.0   0.0      0.0         0.0   0.0       0.0    1.0    0.8    0.8    0.8       0.0
# black       0.8     0.0     0.0    0.0   0.8     0.8     0.0     0.0   0.0      0.0         0.0   0.0       0.0    0.0    1.0    0.9    0.8       0.0
# white       0.8     0.0     0.0    0.0   0.8     0.8     0.0     0.0   0.0      0.0         0.0   0.0       0.0    0.0    0.8    1.0    0.0       0.0
# beige       0.0     0.0     0.0    0.0   0.8     0.8     0.0     0.0   0.0      0.0         0.0   0.0       0.0    0.0    0.0    0.0    1.0       0.0
# eggshell    0.0     0.0     0.0    0.0   0.0     0.0     0.0     0.0   0.0      0.0         0.0   0.0       0.0    0.0    0.0    0.0    0.0       1.0
