import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigtableTableConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Bigtable instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#instance_name BigtableTable#instance_name}
     *
     * @stability stable
     */
    readonly instanceName: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#name BigtableTable#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#project BigtableTable#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A list of predefined keys to split the table on.
     *
     * !> Warning: Modifying the split_keys of an existing table will cause Terraform to delete/recreate the entire google_bigtable_table resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#split_keys BigtableTable#split_keys}
     *
     * @stability stable
     */
    readonly splitKeys?: string[];
    /**
     * column_family block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#column_family BigtableTable#column_family}
     *
     * @stability stable
     */
    readonly columnFamily?: BigtableTableColumnFamily[];
}
/**
 * @stability stable
 */
export interface BigtableTableColumnFamily {
    /**
     * The name of the column family.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html#family BigtableTable#family}
     *
     * @stability stable
     */
    readonly family: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html google_bigtable_table}.
 *
 * @stability stable
 */
export declare class BigtableTable extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_table.html google_bigtable_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigtableTableConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceName?;
    /**
     * @stability stable
     */
    get instanceName(): string;
    /**
     * @stability stable
     */
    set instanceName(value: string);
    /**
     * @stability stable
     */
    get instanceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _splitKeys?;
    /**
     * @stability stable
     */
    get splitKeys(): string[] | undefined;
    /**
     * @stability stable
     */
    set splitKeys(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSplitKeys(): void;
    /**
     * @stability stable
     */
    get splitKeysInput(): string[] | undefined;
    private _columnFamily?;
    /**
     * @stability stable
     */
    get columnFamily(): BigtableTableColumnFamily[] | undefined;
    /**
     * @stability stable
     */
    set columnFamily(value: BigtableTableColumnFamily[] | undefined);
    /**
     * @stability stable
     */
    resetColumnFamily(): void;
    /**
     * @stability stable
     */
    get columnFamilyInput(): BigtableTableColumnFamily[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
