import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service.html#name DataGoogleComputeBackendService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service.html#project DataGoogleComputeBackendService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceBackend extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get balancingMode(): string;
    /**
     * @stability stable
     */
    get capacityScaler(): number;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    get maxConnections(): number;
    /**
     * @stability stable
     */
    get maxConnectionsPerEndpoint(): number;
    /**
     * @stability stable
     */
    get maxConnectionsPerInstance(): number;
    /**
     * @stability stable
     */
    get maxRate(): number;
    /**
     * @stability stable
     */
    get maxRatePerEndpoint(): number;
    /**
     * @stability stable
     */
    get maxRatePerInstance(): number;
    /**
     * @stability stable
     */
    get maxUtilization(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get includeHost(): any;
    /**
     * @stability stable
     */
    get includeProtocol(): any;
    /**
     * @stability stable
     */
    get includeQueryString(): any;
    /**
     * @stability stable
     */
    get queryStringBlacklist(): string[];
    /**
     * @stability stable
     */
    get queryStringWhitelist(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get code(): number;
    /**
     * @stability stable
     */
    get ttl(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceCdnPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cacheKeyPolicy(): any;
    /**
     * @stability stable
     */
    get cacheMode(): string;
    /**
     * @stability stable
     */
    get clientTtl(): number;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    get maxTtl(): number;
    /**
     * @stability stable
     */
    get negativeCaching(): any;
    /**
     * @stability stable
     */
    get negativeCachingPolicy(): any;
    /**
     * @stability stable
     */
    get serveWhileStale(): number;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSec(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceCircuitBreakers extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxConnections(): number;
    /**
     * @stability stable
     */
    get maxPendingRequests(): number;
    /**
     * @stability stable
     */
    get maxRequests(): number;
    /**
     * @stability stable
     */
    get maxRequestsPerConnection(): number;
    /**
     * @stability stable
     */
    get maxRetries(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookieTtl extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    get seconds(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookie extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get ttl(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceConsistentHash extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get httpCookie(): any;
    /**
     * @stability stable
     */
    get httpHeaderName(): string;
    /**
     * @stability stable
     */
    get minimumRingSize(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceIap extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get oauth2ClientId(): string;
    /**
     * @stability stable
     */
    get oauth2ClientSecret(): string;
    /**
     * @stability stable
     */
    get oauth2ClientSecretSha256(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceLogConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enable(): any;
    /**
     * @stability stable
     */
    get sampleRate(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTime extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    get seconds(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceOutlierDetectionInterval extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get nanos(): number;
    /**
     * @stability stable
     */
    get seconds(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeBackendServiceOutlierDetection extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get baseEjectionTime(): any;
    /**
     * @stability stable
     */
    get consecutiveErrors(): number;
    /**
     * @stability stable
     */
    get consecutiveGatewayFailure(): number;
    /**
     * @stability stable
     */
    get enforcingConsecutiveErrors(): number;
    /**
     * @stability stable
     */
    get enforcingConsecutiveGatewayFailure(): number;
    /**
     * @stability stable
     */
    get enforcingSuccessRate(): number;
    /**
     * @stability stable
     */
    get interval(): any;
    /**
     * @stability stable
     */
    get maxEjectionPercent(): number;
    /**
     * @stability stable
     */
    get successRateMinimumHosts(): number;
    /**
     * @stability stable
     */
    get successRateRequestVolume(): number;
    /**
     * @stability stable
     */
    get successRateStdevFactor(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service.html google_compute_backend_service}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeBackendService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service.html google_compute_backend_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleComputeBackendServiceConfig);
    /**
     * @stability stable
     */
    get affinityCookieTtlSec(): number;
    /**
     * @stability stable
     */
    backend(index: string): DataGoogleComputeBackendServiceBackend;
    /**
     * @stability stable
     */
    cdnPolicy(index: string): DataGoogleComputeBackendServiceCdnPolicy;
    /**
     * @stability stable
     */
    circuitBreakers(index: string): DataGoogleComputeBackendServiceCircuitBreakers;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSec(): number;
    /**
     * @stability stable
     */
    consistentHash(index: string): DataGoogleComputeBackendServiceConsistentHash;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    /**
     * @stability stable
     */
    get customRequestHeaders(): string[];
    /**
     * @stability stable
     */
    get customResponseHeaders(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get enableCdn(): any;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get healthChecks(): string[];
    /**
     * @stability stable
     */
    iap(index: string): DataGoogleComputeBackendServiceIap;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string;
    /**
     * @stability stable
     */
    get localityLbPolicy(): string;
    /**
     * @stability stable
     */
    logConfig(index: string): DataGoogleComputeBackendServiceLogConfig;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    outlierDetection(index: string): DataGoogleComputeBackendServiceOutlierDetection;
    /**
     * @stability stable
     */
    get portName(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    get securityPolicy(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get sessionAffinity(): string;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
