"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const YAML = require("yaml");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * (experimental) An Amplify Console application.
 *
 * @experimental
 */
class App extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = (_c = props.sourceCodeProvider) === null || _c === void 0 ? void 0 : _c.bind(this);
        const app = new aws_amplify_1.CfnApp(this, 'Resource', {
            accessToken: (_d = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.accessToken) === null || _d === void 0 ? void 0 : _d.toString(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: (_e = props.autoBranchCreation.autoBuild) !== null && _e !== void 0 ? _e : true,
                environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: (_f = props.autoBranchCreation.pullRequestPreview) !== null && _f !== void 0 ? _f : true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: aws_cdk_lib_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: (_g = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.oauthToken) === null || _g === void 0 ? void 0 : _g.toString(),
            repository: sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * (experimental) Import an existing application.
     *
     * @experimental
     */
    static fromAppId(scope, id, appId) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds a custom rewrite/redirect rule to this application.
     *
     * @experimental
     */
    addCustomRule(rule) {
        this.customRules.push(rule);
        return this;
    }
    /**
     * (experimental) Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * (experimental) Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * (experimental) Adds a branch to this application.
     *
     * @experimental
     */
    addBranch(id, options = {}) {
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * (experimental) Adds a domain to this application.
     *
     * @experimental
     */
    addDomain(id, options = {}) {
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.App", version: "2.0.0-alpha.5" };
/**
 * (experimental) The status code for a URL rewrite or redirect rule.
 *
 * @experimental
 */
var RedirectStatus;
(function (RedirectStatus) {
    RedirectStatus["REWRITE"] = "200";
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    RedirectStatus["NOT_FOUND"] = "404";
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus = exports.RedirectStatus || (exports.RedirectStatus = {}));
/**
 * (experimental) Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 * @experimental
 */
class CustomRule {
    /**
     * @experimental
     */
    constructor(options) {
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.CustomRule", version: "2.0.0-alpha.5" };
/**
 * (experimental) Sets up a 200 rewrite for all paths to `index.html` except for path containing a file extension.
 *
 * @experimental
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
function renderCustomResponseHeaders(customHeaders) {
    const modifiedHeaders = customHeaders.map(customHeader => ({
        ...customHeader,
        headers: Object.entries(customHeader.headers).map(([key, value]) => ({ key, value })),
    }));
    const customHeadersObject = { customHeaders: modifiedHeaders };
    return YAML.stringify(customHeadersObject);
}
//# sourceMappingURL=data:application/json;base64,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