"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) GitHub source code provider.
 *
 * @experimental
 */
class GitHubSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCodeProvider[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.GitHubSourceCodeProvider", version: "2.0.0-alpha.5" };
/**
 * (experimental) GitLab source code provider.
 *
 * @experimental
 */
class GitLabSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app) {
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
_b = JSII_RTTI_SYMBOL_1;
GitLabSourceCodeProvider[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.GitLabSourceCodeProvider", version: "2.0.0-alpha.5" };
/**
 * (experimental) CodeCommit source code provider.
 *
 * @experimental
 */
class CodeCommitSourceCodeProvider {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(app) {
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
_c = JSII_RTTI_SYMBOL_1;
CodeCommitSourceCodeProvider[_c] = { fqn: "@aws-cdk/aws-amplify-alpha.CodeCommitSourceCodeProvider", version: "2.0.0-alpha.5" };
//# sourceMappingURL=data:application/json;base64,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