import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this security policy. Max size is 2048.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#description ComputeSecurityPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The name of the security policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#name ComputeSecurityPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The project in which the resource belongs. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#project ComputeSecurityPolicy#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#rule ComputeSecurityPolicy#rule}
     *
     * @stability stable
     */
    readonly rule?: ComputeSecurityPolicyRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#timeouts ComputeSecurityPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSecurityPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSecurityPolicyRuleMatchConfig {
    /**
     * Set of IP addresses or ranges (IPV4 or IPV6) in CIDR notation to match against inbound traffic.
     *
     * There is a limit of 10 IP ranges per rule. A value of '*' matches all IPs (can be used to override the default behavior).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#src_ip_ranges ComputeSecurityPolicy#src_ip_ranges}
     *
     * @stability stable
     */
    readonly srcIpRanges: string[];
}
export declare function computeSecurityPolicyRuleMatchConfigToTerraform(struct?: ComputeSecurityPolicyRuleMatchConfigOutputReference | ComputeSecurityPolicyRuleMatchConfig): any;
/**
 * @stability stable
 */
export declare class ComputeSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSecurityPolicyRuleMatchConfig | undefined);
    private _srcIpRanges?;
    /**
     * @stability stable
     */
    get srcIpRanges(): string[];
    /**
     * @stability stable
     */
    set srcIpRanges(value: string[]);
    /**
     * @stability stable
     */
    get srcIpRangesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeSecurityPolicyRuleMatchExpr {
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * The application context of the containing message determines which well-known feature set of CEL is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#expression ComputeSecurityPolicy#expression}
     *
     * @stability stable
     */
    readonly expression: string;
}
export declare function computeSecurityPolicyRuleMatchExprToTerraform(struct?: ComputeSecurityPolicyRuleMatchExprOutputReference | ComputeSecurityPolicyRuleMatchExpr): any;
/**
 * @stability stable
 */
export declare class ComputeSecurityPolicyRuleMatchExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSecurityPolicyRuleMatchExpr | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSecurityPolicyRuleMatchExpr | undefined);
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeSecurityPolicyRuleMatch {
    /**
     * Predefined rule expression.
     *
     * If this field is specified, config must also be specified. Available options:   SRC_IPS_V1: Must specify the corresponding src_ip_ranges field in config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#versioned_expr ComputeSecurityPolicy#versioned_expr}
     *
     * @stability stable
     */
    readonly versionedExpr?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#config ComputeSecurityPolicy#config}
     *
     * @stability stable
     */
    readonly config?: ComputeSecurityPolicyRuleMatchConfig;
    /**
     * expr block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#expr ComputeSecurityPolicy#expr}
     *
     * @stability stable
     */
    readonly expr?: ComputeSecurityPolicyRuleMatchExpr;
}
export declare function computeSecurityPolicyRuleMatchToTerraform(struct?: ComputeSecurityPolicyRuleMatchOutputReference | ComputeSecurityPolicyRuleMatch): any;
/**
 * @stability stable
 */
export declare class ComputeSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSecurityPolicyRuleMatch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSecurityPolicyRuleMatch | undefined);
    private _versionedExpr?;
    /**
     * @stability stable
     */
    get versionedExpr(): string;
    /**
     * @stability stable
     */
    set versionedExpr(value: string);
    /**
     * @stability stable
     */
    resetVersionedExpr(): void;
    /**
     * @stability stable
     */
    get versionedExprInput(): string | undefined;
    private _config;
    /**
     * @stability stable
     */
    get config(): ComputeSecurityPolicyRuleMatchConfigOutputReference;
    /**
     * @stability stable
     */
    putConfig(value: ComputeSecurityPolicyRuleMatchConfig): void;
    /**
     * @stability stable
     */
    resetConfig(): void;
    /**
     * @stability stable
     */
    get configInput(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    private _expr;
    /**
     * @stability stable
     */
    get expr(): ComputeSecurityPolicyRuleMatchExprOutputReference;
    /**
     * @stability stable
     */
    putExpr(value: ComputeSecurityPolicyRuleMatchExpr): void;
    /**
     * @stability stable
     */
    resetExpr(): void;
    /**
     * @stability stable
     */
    get exprInput(): ComputeSecurityPolicyRuleMatchExpr | undefined;
}
/**
 * @stability stable
 */
export interface ComputeSecurityPolicyRule {
    /**
     * Action to take when match matches the request.
     *
     * Valid values:   "allow" : allow access to target, "deny(status)" : deny access to target, returns the HTTP response code specified (valid values are 403, 404 and 502)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#action ComputeSecurityPolicy#action}
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * An optional description of this rule. Max size is 64.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#description ComputeSecurityPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * When set to true, the action specified above is not enforced.
     *
     * Stackdriver logs for requests that trigger a preview action are annotated as such.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#preview ComputeSecurityPolicy#preview}
     *
     * @stability stable
     */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
     * An unique positive integer indicating the priority of evaluation for a rule.
     *
     * Rules are evaluated from highest priority (lowest numerically) to lowest priority (highest numerically) in order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#priority ComputeSecurityPolicy#priority}
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#match ComputeSecurityPolicy#match}
     *
     * @stability stable
     */
    readonly match: ComputeSecurityPolicyRuleMatch;
}
export declare function computeSecurityPolicyRuleToTerraform(struct?: ComputeSecurityPolicyRule): any;
/**
 * @stability stable
 */
export interface ComputeSecurityPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#create ComputeSecurityPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#delete ComputeSecurityPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#update ComputeSecurityPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeSecurityPolicyTimeoutsToTerraform(struct?: ComputeSecurityPolicyTimeoutsOutputReference | ComputeSecurityPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSecurityPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSecurityPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html google_compute_security_policy}.
 *
 * @stability stable
 */
export declare class ComputeSecurityPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html google_compute_security_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSecurityPolicyConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): ComputeSecurityPolicyRule[];
    /**
     * @stability stable
     */
    set rule(value: ComputeSecurityPolicyRule[]);
    /**
     * @stability stable
     */
    resetRule(): void;
    /**
     * @stability stable
     */
    get ruleInput(): ComputeSecurityPolicyRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSecurityPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeSecurityPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSecurityPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
