# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pylexique', 'tests']

package_data = \
{'': ['*'], 'pylexique': ['Lexique383/*', 'errors/*']}

install_requires = \
['click>=8.0.3',
 'colorama',
 'joblib>=1.0.1,<2.0.0',
 'pandas>=1.3.4,<2.0.0',
 'setuptools>=49.6.0,<49.7.0',
 'tqdm']

extras_require = \
{':python_version < "3.7"': ['dataclasses>=0.6']}

entry_points = \
{'console_scripts': ['pylexique = pylexique.cli:main']}

setup_kwargs = {
    'name': 'pylexique',
    'version': '1.5.0',
    'description': 'Pylexique is a Python wrapper around Lexique383',
    'long_description': '=========\npylexique\n=========\n\n\n.. image:: https://img.shields.io/badge/Maintained%3F-yes-green.svg\n        :target: https://GitHub.com/SekouDiaoNlp/pylexique/graphs/commit-activity\n        :alt: Package Maintenance Status\n\n.. image:: https://img.shields.io/badge/maintainer-SekouDiaoNlp-blue\n        :target: https://GitHub.com/SekouDiaoNlp/pylexique\n        :alt: Package Maintener\n\n.. image:: https://img.shields.io/github/checks-status/SekouDiaoNlp/mlconjug3/master?label=Build%20status%20on%20Windows%2C%20MacOs%20and%20Linux\n        :target: https://github.com/SekouDiaoNlp/pylexique/actions/workflows/main.yml\n        :alt: Build status on Windows, MacOs and Linux\n\n.. image:: https://img.shields.io/pypi/v/pylexique.svg\n        :target: https://pypi.python.org/pypi/pylexique\n        :alt: Pypi Python Package Index Status\n\n.. image:: https://anaconda.org/conda-forge/pylexique/badges/version.svg\n        :target: https://anaconda.org/conda-forge/pylexique\n        :alt: Anaconda Package Index Status\n\n.. image:: https://img.shields.io/pypi/pyversions/pylexique\n        :target: https://pypi.python.org/pypi/pylexique\n        :alt: Compatible Python versions\n\n.. image:: https://img.shields.io/conda/pn/conda-forge/pylexique?color=dark%20green&label=Supported%20platforms\n        :target: https://anaconda.org/conda-forge/pylexique\n        :alt: Supported platforms\n\n.. image:: https://readthedocs.org/projects/pylexique/badge/?version=latest\n        :target: https://pylexique.readthedocs.io/en/latest\n        :alt: Documentation Status\n\n.. image:: https://pyup.io/repos/github/SekouDiaoNlp/pylexique/shield.svg\n        :target: https://pyup.io/repos/github/SekouDiaoNlp/pylexique/\n        :alt: Dependencies status\n\n.. image:: https://codecov.io/gh/SekouDiaoNlp/pylexique/branch/master/graph/badge.svg?token=EiEXyUJGpF\n        :target: https://codecov.io/gh/SekouDiaoNlp/pylexique\n        :alt: Code Coverage Status\n\n.. image:: https://snyk-widget.herokuapp.com/badge/pip/pylexique/badge.svg\n        :target: https://snyk.io/test/github/SekouDiaoNlp/pylexique?targetFile=requirements.txt\n        :alt: Code Vulnerability Status\n\n.. image:: https://img.shields.io/pypi/dm/pylexique?label=PyPi%20Downloads\n        :target: https://pypi.org/project/pylexique/\n        :alt: PyPI Downloads\n\n.. image:: https://img.shields.io/conda/dn/conda-forge/pylexique?label=Anaconda%20Total%20Downloads\n        :target: https://anaconda.org/conda-forge/pylexique\n        :alt: Conda\n\n\n|\n\n\n| Pylexique is a Python wrapper around Lexique383_.\n\n| It allows the extraction of lexical information from more than 140 000 French words in an Object Oriented way.\n\n|\n\n| Pylexique est une librairie Python encapsulant Lexique383_.\n\n| Cette librairie permet d\'extraire l\'information lexicale de plus de 140 000 mots Français de manière Orientée Objet.\n\n|\n|\n\n* Free software: MIT license\n* PyLexique Documentation: https://pylexique.readthedocs.io\n\n| Each lexical item is represented as a LexItem having the following LexEntryType:\n|\n\n| Chaque entrée lexicale est représentée par un LexItem de type LexEntryType:\n|\n\n.. code-block:: python\n\n        class LexEntryType:\n        """\n        Type information about all the lexical attributes in a LexItem object.\n\n        """\n        ortho: str\n        phon: str\n        lemme: str\n        cgram: str\n        genre: str\n        nombre: str\n        freqlemfilms2: float\n        freqlemlivres: float\n        freqfilms2: float\n        freqlivres: float\n        infover: str\n        nbhomogr: int\n        nbhomoph: int\n        islem: bool\n        nblettres: int\n        nbphons: int\n        cvcv: str\n        p_cvcv: str\n        voisorth: int\n        voisphon: int\n        puorth: int\n        puphon: int\n        syll: str\n        nbsyll: int\n        cv_cv: str\n        orthrenv: str\n        phonrenv: str\n        orthosyll: str\n        cgramortho: str\n        deflem: float\n        defobs: int\n        old20: float\n        pld20: float\n        morphoder: str\n        nbmorph: int\n\nThe meanings of the attributes of this object are as follow:\n\n* ortho: the word\n* phon: the phonological forms of the word\n* lemme: the lemmas of this word\n* cgram: the grammatical categories of this word\n* genre: the gender\n* nombre: the number\n* freqlemfilms: the frequency of the lemma according to the corpus of subtitles (per million occurrences)\n* freqlemlivres: the frequency of the lemma according to the body of books (per million occurrences)\n* freqfilms: the frequency of the word according to the corpus of subtitles (per million occurrences)\n* freqlivres: the frequency of the word according to the body of books (per million occurrences)\n* infover: modes, tenses, and possible people for verbs\n* nbhomogr: number of homographs\n* nbhomoph: number of homophones\n* islem: indicates if it is a lemma or not\n* nblettres: the number of letters\n* nbphons: number of phonemes\n* cvcv: the orthographic structure\n* p-cvcv: the phonological structure\n* voisorth: number of orthographic neighbors\n* voisphon: number of phonological neighbors\n* puorth: point of spelling uniqueness\n* puphon: point of phonological uniqueness\n* syll: syllable phonological form\n* nbsyll: number of syllables\n* cv-cv: syllable phonological structure\n* orthrenv: reverse orthographic form\n* phonrenv: reversed phonological form\n* orthosyll: syllable orthographic form\n* cgramortho: the different grammatical category for a given orthographic representation\n* deflem: the percentage of people who said they knew the lemma of the word\n* defobs: the size of the sample from which \'deflem\' is derived\n* old20:  orthographic Levenshtein Distance\n* pld20: phonological Levenshtein Distance\n* morphoder: inflectional morphology\n* nbmorph: the number of morphemes directly computed from \'morphoder\'\n\n\nYou can find all the relevant information in the `official documentation of Lexique383`_ (French).\n\n\nFeatures\n--------\n\n* Extract all lexical information from a French  word such as:\n    * orthographic and phonemics representations\n    * associated lemmas\n    * syllabation\n    * grammatical category\n    * gender and number\n    * frequencies in a corpus of books and in a body of film subtitles, etc...\n* Extract all the lexical forms of a French word.\n* Easy to use Api.\n* Easily integrate pylexique in your own projects as an imported library.\n* Can be used as a command line tool.\n\nCredits\n-------\n\nMain developer SekouDiaoNlp_.\n\nLexical corpus: Lexique383_\n\nAbout Lexique383\n================\n\nLexique3\n========\n\nLexique 3.83 is a French lexical database that provides\nfor ~ 140,000 words of French: orthographic and phonemics representations,\nassociated lemmas, syllabation, grammatical category, gender and number,\nfrequencies in a corpus of books and in a body of film subtitles, etc...\n\n|\n\nLexique 3.83 est une base de données lexicales du français qui fournit\npour ~140000 mots du français: les représentations orthographiques et\nphonémiques, les lemmes associés, la syllabation, la catégorie\ngrammaticale, le genre et le nombre, les fréquences dans un corpus de\nlivres et dans un corpus de sous-titres de films, etc...\n\nTable: `Lexique383.zip`_\n\nWeb site: http://www.lexique.org\n\nOnline: http://www.lexique.org/shiny/lexique\n\nPublications\n------------\n\n-  New, Boris, Christophe Pallier, Marc Brysbaert, and Ludovic Ferrand.\n   2004. "Lexique 2: A New French Lexical Database." *Behavior Research\n   Methods, Instruments, & Computers* 36 (3): 516--524.\n   `DOI <https://doi.org/10.3758/bf03195598>`__.\n   `pdf`_\n\n-  New, Boris, Christophe Pallier, Ludovic Ferrand, and Rafael Matos.\n   2001. "Une Base de Données Lexicales Du Français Contemporain Sur\n   Internet: LEXIQUE" *L\'Année Psychologique* 101 (3): 447--462.\n   `DOI <https://doi.org/10.1017/S014271640707035X>`__.\n   `pdf <https://docs.google.com/viewer?url=http://www.lexique.org/outils/Lexique_Annee.pdf>`__\n\n-  Boris New, Marc Brysbaert, Jean Veronis, and Christophe Pallier.\n   2007. "The Use of Film Subtitles to Estimate Word Frequencies."\n   Applied Psycholinguistics 28 (4): 661--77.\n   `DOI <https://doi.org/10.1017/S014271640707035X>`__.\n   (`pdf <https://drive.google.com/file/d/1uvKrxGqETXkFeRH4PcYaql8ES9FjEdbV/view?usp=sharing>`__)\n\nContributors\n------------\n\n-  Boris New & Christophe Pallier\n-  Ronald Peereman\n-  Sophie Dufour\n-  Christian Lachaud\n-  and many others... (contact us to be listed)\n\nLicense\n-------\n\n`CC BY SA40.0`_\n\n.. _Lexique383.zip: http://www.lexique.org/databases/Lexique383/Lexique383.zip\n.. _pdf: https://docs.google.com/viewer?url=http://sites.google.com/site/borisnew/pub/New-et-al2004-BRMIC.pdf?attredirects=0\n.. _CC BY SA40.0: LICENSE-CC-BY-SA4.0.txt\n\n\nBibTex Entry to cite publications about Lexique383:\n\n\n.. code:: bibtex\n\n    @article{npbf04,\n    author = {New, B. and Pallier, C. and Brysbaert, M. and Ferrand, L.},\n    journal = {ehavior Research Methods, Instruments, & Computers},\n    number = {3},\n    pages = {516-524},\n    title = {Lexique 2 : A New French Lexical Database},\n    volume = {36},\n    year = {2004},\n    eprint = {http://www.lexique.org/?page_id=294},\n    }\n\n.. code:: bibtex\n\n    @article{npfm01,\n    author = {New, B. and Pallier, C. and Ferrand, L. and Matos, R.},\n    journal = {L\'Ann{\\\'e}e Pschologique},\n    number = {447-462},\n    pages = {1396-2},\n    title = {Une base de donn{\\\'e}es lexicales du fran\\c{c}ais contemporain sur internet: LEXIQUE},\n    volume = {101},\n    year = {2001},\n    }\n\n.. code:: bibtex\n\n    @article{new_brysbaert_veronis_pallier_2007,\n    author={NEW, BORIS and BRYSBAERT, MARC and VERONIS, JEAN and PALLIER, CHRISTOPHE},\n    title={The use of film subtitles to estimate word frequencies},\n    volume={28}, DOI={10.1017/S014271640707035X},\n    number={4}, journal={Applied Psycholinguistics},\n    publisher={Cambridge University Press},\n    year={2007},\n    pages={661–677}}\n\nBibTeX\n------\n\nIf you want to cite pylexique in an academic publication use this citation format:\n\n.. code:: bibtex\n\n   @article{pylexique,\n     title={pylexique},\n     author={Sekou Diao},\n     journal={GitHub. Note: https://github.com/SekouDiaoNlp/pylexique Cited by},\n     year={2021}\n   }\n\n\n.. _Lexique383: http://www.lexique.org/\n.. _SekouDiaoNlp: https://github.com/SekouDiaoNlp\n.. _`official documentation of Lexique383`: http://lexique.org/_documentation/Manuel_Lexique.3.2.pdf\n',
    'author': 'SekouDiaoNlp',
    'author_email': 'diao.sekou.nlp@gmail.com',
    'maintainer': 'SekouDiaoNlp',
    'maintainer_email': 'diao.sekou.nlp@gmail.com',
    'url': 'https://github.com/SekouDiaoNlp/pylexique',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4',
}


setup(**setup_kwargs)
