from typing import Type

from .exception import StrawberryException
from .exception_source import ExceptionSourceIsAttribute


class PrivateStrawberryFieldError(ExceptionSourceIsAttribute, StrawberryException):
    def __init__(self, field_name: str, cls: Type):
        self.cls = cls
        self.field_name = field_name

        self.message = (
            f"Field {field_name} on type {cls.__name__} cannot be both "
            "private and a strawberry.field"
        )
        self.rich_message = (
            f"`[underline]{self.field_name}[/]` field cannot be both "
            "private and a strawberry.field "
        )
        self.annotation_message = "private field defined here"
        self.suggestion = (
            "To fix this error you should either make the field non private, "
            "or remove the strawberry.field annotation."
        )

        super().__init__(self.message)
