"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainRecord = exports.DomainRecordProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dns_generated_1 = require("./dns.generated");
Object.defineProperty(exports, "DomainRecordProperty", { enumerable: true, get: function () { return dns_generated_1.RosDomainRecord; } });
/**
 * A ROS resource type:  `ALIYUN::DNS::DomainRecord`
 */
class DomainRecord extends ros.Resource {
    /**
     * Create a new `ALIYUN::DNS::DomainRecord`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomainRecord = new dns_generated_1.RosDomainRecord(this, id, {
            rr: props.rr,
            line: props.line,
            type: props.type,
            domainName: props.domainName,
            priority: props.priority,
            value: props.value,
            ttl: props.ttl === undefined || props.ttl === null ? 600 : props.ttl,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomainRecord;
        this.attrRecordId = rosDomainRecord.attrRecordId;
    }
}
exports.DomainRecord = DomainRecord;
//# sourceMappingURL=data:application/json;base64,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