# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['flyswot']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.0.0,<9.0.0',
 'click>=7.0,<8.0',
 'numpy>=1.20.2,<2.0.0',
 'onnxruntime>=1.7.0,<2.0.0',
 'rich>=10.1.0,<11.0.0',
 'toolz>=0.11.1,<0.12.0',
 'typer>=0.3.2,<0.4.0',
 'validators>=0.18.2,<0.19.0']

entry_points = \
{'console_scripts': ['flyswot = flyswot.cli:main']}

setup_kwargs = {
    'name': 'flyswot',
    'version': '0.0.3a0',
    'description': 'flyswot',
    'long_description': 'flyswot\n=======\n\n|PyPI| |Python Version| |License|\n\n|Read the Docs| |Tests| |Codecov|\n\n|pre-commit| |Black|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/flyswot.svg\n   :target: https://pypi.org/project/flyswot/\n   :alt: PyPI\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/flyswot\n   :target: https://pypi.org/project/flyswot\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/pypi/l/flyswot\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/flyswot/latest.svg?label=Read%20the%20Docs\n   :target: https://flyswot.readthedocs.io/\n   :alt: Read the documentation at https://flyswot.readthedocs.io/\n.. |Tests| image:: https://github.com/davanstrien/flyswot/workflows/Tests/badge.svg\n   :target: https://github.com/davanstrien/flyswot/actions?workflow=Tests\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/davanstrien/flyswot/branch/main/graph/badge.svg\n   :target: https://codecov.io/gh/davanstrien/flyswot\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n\n.. image:: https://raw.githubusercontent.com/davanstrien/flyswot/main/docs/_static/fly.png?token=ACEUI5KJ2HPO4ZGNTBX6OE3ARMXII\n\n\nDisclaimer\n-----------\n\n\n*flyswot* is a work in progress and is currently only intended to be used for testing by `HMD`_.\n\nFeatures\n--------\n\n`flyswot` is a Command Line Tool for detecting \'fake\' flysheets. TODO add description of project\n\n* unix style search patterns for matching images to predict against\n* produces a csv output containing the paths to the input images, the predicted label and the models confidence for that prediction.\n\n\nRequirements\n------------\n\n* Python 3.7+\n\nTODO update this section with requirements and uses.\n\nInstallation\n------------\n\nYou can install *flyswot* via pip_ from PyPI_:\n\n.. code:: console\n\n   $ pip install flyswot\n\nThis will install the latest release version of *flyswot*\n\nDetailed Installation Guide\n---------------------------\n\nThis section gives a more detailed instructions for installing *flyswot*. This guidance is aimed particularly at `HMD`_ users of *flyswot*. This set of instructions covers the steps required to install *flyswot*.\n\nNote on the examples\n^^^^^^^^^^^^^^^^^^^^\n\nYou will see examples for input in the guidance below which looks like:\n\n.. code:: console\n\n          $ pip\n\nThe ``$`` symbol here is often used as a convention to show that this is input to a terminal/command line. When you input this into your own terminal you should only input the part after the ``$`` symbol. For example, in the above case you would type ``pip``.\n\n\nInstall Python\n^^^^^^^^^^^^^^\n\n*flyswot* uses the `Python`_ programming language. You will therefore need to have Python installed on your computer to run *flyswot*.\n\nFor HMD users of `flyswot` it is suggested to use the `Anaconda`_ distribution of Python. If you are on a managed PC/laptop you should request this via Technology.\n\nCreate and activate a Conda Environment\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nA virtual environment allows us to isolate the requirements of different python packages. This can be useful since different python packages might have different requirements. Using a virtual environment allows us to install these in a way where you are less likely to have conflicts between these packages.\n\nThere are various different ways of creating virtual environments within Python. Anaconda comes with a system for creating virtual environment\'s. Creating Conda environments within Conda can be done in various ways, if you are new to Python and Anaconda it is suggested to use `Anaconda Navigator`_.\n\nYou can find more detailed instructions for creating a new virtual environments in the `Anaconda documentation`_. Briefly you should:\n\n- Open Anaconda Navigator\n- Navigate to the *Environments* tab\n- Create a new Python environment and give it a descriptive name i.e. *flyswot*. You should ensure that the Python version is greater than 3.7\n\nOnce you have created this new environment you can "activate it" by clicking on the arrow next to the name of the environment. You should select the "open terminal". This should open a new terminal window. On the left you should see the name of your environment in brackets:\n\n.. code:: console\n\n    (flyswot) $\n\nInstall flyswot in your Conda Environment\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nNow you have created and activated your conda environment you can install flyswot. Before doing this you can check that `pip`_ is available inside your environment:\n\n.. code:: console\n\n          $ pip\n\nThis should return the help pages for `pip`_. We can now use `pip`_ to install *flyswot* from `PyPI`_.\nTo do this run:\n\n.. code:: console\n\n   $ pip install flyswot\n\nYou should now see the installation process begin. During this you will see some information printed to the terminal abou what packages are being installed.\n\nCheck flyswot is installed\n^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nWe can quickly confirm that *flyswot* has been installed by printing out the help information. We can do this by typing:\n\n.. code:: console\n\n  $ flyswot --help\n\nThis should print some help information to the screen. If you get this it means you have successfully installed *flyswot* 💪.\n\n\nUsage\n-----\n\nTo run predictions against a directory of images:\n\n.. code:: console\n\n   $ flyswot predict directory manuscripts_folder .\n\n- *flyswot* will search inside the manuscripts_folder looking for image files.\n- By default it will look for files that contain :code:`FSE` in the filename since these are files which have been labelled as being "end flysheets".\n- Once it has found all the files labelled as `flysheet` it will then run a computer vision model against these images to see if they are labelled correctly i.e. if it is indeed a flysheet or something else.\n- flyswot will save a csv report containing the paths to the image, the directory the image is stored in, the label, and the confidence for that prediction.\n\nDetailed Usage Guide\n--------------------\n\nThis section provides additional guidance on the usage of *flyswot*. This is primarily aimed at `HMD`_ users of *flyswot*.\n\nHow flyswot searches for images\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n*flyswot* is currently intended to identify images which have an incorrect label associated with them. In particular it is currently intended to identify "fake" flysheets. These images have ``fse`` as part of their filename so this is used by flyswot to identify images which should be checked using the computer vision model. This can be channged if you also want to match other filename patterns.\n\nSince these images of concern will often be inside a directory structure *flyswot* will look in sub-folders from the input folder for images which contain ``fse`` in the name. For example in the following folder structure:\n\n.. code:: console\n\n   Collection/\n   ├─ item1/\n   │  ├─ add_ms_9403_fbspi.tif\n   │  ├─ add_ms_9403_fse001r.tif\n   │  ├─ add_ms_9403_fse001v.tif\n   ├─ item2/\n   │  ├─ sloane_ms_116_fblefr.tif\n   │  ├─ sloane_ms_116_fbspi.tif\n   │  ├─ sloane_ms_116_fse004r.tif\n\nAll of the images containing ``fse`` would be checked but others such as files containing ``fbspi`` and ``fblefr`` won\'t be checked since these aren\'t labelled as flysheets so don\'t need to be checked.\n\n\nRunning flyswot against a directory of images\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nTo run *flyswot* against a directory of images you need to give it the path to that directory/folder.\nThere are different ways you could do this. The following is suggested for people who are not very familiar (yet 😜) with terminal interfaces.\n\nIdentify the folder you want to flyswot to check for "fake" flysheets. If you are using *flyswot* for the first time it may make sense to choose a folder which doesn\'t contain a huge number of collection items so you don\'t have to wait to long for *flyswot* to finish running. Once you have found a directory you want to predict against copy the path. This path should be the full path to the item.\n\nFor example something that looks like:\n\n.. code:: console\n\n  \\\\ad\\collections\\hmd\\excitingcollection\\excitingsubcollection\\\n\n\nThis will be the folder from which *flyswot* starts looking.\n\nWhen you activated your conda environment in a terminal, you were likely \'inside\' your user directory. Since we need to specify a place for *flyswot* to store the CSV report, we\'ll move to a better place to store that output; your ``Desktop`` folder. To do we can navigate using the command:\n\n.. code:: console\n\n   $ chdir desktop\n\n\nif you are using  Mac, Linux or have GitBash installed you should instead run:\n\n.. code:: console\n\n   $ cd Desktop\n\n\n\nThis will take you to your Desktop. We\'ll now run *flyswot*. As with many other command line tools, *flyswot* has commands and sub-commands. We are interested in the ``predict`` command. This includes two sub-commands: ``predict-image`` and ``directory``.  We will mostly want to predict directories. To do this we use the following approach\n\n.. code:: console\n\n   $ flyswot predict directory input_directory output_directory\n\nThe input directory is the folder containing our images and the output directory is where we want to save our CSV report. Using the folder we previously identified this would look like:\n\n.. code:: console\n\n   $ flyswot predict directory \\\\ad\\collections\\hmd\\excitingcollection\\excitingsubcollection\\ .\n\nWe can use ``.`` to indicate we want the CSV report to be saved to the current directory (in this case the Deskop directory).\n\nOnce you run this command you should see some progress reported by *flyswot*, including a progress bar that shows how many of the images *flyswot* has predicted against.\n\nWhen *flyswot* has finshed you will have a CSV \'report\' which contains the path to the image, the predicted label and the confidence for that prediction.\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\nDistributed under the terms of the `MIT license`_,\n*flyswot* is free and open source software.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\n\nThis project was generated from `@cjolowicz`_\'s `Hypermodern Python Cookiecutter`_ template.\n\n.. _@cjolowicz: https://github.com/cjolowicz\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _MIT license: https://opensource.org/licenses/MIT\n.. _PyPI: https://pypi.org/\n.. _Hypermodern Python Cookiecutter: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n.. _file an issue: https://github.com/davanstrien/flyswot/issues\n.. _pip: https://pip.pypa.io/\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n.. _Usage: https://flyswot.readthedocs.io/en/latest/usage.html\n.. _HMD: https://www.bl.uk/projects/heritage-made-digital\n.. _Python: https://www.python.org/\n.. _Anaconda: https://www.anaconda.com/products/individual\n.. _Anaconda Navigator: https://docs.anaconda.com/anaconda/navigator/\n.. _Anaconda Documentation: https://docs.anaconda.com/anaconda/navigator/tutorials/manage-environments/#creating-a-new-environment\n',
    'author': 'Daniel van Strien',
    'author_email': 'daniel.van-strien@bl.uk',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/davanstrien/flyswot',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.0,<4.0.0',
}


setup(**setup_kwargs)
