"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core = require("@aws-cdk/core");
/**
 * Represents a provider for an AWS CloudFormation custom resources.
 */
class CustomResourceProvider {
    /**
     * @param serviceToken the ServiceToken which contains the ARN for this provider.
     */
    constructor(serviceToken) {
        this.serviceToken = serviceToken;
    }
    /**
     * The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     */
    static fromLambda(handler) {
        return new CustomResourceProvider(handler.functionArn);
    }
    /**
     * The SNS Topic for the provider that implements this custom resource.
     */
    static fromTopic(topic) {
        return new CustomResourceProvider(topic.topicArn);
    }
    /**
     * Use AWS Lambda as a provider.
     * @deprecated use `fromLambda`
     */
    static lambda(handler) { return this.fromLambda(handler); }
    /**
     * Use an SNS topic as the provider.
     * @deprecated use `fromTopic`
     */
    static topic(topic) { return this.fromTopic(topic); }
    bind(_) {
        return { serviceToken: this.serviceToken };
    }
}
exports.CustomResourceProvider = CustomResourceProvider;
/**
 * Deprecated.
 * @deprecated use `core.CustomResource`
 */
class CustomResource extends core.CustomResource {
    constructor(scope, id, props) {
        super(scope, id, {
            pascalCaseProperties: true,
            properties: props.properties,
            removalPolicy: props.removalPolicy,
            resourceType: props.resourceType,
            serviceToken: core.Lazy.stringValue({ produce: () => props.provider.bind(this).serviceToken }),
        });
    }
}
exports.CustomResource = CustomResource;
//# sourceMappingURL=data:application/json;base64,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