"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const sns = require("@aws-cdk/aws-sns");
const sns_subscriptions = require("@aws-cdk/aws-sns-subscriptions");
const sqs = require("@aws-cdk/aws-sqs");
const core_1 = require("@aws-cdk/core");
const cfn = require("../lib");
class MyNestedStack extends cfn.NestedStack {
    constructor(scope, id, props) {
        const topicNamePrefixLogicalId = 'TopicNamePrefix';
        super(scope, id, {
            parameters: {
                [topicNamePrefixLogicalId]: props.topicNamePrefix,
            },
        });
        const topicNamePrefixParameter = new core_1.CfnParameter(this, 'TopicNamePrefix', { type: 'String' });
        for (let i = 0; i < props.topicCount; ++i) {
            const topic = new sns.Topic(this, `topic-${i}`, { displayName: `${topicNamePrefixParameter.valueAsString}-${i}` });
            // since the subscription resources are defined in the subscriber's stack, this
            // will add an SNS subscription resource to the parent stack that reference this topic.
            if (props.subscriber) {
                topic.addSubscription(new sns_subscriptions.SqsSubscription(props.subscriber));
            }
        }
        if (props.subscriber) {
            new lambda.Function(this, 'fn', {
                runtime: lambda.Runtime.NODEJS_10_X,
                code: lambda.Code.inline('console.error("hi")'),
                handler: 'index.handler',
                environment: {
                    TOPIC_ARN: props.siblingTopic ? props.siblingTopic.topicArn : '',
                    QUEUE_URL: props.subscriber.queueUrl,
                },
            });
        }
    }
}
class MyTestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const queue = new sqs.Queue(this, 'SubscriberQueue');
        new MyNestedStack(this, 'NestedStack1', { topicCount: 3, topicNamePrefix: 'Prefix1', subscriber: queue });
        new MyNestedStack(this, 'NestedStack2', { topicCount: 2, topicNamePrefix: 'Prefix2' });
    }
}
const app = new core_1.App();
new MyTestStack(app, 'nested-stacks-test');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubmVzdGVkLXN0YWNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcubmVzdGVkLXN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQThDO0FBQzlDLHdDQUF3QztBQUN4QyxvRUFBb0U7QUFDcEUsd0NBQXdDO0FBQ3hDLHdDQUFvRTtBQUNwRSw4QkFBOEI7QUFTOUIsTUFBTSxhQUFjLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUFDekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF5QjtRQUNqRSxNQUFNLHdCQUF3QixHQUFHLGlCQUFpQixDQUFDO1FBRW5ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsVUFBVSxFQUFFO2dCQUNWLENBQUMsd0JBQXdCLENBQUMsRUFBRSxLQUFLLENBQUMsZUFBZTthQUNsRDtTQUNGLENBQUMsQ0FBQztRQUVILE1BQU0sd0JBQXdCLEdBQUcsSUFBSSxtQkFBWSxDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsQ0FBQyxDQUFDO1FBRS9GLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxLQUFLLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQyxFQUFFO1lBQ3pDLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLEVBQUUsRUFBRSxFQUFFLFdBQVcsRUFBRSxHQUFHLHdCQUF3QixDQUFDLGFBQWEsSUFBSSxDQUFDLEVBQUUsRUFBQyxDQUFDLENBQUM7WUFFbEgsK0VBQStFO1lBQy9FLHVGQUF1RjtZQUN2RixJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7Z0JBQ3BCLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSxpQkFBaUIsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7YUFDaEY7U0FDRjtRQUVELElBQUksS0FBSyxDQUFDLFVBQVUsRUFBRTtZQUNwQixJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRTtnQkFDOUIsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztnQkFDbkMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDO2dCQUMvQyxPQUFPLEVBQUUsZUFBZTtnQkFDeEIsV0FBVyxFQUFFO29CQUNYLFNBQVMsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRTtvQkFDaEUsU0FBUyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsUUFBUTtpQkFDckM7YUFDRixDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7Q0FDRjtBQUVELE1BQU0sV0FBWSxTQUFRLFlBQUs7SUFDN0IsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFFckQsSUFBSSxhQUFhLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRSxFQUFFLFVBQVUsRUFBRSxDQUFDLEVBQUUsZUFBZSxFQUFFLFNBQVMsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUMxRyxJQUFJLGFBQWEsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFLEVBQUUsVUFBVSxFQUFFLENBQUMsRUFBRSxlQUFlLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQztJQUN6RixDQUFDO0NBQ0Y7QUFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLElBQUksV0FBVyxDQUFDLEdBQUcsRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO0FBQzNDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcbmltcG9ydCAqIGFzIHNuc19zdWJzY3JpcHRpb25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMtc3Vic2NyaXB0aW9ucyc7XG5pbXBvcnQgKiBhcyBzcXMgZnJvbSAnQGF3cy1jZGsvYXdzLXNxcyc7XG5pbXBvcnQgeyBBcHAsIENmblBhcmFtZXRlciwgQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY2ZuIGZyb20gJy4uL2xpYic7XG5cbmludGVyZmFjZSBNeU5lc3RlZFN0YWNrUHJvcHMge1xuICByZWFkb25seSBzdWJzY3JpYmVyPzogc3FzLlF1ZXVlO1xuICByZWFkb25seSBzaWJsaW5nVG9waWM/OiBzbnMuVG9waWM7IC8vIGEgdG9waWMgZGVmaW5lZCBpbiBhIHNpYmxpbmcgbmVzdGVkIHN0YWNrXG4gIHJlYWRvbmx5IHRvcGljQ291bnQ6IG51bWJlcjtcbiAgcmVhZG9ubHkgdG9waWNOYW1lUHJlZml4OiBzdHJpbmc7XG59XG5cbmNsYXNzIE15TmVzdGVkU3RhY2sgZXh0ZW5kcyBjZm4uTmVzdGVkU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTXlOZXN0ZWRTdGFja1Byb3BzKSB7XG4gICAgY29uc3QgdG9waWNOYW1lUHJlZml4TG9naWNhbElkID0gJ1RvcGljTmFtZVByZWZpeCc7XG5cbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgW3RvcGljTmFtZVByZWZpeExvZ2ljYWxJZF06IHByb3BzLnRvcGljTmFtZVByZWZpeCwgLy8gcGFzcyBpbiBhIHBhcmFtZXRlciB0byB0aGUgbmVzdGVkIHN0YWNrXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgY29uc3QgdG9waWNOYW1lUHJlZml4UGFyYW1ldGVyID0gbmV3IENmblBhcmFtZXRlcih0aGlzLCAnVG9waWNOYW1lUHJlZml4JywgeyB0eXBlOiAnU3RyaW5nJyB9KTtcblxuICAgIGZvciAobGV0IGkgPSAwOyBpIDwgcHJvcHMudG9waWNDb3VudDsgKytpKSB7XG4gICAgICBjb25zdCB0b3BpYyA9IG5ldyBzbnMuVG9waWModGhpcywgYHRvcGljLSR7aX1gLCB7IGRpc3BsYXlOYW1lOiBgJHt0b3BpY05hbWVQcmVmaXhQYXJhbWV0ZXIudmFsdWVBc1N0cmluZ30tJHtpfWB9KTtcblxuICAgICAgLy8gc2luY2UgdGhlIHN1YnNjcmlwdGlvbiByZXNvdXJjZXMgYXJlIGRlZmluZWQgaW4gdGhlIHN1YnNjcmliZXIncyBzdGFjaywgdGhpc1xuICAgICAgLy8gd2lsbCBhZGQgYW4gU05TIHN1YnNjcmlwdGlvbiByZXNvdXJjZSB0byB0aGUgcGFyZW50IHN0YWNrIHRoYXQgcmVmZXJlbmNlIHRoaXMgdG9waWMuXG4gICAgICBpZiAocHJvcHMuc3Vic2NyaWJlcikge1xuICAgICAgICB0b3BpYy5hZGRTdWJzY3JpcHRpb24obmV3IHNuc19zdWJzY3JpcHRpb25zLlNxc1N1YnNjcmlwdGlvbihwcm9wcy5zdWJzY3JpYmVyKSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnN1YnNjcmliZXIpIHtcbiAgICAgIG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgJ2ZuJywge1xuICAgICAgICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTBfWCxcbiAgICAgICAgY29kZTogbGFtYmRhLkNvZGUuaW5saW5lKCdjb25zb2xlLmVycm9yKFwiaGlcIiknKSxcbiAgICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICAgIFRPUElDX0FSTjogcHJvcHMuc2libGluZ1RvcGljID8gcHJvcHMuc2libGluZ1RvcGljLnRvcGljQXJuIDogJycsXG4gICAgICAgICAgUVVFVUVfVVJMOiBwcm9wcy5zdWJzY3JpYmVyLnF1ZXVlVXJsLCAvLyBuZXN0ZWQgc3RhY2sgcmVmZXJlbmNlcyBhIHJlc291cmNlIGluIHRoZSBwYXJlbnRcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxufVxuXG5jbGFzcyBNeVRlc3RTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBxdWV1ZSA9IG5ldyBzcXMuUXVldWUodGhpcywgJ1N1YnNjcmliZXJRdWV1ZScpO1xuXG4gICAgbmV3IE15TmVzdGVkU3RhY2sodGhpcywgJ05lc3RlZFN0YWNrMScsIHsgdG9waWNDb3VudDogMywgdG9waWNOYW1lUHJlZml4OiAnUHJlZml4MScsIHN1YnNjcmliZXI6IHF1ZXVlIH0pO1xuICAgIG5ldyBNeU5lc3RlZFN0YWNrKHRoaXMsICdOZXN0ZWRTdGFjazInLCB7IHRvcGljQ291bnQ6IDIsIHRvcGljTmFtZVByZWZpeDogJ1ByZWZpeDInIH0pO1xuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbm5ldyBNeVRlc3RTdGFjayhhcHAsICduZXN0ZWQtc3RhY2tzLXRlc3QnKTtcbmFwcC5zeW50aCgpO1xuIl19