"use strict";
/// !cdk-integ Stack2
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cfn = require("../lib");
const app = new core_1.App();
const stack1 = new core_1.Stack(app, 'Stack1');
const stack2 = new core_1.Stack(app, 'Stack2');
const nestedUnderStack1 = new cfn.NestedStack(stack1, 'NestedUnderStack1');
const topicInNestedUnderStack1 = new sns.Topic(nestedUnderStack1, 'TopicInNestedUnderStack1');
new sns.Topic(stack2, 'TopicInStack2', {
    // topicName is too long for displayName, so just take the second part:
    // Stack1-NestedUnderStack1NestedStackNestedUnderStack1NestedStackResourceF616305B-EM64TEGA04J9-TopicInNestedUnderStack115E329C4-HEO7NLYC1AFL
    displayName: core_1.Fn.select(1, core_1.Fn.split('-', topicInNestedUnderStack1.topicName)),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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