// Generated by CoffeeScript 1.3.3

define(['cilantro/types/report/main', 'cilantro/types/scope/main', 'cilantro/types/domain/main', 'cilantro/types/concept/main', 'cilantro/pages/define/search', 'cilantro/pages/define/condition', 'cilantro/pages/define/interface'], function(Report, Scope, Domain, Concept, Search, Condition, Interface) {
  var conceptResults, concepts, conditions, domains, sessionReport;
  domains = new Domain.Models.Collection;
  concepts = new Concept.Models.Collection;
  sessionReport = new Report.Models.Session;
  conditions = {
    bind: function() {},
    fetch: function() {},
    remove: function() {}
  };
  conceptResults = new Search.ResultCollection;
  App.pending = 2;
  App.session = {};
  App.ready(function() {
    return domains.at(0).activate();
  });
  App.hub.subscribe('session/idle', function() {
    return sessionReport.stopPolling();
  });
  App.hub.subscribe('session/resume', function() {
    return sessionReport.startPolling();
  });
  return $(function() {
    var ConceptInterface, ConceptList, ConceptResultList, ConditionList, ConditionListPane, DomainTabs, ReportEditor, ReportName, UnsavedReport;
    ConceptInterface = new Interface.ConceptInterfaceView;
    DomainTabs = new Domain.Views.DomainCollectionView({
      collection: domains
    });
    ConceptList = new Concept.Views.CollectionView({
      collection: concepts
    });
    ConceptResultList = new Search.ResultListView({
      collection: conceptResults
    });
    ConditionList = new Condition.ListView({
      collection: conditions
    });
    ConditionListPane = new Condition.ListPane({
      list: ConditionList
    });
    ReportEditor = new Report.Views.Editor;
    ReportName = new Report.Views.Name({
      model: sessionReport
    });
    UnsavedReport = new Report.Messages.UnsavedReport({
      model: sessionReport
    });
    domains.fetch({
      initial: true,
      success: function() {
        return App.pending--;
      }
    });
    concepts.fetch({
      initial: true,
      success: function() {
        return App.pending--;
      }
    });
    conceptResults.fetch();
    conditions.fetch();
    sessionReport.fetch();
    return $(function() {
      var closeSearch, openSearch, searchInput, searchToggle, searchWrap;
      searchWrap = $('#concept-search-wrap');
      openSearch = function() {
        searchWrap.addClass('open');
        return searchInput.focus();
      };
      closeSearch = function() {
        return searchWrap.removeClass('open');
      };
      searchToggle = $('#concept-search-toggle').click(openSearch);
      return searchInput = $('#concept-search').on({
        blur: function(event) {
          return closeSearch();
        }
      });
    });
  });
});
