// Generated by CoffeeScript 1.3.3
var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

define(['underscore', 'common/views/collection', 'cilantro/types/report/main'], function(_, CollectionViews, Report) {
  var PerspectiveView, ReportView, ScopeView;
  ScopeView = (function(_super) {

    __extends(ScopeView, _super);

    function ScopeView() {
      this.render = __bind(this.render, this);
      return ScopeView.__super__.constructor.apply(this, arguments);
    }

    ScopeView.prototype.el = '#session-scope';

    ScopeView.prototype.defaultContent = '<li class="info">No conditions have been defined</li>';

    ScopeView.prototype.initialize = function() {
      this.model.bind('change:conditions', this.render);
      this.defaultContent = this.$(this.defaultContent);
      return this.el.append(this.defaultContent);
    };

    ScopeView.prototype.render = function() {
      var conditions, html, key, value;
      conditions = this.model.get('conditions');
      this.defaultContent.detach();
      this.el.empty();
      if (conditions) {
        html = '';
        for (key in conditions) {
          value = conditions[key];
          _.map(value, function(text) {
            return html += "<li>" + text + "</li>";
          });
        }
        this.el.html(html);
      } else {
        this.el.append(this.defaultContent);
      }
      return this.collapse();
    };

    return ScopeView;

  })(CollectionViews.ExpandableList);
  PerspectiveView = (function(_super) {

    __extends(PerspectiveView, _super);

    function PerspectiveView() {
      this.render = __bind(this.render, this);
      return PerspectiveView.__super__.constructor.apply(this, arguments);
    }

    PerspectiveView.prototype.el = '#session-perspective';

    PerspectiveView.prototype.defaultContent = '<li class="info">No data columns have been choosen</li>';

    PerspectiveView.prototype.initialize = function() {
      this.model.bind('change:header', this.render);
      this.defaultContent = this.$(this.defaultContent);
      return this.el.append(this.defaultContent);
    };

    PerspectiveView.prototype.template = _.template('<li><%= name %><% if (direction) { %>\
            <span class="info">(<%= direction %>)</span><% } %></li>');

    PerspectiveView.prototype.render = function() {
      var col, header, _i, _len;
      this.defaultContent.detach();
      this.el.empty();
      if ((header = this.model.get('header'))) {
        for (_i = 0, _len = header.length; _i < _len; _i++) {
          col = header[_i];
          this.el.append(this.template(col));
        }
      } else {
        this.el.append(this.defaultContent);
      }
      return this.collapse();
    };

    return PerspectiveView;

  })(CollectionViews.ExpandableList);
  ReportView = (function(_super) {

    __extends(ReportView, _super);

    function ReportView() {
      this.render = __bind(this.render, this);
      return ReportView.__super__.constructor.apply(this, arguments);
    }

    ReportView.prototype.el = '<div>\
                <strong><a role="name"></a></strong>\
                <span class="info">- <span role="unique-count"></span> unique <span role="verbose-name"></span></span>\
                <span class="info time" style="float: right">modified <span role="modified"></span><span role="timesince"></span></span>\
                <div role="description"></div>\
            </div>';

    ReportView.prototype.parent = '#session-report';

    ReportView.prototype.initialize = function() {
      this.el.prependTo(this.parent);
      return this.model.bind('change', this.render);
    };

    ReportView.prototype.render = function() {
      var name;
      ReportView.__super__.render.apply(this, arguments);
      name = this.model.get('name');
      if (this.model.hasChanged('name') && name) {
        return this.name.text(name).attr('href', this.model.get('permalink')).parent().show();
      } else if (!name) {
        return this.name.text('(session)');
      }
    };

    return ReportView;

  })(Report.Views.Item);
  return {
    Report: ReportView,
    Scope: ScopeView,
    Perspective: PerspectiveView
  };
});
