// Generated by CoffeeScript 1.3.3
var __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

define(['underscore', 'common/views/state', 'common/views/collection', 'common/views/popover'], function(_, stateview, collectionview, popover) {
  var ConceptCollectionView, ConceptDescriptionPopover, ConceptView;
  ConceptView = (function(_super) {

    __extends(ConceptView, _super);

    function ConceptView() {
      return ConceptView.__super__.constructor.apply(this, arguments);
    }

    ConceptView.prototype.template = _.template('<span class="name"><%= name %></span>\
            <span class="description"><%= description %></span>');

    ConceptView.prototype.events = {
      'click': 'click'
    };

    ConceptView.prototype.render = function() {
      this.el.html(this.template(this.model.toJSON()));
      this.el.data({
        id: this.model.id
      });
      return this;
    };

    ConceptView.prototype.click = function() {
      return this.model.activate({
        local: true
      });
    };

    return ConceptView;

  })(stateview.View);
  ConceptDescriptionPopover = (function(_super) {

    __extends(ConceptDescriptionPopover, _super);

    function ConceptDescriptionPopover() {
      return ConceptDescriptionPopover.__super__.constructor.apply(this, arguments);
    }

    ConceptDescriptionPopover.prototype.el = '#concept-description';

    ConceptDescriptionPopover.prototype.defaultContent = '<span class="info">No description available</span>';

    ConceptDescriptionPopover.prototype.update = function(view) {
      this.title.text(view.model.get('name'));
      return this.content.html(view.model.get('description') || this.defaultContent);
    };

    return ConceptDescriptionPopover;

  })(popover.Popover);
  ConceptCollectionView = (function(_super) {

    __extends(ConceptCollectionView, _super);

    function ConceptCollectionView() {
      this.activate = __bind(this.activate, this);

      this.scrollToConcept = __bind(this.scrollToConcept, this);
      return ConceptCollectionView.__super__.constructor.apply(this, arguments);
    }

    ConceptCollectionView.prototype.el = '#criteria';

    ConceptCollectionView.prototype.viewClass = ConceptView;

    ConceptCollectionView.prototype.events = {
      'mouseenter div': 'mouseenter',
      'mouseleave div': 'mouseleave',
      'click': 'click'
    };

    ConceptCollectionView.prototype.initialize = function() {
      ConceptCollectionView.__super__.initialize.apply(this, arguments);
      this.collection.bind('active', this.activate);
      return this.description = new ConceptDescriptionPopover;
    };

    ConceptCollectionView.prototype.reset = function(collection, options) {
      ConceptCollectionView.__super__.reset.apply(this, arguments);
      if (options.initial) {
        return this.el.parent().fadeIn();
      }
    };

    ConceptCollectionView.prototype.scrollToConcept = function(model) {
      var view;
      view = this.childViews[model.id];
      return this.el.scrollTo(view.el, {
        duration: 800,
        axis: 'y',
        offset: {
          top: this.el.outerHeight() / -2
        },
        easing: 'easeOutQuint'
      });
    };

    ConceptCollectionView.prototype.activate = function(model, options) {
      if (!(options != null ? options.local : void 0)) {
        _.defer(this.scrollToConcept, model);
      }
      return App.hub.publish('concept/active', model);
    };

    ConceptCollectionView.prototype.mouseenter = function(event) {
      var id, view;
      id = this.$(event.currentTarget).data('id');
      view = this.childViews[id];
      return this.description.show(view, 'right');
    };

    ConceptCollectionView.prototype.mouseleave = function(event) {
      return this.description.hide();
    };

    ConceptCollectionView.prototype.click = function() {
      return this.description.hide(true);
    };

    return ConceptCollectionView;

  })(collectionview.View);
  return {
    View: ConceptView,
    CollectionView: ConceptCollectionView
  };
});
