// Generated by CoffeeScript 1.3.3
var __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

define(['underscore', 'backbone', 'common/models/state', 'cilantro/types/domain/views'], function(_, Backbone, statemodel, DomainViews) {
  /*
      A Domain is a high-level organization for concepts. Only a single domain
      can be active at any given time.
  
      A domain can have subdomains associated with it. If this is the case, it
      will act as a delegate to those subdomains.
  */

  var Domain, DomainCollection, Subdomain, SubdomainCollection;
  Domain = (function(_super) {

    __extends(Domain, _super);

    function Domain() {
      return Domain.__super__.constructor.apply(this, arguments);
    }

    return Domain;

  })(statemodel.Model);
  /*
      The DomainCollection encapsulates cross-instance logic.
  */

  DomainCollection = (function(_super) {

    __extends(DomainCollection, _super);

    function DomainCollection() {
      return DomainCollection.__super__.constructor.apply(this, arguments);
    }

    DomainCollection.prototype.model = Domain;

    DomainCollection.prototype.url = App.endpoints.domains;

    DomainCollection.prototype.initialize = function() {
      var _this = this;
      this.bind('active', this.activate);
      this.bind('inactive', this.inactivate);
      return App.hub.subscribe('domain/request', function(id) {
        var domain, subdomain;
        domain = _this.get(id);
        if (domain) {
          return domain.activate();
        } else {
          subdomain = _this.subdomains.get(id);
          domain = _this.get(subdomain.get('parent').id);
          domain.activate();
          return subdomain.activate();
        }
      });
    };

    DomainCollection.prototype.comparator = function(model) {
      return model.get('order');
    };

    DomainCollection.prototype.parse = function(resp, xhr) {
      var domains, groups, id, key, subdomains;
      groups = _.groupBy(resp, function(obj) {
        var _ref;
        return ((_ref = obj['parent']) != null ? _ref.id : void 0) || null;
      });
      this.subdomains = new SubdomainCollection;
      new DomainViews.SubdomainCollectionView({
        collection: this.subdomains
      });
      domains = groups['null'];
      delete groups['null'];
      subdomains = _.flatten(_.values(groups));
      for (key in groups) {
        id = parseInt(key);
        subdomains.push({
          id: id,
          name: 'All',
          parent: {
            id: id
          }
        });
      }
      this.subdomains.reset(subdomains);
      return domains;
    };

    DomainCollection.prototype.activate = function(model) {
      App.hub.publish('domain/active', model.id);
      return this.chain().without(model).map(function(model) {
        return model.inactivate();
      });
    };

    DomainCollection.prototype.inactivate = function(model) {
      return App.hub.publish('domain/inactive', model.id);
    };

    return DomainCollection;

  })(Backbone.Collection);
  Subdomain = (function(_super) {

    __extends(Subdomain, _super);

    function Subdomain() {
      return Subdomain.__super__.constructor.apply(this, arguments);
    }

    return Subdomain;

  })(Domain);
  SubdomainCollection = (function(_super) {

    __extends(SubdomainCollection, _super);

    function SubdomainCollection() {
      this.toggleEnableByDomain = __bind(this.toggleEnableByDomain, this);
      return SubdomainCollection.__super__.constructor.apply(this, arguments);
    }

    SubdomainCollection.prototype.model = Subdomain;

    SubdomainCollection.prototype.initialize = function() {
      App.hub.subscribe('domain/active', this.toggleEnableByDomain);
      this.bind('reset', this.groupByDomain);
      this.bind('active', this.activate);
      return this.bind('inactive', this.inactivate);
    };

    SubdomainCollection.prototype.comparator = function(model) {
      return model.get('order');
    };

    SubdomainCollection.prototype.groupByDomain = function() {
      return this._byDomain = this.groupBy(function(model) {
        return model.get('parent').id;
      });
    };

    SubdomainCollection.prototype.toggleEnableByDomain = function(id) {
      var active,
        _this = this;
      active = false;
      this.map(function(model) {
        if (model.get('parent').id === id) {
          model.enable({
            reactivate: true
          });
          if (model.isActive()) {
            return active = true;
          }
        } else {
          return model.disable();
        }
      });
      if (!active && this._byDomain[id]) {
        return this.get(id).activate();
      }
    };

    SubdomainCollection.prototype.activate = function(model) {
      App.hub.publish('subdomain/active', model.id);
      return _(this._byDomain[model.get('parent').id]).without(model).map(function(model) {
        return model.inactivate();
      });
    };

    SubdomainCollection.prototype.inactivate = function(model) {
      return App.hub.publish('subdomain/inactive', model.id);
    };

    return SubdomainCollection;

  })(DomainCollection);
  return {
    Model: Domain,
    Collection: DomainCollection
  };
});
