// Generated by CoffeeScript 1.3.3
var __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

define(['backbone', 'underscore'], function(Backbone, _) {
  var LOG_LEVELS, Log, LogView, Message, MessageView;
  LOG_LEVELS = {
    'debug': 0,
    'info': 1,
    'warning': 2,
    'error': 3,
    'critical': 4
  };
  Message = (function(_super) {

    __extends(Message, _super);

    function Message() {
      return Message.__super__.constructor.apply(this, arguments);
    }

    Message.prototype.defaults = {
      level: 'info',
      timeout: 3000
    };

    return Message;

  })(Backbone.Model);
  Log = (function(_super) {

    __extends(Log, _super);

    function Log() {
      this.log = __bind(this.log, this);
      return Log.__super__.constructor.apply(this, arguments);
    }

    Log.prototype.model = Message;

    Log.prototype.initialize = function() {
      return App.hub.subscribe('log', this.log);
    };

    Log.prototype.log = function(message) {
      if (message instanceof Backbone.Model) {
        this.add(message);
        return console.log(message);
      }
    };

    return Log;

  })(Backbone.Collection);
  MessageView = (function(_super) {

    __extends(MessageView, _super);

    function MessageView() {
      return MessageView.__super__.constructor.apply(this, arguments);
    }

    MessageView.prototype.template = _.template('<div class="message <%= level %>"><%= message %></div>');

    MessageView.prototype.render = function() {
      this.el = this.$(this.template(this.model.get('message')));
      return this;
    };

    MessageView.prototype.show = function() {
      return this.el.fadeIn(500);
    };

    MessageView.prototype.hide = function() {
      return this.el.fadeOut(300);
    };

    return MessageView;

  })(Backbone.View);
  LogView = (function(_super) {

    __extends(LogView, _super);

    function LogView() {
      this.dismiss = __bind(this.dismiss, this);

      this.log = __bind(this.log, this);
      return LogView.__super__.constructor.apply(this, arguments);
    }

    LogView.prototype.el = '#messages';

    LogView.prototype.initialize = function() {
      App.hub.subscribe('log', this.log);
      App.hub.subscribe('dismiss', this.dismiss);
      return this.modelViews = {};
    };

    LogView.prototype.log = function(view) {
      var model;
      if (!(view instanceof Backbone.View)) {
        model = view;
        view = new MessageView({
          model: model
        });
        this.modelViews[model] = view;
      }
      this.el.append(view.el.hide());
      view.show();
      if (view.timeout) {
        return this._messageTimer = _.delay(function() {
          return view.hide();
        }, view.timeout);
      }
    };

    LogView.prototype.dismiss = function(view) {
      var model;
      if (!(view instanceof Backbone.View)) {
        model = view;
        view = this.modelViews[model];
        delete this.modelViews[model];
      }
      if (view) {
        clearTimeout(this._messageTimer);
        return view.hide();
      }
    };

    return LogView;

  })(Backbone.View);
  return {
    Message: Message,
    MessageView: MessageView,
    Log: Log,
    LogView: LogView
  };
});
