# WARNING: Do not edit by hand, this file was generated by Crank:
#
#   https://github.com/gocardless/crank
#

from . import base_service
from .. import resources
from ..paginator import Paginator
from .. import errors

class BillingRequestTemplatesService(base_service.BaseService):
    """Service class that provides access to the billing_request_templates
    endpoints of the GoCardless Pro API.
    """

    RESOURCE_CLASS = resources.BillingRequestTemplate
    RESOURCE_NAME = 'billing_request_templates'


    def list(self,params=None, headers=None):
        """List Billing Request Templates.

        Returns a [cursor-paginated](#api-usage-cursor-pagination) list of your
        Billing Request Templates.

        Args:
              params (dict, optional): Query string parameters.

        Returns:
              ListResponse of BillingRequestTemplate instances
        """
        path = '/billing_request_templates'
        

        response = self._perform_request('GET', path, params, headers,
                                         retry_failures=True)
        return self._resource_for(response)

    def all(self, params=None):
        if params is None:
            params = {}
        return Paginator(self, params)
    
  

    def get(self,identity,params=None, headers=None):
        """Get a single Billing Request Template.

        Fetches a Billing Request Template

        Args:
              identity (string): Unique identifier, beginning with "BRT".
              params (dict, optional): Query string parameters.

        Returns:
              BillingRequestTemplate
        """
        path = self._sub_url_params('/billing_request_templates/:identity', {
          
            'identity': identity,
          })
        

        response = self._perform_request('GET', path, params, headers,
                                         retry_failures=True)
        return self._resource_for(response)
  

    def create(self,params=None, headers=None):
        """Create a Billing Request Template.

        

        Args:
              params (dict, optional): Request body.

        Returns:
              BillingRequestTemplate
        """
        path = '/billing_request_templates'
        
        if params is not None:
            params = {self._envelope_key(): params}

        try:
          response = self._perform_request('POST', path, params, headers,
                                            retry_failures=True)
        except errors.IdempotentCreationConflictError as err:
          if self.raise_on_idempotency_conflict:
            raise err
          return self.get(identity=err.conflicting_resource_id,
                          params=params,
                          headers=headers)
        return self._resource_for(response)
  

    def update(self,identity,params=None, headers=None):
        """Update a Billing Request Template.

        Updates a Billing Request Template, which will affect all future
        Billing Requests created by this template.

        Args:
              identity (string): Unique identifier, beginning with "BRQ".
              params (dict, optional): Request body.

        Returns:
              BillingRequestTemplate
        """
        path = self._sub_url_params('/billing_request_templates/:identity', {
          
            'identity': identity,
          })
        
        if params is not None:
            params = {self._envelope_key(): params}

        response = self._perform_request('PUT', path, params, headers,
                                         retry_failures=True)
        return self._resource_for(response)
  
