# WARNING: Do not edit by hand, this file was generated by Crank:
#
#   https://github.com/gocardless/crank
#

from . import base_service
from .. import resources
from ..paginator import Paginator
from .. import errors

class WebhooksService(base_service.BaseService):
    """Service class that provides access to the webhooks
    endpoints of the GoCardless Pro API.
    """

    RESOURCE_CLASS = resources.Webhook
    RESOURCE_NAME = 'webhooks'


    def list(self,params=None, headers=None):
        """List webhooks.

        Returns a [cursor-paginated](#api-usage-cursor-pagination) list of your
        webhooks.

        Args:
              params (dict, optional): Query string parameters.

        Returns:
              ListResponse of Webhook instances
        """
        path = '/webhooks'
        

        response = self._perform_request('GET', path, params, headers,
                                         retry_failures=True)
        return self._resource_for(response)

    def all(self, params=None):
        if params is None:
            params = {}
        return Paginator(self, params)
    
  

    def get(self,identity,params=None, headers=None):
        """Get a single webhook.

        Retrieves the details of an existing webhook.

        Args:
              identity (string): Unique identifier, beginning with "WB".
              params (dict, optional): Query string parameters.

        Returns:
              Webhook
        """
        path = self._sub_url_params('/webhooks/:identity', {
          
            'identity': identity,
          })
        

        response = self._perform_request('GET', path, params, headers,
                                         retry_failures=True)
        return self._resource_for(response)
  

    def retry(self,identity,params=None, headers=None):
        """Retry a webhook.

        Requests for a previous webhook to be sent again

        Args:
              identity (string): Unique identifier, beginning with "WB".
              params (dict, optional): Request body.

        Returns:
              Webhook
        """
        path = self._sub_url_params('/webhooks/:identity/actions/retry', {
          
            'identity': identity,
          })
        
        if params is not None:
            params = {'data': params}
        response = self._perform_request('POST', path, params, headers,
                                         retry_failures=False)
        return self._resource_for(response)
  
