# WARNING: Do not edit by hand, this file was generated by Crank:
#
#   https://github.com/gocardless/crank
#

import json

import requests
import responses
from nose.tools import (
  assert_equal,
  assert_is_instance,
  assert_is_none,
  assert_is_not_none,
  assert_not_equal,
  assert_raises
)

from gocardless_pro.errors import MalformedResponseError
from gocardless_pro import resources
from gocardless_pro import list_response

from .. import helpers
  

@responses.activate
def test_blocks_create():
    fixture = helpers.load_fixture('blocks')['create']
    helpers.stub_response(fixture)
    response = helpers.client.blocks.create(*fixture['url_params'])
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.active, body.get('active'))
    assert_equal(response.block_type, body.get('block_type'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.reason_description, body.get('reason_description'))
    assert_equal(response.reason_type, body.get('reason_type'))
    assert_equal(response.resource_reference, body.get('resource_reference'))
    assert_equal(response.updated_at, body.get('updated_at'))

@responses.activate
def test_blocks_create_new_idempotency_key_for_each_call():
    fixture = helpers.load_fixture('blocks')['create']
    helpers.stub_response(fixture)
    helpers.client.blocks.create(*fixture['url_params'])
    helpers.client.blocks.create(*fixture['url_params'])
    assert_not_equal(responses.calls[0].request.headers.get('Idempotency-Key'),
                     responses.calls[1].request.headers.get('Idempotency-Key'))

def test_timeout_blocks_create_idempotency_conflict():
    create_fixture = helpers.load_fixture('blocks')['create']
    get_fixture = helpers.load_fixture('blocks')['get']
    with helpers.stub_timeout_then_idempotency_conflict(create_fixture, get_fixture) as rsps:
      response = helpers.client.blocks.create(*create_fixture['url_params'])
      assert_equal(2, len(rsps.calls))

    assert_is_instance(response, resources.Block)

@responses.activate
def test_timeout_blocks_create_retries():
    fixture = helpers.load_fixture('blocks')['create']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.blocks.create(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)

def test_502_blocks_create_retries():
    fixture = helpers.load_fixture('blocks')['create']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.blocks.create(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)
  

@responses.activate
def test_blocks_get():
    fixture = helpers.load_fixture('blocks')['get']
    helpers.stub_response(fixture)
    response = helpers.client.blocks.get(*fixture['url_params'])
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)
    assert_is_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.active, body.get('active'))
    assert_equal(response.block_type, body.get('block_type'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.reason_description, body.get('reason_description'))
    assert_equal(response.reason_type, body.get('reason_type'))
    assert_equal(response.resource_reference, body.get('resource_reference'))
    assert_equal(response.updated_at, body.get('updated_at'))

@responses.activate
def test_timeout_blocks_get_retries():
    fixture = helpers.load_fixture('blocks')['get']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.blocks.get(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)

def test_502_blocks_get_retries():
    fixture = helpers.load_fixture('blocks')['get']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.blocks.get(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)
  

@responses.activate
def test_blocks_list():
    fixture = helpers.load_fixture('blocks')['list']
    helpers.stub_response(fixture)
    response = helpers.client.blocks.list(*fixture['url_params'])
    body = fixture['body']['blocks']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.Block)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])
    assert_is_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal([r.active for r in response.records],
                 [b.get('active') for b in body])
    assert_equal([r.block_type for r in response.records],
                 [b.get('block_type') for b in body])
    assert_equal([r.created_at for r in response.records],
                 [b.get('created_at') for b in body])
    assert_equal([r.id for r in response.records],
                 [b.get('id') for b in body])
    assert_equal([r.reason_description for r in response.records],
                 [b.get('reason_description') for b in body])
    assert_equal([r.reason_type for r in response.records],
                 [b.get('reason_type') for b in body])
    assert_equal([r.resource_reference for r in response.records],
                 [b.get('resource_reference') for b in body])
    assert_equal([r.updated_at for r in response.records],
                 [b.get('updated_at') for b in body])

@responses.activate
def test_timeout_blocks_list_retries():
    fixture = helpers.load_fixture('blocks')['list']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.blocks.list(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['blocks']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.Block)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])

def test_502_blocks_list_retries():
    fixture = helpers.load_fixture('blocks')['list']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.blocks.list(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['blocks']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.Block)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])

@responses.activate
def test_blocks_all():
    fixture = helpers.load_fixture('blocks')['list']

    def callback(request):
        if 'after=123' in request.url:
          fixture['body']['meta']['cursors']['after'] = None
        else:
          fixture['body']['meta']['cursors']['after'] = '123'
        return [200, {}, json.dumps(fixture['body'])]

    url = 'http://example.com' + fixture['path_template']
    responses.add_callback(fixture['method'], url, callback)

    all_records = list(helpers.client.blocks.all())
    assert_equal(len(all_records), len(fixture['body']['blocks']) * 2)
    for record in all_records:
      assert_is_instance(record, resources.Block)
    
  

@responses.activate
def test_blocks_disable():
    fixture = helpers.load_fixture('blocks')['disable']
    helpers.stub_response(fixture)
    response = helpers.client.blocks.disable(*fixture['url_params'])
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.active, body.get('active'))
    assert_equal(response.block_type, body.get('block_type'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.reason_description, body.get('reason_description'))
    assert_equal(response.reason_type, body.get('reason_type'))
    assert_equal(response.resource_reference, body.get('resource_reference'))
    assert_equal(response.updated_at, body.get('updated_at'))

def test_timeout_blocks_disable_doesnt_retry():
    fixture = helpers.load_fixture('blocks')['disable']
    with helpers.stub_timeout(fixture) as rsps:
      with assert_raises(requests.ConnectTimeout):
        response = helpers.client.blocks.disable(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))

def test_502_blocks_disable_doesnt_retry():
    fixture = helpers.load_fixture('blocks')['disable']
    with helpers.stub_502(fixture) as rsps:
      with assert_raises(MalformedResponseError):
        response = helpers.client.blocks.disable(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))
  

@responses.activate
def test_blocks_enable():
    fixture = helpers.load_fixture('blocks')['enable']
    helpers.stub_response(fixture)
    response = helpers.client.blocks.enable(*fixture['url_params'])
    body = fixture['body']['blocks']

    assert_is_instance(response, resources.Block)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.active, body.get('active'))
    assert_equal(response.block_type, body.get('block_type'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.reason_description, body.get('reason_description'))
    assert_equal(response.reason_type, body.get('reason_type'))
    assert_equal(response.resource_reference, body.get('resource_reference'))
    assert_equal(response.updated_at, body.get('updated_at'))

def test_timeout_blocks_enable_doesnt_retry():
    fixture = helpers.load_fixture('blocks')['enable']
    with helpers.stub_timeout(fixture) as rsps:
      with assert_raises(requests.ConnectTimeout):
        response = helpers.client.blocks.enable(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))

def test_502_blocks_enable_doesnt_retry():
    fixture = helpers.load_fixture('blocks')['enable']
    with helpers.stub_502(fixture) as rsps:
      with assert_raises(MalformedResponseError):
        response = helpers.client.blocks.enable(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))
  

@responses.activate
def test_blocks_block_by_ref():
    fixture = helpers.load_fixture('blocks')['block_by_ref']
    helpers.stub_response(fixture)
    response = helpers.client.blocks.block_by_ref(*fixture['url_params'])
    body = fixture['body']['blocks']

    assert_is_instance(response, list_response.ListResponse)
    assert_is_instance(response.records[0], resources.Block)

    assert_equal(response.before, fixture['body']['meta']['cursors']['before'])
    assert_equal(response.after, fixture['body']['meta']['cursors']['after'])
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal([r.active for r in response.records],
                 [b.get('active') for b in body])
    assert_equal([r.block_type for r in response.records],
                 [b.get('block_type') for b in body])
    assert_equal([r.created_at for r in response.records],
                 [b.get('created_at') for b in body])
    assert_equal([r.id for r in response.records],
                 [b.get('id') for b in body])
    assert_equal([r.reason_description for r in response.records],
                 [b.get('reason_description') for b in body])
    assert_equal([r.reason_type for r in response.records],
                 [b.get('reason_type') for b in body])
    assert_equal([r.resource_reference for r in response.records],
                 [b.get('resource_reference') for b in body])
    assert_equal([r.updated_at for r in response.records],
                 [b.get('updated_at') for b in body])

def test_timeout_blocks_block_by_ref_doesnt_retry():
    fixture = helpers.load_fixture('blocks')['block_by_ref']
    with helpers.stub_timeout(fixture) as rsps:
      with assert_raises(requests.ConnectTimeout):
        response = helpers.client.blocks.block_by_ref(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))

def test_502_blocks_block_by_ref_doesnt_retry():
    fixture = helpers.load_fixture('blocks')['block_by_ref']
    with helpers.stub_502(fixture) as rsps:
      with assert_raises(MalformedResponseError):
        response = helpers.client.blocks.block_by_ref(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))
  
