# WARNING: Do not edit by hand, this file was generated by Crank:
#
#   https://github.com/gocardless/crank
#

import json

import requests
import responses
from nose.tools import (
  assert_equal,
  assert_is_instance,
  assert_is_none,
  assert_is_not_none,
  assert_not_equal,
  assert_raises
)

from gocardless_pro.errors import MalformedResponseError
from gocardless_pro import resources
from gocardless_pro import list_response

from .. import helpers
  

@responses.activate
def test_customer_notifications_handle():
    fixture = helpers.load_fixture('customer_notifications')['handle']
    helpers.stub_response(fixture)
    response = helpers.client.customer_notifications.handle(*fixture['url_params'])
    body = fixture['body']['customer_notifications']

    assert_is_instance(response, resources.CustomerNotification)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.action_taken, body.get('action_taken'))
    assert_equal(response.action_taken_at, body.get('action_taken_at'))
    assert_equal(response.action_taken_by, body.get('action_taken_by'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.type, body.get('type'))
    assert_equal(response.links.customer,
                 body.get('links')['customer'])
    assert_equal(response.links.event,
                 body.get('links')['event'])
    assert_equal(response.links.mandate,
                 body.get('links')['mandate'])
    assert_equal(response.links.payment,
                 body.get('links')['payment'])
    assert_equal(response.links.refund,
                 body.get('links')['refund'])
    assert_equal(response.links.subscription,
                 body.get('links')['subscription'])

def test_timeout_customer_notifications_handle_doesnt_retry():
    fixture = helpers.load_fixture('customer_notifications')['handle']
    with helpers.stub_timeout(fixture) as rsps:
      with assert_raises(requests.ConnectTimeout):
        response = helpers.client.customer_notifications.handle(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))

def test_502_customer_notifications_handle_doesnt_retry():
    fixture = helpers.load_fixture('customer_notifications')['handle']
    with helpers.stub_502(fixture) as rsps:
      with assert_raises(MalformedResponseError):
        response = helpers.client.customer_notifications.handle(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))
  
