# WARNING: Do not edit by hand, this file was generated by Crank:
#
#   https://github.com/gocardless/crank
#

import json

import requests
import responses
from nose.tools import (
  assert_equal,
  assert_is_instance,
  assert_is_none,
  assert_is_not_none,
  assert_not_equal,
  assert_raises
)

from gocardless_pro.errors import MalformedResponseError
from gocardless_pro import resources
from gocardless_pro import list_response

from .. import helpers
  

@responses.activate
def test_payer_authorisations_get():
    fixture = helpers.load_fixture('payer_authorisations')['get']
    helpers.stub_response(fixture)
    response = helpers.client.payer_authorisations.get(*fixture['url_params'])
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
    assert_is_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.incomplete_fields, body.get('incomplete_fields'))
    assert_equal(response.status, body.get('status'))
    assert_equal(response.bank_account.account_holder_name,
                 body.get('bank_account')['account_holder_name'])
    assert_equal(response.bank_account.account_number,
                 body.get('bank_account')['account_number'])
    assert_equal(response.bank_account.account_number_ending,
                 body.get('bank_account')['account_number_ending'])
    assert_equal(response.bank_account.account_number_suffix,
                 body.get('bank_account')['account_number_suffix'])
    assert_equal(response.bank_account.account_type,
                 body.get('bank_account')['account_type'])
    assert_equal(response.bank_account.bank_code,
                 body.get('bank_account')['bank_code'])
    assert_equal(response.bank_account.branch_code,
                 body.get('bank_account')['branch_code'])
    assert_equal(response.bank_account.country_code,
                 body.get('bank_account')['country_code'])
    assert_equal(response.bank_account.currency,
                 body.get('bank_account')['currency'])
    assert_equal(response.bank_account.iban,
                 body.get('bank_account')['iban'])
    assert_equal(response.bank_account.metadata,
                 body.get('bank_account')['metadata'])
    assert_equal(response.customer.address_line1,
                 body.get('customer')['address_line1'])
    assert_equal(response.customer.address_line2,
                 body.get('customer')['address_line2'])
    assert_equal(response.customer.address_line3,
                 body.get('customer')['address_line3'])
    assert_equal(response.customer.city,
                 body.get('customer')['city'])
    assert_equal(response.customer.company_name,
                 body.get('customer')['company_name'])
    assert_equal(response.customer.country_code,
                 body.get('customer')['country_code'])
    assert_equal(response.customer.danish_identity_number,
                 body.get('customer')['danish_identity_number'])
    assert_equal(response.customer.email,
                 body.get('customer')['email'])
    assert_equal(response.customer.family_name,
                 body.get('customer')['family_name'])
    assert_equal(response.customer.given_name,
                 body.get('customer')['given_name'])
    assert_equal(response.customer.locale,
                 body.get('customer')['locale'])
    assert_equal(response.customer.metadata,
                 body.get('customer')['metadata'])
    assert_equal(response.customer.postal_code,
                 body.get('customer')['postal_code'])
    assert_equal(response.customer.region,
                 body.get('customer')['region'])
    assert_equal(response.customer.swedish_identity_number,
                 body.get('customer')['swedish_identity_number'])
    assert_equal(response.links.bank_account,
                 body.get('links')['bank_account'])
    assert_equal(response.links.customer,
                 body.get('links')['customer'])
    assert_equal(response.links.mandate,
                 body.get('links')['mandate'])
    assert_equal(response.mandate.metadata,
                 body.get('mandate')['metadata'])
    assert_equal(response.mandate.payer_ip_address,
                 body.get('mandate')['payer_ip_address'])
    assert_equal(response.mandate.reference,
                 body.get('mandate')['reference'])
    assert_equal(response.mandate.scheme,
                 body.get('mandate')['scheme'])

@responses.activate
def test_timeout_payer_authorisations_get_retries():
    fixture = helpers.load_fixture('payer_authorisations')['get']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.payer_authorisations.get(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)

def test_502_payer_authorisations_get_retries():
    fixture = helpers.load_fixture('payer_authorisations')['get']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.payer_authorisations.get(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
  

@responses.activate
def test_payer_authorisations_create():
    fixture = helpers.load_fixture('payer_authorisations')['create']
    helpers.stub_response(fixture)
    response = helpers.client.payer_authorisations.create(*fixture['url_params'])
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.incomplete_fields, body.get('incomplete_fields'))
    assert_equal(response.status, body.get('status'))
    assert_equal(response.bank_account.account_holder_name,
                 body.get('bank_account')['account_holder_name'])
    assert_equal(response.bank_account.account_number,
                 body.get('bank_account')['account_number'])
    assert_equal(response.bank_account.account_number_ending,
                 body.get('bank_account')['account_number_ending'])
    assert_equal(response.bank_account.account_number_suffix,
                 body.get('bank_account')['account_number_suffix'])
    assert_equal(response.bank_account.account_type,
                 body.get('bank_account')['account_type'])
    assert_equal(response.bank_account.bank_code,
                 body.get('bank_account')['bank_code'])
    assert_equal(response.bank_account.branch_code,
                 body.get('bank_account')['branch_code'])
    assert_equal(response.bank_account.country_code,
                 body.get('bank_account')['country_code'])
    assert_equal(response.bank_account.currency,
                 body.get('bank_account')['currency'])
    assert_equal(response.bank_account.iban,
                 body.get('bank_account')['iban'])
    assert_equal(response.bank_account.metadata,
                 body.get('bank_account')['metadata'])
    assert_equal(response.customer.address_line1,
                 body.get('customer')['address_line1'])
    assert_equal(response.customer.address_line2,
                 body.get('customer')['address_line2'])
    assert_equal(response.customer.address_line3,
                 body.get('customer')['address_line3'])
    assert_equal(response.customer.city,
                 body.get('customer')['city'])
    assert_equal(response.customer.company_name,
                 body.get('customer')['company_name'])
    assert_equal(response.customer.country_code,
                 body.get('customer')['country_code'])
    assert_equal(response.customer.danish_identity_number,
                 body.get('customer')['danish_identity_number'])
    assert_equal(response.customer.email,
                 body.get('customer')['email'])
    assert_equal(response.customer.family_name,
                 body.get('customer')['family_name'])
    assert_equal(response.customer.given_name,
                 body.get('customer')['given_name'])
    assert_equal(response.customer.locale,
                 body.get('customer')['locale'])
    assert_equal(response.customer.metadata,
                 body.get('customer')['metadata'])
    assert_equal(response.customer.postal_code,
                 body.get('customer')['postal_code'])
    assert_equal(response.customer.region,
                 body.get('customer')['region'])
    assert_equal(response.customer.swedish_identity_number,
                 body.get('customer')['swedish_identity_number'])
    assert_equal(response.links.bank_account,
                 body.get('links')['bank_account'])
    assert_equal(response.links.customer,
                 body.get('links')['customer'])
    assert_equal(response.links.mandate,
                 body.get('links')['mandate'])
    assert_equal(response.mandate.metadata,
                 body.get('mandate')['metadata'])
    assert_equal(response.mandate.payer_ip_address,
                 body.get('mandate')['payer_ip_address'])
    assert_equal(response.mandate.reference,
                 body.get('mandate')['reference'])
    assert_equal(response.mandate.scheme,
                 body.get('mandate')['scheme'])

@responses.activate
def test_payer_authorisations_create_new_idempotency_key_for_each_call():
    fixture = helpers.load_fixture('payer_authorisations')['create']
    helpers.stub_response(fixture)
    helpers.client.payer_authorisations.create(*fixture['url_params'])
    helpers.client.payer_authorisations.create(*fixture['url_params'])
    assert_not_equal(responses.calls[0].request.headers.get('Idempotency-Key'),
                     responses.calls[1].request.headers.get('Idempotency-Key'))

def test_timeout_payer_authorisations_create_idempotency_conflict():
    create_fixture = helpers.load_fixture('payer_authorisations')['create']
    get_fixture = helpers.load_fixture('payer_authorisations')['get']
    with helpers.stub_timeout_then_idempotency_conflict(create_fixture, get_fixture) as rsps:
      response = helpers.client.payer_authorisations.create(*create_fixture['url_params'])
      assert_equal(2, len(rsps.calls))

    assert_is_instance(response, resources.PayerAuthorisation)

@responses.activate
def test_timeout_payer_authorisations_create_retries():
    fixture = helpers.load_fixture('payer_authorisations')['create']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.payer_authorisations.create(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)

def test_502_payer_authorisations_create_retries():
    fixture = helpers.load_fixture('payer_authorisations')['create']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.payer_authorisations.create(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
  

@responses.activate
def test_payer_authorisations_update():
    fixture = helpers.load_fixture('payer_authorisations')['update']
    helpers.stub_response(fixture)
    response = helpers.client.payer_authorisations.update(*fixture['url_params'])
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
    assert_is_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.incomplete_fields, body.get('incomplete_fields'))
    assert_equal(response.status, body.get('status'))
    assert_equal(response.bank_account.account_holder_name,
                 body.get('bank_account')['account_holder_name'])
    assert_equal(response.bank_account.account_number,
                 body.get('bank_account')['account_number'])
    assert_equal(response.bank_account.account_number_ending,
                 body.get('bank_account')['account_number_ending'])
    assert_equal(response.bank_account.account_number_suffix,
                 body.get('bank_account')['account_number_suffix'])
    assert_equal(response.bank_account.account_type,
                 body.get('bank_account')['account_type'])
    assert_equal(response.bank_account.bank_code,
                 body.get('bank_account')['bank_code'])
    assert_equal(response.bank_account.branch_code,
                 body.get('bank_account')['branch_code'])
    assert_equal(response.bank_account.country_code,
                 body.get('bank_account')['country_code'])
    assert_equal(response.bank_account.currency,
                 body.get('bank_account')['currency'])
    assert_equal(response.bank_account.iban,
                 body.get('bank_account')['iban'])
    assert_equal(response.bank_account.metadata,
                 body.get('bank_account')['metadata'])
    assert_equal(response.customer.address_line1,
                 body.get('customer')['address_line1'])
    assert_equal(response.customer.address_line2,
                 body.get('customer')['address_line2'])
    assert_equal(response.customer.address_line3,
                 body.get('customer')['address_line3'])
    assert_equal(response.customer.city,
                 body.get('customer')['city'])
    assert_equal(response.customer.company_name,
                 body.get('customer')['company_name'])
    assert_equal(response.customer.country_code,
                 body.get('customer')['country_code'])
    assert_equal(response.customer.danish_identity_number,
                 body.get('customer')['danish_identity_number'])
    assert_equal(response.customer.email,
                 body.get('customer')['email'])
    assert_equal(response.customer.family_name,
                 body.get('customer')['family_name'])
    assert_equal(response.customer.given_name,
                 body.get('customer')['given_name'])
    assert_equal(response.customer.locale,
                 body.get('customer')['locale'])
    assert_equal(response.customer.metadata,
                 body.get('customer')['metadata'])
    assert_equal(response.customer.postal_code,
                 body.get('customer')['postal_code'])
    assert_equal(response.customer.region,
                 body.get('customer')['region'])
    assert_equal(response.customer.swedish_identity_number,
                 body.get('customer')['swedish_identity_number'])
    assert_equal(response.links.bank_account,
                 body.get('links')['bank_account'])
    assert_equal(response.links.customer,
                 body.get('links')['customer'])
    assert_equal(response.links.mandate,
                 body.get('links')['mandate'])
    assert_equal(response.mandate.metadata,
                 body.get('mandate')['metadata'])
    assert_equal(response.mandate.payer_ip_address,
                 body.get('mandate')['payer_ip_address'])
    assert_equal(response.mandate.reference,
                 body.get('mandate')['reference'])
    assert_equal(response.mandate.scheme,
                 body.get('mandate')['scheme'])

@responses.activate
def test_timeout_payer_authorisations_update_retries():
    fixture = helpers.load_fixture('payer_authorisations')['update']
    with helpers.stub_timeout_then_response(fixture) as rsps:
      response = helpers.client.payer_authorisations.update(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)

def test_502_payer_authorisations_update_retries():
    fixture = helpers.load_fixture('payer_authorisations')['update']
    with helpers.stub_502_then_response(fixture) as rsps:
      response = helpers.client.payer_authorisations.update(*fixture['url_params'])
      assert_equal(2, len(rsps.calls))
      assert_equal(rsps.calls[0].request.headers.get('Idempotency-Key'),
                   rsps.calls[1].request.headers.get('Idempotency-Key'))
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
  

@responses.activate
def test_payer_authorisations_submit():
    fixture = helpers.load_fixture('payer_authorisations')['submit']
    helpers.stub_response(fixture)
    response = helpers.client.payer_authorisations.submit(*fixture['url_params'])
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.incomplete_fields, body.get('incomplete_fields'))
    assert_equal(response.status, body.get('status'))
    assert_equal(response.bank_account.account_holder_name,
                 body.get('bank_account')['account_holder_name'])
    assert_equal(response.bank_account.account_number,
                 body.get('bank_account')['account_number'])
    assert_equal(response.bank_account.account_number_ending,
                 body.get('bank_account')['account_number_ending'])
    assert_equal(response.bank_account.account_number_suffix,
                 body.get('bank_account')['account_number_suffix'])
    assert_equal(response.bank_account.account_type,
                 body.get('bank_account')['account_type'])
    assert_equal(response.bank_account.bank_code,
                 body.get('bank_account')['bank_code'])
    assert_equal(response.bank_account.branch_code,
                 body.get('bank_account')['branch_code'])
    assert_equal(response.bank_account.country_code,
                 body.get('bank_account')['country_code'])
    assert_equal(response.bank_account.currency,
                 body.get('bank_account')['currency'])
    assert_equal(response.bank_account.iban,
                 body.get('bank_account')['iban'])
    assert_equal(response.bank_account.metadata,
                 body.get('bank_account')['metadata'])
    assert_equal(response.customer.address_line1,
                 body.get('customer')['address_line1'])
    assert_equal(response.customer.address_line2,
                 body.get('customer')['address_line2'])
    assert_equal(response.customer.address_line3,
                 body.get('customer')['address_line3'])
    assert_equal(response.customer.city,
                 body.get('customer')['city'])
    assert_equal(response.customer.company_name,
                 body.get('customer')['company_name'])
    assert_equal(response.customer.country_code,
                 body.get('customer')['country_code'])
    assert_equal(response.customer.danish_identity_number,
                 body.get('customer')['danish_identity_number'])
    assert_equal(response.customer.email,
                 body.get('customer')['email'])
    assert_equal(response.customer.family_name,
                 body.get('customer')['family_name'])
    assert_equal(response.customer.given_name,
                 body.get('customer')['given_name'])
    assert_equal(response.customer.locale,
                 body.get('customer')['locale'])
    assert_equal(response.customer.metadata,
                 body.get('customer')['metadata'])
    assert_equal(response.customer.postal_code,
                 body.get('customer')['postal_code'])
    assert_equal(response.customer.region,
                 body.get('customer')['region'])
    assert_equal(response.customer.swedish_identity_number,
                 body.get('customer')['swedish_identity_number'])
    assert_equal(response.links.bank_account,
                 body.get('links')['bank_account'])
    assert_equal(response.links.customer,
                 body.get('links')['customer'])
    assert_equal(response.links.mandate,
                 body.get('links')['mandate'])
    assert_equal(response.mandate.metadata,
                 body.get('mandate')['metadata'])
    assert_equal(response.mandate.payer_ip_address,
                 body.get('mandate')['payer_ip_address'])
    assert_equal(response.mandate.reference,
                 body.get('mandate')['reference'])
    assert_equal(response.mandate.scheme,
                 body.get('mandate')['scheme'])

def test_timeout_payer_authorisations_submit_doesnt_retry():
    fixture = helpers.load_fixture('payer_authorisations')['submit']
    with helpers.stub_timeout(fixture) as rsps:
      with assert_raises(requests.ConnectTimeout):
        response = helpers.client.payer_authorisations.submit(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))

def test_502_payer_authorisations_submit_doesnt_retry():
    fixture = helpers.load_fixture('payer_authorisations')['submit']
    with helpers.stub_502(fixture) as rsps:
      with assert_raises(MalformedResponseError):
        response = helpers.client.payer_authorisations.submit(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))
  

@responses.activate
def test_payer_authorisations_confirm():
    fixture = helpers.load_fixture('payer_authorisations')['confirm']
    helpers.stub_response(fixture)
    response = helpers.client.payer_authorisations.confirm(*fixture['url_params'])
    body = fixture['body']['payer_authorisations']

    assert_is_instance(response, resources.PayerAuthorisation)
    assert_is_not_none(responses.calls[-1].request.headers.get('Idempotency-Key'))
    assert_equal(response.created_at, body.get('created_at'))
    assert_equal(response.id, body.get('id'))
    assert_equal(response.incomplete_fields, body.get('incomplete_fields'))
    assert_equal(response.status, body.get('status'))
    assert_equal(response.bank_account.account_holder_name,
                 body.get('bank_account')['account_holder_name'])
    assert_equal(response.bank_account.account_number,
                 body.get('bank_account')['account_number'])
    assert_equal(response.bank_account.account_number_ending,
                 body.get('bank_account')['account_number_ending'])
    assert_equal(response.bank_account.account_number_suffix,
                 body.get('bank_account')['account_number_suffix'])
    assert_equal(response.bank_account.account_type,
                 body.get('bank_account')['account_type'])
    assert_equal(response.bank_account.bank_code,
                 body.get('bank_account')['bank_code'])
    assert_equal(response.bank_account.branch_code,
                 body.get('bank_account')['branch_code'])
    assert_equal(response.bank_account.country_code,
                 body.get('bank_account')['country_code'])
    assert_equal(response.bank_account.currency,
                 body.get('bank_account')['currency'])
    assert_equal(response.bank_account.iban,
                 body.get('bank_account')['iban'])
    assert_equal(response.bank_account.metadata,
                 body.get('bank_account')['metadata'])
    assert_equal(response.customer.address_line1,
                 body.get('customer')['address_line1'])
    assert_equal(response.customer.address_line2,
                 body.get('customer')['address_line2'])
    assert_equal(response.customer.address_line3,
                 body.get('customer')['address_line3'])
    assert_equal(response.customer.city,
                 body.get('customer')['city'])
    assert_equal(response.customer.company_name,
                 body.get('customer')['company_name'])
    assert_equal(response.customer.country_code,
                 body.get('customer')['country_code'])
    assert_equal(response.customer.danish_identity_number,
                 body.get('customer')['danish_identity_number'])
    assert_equal(response.customer.email,
                 body.get('customer')['email'])
    assert_equal(response.customer.family_name,
                 body.get('customer')['family_name'])
    assert_equal(response.customer.given_name,
                 body.get('customer')['given_name'])
    assert_equal(response.customer.locale,
                 body.get('customer')['locale'])
    assert_equal(response.customer.metadata,
                 body.get('customer')['metadata'])
    assert_equal(response.customer.postal_code,
                 body.get('customer')['postal_code'])
    assert_equal(response.customer.region,
                 body.get('customer')['region'])
    assert_equal(response.customer.swedish_identity_number,
                 body.get('customer')['swedish_identity_number'])
    assert_equal(response.links.bank_account,
                 body.get('links')['bank_account'])
    assert_equal(response.links.customer,
                 body.get('links')['customer'])
    assert_equal(response.links.mandate,
                 body.get('links')['mandate'])
    assert_equal(response.mandate.metadata,
                 body.get('mandate')['metadata'])
    assert_equal(response.mandate.payer_ip_address,
                 body.get('mandate')['payer_ip_address'])
    assert_equal(response.mandate.reference,
                 body.get('mandate')['reference'])
    assert_equal(response.mandate.scheme,
                 body.get('mandate')['scheme'])

def test_timeout_payer_authorisations_confirm_doesnt_retry():
    fixture = helpers.load_fixture('payer_authorisations')['confirm']
    with helpers.stub_timeout(fixture) as rsps:
      with assert_raises(requests.ConnectTimeout):
        response = helpers.client.payer_authorisations.confirm(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))

def test_502_payer_authorisations_confirm_doesnt_retry():
    fixture = helpers.load_fixture('payer_authorisations')['confirm']
    with helpers.stub_502(fixture) as rsps:
      with assert_raises(MalformedResponseError):
        response = helpers.client.payer_authorisations.confirm(*fixture['url_params'])
      assert_equal(1, len(rsps.calls))
  
