"use strict";
const core_1 = require("@aws-cdk/core");
const events = require("../lib");
module.exports = {
    'cron expressions day and dow are mutex: given weekday'(test) {
        // Run every 10 minutes Monday through Friday
        test.equal('cron(0/10 * ? * MON-FRI *)', events.Schedule.cron({
            minute: '0/10',
            weekDay: 'MON-FRI'
        }).expressionString);
        test.done();
    },
    'cron expressions day and dow are mutex: given month day'(test) {
        // Run at 8:00 am (UTC) every 1st day of the month
        test.equal('cron(0 8 1 * ? *)', events.Schedule.cron({
            minute: '0',
            hour: '8',
            day: '1',
        }).expressionString);
        test.done();
    },
    'cron expressions day and dow are mutex: given neither'(test) {
        // Run at 10:00 am (UTC) every day
        test.equal('cron(0 10 * * ? *)', events.Schedule.cron({
            minute: '0',
            hour: '10',
        }).expressionString);
        test.done();
    },
    'rate must be whole number of minutes'(test) {
        test.throws(() => {
            events.Schedule.rate(core_1.Duration.seconds(12345));
        }, /'12345 seconds' cannot be converted into a whole number of minutes/);
        test.done();
    },
    'rate cannot be 0'(test) {
        test.throws(() => {
            events.Schedule.rate(core_1.Duration.days(0));
        }, /Duration cannot be 0/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5zY2hlZHVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3Quc2NoZWR1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHdDQUF5QztBQUV6QyxpQ0FBaUM7QUFFakMsaUJBQVM7SUFDUCx1REFBdUQsQ0FBQyxJQUFVO1FBQ2hFLDZDQUE2QztRQUM3QyxJQUFJLENBQUMsS0FBSyxDQUFDLDRCQUE0QixFQUFFLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO1lBQzVELE1BQU0sRUFBRSxNQUFNO1lBQ2QsT0FBTyxFQUFFLFNBQVM7U0FDbkIsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDckIsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELHlEQUF5RCxDQUFDLElBQVU7UUFDbEUsa0RBQWtEO1FBQ2xELElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CLEVBQUUsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUM7WUFDbkQsTUFBTSxFQUFFLEdBQUc7WUFDWCxJQUFJLEVBQUUsR0FBRztZQUNULEdBQUcsRUFBRSxHQUFHO1NBQ1QsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDckIsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELHVEQUF1RCxDQUFDLElBQVU7UUFDaEUsa0NBQWtDO1FBQ2xDLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEVBQUUsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUM7WUFDcEQsTUFBTSxFQUFFLEdBQUc7WUFDWCxJQUFJLEVBQUUsSUFBSTtTQUNYLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ3JCLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxzQ0FBc0MsQ0FBQyxJQUFVO1FBQy9DLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFO1lBQ2YsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsZUFBUSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQ2hELENBQUMsRUFBRSxvRUFBb0UsQ0FBQyxDQUFDO1FBQ3pFLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCxrQkFBa0IsQ0FBQyxJQUFVO1FBQzNCLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxFQUFFO1lBQ2YsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsZUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3pDLENBQUMsRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO1FBQzNCLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnLi4vbGliJztcblxuZXhwb3J0ID0ge1xuICAnY3JvbiBleHByZXNzaW9ucyBkYXkgYW5kIGRvdyBhcmUgbXV0ZXg6IGdpdmVuIHdlZWtkYXknKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBSdW4gZXZlcnkgMTAgbWludXRlcyBNb25kYXkgdGhyb3VnaCBGcmlkYXlcbiAgICB0ZXN0LmVxdWFsKCdjcm9uKDAvMTAgKiA/ICogTU9OLUZSSSAqKScsIGV2ZW50cy5TY2hlZHVsZS5jcm9uKHtcbiAgICAgIG1pbnV0ZTogJzAvMTAnLFxuICAgICAgd2Vla0RheTogJ01PTi1GUkknXG4gICAgfSkuZXhwcmVzc2lvblN0cmluZyk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ2Nyb24gZXhwcmVzc2lvbnMgZGF5IGFuZCBkb3cgYXJlIG11dGV4OiBnaXZlbiBtb250aCBkYXknKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBSdW4gYXQgODowMCBhbSAoVVRDKSBldmVyeSAxc3QgZGF5IG9mIHRoZSBtb250aFxuICAgIHRlc3QuZXF1YWwoJ2Nyb24oMCA4IDEgKiA/ICopJywgZXZlbnRzLlNjaGVkdWxlLmNyb24oe1xuICAgICAgbWludXRlOiAnMCcsXG4gICAgICBob3VyOiAnOCcsXG4gICAgICBkYXk6ICcxJyxcbiAgICB9KS5leHByZXNzaW9uU3RyaW5nKTtcbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnY3JvbiBleHByZXNzaW9ucyBkYXkgYW5kIGRvdyBhcmUgbXV0ZXg6IGdpdmVuIG5laXRoZXInKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBSdW4gYXQgMTA6MDAgYW0gKFVUQykgZXZlcnkgZGF5XG4gICAgdGVzdC5lcXVhbCgnY3JvbigwIDEwICogKiA/ICopJywgZXZlbnRzLlNjaGVkdWxlLmNyb24oe1xuICAgICAgbWludXRlOiAnMCcsXG4gICAgICBob3VyOiAnMTAnLFxuICAgIH0pLmV4cHJlc3Npb25TdHJpbmcpO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdyYXRlIG11c3QgYmUgd2hvbGUgbnVtYmVyIG9mIG1pbnV0ZXMnKHRlc3Q6IFRlc3QpIHtcbiAgICB0ZXN0LnRocm93cygoKSA9PiB7XG4gICAgICBldmVudHMuU2NoZWR1bGUucmF0ZShEdXJhdGlvbi5zZWNvbmRzKDEyMzQ1KSk7XG4gICAgfSwgLycxMjM0NSBzZWNvbmRzJyBjYW5ub3QgYmUgY29udmVydGVkIGludG8gYSB3aG9sZSBudW1iZXIgb2YgbWludXRlcy8pO1xuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdyYXRlIGNhbm5vdCBiZSAwJyh0ZXN0OiBUZXN0KSB7XG4gICAgdGVzdC50aHJvd3MoKCkgPT4ge1xuICAgICAgZXZlbnRzLlNjaGVkdWxlLnJhdGUoRHVyYXRpb24uZGF5cygwKSk7XG4gICAgfSwgL0R1cmF0aW9uIGNhbm5vdCBiZSAwLyk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59O1xuIl19