import setuptools

with open("version.txt", "r") as f:
    version = f.read()

with open("README.rst", "r") as f:
    long_description = f.read()

setuptools.setup(
    name="telegen-definitions",
    version=version,
    author="Alessandro Cerruti",
    author_email="strychnide@protonmail.com",
    description="Autogenerated telegen definitions",
    long_description=long_description,
    long_description_content_type="text/x-rst",
    url="https://gitlab.com/strychnide/telegen",
    project_urls={
        "Documentation": "https://strychnide.gitlab.io/telegen",
        "Issues": "https://gitlab.com/strychnide/telegen/-/issues",
        "Source": "https://gitlab.com/strychnide/telegen",
    },
    classifiers=[
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Topic :: Communications :: Chat",
        "Topic :: Internet",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    packages=["telegen_definitions"],
    python_requires=">=3.6",
)
