const path = require('path');

module.exports = {
  entry: "./src/client.ts",
  output: {
    path: path.resolve("build"),
    filename: "s3ff-client.js",
    libraryExport: "S3FF Client",
    libraryTarget: "umd"
  },
  resolve: {
    // Add `.ts` and `.tsx` as a resolvable extension.
    extensions: [".ts", ".tsx", ".js"]
  },
  module: {
    rules: [
      // all files with a `.ts` or `.tsx` extension will be handled by `ts-loader`
      {
        test: /\.tsx?$/,
        loader: "ts-loader",
        options: {
          configFile: "tsconfig.lib.json"
        }
      }
    ]
  },
};
