"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'moderation-demo', { env });
        // create the moderation
        const mod = new _1.Moderation(stack, 'Mod', {
            moderationLabels: [
                _1.ModerationLabels.EXPLICIT_NUDITY,
                _1.ModerationLabels.DRUGS,
                _1.ModerationLabels.TOBACCO,
                _1.ModerationLabels.ALCOHOL,
                _1.ModerationLabels.VIOLENCE,
                _1.ModerationLabels.RUDE_GESTURES,
            ],
        });
        // sns to telegram
        new _1.SNS2Telegram(stack, 'SNS2TG', {
            topic: mod.topic,
            chatid: '-547476398',
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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