# coding=utf-8
import random
from otlmow_model.BaseClasses.KeuzelijstField import KeuzelijstField
from otlmow_model.BaseClasses.KeuzelijstWaarde import KeuzelijstWaarde


# Generated with OTLEnumerationCreator. To modify: extend, do not edit
class KlNSB(KeuzelijstField):
    """Het mogelijke huidige natuurbeelden of natuurstreefbeelden."""
    naam = 'KlNSB'
    label = 'Natuurstreefbeeld'
    objectUri = 'https://wegenenverkeer.data.vlaanderen.be/ns/onderdeel#KlNSB'
    definition = 'Het mogelijke huidige natuurbeelden of natuurstreefbeelden.'
    status = 'ingebruik'
    codelist = 'https://wegenenverkeer.data.vlaanderen.be/id/conceptscheme/KlNSB'
    options = {
        '2130': KeuzelijstWaarde(invulwaarde='2130',
                                 label='2130',
                                 status='ingebruik',
                                 definitie='zanddoddengras, kleverige reigersbek, ruw vergeet-mij-nietje, kruipend stalkruid, zandhoornbloem, duinfakkelgras, liggende asperge, duindravik, duinviooltje, kegelsilene, ruwe klaver, duin- en gewimperd langbaardgras, lathyruswikke, geel walstro, grote tijm, geel zonneroosje, liggend bergvlas, nachtsilene, walstrobremraap, kalkbedstro, zachte haver, voorjaarsganzerik, duindravik, gestreepte klaver, wondklaver',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/2130'),
        '2330': KeuzelijstWaarde(invulwaarde='2330',
                                 label='2330',
                                 status='ingebruik',
                                 definitie='vroege haver, klein vogelpootje, zilverhaver, klein tasjeskruid, dwergviltkruid, eekhoorngras, zandblauwtje, veldereprijs, hazenpootje, eenjarige hardbloem, rode schijnspurrie, akkerviooltje, zandmuur, reigersbek, spurrie, straatgras, zandraket, vroegeling, kleine leeuwenklauw, zachte ooievaarsbek, klein streepzaad, gewoon langbaardgras, zandhoornbloem, slofhak ',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/2330'),
        '4030': KeuzelijstWaarde(invulwaarde='4030',
                                 label='4030',
                                 status='ingebruik',
                                 definitie='meidoorn spp., sleedoorn en rozen',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/4030'),
        '6120': KeuzelijstWaarde(invulwaarde='6120',
                                 label='6120',
                                 status='ingebruik',
                                 definitie='cipreswolfsmelk, geoorde zuring, gestreepte klaver, grote tijm, handjesgras, harige ratelaar, hemelsleutel, kaal breukkruid, kleine pimpernel, kleine ratelaar, knikkende distel, knolbeemdgras, kruisdistel, kweekdravik, moeslook, ronde ooievaarsbek, rozetkruidkers, rozetsteenkers, sikkelklaver, slangenlook, smalle raai, tripmadam, veldsalie, viltganzerik, voorjaarszegge, wit en zacht vetkruid, zachte haver, zeepkruid',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6120'),
        '6210-Hk': KeuzelijstWaarde(invulwaarde='6210-Hk',
                                    label='6210 Hk',
                                    status='ingebruik',
                                    definitie='blauwgras, bergdravik, duifkruid, grote centaurie, ruige scheefkelk, geel zonneroosje, kleine pimpernel, Kalkwalstro, gevinde kortsteel, aarddistel, smal fakkelgras, driedistel',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6210-Hk'),
        '6230-Ha': KeuzelijstWaarde(invulwaarde='6230-Ha',
                                    label='6230 Ha',
                                    status='ingebruik',
                                    definitie='Idem als hierboven maar met 3 soorten aanwezig uit: bosdroogbloem, dicht havikskruid, dwergviltkruid, eekhoorngras, geel walstro, grasklokje, steenanjer, viltganzerik, kleine tijm, zandblauwtje',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6230-Ha'),
        '6230-Hmo': KeuzelijstWaarde(invulwaarde='6230-Hmo',
                                     label='6230 Hmo',
                                     status='ingebruik',
                                     definitie='blauwe knoop, blauwe zegge, bleeksporig bosviooltje, bleke zegge, borstelgras, dicht havikskruid, echte guldenroede, fijn schapengras, fraai hertshooi, gelobde maanvaren, gevlekte orchis, heidekartelblad, hondsviooltje, kleine tijm, klokjesgentiaan, knollathyrus, kruipganzerik, liggend walstro, liggende vleugeltjesbloem, mannetjesereprijs, spits havikskruid, stijf havikskruid, stijve ogentroost, tandjesgras, tormentil, trekrus, tweenervige zegge, veelbloemige veldbies, zaagblad, klokjesgentiaan, heidekartelblad, welriekende nachtorchis',
                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6230-Hmo'),
        '6230-Hn': KeuzelijstWaarde(invulwaarde='6230-Hn',
                                    label='6230 Hn',
                                    status='ingebruik',
                                    definitie='blauwe knoop, blauwe zegge, bleeksporig bosviooltje, bleke zegge, borstelgras, dicht havikskruid, echte guldenroede, fijn schapengras, fraai hertshooi, gelobde maanvaren, gevlekte orchis, heidekartelblad, hondsviooltje, kleine tijm, klokjesgentiaan, knollathyrus, kruipganzerik, liggend walstro, liggende vleugeltjesbloem, mannetjesereprijs, spits havikskruid, stijf havikskruid, stijve ogentroost, tandjesgras, tormentil, trekrus, tweenervige zegge, veelbloemige veldbies, zaagblad, klokjesgentiaan, heidekartelblad, welriekende nachtorchis',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6230-Hn'),
        '6430': KeuzelijstWaarde(invulwaarde='6430',
                                 label='6430',
                                 status='ingebruik',
                                 definitie='oeverzegge, moeraszegge, gele lis, wolfspoot, hop, harig wilgenroosje, gewone smeerwortel, haagwinde, moerasandoorn, groot hoefblad, koninginnenkruid, grote kattenstaart, geoord helmkruid, gevleugeld helmkruid, viltige bastaardwederik, groot warkruid, moerasmelkdistel en heemst',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6430'),
        '6510Hu': KeuzelijstWaarde(invulwaarde='6510Hu',
                                   label='6510Hu',
                                   status='ingebruik',
                                   definitie='aardaker, beemdkroon, beemdooievaarsbek, bevertjes, gele morgenster, gewone agrimonie, gewone rolklaver, gewone vogelmelk, glad walstro, goudhaver, graslathyrus, groot streepzaad, grote bevernel, grote pimpernel, gulden boterbloem, gulden sleutelbloem, klavervreter, kleine bevernel, kleine ratelaar, knolboterbloem, knolsteenbreek, knoopkruid, kraailook, margriet, muskuskaasjeskruid, naakte lathyrus, rapunzelklokje, ruige leeuwentand, veldlathyrus, veldsalie, vijfdelig kaasjeskruid en zachte haver, grote ratelaar, vertakte leeuwentand, vierzadige wikke',
                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6510Hu'),
        '6510Huk': KeuzelijstWaarde(invulwaarde='6510Huk',
                                    label='6510Huk',
                                    status='ingebruik',
                                    definitie='aarddistel, beemdkroon, bevertjes, driedistel, duifkruid, geelhartje, gevinde kortsteel, gewone agrimonie, goudhaver, grote tijm, gulden sleutelbloem, kattendoorn, kleine bevernel, kleine pimpernel, knolboterbloem, kruipend stalkruid, ruige leeuwentand, ruige weegbree, voorjaarszegge, wilde marjolein, zachte haver, zeegroene zegge',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/6510Huk'),
        '9110': KeuzelijstWaarde(invulwaarde='9110',
                                 label='9110',
                                 status='ingebruik',
                                 definitie='Veldbies-Beukenbossen',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/9110'),
        '9120': KeuzelijstWaarde(invulwaarde='9120',
                                 label='9120',
                                 status='ingebruik',
                                 definitie='Eiken-Beukenbossen op zure bodems ',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/9120'),
        '9130': KeuzelijstWaarde(invulwaarde='9130',
                                 label='9130',
                                 status='ingebruik',
                                 definitie='Eiken-Beukenbossen met Wilde hyacint en ParelgrasBeukenbossen',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/9130'),
        '9150': KeuzelijstWaarde(invulwaarde='9150',
                                 label='9150',
                                 status='ingebruik',
                                 definitie='9150',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/9150'),
        '9160': KeuzelijstWaarde(invulwaarde='9160',
                                 label='9160',
                                 status='ingebruik',
                                 definitie='Essen-Eikenbossen zonder Wilde hyacint',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/9160'),
        '9190': KeuzelijstWaarde(invulwaarde='9190',
                                 label='9190',
                                 status='ingebruik',
                                 definitie='Oude Eiken-Berkenbossen op zeer voedselarm zand',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/9190'),
        '91E0': KeuzelijstWaarde(invulwaarde='91E0',
                                 label='91E0',
                                 status='ingebruik',
                                 definitie='grove den (min 50% van de boomlaag) + > 0,5 ha + oud bos + kenmerkende soorten: Lelietje-van-dalen, dalkruid, ruige veldbies, bosgierstgras, hulst, wilde kamperfoelie, gladde witbol, dubbelloof, valse salie, pilzegge, adelaarsvaren, grote veldbies, witte veldbies, gewone salomonszegel, bosanemoon, witte klaverzurig',
                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/91E0'),
        'andere-Cd': KeuzelijstWaarde(invulwaarde='andere-Cd',
                                      label='andere Cd',
                                      status='ingebruik',
                                      definitie='andere cd',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Cd'),
        'andere-Cm': KeuzelijstWaarde(invulwaarde='andere-Cm',
                                      label='andere Cm',
                                      status='ingebruik',
                                      definitie='andere cm',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Cm'),
        'andere-Cp': KeuzelijstWaarde(invulwaarde='andere-Cp',
                                      label='andere Cp',
                                      status='ingebruik',
                                      definitie='struikheide, dopheide, blauwe bosbes, stekelbrem, kruipbrem',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Cp'),
        'andere-Ha': KeuzelijstWaarde(invulwaarde='andere-Ha',
                                      label='andere Ha',
                                      status='ingebruik',
                                      definitie='akkerhoornbloem, gewone veldbies, gewoon biggenkruid, gewoon duizendblad, gewoon struisgras, hazenpootje, klein vogelpootje, kleine klaver, kleine leeuwentand, knolboterbloem, muizenoor, schapenzuring, smalle weegbree, vroege haver, zilverhaver',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Ha'),
        'andere-Hj': KeuzelijstWaarde(invulwaarde='andere-Hj',
                                      label='andere Hj',
                                      status='ingebruik',
                                      definitie='andere hj',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Hj'),
        'andere-Hp': KeuzelijstWaarde(invulwaarde='andere-Hp',
                                      label='andere Hp',
                                      status='ingebruik',
                                      definitie='geen soorten van de twee volgende types (rbbkam & rbbvos) aanwezig.',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Hp'),
        'andere-Hr': KeuzelijstWaarde(invulwaarde='andere-Hr',
                                      label='andere Hr',
                                      status='ingebruik',
                                      definitie='grote brandnetel, kleefkruid, ridderzuring, akkerdistel, speerdistel, gewone berenklauw, fluitenkruid, bramen, klit, jacobskruiskruid, ijle dravik, dolle kervel, kweek, kropaar, haagwinde, zevenblad',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Hr'),
        'andere-Hu': KeuzelijstWaarde(invulwaarde='andere-Hu',
                                      label='andere Hu',
                                      status='ingebruik',
                                      definitie='Voldoet niet aan de voorwaarden voor 6510 (< 7 soorten uit 6510)',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Hu'),
        'andere-Mr': KeuzelijstWaarde(invulwaarde='andere-Mr',
                                      label='andere Mr',
                                      status='ingebruik',
                                      definitie='riet en soorten uit R3',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Mr'),
        'andere-Sz': KeuzelijstWaarde(invulwaarde='andere-Sz',
                                      label='andere Sz',
                                      status='ingebruik',
                                      definitie='Andere Sz',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/andere-Sz'),
        'rbbha': KeuzelijstWaarde(invulwaarde='rbbha',
                                  label='rbbha',
                                  status='ingebruik',
                                  definitie='Soortenrijk struisgrasland met vrij algemene soorten',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbha'),
        'rbbhc': KeuzelijstWaarde(invulwaarde='rbbhc',
                                  label='rbbhc',
                                  status='ingebruik',
                                  definitie='echte koekoeksbloem, grote ratelaar, kruipend zenegroen, moeras/zompvergeet-me-nietje, dotterbloem, kale jonker, lidrus, moerasrolklaver, moeraswalstro, egelboterbloem, pinksterbloem, slanke sleutelbloem, tweerijige zegge, gewone waterbies, heelblaadjes, penningkruid, pijptorkruid, zomprus',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbhc'),
        'rbbhf': KeuzelijstWaarde(invulwaarde='rbbhf',
                                  label='rbbhf',
                                  status='ingebruik',
                                  definitie='wilde bertram, grote wederik, melkeppe, hennegras, ruw walstro, wateraardbei, moerasbeemdgras, veenpluis, veenmos en/of zwarte zegge, moerasspirea',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbhf'),
        'rbbhu': KeuzelijstWaarde(invulwaarde='rbbhu',
                                  label='rbbhu',
                                  status='ingebruik',
                                  definitie='min. 2 soorten abundant aanwezig uit:  kruipend zenegroen, pinksterbloem, tweerijige zegge, moesdistel, ruwe smele, lidrus, moerasspirea, beemdlangbloem, moerasrolklaver, echte koekoeksbloem, penningkruid, moeras/zompvergeet-mij-nietje, grote ratelaar, waterkruiskruid, smeerwortel, vogelwikke OF trosdravik of grote trosdravik aanwezig',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbhu'),
        'rbbkam': KeuzelijstWaarde(invulwaarde='rbbkam',
                                   label='rbbkam',
                                   status='ingebruik',
                                   definitie='kamgras en/of veldgerst abundant én aantal soorten >;15.',
                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbkam'),
        'rbbmr': KeuzelijstWaarde(invulwaarde='rbbmr',
                                  label='rbbmr',
                                  status='ingebruik',
                                  definitie='riet en soorten uit R3; kenmerken en kenmerkende soorten voor rbbmr worden in 2017 door INBO uitgewerkt.',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbmr'),
        'rbbppm': KeuzelijstWaarde(invulwaarde='rbbppm',
                                   label='rbbppm',
                                   status='ingebruik',
                                   definitie='Structuurrijke, oude bestanden van Grove den met een minimale leeftijd van tachtig jaar.',
                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbppm'),
        'rbbsf': KeuzelijstWaarde(invulwaarde='rbbsf',
                                  label='rbbsf',
                                  status='ingebruik',
                                  definitie='Boomlaag zoals hierboven + opp > 0,5 ha + oud bos met kenmerkende soorten van oud bos (bijlage 3), schraalland of heide (verder te bepalen met Bossleutel) ',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbsf'),
        'rbbsg': KeuzelijstWaarde(invulwaarde='rbbsg',
                                  label='rbbsg',
                                  status='ingebruik',
                                  definitie='Dit type staat voor begroeiingen waar Brem veel voorkomt of domineert. Soms komt ook de veel zeldzamere Gaspeldoorn voor. Bremstruwelen bedekken zelden volledige percelen.',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbsg'),
        'rbbsp': KeuzelijstWaarde(invulwaarde='rbbsp',
                                  label='rbbsp',
                                  status='ingebruik',
                                  definitie='Dit zijn struwelen die gedomineerd worden door houtige, doornige soorten zoals Sleedoorn, meidoorn (eenstijlige en tweestijlige) en/of rozen. We vinden dedoornige struwelen vooral terug als houtkanten en uitgegroeide hagen. ',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbsp'),
        'rbbzil': KeuzelijstWaarde(invulwaarde='rbbzil',
                                   label='rbbzil',
                                   status='ingebruik',
                                   definitie='zilt grasland: aardbeiklaver, akkerkers, getand vlotgras, gewone waterbies, heelblaadjes, klein vlooienkruid, kruipend moerasscherm, moeras/zompvergeetme-nietje, moeraszoutgras (polderstreek), penningkruid, pijptorkruid, platte rus, polei, rode ogentroost, slanke waterbies, smalle rolklaver (polderstreek), valse voszegge, watermunt, zeegroene rus, zilte rus, zilte zegge (polderstreek), zilverschoon, zomprus',
                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlNSB/rbbzil')
    }

    @classmethod
    def create_dummy_data(cls):
        return cls.create_dummy_data_keuzelijst(cls.options)

