/*
 * Copyright (c) 2018, Suprock Technologies
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>

#include "asphodel.h"


ASPHODEL_API const char * asphodel_error_name(int error_code)
{
	if (error_code == ASPHODEL_SUCCESS)
	{
		return "ASPHODEL_SUCCESS";
	}
	else
	{
		switch (error_code)
		{
		case ASPHODEL_ERROR_IO:
			return "ASPHODEL_ERROR_IO";
		case ASPHODEL_ACCESS_ERROR:
			return "ASPHODEL_ACCESS_ERROR";
		case ASPHODEL_NO_DEVICE:
			return "ASPHODEL_NO_DEVICE";
		case ASPHODEL_BUSY:
			return "ASPHODEL_BUSY";
		case ASPHODEL_TIMEOUT:
			return "ASPHODEL_TIMEOUT";
		case ASPHODEL_OVERFLOW:
			return "ASPHODEL_OVERFLOW";
		case ASPHODEL_PIPE_ERROR:
			return "ASPHODEL_PIPE_ERROR";
		case ASPHODEL_INTERRUPTED:
			return "ASPHODEL_INTERRUPTED";
		case ASPHODEL_NOT_SUPPORTED:
			return "ASPHODEL_NOT_SUPPORTED";
		case ASPHODEL_TRANSPORT_ERROR:
			return "ASPHODEL_TRANSPORT_ERROR";
		case ASPHODEL_STALL:
			return "ASPHODEL_STALL";
		case ASPHODEL_CANCELLED:
			return "ASPHODEL_CANCELLED";
		case ASPHODEL_NO_MEM:
			return "ASPHODEL_NO_MEM";
		case ASPHODEL_BAD_REPLY_LENGTH:
			return "ASPHODEL_BAD_REPLY_LENGTH";
		case ASPHODEL_MALFORMED_REPLY:
			return "ASPHODEL_MALFORMED_REPLY";
		case ASPHODEL_MALFORMED_ERROR:
			return "ASPHODEL_MALFORMED_ERROR";
		case ASPHODEL_MISMATCHED_TRANSACTION:
			return "ASPHODEL_MISMATCHED_TRANSACTION";
		case ASPHODEL_MISMATCHED_COMMAND:
			return "ASPHODEL_MISMATCHED_COMMAND";
		case ASPHODEL_TRANSFER_ERROR:
			return "ASPHODEL_TRANSFER_ERROR";
		case ASPHODEL_INVALID_DESCRIPTOR:
			return "ASPHODEL_INVALID_DESCRIPTOR";
		case ASPHODEL_FULL_TRANSACTION_TABLE:
			return "ASPHODEL_FULL_TRANSACTION_TABLE";
		case ASPHODEL_DEVICE_CLOSED:
			return "ASPHODEL_DEVICE_CLOSED";
		case ASPHODEL_BAD_PARAMETER:
			return "ASPHODEL_BAD_PARAMETER";
		case ASPHODEL_COUNTER_FORMAT_UNSUPPORTED:
			return "ASPHODEL_COUNTER_FORMAT_UNSUPPORTED";
		case ASPHODEL_CHANNEL_FORMAT_UNSUPPORTED:
			return "ASPHODEL_CHANNEL_FORMAT_UNSUPPORTED";
		case ASPHODEL_STREAM_ID_FORMAT_UNSUPPORTED:
			return "ASPHODEL_STREAM_ID_FORMAT_UNSUPPORTED";
		case ASPHODEL_TOO_MANY_TRIES:
			return "ASPHODEL_TOO_MANY_TRIES";
		case ASPHODEL_BAD_STREAM_PACKET_SIZE:
			return "ASPHODEL_BAD_STREAM_PACKET_SIZE";
		case ASPHODEL_BAD_CHANNEL_TYPE:
			return "ASPHODEL_BAD_CHANNEL_TYPE";
		case ASPHODEL_OUTGOING_PACKET_TOO_LONG:
			return "ASPHODEL_OUTGOING_PACKET_TOO_LONG";
		case ASPHODEL_BAD_STREAM_RATE:
			return "ASPHODEL_BAD_STREAM_RATE";
		case ASPHODEL_NOT_FOUND:
			return "ASPHODEL_NOT_FOUND";
		case ASPHODEL_NO_RESOURCES:
			return "ASPHODEL_NO_RESOURCES";
		case ASPHODEL_UNREACHABLE:
			return "ASPHODEL_UNREACHABLE";
		case ASPHODEL_UNINITIALIZED:
			return "ASPHODEL_UNINITIALIZED";
		case ERROR_CODE_UNSPECIFIED:
			return "ERROR_CODE_UNSPECIFIED";
		case ERROR_CODE_MALFORMED_COMMAND:
			return "ERROR_CODE_MALFORMED_COMMAND";
		case ERROR_CODE_UNIMPLEMENTED_COMMAND:
			return "ERROR_CODE_UNIMPLEMENTED_COMMAND";
		case ERROR_CODE_BAD_CMD_LENGTH:
			return "ERROR_CODE_BAD_CMD_LENGTH";
		case ERROR_CODE_BAD_ADDRESS:
			return "ERROR_CODE_BAD_ADDRESS";
		case ERROR_CODE_BAD_INDEX:
			return "ERROR_CODE_BAD_INDEX";
		case ERROR_CODE_INVALID_DATA:
			return "ERROR_CODE_INVALID_DATA";
		case ERROR_CODE_UNSUPPORTED:
			return "ERROR_CODE_UNSUPPORTED";
		case ERROR_CODE_BAD_STATE:
			return "ERROR_CODE_BAD_STATE";
		case ERROR_CODE_I2C_ERROR:
			return "ERROR_CODE_I2C_ERROR";
		case ERROR_CODE_INCOMPLETE:
			return "ERROR_CODE_INCOMPLETE";
		default:
			return "unknown";
		}
	}
}

ASPHODEL_API const char * asphodel_unit_type_name(uint8_t unit_type)
{
	switch (unit_type)
	{
	case UNIT_TYPE_NONE:
		return "UNIT_TYPE_NONE";
	case UNIT_TYPE_LSB:
		return "UNIT_TYPE_LSB";
	case UNIT_TYPE_PERCENT:
		return "UNIT_TYPE_PERCENT";
	case UNIT_TYPE_VOLT:
		return "UNIT_TYPE_VOLT";
	case UNIT_TYPE_AMPERE:
		return "UNIT_TYPE_AMPERE";
	case UNIT_TYPE_WATT:
		return "UNIT_TYPE_WATT";
	case UNIT_TYPE_OHM:
		return "UNIT_TYPE_OHM";
	case UNIT_TYPE_CELSIUS:
		return "UNIT_TYPE_CELSIUS";
	case UNIT_TYPE_PASCAL:
		return "UNIT_TYPE_PASCAL";
	case UNIT_TYPE_NEWTON:
		return "UNIT_TYPE_NEWTON";
	case UNIT_TYPE_M_PER_S:
		return "UNIT_TYPE_M_PER_S";
	case UNIT_TYPE_M_PER_S2:
		return "UNIT_TYPE_M_PER_S2";
	case UNIT_TYPE_DB:
		return "UNIT_TYPE_DB";
	case UNIT_TYPE_DBM:
		return "UNIT_TYPE_DBM";
	case UNIT_TYPE_STRAIN:
		return "UNIT_TYPE_STRAIN";
	case UNIT_TYPE_HZ:
		return "UNIT_TYPE_HZ";
	case UNIT_TYPE_SECOND:
		return "UNIT_TYPE_SECOND";
	case UNIT_TYPE_LSB_PER_CELSIUS:
		return "UNIT_TYPE_LSB_PER_CELSIUS";
	case UNIT_TYPE_GRAM_PER_S:
		return "UNIT_TYPE_GRAM_PER_S";
	case UNIT_TYPE_L_PER_S:
		return "UNIT_TYPE_L_PER_S";
	case UNIT_TYPE_NEWTON_METER:
		return "UNIT_TYPE_NEWTON_METER";
	case UNIT_TYPE_METER:
		return "UNIT_TYPE_METER";
	case UNIT_TYPE_GRAM:
		return "UNIT_TYPE_GRAM";
	case UNIT_TYPE_M3_PER_S:
		return "UNIT_TYPE_M3_PER_S";
	default:
		return "unknown";
	}
}

ASPHODEL_API uint8_t asphodel_get_unit_type_count(void)
{
	return UNIT_TYPE_COUNT;
}

ASPHODEL_API const char * asphodel_channel_type_name(uint8_t channel_type)
{
	switch (channel_type)
	{
	case CHANNEL_TYPE_LINEAR:
		return "CHANNEL_TYPE_LINEAR";
	case CHANNEL_TYPE_NTC:
		return "CHANNEL_TYPE_NTC";
	case CHANNEL_TYPE_ARRAY:
		return "CHANNEL_TYPE_ARRAY";
	case CHANNEL_TYPE_SLOW_STRAIN:
		return "CHANNEL_TYPE_SLOW_STRAIN";
	case CHANNEL_TYPE_FAST_STRAIN:
		return "CHANNEL_TYPE_FAST_STRAIN";
	case CHANNEL_TYPE_SLOW_ACCEL:
		return "CHANNEL_TYPE_SLOW_ACCEL";
	case CHANNEL_TYPE_PACKED_ACCEL:
		return "CHANNEL_TYPE_PACKED_ACCEL";
	case CHANNEL_TYPE_COMPOSITE_STRAIN:
		return "CHANNEL_TYPE_COMPOSITE_STRAIN";
	case CHANNEL_TYPE_LINEAR_ACCEL:
		return "CHANNEL_TYPE_LINEAR_ACCEL";
	case CHANNEL_TYPE_BIG_ENDIAN_FLOAT32:
		return "CHANNEL_TYPE_BIG_ENDIAN_FLOAT32";
	case CHANNEL_TYPE_BIG_ENDIAN_FLOAT64:
		return "CHANNEL_TYPE_BIG_ENDIAN_FLOAT64";
	case CHANNEL_TYPE_LITTLE_ENDIAN_FLOAT32:
		return "CHANNEL_TYPE_LITTLE_ENDIAN_FLOAT32";
	case CHANNEL_TYPE_LITTLE_ENDIAN_FLOAT64:
		return "CHANNEL_TYPE_LITTLE_ENDIAN_FLOAT64";
	default:
		return "unknown";
	}
}

ASPHODEL_API uint8_t asphodel_get_channel_type_count(void)
{
	return CHANNEL_TYPE_COUNT;
}

ASPHODEL_API const char * asphodel_setting_type_name(uint8_t setting_type)
{
	switch (setting_type)
	{
	case SETTING_TYPE_BYTE:
		return "SETTING_TYPE_BYTE";
	case SETTING_TYPE_BOOLEAN:
		return "SETTING_TYPE_BOOLEAN";
	case SETTING_TYPE_UNIT_TYPE:
		return "SETTING_TYPE_UNIT_TYPE";
	case SETTING_TYPE_CHANNEL_TYPE:
		return "SETTING_TYPE_CHANNEL_TYPE";
	case SETTING_TYPE_BYTE_ARRAY:
		return "SETTING_TYPE_BYTE_ARRAY";
	case SETTING_TYPE_STRING:
		return "SETTING_TYPE_STRING";
	case SETTING_TYPE_INT32:
		return "SETTING_TYPE_INT32";
	case SETTING_TYPE_INT32_SCALED:
		return "SETTING_TYPE_INT32_SCALED";
	case SETTING_TYPE_FLOAT:
		return "SETTING_TYPE_FLOAT";
	case SETTING_TYPE_FLOAT_ARRAY:
		return "SETTING_TYPE_FLOAT_ARRAY";
	case SETTING_TYPE_CUSTOM_ENUM:
		return "SETTING_TYPE_CUSTOM_ENUM";
	default:
		return "unknown";
	}
}

ASPHODEL_API uint8_t asphodel_get_setting_type_count(void)
{
	return SETTING_TYPE_COUNT;
}
