// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack.h"
#include "unpack_all_sizes.h"
#include "unwrap.h"
#include "unpack_id.h"


static void unpack_generic_0bit(const uint8_t * input, double * output, void *closure) {
	uintptr_t closure_value = (uintptr_t)closure;
	//int offset = closure_value & 0xFF;
	//int bits = (closure_value >> 8) & 0xFF;
	int count = (closure_value >> 16) & 0xFFFF;

	while (count > 0) {
		*output = 0.0;
		output++;
		count--;
	}
}

static void unpack_generic_32bit_acc_unsigned(const uint8_t * input, double * output, void *closure) {
	uintptr_t closure_value = (uintptr_t)closure;
	int offset = closure_value & 0xFF;
	int bits = (closure_value >> 8) & 0xFF;
	int count = (closure_value >> 16) & 0xFFFF;

	// load the first byte
	int valid_bits = 8 - offset;
	uint32_t accumulator = ((uint32_t)*input) << (24 + offset);
	input++;

	while (count > 0) {
		while (valid_bits < bits) {
			// load a byte
			accumulator |= (((uint32_t)*input) << (24 - valid_bits));
			input++;
			valid_bits += 8;
		}

		*output = (double)(accumulator >> (32 - bits));
		output++;
		count--;

		accumulator = accumulator << bits;
		valid_bits -= bits;
	}
}

static void unpack_generic_32bit_acc_signed(const uint8_t * input, double * output, void *closure) {
	uintptr_t closure_value = (uintptr_t)closure;
	int offset = closure_value & 0xFF;
	int bits = (closure_value >> 8) & 0xFF;
	int count = (closure_value >> 16) & 0xFFFF;

	// load the first byte
	int valid_bits = 8 - offset;
	int32_t accumulator = ((int32_t)*input) << (24 + offset);
	input++;

	while (count > 0) {
		while (valid_bits < bits) {
			// load a byte
			accumulator |= (((int32_t)*input) << (24 - valid_bits));
			input++;
			valid_bits += 8;
		}

		*output = (double)(accumulator >> (32 - bits));
		output++;
		count--;

		accumulator = accumulator << bits;
		valid_bits -= bits;
	}
}

static void unpack_generic_64bit_acc_unsigned(const uint8_t * input, double * output, void *closure) {
	uintptr_t closure_value = (uintptr_t)closure;
	int offset = closure_value & 0xFF;
	int bits = (closure_value >> 8) & 0xFF;
	int count = (closure_value >> 16) & 0xFFFF;

	// load the first byte
	int valid_bits = 8 - offset;
	uint64_t accumulator = ((uint64_t)*input) << (56 + offset);
	input++;

	while (count > 0) {
		while (valid_bits < bits) {
			// load a byte
			accumulator |= (((uint64_t)*input) << (56 - valid_bits));
			input++;
			valid_bits += 8;
		}

		*output = (double)(accumulator >> (64 - bits));
		output++;
		count--;

		accumulator = accumulator << bits;
		valid_bits -= bits;
	}
}

static void unpack_generic_64bit_acc_signed(const uint8_t * input, double * output, void *closure) {
	uintptr_t closure_value = (uintptr_t)closure;
	int offset = closure_value & 0xFF;
	int bits = (closure_value >> 8) & 0xFF;
	int count = (closure_value >> 16) & 0xFFFF;

	// load the first byte
	int valid_bits = 8 - offset;
	int64_t accumulator = ((int64_t)*input) << (56 + offset);
	input++;

	while (count > 0) {
		while (valid_bits < bits) {
			// load a byte
			accumulator |= (((int64_t)*input) << (56 - valid_bits));
			input++;
			valid_bits += 8;
		}

		*output = (double)(accumulator >> (64 - bits));
		output++;
		count--;

		accumulator = accumulator << bits;
		valid_bits -= bits;
	}
}

UNPACK_API unpack_func_t find_unpack(int count, int bits, int is_signed, int offset, void **closure) {
	if (0 <= offset && offset <= 7 && 1 <= count && count <= 0xFFFF) {
		switch (bits) {
			case 0:
				if (count <= UNPACK_0BIT_MAX_COUNT) {
					return unpack_0bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 1:
				if (count <= UNPACK_1BIT_MAX_COUNT) {
					return unpack_1bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 2:
				if (count <= UNPACK_2BIT_MAX_COUNT) {
					return unpack_2bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 3:
				if (count <= UNPACK_3BIT_MAX_COUNT) {
					return unpack_3bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 4:
				if (count <= UNPACK_4BIT_MAX_COUNT) {
					return unpack_4bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 5:
				if (count <= UNPACK_5BIT_MAX_COUNT) {
					return unpack_5bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 6:
				if (count <= UNPACK_6BIT_MAX_COUNT) {
					return unpack_6bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 7:
				if (count <= UNPACK_7BIT_MAX_COUNT) {
					return unpack_7bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 8:
				if (count <= UNPACK_8BIT_MAX_COUNT) {
					return unpack_8bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 9:
				if (count <= UNPACK_9BIT_MAX_COUNT) {
					return unpack_9bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 10:
				if (count <= UNPACK_10BIT_MAX_COUNT) {
					return unpack_10bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 11:
				if (count <= UNPACK_11BIT_MAX_COUNT) {
					return unpack_11bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 12:
				if (count <= UNPACK_12BIT_MAX_COUNT) {
					return unpack_12bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 13:
				if (count <= UNPACK_13BIT_MAX_COUNT) {
					return unpack_13bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 14:
				if (count <= UNPACK_14BIT_MAX_COUNT) {
					return unpack_14bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 15:
				if (count <= UNPACK_15BIT_MAX_COUNT) {
					return unpack_15bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 16:
				if (count <= UNPACK_16BIT_MAX_COUNT) {
					return unpack_16bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 17:
				if (count <= UNPACK_17BIT_MAX_COUNT) {
					return unpack_17bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 18:
				if (count <= UNPACK_18BIT_MAX_COUNT) {
					return unpack_18bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 19:
				if (count <= UNPACK_19BIT_MAX_COUNT) {
					return unpack_19bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 20:
				if (count <= UNPACK_20BIT_MAX_COUNT) {
					return unpack_20bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 21:
				if (count <= UNPACK_21BIT_MAX_COUNT) {
					return unpack_21bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 22:
				if (count <= UNPACK_22BIT_MAX_COUNT) {
					return unpack_22bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 23:
				if (count <= UNPACK_23BIT_MAX_COUNT) {
					return unpack_23bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 24:
				if (count <= UNPACK_24BIT_MAX_COUNT) {
					return unpack_24bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 25:
				if (count <= UNPACK_25BIT_MAX_COUNT) {
					return unpack_25bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 26:
				if (count <= UNPACK_26BIT_MAX_COUNT) {
					return unpack_26bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 27:
				if (count <= UNPACK_27BIT_MAX_COUNT) {
					return unpack_27bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 28:
				if (count <= UNPACK_28BIT_MAX_COUNT) {
					return unpack_28bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 29:
				if (count <= UNPACK_29BIT_MAX_COUNT) {
					return unpack_29bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 30:
				if (count <= UNPACK_30BIT_MAX_COUNT) {
					return unpack_30bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 31:
				if (count <= UNPACK_31BIT_MAX_COUNT) {
					return unpack_31bit[count - 1][offset][is_signed != 0];
				}
				break;
			case 32:
				if (count <= UNPACK_32BIT_MAX_COUNT) {
					return unpack_32bit[count - 1][offset][is_signed != 0];
				}
				break;
		}

		// no precompiled function available
		uintptr_t closure_value = (uint32_t)((count << 16) | (bits << 8) | offset);
		*closure = (void*)closure_value;
		if (bits == 0) {
			return unpack_generic_0bit;
		}
		else if (bits <= 24) {
			if (is_signed) {
				return unpack_generic_32bit_acc_signed;
			}
			else {
				return unpack_generic_32bit_acc_unsigned;
			}
		}
		else {
			if (is_signed) {
				return unpack_generic_64bit_acc_signed;
			}
			else {
				return unpack_generic_64bit_acc_unsigned;
			}
		}
	}

	return NULL;
}

UNPACK_API unwrap_func_t find_unwrap(int bits, int offset) {
	if (0 <= offset && offset <= 7) {
		if (UNWRAP_MIN_COUNT <= bits && bits <= UNWRAP_MAX_COUNT) {
			return unwrap[bits - UNWRAP_MIN_COUNT][offset];
		}
	}

	return NULL;
}

UNPACK_API unpack_id_func_t find_unpack_id(int bits, int offset) {
	if (0 <= offset && offset <= 7) {
		if (UNPACK_ID_MIN_COUNT <= bits && bits <= UNPACK_ID_MAX_COUNT) {
			return unpack_id[bits - UNPACK_ID_MIN_COUNT][offset];
		}
	}

	return NULL;
}
