// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack10.h"



static void unpack_1_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 10 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 10 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);
}

static void unpack_1_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 10 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);
}

static void unpack_2_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);
}

static void unpack_3_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 40 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 40 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);
}

static void unpack_4_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 50 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 50 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);
}

static void unpack_5_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 50 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);
}

static void unpack_6_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);
}

static void unpack_7_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 80 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 80 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);
}

static void unpack_8_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);
}

static void unpack_9_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);
}

static void unpack_10_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);
}

static void unpack_11_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);
}

static void unpack_12_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 130 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 130 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);
}

static void unpack_13_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 130 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);
}

static void unpack_14_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 150 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);
}

static void unpack_15_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 150 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);
}

static void unpack_16_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 170 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 170 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);
}

static void unpack_17_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 170 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);
}

static void unpack_18_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 190 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 190 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 190 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 190 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 190 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 190 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);
}

static void unpack_19_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 190 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 200 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 200 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);
}

static void unpack_20_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 210 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);
}

static void unpack_21_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 210 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);
}

static void unpack_22_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 230 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 230 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 230 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 221 to 230
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)(input[28] & 0xfe) << 21);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 230 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 221 to 230
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)(input[28] & 0xfe) << 21);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 230 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 222 to 231
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 230 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 222 to 231
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 223 to 232
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0x80) << 15);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 223 to 232
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0x80) << 15);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 224 to 233
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xc0) << 16);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 224 to 233
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xc0) << 16);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 225 to 234
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xe0) << 17);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 225 to 234
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xe0) << 17);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 226 to 235
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)(input[29] & 0xf0) << 18);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 226 to 235
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)(input[29] & 0xf0) << 18);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 227 to 236
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)(input[29] & 0xf8) << 19);
	output[22] = (double)(value >> 22);
}

static void unpack_23_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 230 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 227 to 236
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)(input[29] & 0xf8) << 19);
	output[22] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 230 to 239
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 230 to 239
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 221 to 230
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)(input[28] & 0xfe) << 21);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 231 to 240
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0x80) << 15);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 221 to 230
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)(input[28] & 0xfe) << 21);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 231 to 240
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0x80) << 15);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 222 to 231
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 232 to 241
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xc0) << 16);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 222 to 231
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 232 to 241
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xc0) << 16);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 223 to 232
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0x80) << 15);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 233 to 242
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xe0) << 17);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 223 to 232
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0x80) << 15);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 233 to 242
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xe0) << 17);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 224 to 233
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xc0) << 16);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 234 to 243
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xf0) << 18);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 224 to 233
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xc0) << 16);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 234 to 243
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xf0) << 18);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 225 to 234
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xe0) << 17);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 235 to 244
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xf8) << 19);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 225 to 234
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xe0) << 17);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 235 to 244
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xf8) << 19);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 226 to 235
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)(input[29] & 0xf0) << 18);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 236 to 245
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)(input[30] & 0xfc) << 20);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 226 to 235
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)(input[29] & 0xf0) << 18);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 236 to 245
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)(input[30] & 0xfc) << 20);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 227 to 236
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)(input[29] & 0xf8) << 19);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 237 to 246
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)(input[30] & 0xfe) << 21);
	output[23] = (double)(value >> 22);
}

static void unpack_24_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 227 to 236
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)(input[29] & 0xf8) << 19);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 237 to 246
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)(input[30] & 0xfe) << 21);
	output[23] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 230 to 239
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 240 to 249
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xc0) << 16);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 230 to 239
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 240 to 249
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xc0) << 16);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 221 to 230
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)(input[28] & 0xfe) << 21);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 231 to 240
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0x80) << 15);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 241 to 250
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xe0) << 17);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 1 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xe0) << 17);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 11 to 20
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xf8) << 19);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 21 to 30
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)(input[3] & 0xfe) << 21);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 31 to 40
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0x80) << 15);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 41 to 50
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xe0) << 17);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 51 to 60
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xf8) << 19);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 61 to 70
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)(input[8] & 0xfe) << 21);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 71 to 80
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0x80) << 15);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 81 to 90
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xe0) << 17);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 91 to 100
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xf8) << 19);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 101 to 110
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)(input[13] & 0xfe) << 21);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 111 to 120
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0x80) << 15);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 121 to 130
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xe0) << 17);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 131 to 140
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)(input[17] & 0xf8) << 19);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 141 to 150
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)(input[18] & 0xfe) << 21);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 151 to 160
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0x80) << 15);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 161 to 170
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xe0) << 17);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 171 to 180
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xf8) << 19);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 181 to 190
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)(input[23] & 0xfe) << 21);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 191 to 200
	value = ((uint32_t)(input[23] & 0x01) << 31) |
			((uint32_t)input[24] << 23) |
			((uint32_t)(input[25] & 0x80) << 15);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 201 to 210
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xe0) << 17);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 211 to 220
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xf8) << 19);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 221 to 230
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)(input[28] & 0xfe) << 21);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 231 to 240
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0x80) << 15);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 241 to 250
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xe0) << 17);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 2 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 222 to 231
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 232 to 241
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xc0) << 16);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 242 to 251
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xf0) << 18);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 2 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 11
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf0) << 18);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 12 to 21
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfc) << 20);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 22 to 31
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 32 to 41
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xc0) << 16);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 42 to 51
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xf0) << 18);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 52 to 61
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)(input[7] & 0xfc) << 20);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 62 to 71
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 72 to 81
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xc0) << 16);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 82 to 91
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf0) << 18);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 92 to 101
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)(input[12] & 0xfc) << 20);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 102 to 111
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 112 to 121
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xc0) << 16);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 122 to 131
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xf0) << 18);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 132 to 141
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)(input[17] & 0xfc) << 20);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 142 to 151
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 152 to 161
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)(input[20] & 0xc0) << 16);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 162 to 171
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xf0) << 18);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 172 to 181
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)(input[22] & 0xfc) << 20);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 182 to 191
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 192 to 201
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xc0) << 16);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 202 to 211
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)(input[26] & 0xf0) << 18);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 212 to 221
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)(input[27] & 0xfc) << 20);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 222 to 231
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 232 to 241
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xc0) << 16);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 242 to 251
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xf0) << 18);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 3 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 223 to 232
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0x80) << 15);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 233 to 242
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xe0) << 17);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 243 to 252
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xf8) << 19);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 3 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 12
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xf8) << 19);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 13 to 22
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)(input[2] & 0xfe) << 21);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 23 to 32
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0x80) << 15);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 33 to 42
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xe0) << 17);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 43 to 52
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xf8) << 19);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 53 to 62
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)(input[7] & 0xfe) << 21);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 63 to 72
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0x80) << 15);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 73 to 82
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xe0) << 17);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 83 to 92
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xf8) << 19);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 93 to 102
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)(input[12] & 0xfe) << 21);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 103 to 112
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0x80) << 15);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 113 to 122
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xe0) << 17);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 123 to 132
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xf8) << 19);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 133 to 142
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)(input[17] & 0xfe) << 21);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 143 to 152
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0x80) << 15);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 153 to 162
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)(input[20] & 0xe0) << 17);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 163 to 172
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xf8) << 19);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 173 to 182
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)(input[22] & 0xfe) << 21);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 183 to 192
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0x80) << 15);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 193 to 202
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xe0) << 17);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 203 to 212
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)(input[26] & 0xf8) << 19);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 213 to 222
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)(input[27] & 0xfe) << 21);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 223 to 232
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0x80) << 15);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 233 to 242
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xe0) << 17);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 243 to 252
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xf8) << 19);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 4 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 224 to 233
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xc0) << 16);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 234 to 243
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xf0) << 18);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 244 to 253
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)(input[31] & 0xfc) << 20);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 4 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 13
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfc) << 20);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 14 to 23
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 24 to 33
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xc0) << 16);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 34 to 43
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf0) << 18);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 44 to 53
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfc) << 20);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 54 to 63
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 64 to 73
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xc0) << 16);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 74 to 83
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xf0) << 18);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 84 to 93
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfc) << 20);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 94 to 103
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 104 to 113
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xc0) << 16);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 114 to 123
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xf0) << 18);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 124 to 133
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)(input[16] & 0xfc) << 20);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 134 to 143
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 144 to 153
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xc0) << 16);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 154 to 163
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)(input[20] & 0xf0) << 18);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 164 to 173
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)(input[21] & 0xfc) << 20);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 174 to 183
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 184 to 193
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xc0) << 16);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 194 to 203
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xf0) << 18);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 204 to 213
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)(input[26] & 0xfc) << 20);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 214 to 223
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 224 to 233
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xc0) << 16);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 234 to 243
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xf0) << 18);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 244 to 253
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)(input[31] & 0xfc) << 20);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 5 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 225 to 234
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xe0) << 17);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 235 to 244
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xf8) << 19);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 245 to 254
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)(input[31] & 0xfe) << 21);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 5 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 14
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)(input[1] & 0xfe) << 21);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 15 to 24
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0x80) << 15);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 25 to 34
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xe0) << 17);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 35 to 44
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xf8) << 19);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 45 to 54
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)(input[6] & 0xfe) << 21);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 55 to 64
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0x80) << 15);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 65 to 74
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xe0) << 17);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 75 to 84
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xf8) << 19);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 85 to 94
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)(input[11] & 0xfe) << 21);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 95 to 104
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0x80) << 15);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 105 to 114
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xe0) << 17);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 115 to 124
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xf8) << 19);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 125 to 134
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)(input[16] & 0xfe) << 21);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 135 to 144
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0x80) << 15);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 145 to 154
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xe0) << 17);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 155 to 164
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)(input[20] & 0xf8) << 19);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 165 to 174
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)(input[21] & 0xfe) << 21);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 175 to 184
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0x80) << 15);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 185 to 194
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xe0) << 17);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 195 to 204
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xf8) << 19);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 205 to 214
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)(input[26] & 0xfe) << 21);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 215 to 224
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0x80) << 15);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 225 to 234
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xe0) << 17);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 235 to 244
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xf8) << 19);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 245 to 254
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)(input[31] & 0xfe) << 21);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 6 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 226 to 235
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)(input[29] & 0xf0) << 18);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 236 to 245
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)(input[30] & 0xfc) << 20);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 246 to 255
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 6 bits, read 250 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 15
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 16 to 25
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xc0) << 16);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 26 to 35
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf0) << 18);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 36 to 45
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfc) << 20);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 46 to 55
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 56 to 65
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xc0) << 16);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 66 to 75
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf0) << 18);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 76 to 85
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)(input[10] & 0xfc) << 20);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 86 to 95
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 96 to 105
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xc0) << 16);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 106 to 115
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)(input[14] & 0xf0) << 18);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 116 to 125
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)(input[15] & 0xfc) << 20);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 126 to 135
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 136 to 145
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xc0) << 16);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 146 to 155
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xf0) << 18);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 156 to 165
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)(input[20] & 0xfc) << 20);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 166 to 175
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 176 to 185
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)(input[23] & 0xc0) << 16);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 186 to 195
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xf0) << 18);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 196 to 205
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)(input[25] & 0xfc) << 20);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 206 to 215
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 216 to 225
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xc0) << 16);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 226 to 235
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)(input[29] & 0xf0) << 18);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 236 to 245
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)(input[30] & 0xfc) << 20);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 246 to 255
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit signed
	// Skip 7 bits, read 250 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 227 to 236
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)(input[29] & 0xf8) << 19);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 237 to 246
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)(input[30] & 0xfe) << 21);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 247 to 256
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0x80) << 15);
	output[24] = (double)(value >> 22);
}

static void unpack_25_10bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 10-bit unsigned
	// Skip 7 bits, read 250 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 16
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0x80) << 15);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 17 to 26
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xe0) << 17);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 27 to 36
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xf8) << 19);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 37 to 46
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)(input[5] & 0xfe) << 21);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 47 to 56
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0x80) << 15);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 57 to 66
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xe0) << 17);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 67 to 76
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xf8) << 19);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 77 to 86
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)(input[10] & 0xfe) << 21);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 87 to 96
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0x80) << 15);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 97 to 106
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xe0) << 17);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 107 to 116
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)(input[14] & 0xf8) << 19);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 117 to 126
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)(input[15] & 0xfe) << 21);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 127 to 136
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0x80) << 15);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 137 to 146
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xe0) << 17);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 147 to 156
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xf8) << 19);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 157 to 166
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)(input[20] & 0xfe) << 21);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 167 to 176
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0x80) << 15);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 177 to 186
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)(input[23] & 0xe0) << 17);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 187 to 196
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xf8) << 19);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 197 to 206
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)(input[25] & 0xfe) << 21);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 207 to 216
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0x80) << 15);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 217 to 226
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xe0) << 17);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 227 to 236
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)(input[29] & 0xf8) << 19);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 237 to 246
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)(input[30] & 0xfe) << 21);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 247 to 256
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0x80) << 15);
	output[24] = (double)(value >> 22);
}

static void unpack_26_10bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 26 values into output
	// Values are 10-bit signed
	// Skip 0 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 230 to 239
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 240 to 249
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xc0) << 16);
	output[24] = (double)(value >> 22);

	// read output[25]: from bit 250 to 259
	value = ((uint32_t)(input[31] & 0x3f) << 26) |
			((uint32_t)(input[32] & 0xf0) << 18);
	output[25] = (double)(value >> 22);
}

static void unpack_26_10bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 26 values into output
	// Values are 10-bit unsigned
	// Skip 0 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 9
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xc0) << 16);
	output[0] = (double)(value >> 22);

	// read output[1]: from bit 10 to 19
	value = ((uint32_t)(input[1] & 0x3f) << 26) |
			((uint32_t)(input[2] & 0xf0) << 18);
	output[1] = (double)(value >> 22);

	// read output[2]: from bit 20 to 29
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)(input[3] & 0xfc) << 20);
	output[2] = (double)(value >> 22);

	// read output[3]: from bit 30 to 39
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22);
	output[3] = (double)(value >> 22);

	// read output[4]: from bit 40 to 49
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xc0) << 16);
	output[4] = (double)(value >> 22);

	// read output[5]: from bit 50 to 59
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf0) << 18);
	output[5] = (double)(value >> 22);

	// read output[6]: from bit 60 to 69
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfc) << 20);
	output[6] = (double)(value >> 22);

	// read output[7]: from bit 70 to 79
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22);
	output[7] = (double)(value >> 22);

	// read output[8]: from bit 80 to 89
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xc0) << 16);
	output[8] = (double)(value >> 22);

	// read output[9]: from bit 90 to 99
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xf0) << 18);
	output[9] = (double)(value >> 22);

	// read output[10]: from bit 100 to 109
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)(input[13] & 0xfc) << 20);
	output[10] = (double)(value >> 22);

	// read output[11]: from bit 110 to 119
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22);
	output[11] = (double)(value >> 22);

	// read output[12]: from bit 120 to 129
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xc0) << 16);
	output[12] = (double)(value >> 22);

	// read output[13]: from bit 130 to 139
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)(input[17] & 0xf0) << 18);
	output[13] = (double)(value >> 22);

	// read output[14]: from bit 140 to 149
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)(input[18] & 0xfc) << 20);
	output[14] = (double)(value >> 22);

	// read output[15]: from bit 150 to 159
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22);
	output[15] = (double)(value >> 22);

	// read output[16]: from bit 160 to 169
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xc0) << 16);
	output[16] = (double)(value >> 22);

	// read output[17]: from bit 170 to 179
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xf0) << 18);
	output[17] = (double)(value >> 22);

	// read output[18]: from bit 180 to 189
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)(input[23] & 0xfc) << 20);
	output[18] = (double)(value >> 22);

	// read output[19]: from bit 190 to 199
	value = ((uint32_t)(input[23] & 0x03) << 30) |
			((uint32_t)input[24] << 22);
	output[19] = (double)(value >> 22);

	// read output[20]: from bit 200 to 209
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xc0) << 16);
	output[20] = (double)(value >> 22);

	// read output[21]: from bit 210 to 219
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xf0) << 18);
	output[21] = (double)(value >> 22);

	// read output[22]: from bit 220 to 229
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)(input[28] & 0xfc) << 20);
	output[22] = (double)(value >> 22);

	// read output[23]: from bit 230 to 239
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22);
	output[23] = (double)(value >> 22);

	// read output[24]: from bit 240 to 249
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xc0) << 16);
	output[24] = (double)(value >> 22);

	// read output[25]: from bit 250 to 259
	value = ((uint32_t)(input[31] & 0x3f) << 26) |
			((uint32_t)(input[32] & 0xf0) << 18);
	output[25] = (double)(value >> 22);
}

static void unpack_26_10bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 26 values into output
	// Values are 10-bit signed
	// Skip 1 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 10
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((u