// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack11.h"



static void unpack_1_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 11 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 11 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 11 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 11 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);
}

static void unpack_1_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 11 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);
}

static void unpack_2_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);
}

static void unpack_3_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 33 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);
}

static void unpack_4_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 55 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 55 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 55 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 55 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);
}

static void unpack_5_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 55 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 55 to 65
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xc0) << 15);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 55 to 65
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xc0) << 15);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 56 to 66
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xe0) << 16);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 56 to 66
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xe0) << 16);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 57 to 67
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xf0) << 17);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 57 to 67
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xf0) << 17);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 58 to 68
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)(input[8] & 0xf8) << 18);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 58 to 68
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)(input[8] & 0xf8) << 18);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 59 to 69
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)(input[8] & 0xfc) << 19);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 59 to 69
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)(input[8] & 0xfc) << 19);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 60 to 70
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfe) << 20);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 60 to 70
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfe) << 20);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 61 to 71
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 61 to 71
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 66 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 62 to 72
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0x80) << 14);
	output[5] = (double)(value >> 21);
}

static void unpack_6_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 66 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 62 to 72
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0x80) << 14);
	output[5] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 55 to 65
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xc0) << 15);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 66 to 76
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf8) << 18);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 55 to 65
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xc0) << 15);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 66 to 76
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf8) << 18);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 56 to 66
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xe0) << 16);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 67 to 77
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfc) << 19);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 56 to 66
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xe0) << 16);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 67 to 77
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfc) << 19);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 57 to 67
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xf0) << 17);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 68 to 78
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)(input[9] & 0xfe) << 20);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 57 to 67
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xf0) << 17);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 68 to 78
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)(input[9] & 0xfe) << 20);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 58 to 68
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)(input[8] & 0xf8) << 18);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 69 to 79
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 77 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 58 to 68
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)(input[8] & 0xf8) << 18);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 69 to 79
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 59 to 69
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)(input[8] & 0xfc) << 19);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 70 to 80
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0x80) << 14);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 59 to 69
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)(input[8] & 0xfc) << 19);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 70 to 80
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0x80) << 14);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 60 to 70
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfe) << 20);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 71 to 81
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xc0) << 15);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 60 to 70
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfe) << 20);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 71 to 81
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xc0) << 15);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 61 to 71
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 72 to 82
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xe0) << 16);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 61 to 71
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 72 to 82
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xe0) << 16);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 62 to 72
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0x80) << 14);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 73 to 83
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf0) << 17);
	output[6] = (double)(value >> 21);
}

static void unpack_7_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 77 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 62 to 72
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0x80) << 14);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 73 to 83
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf0) << 17);
	output[6] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 0 bits, read 88 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 55 to 65
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xc0) << 15);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 66 to 76
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf8) << 18);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 77 to 87
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 0 bits, read 88 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 10
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xe0) << 16);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 11 to 21
	value = ((uint32_t)(input[1] & 0x1f) << 27) |
			((uint32_t)(input[2] & 0xfc) << 19);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 22 to 32
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0x80) << 14);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 33 to 43
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xf0) << 17);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 44 to 54
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)(input[6] & 0xfe) << 20);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 55 to 65
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xc0) << 15);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 66 to 76
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xf8) << 18);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 77 to 87
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 1 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 56 to 66
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xe0) << 16);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 67 to 77
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfc) << 19);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 78 to 88
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0x80) << 14);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 1 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 11
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf0) << 17);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 12 to 22
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)(input[2] & 0xfe) << 20);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 23 to 33
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xc0) << 15);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 34 to 44
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)(input[5] & 0xf8) << 18);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 45 to 55
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 56 to 66
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xe0) << 16);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 67 to 77
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfc) << 19);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 78 to 88
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0x80) << 14);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 2 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 57 to 67
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xf0) << 17);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 68 to 78
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)(input[9] & 0xfe) << 20);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 79 to 89
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xc0) << 15);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 2 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 12
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xf8) << 18);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 13 to 23
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 24 to 34
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xe0) << 16);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 35 to 45
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)(input[5] & 0xfc) << 19);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 46 to 56
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0x80) << 14);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 57 to 67
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xf0) << 17);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 68 to 78
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)(input[9] & 0xfe) << 20);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 79 to 89
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xc0) << 15);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 3 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 58 to 68
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)(input[8] & 0xf8) << 18);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 69 to 79
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 80 to 90
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xe0) << 16);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 3 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 13
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfc) << 19);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 14 to 24
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0x80) << 14);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 25 to 35
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf0) << 17);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 36 to 46
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)(input[5] & 0xfe) << 20);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 47 to 57
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xc0) << 15);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 58 to 68
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)(input[8] & 0xf8) << 18);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 69 to 79
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 80 to 90
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xe0) << 16);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 4 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 59 to 69
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)(input[8] & 0xfc) << 19);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 70 to 80
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0x80) << 14);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 81 to 91
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xf0) << 17);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 4 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 14
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)(input[1] & 0xfe) << 20);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 15 to 25
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xc0) << 15);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 26 to 36
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xf8) << 18);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 37 to 47
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 48 to 58
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xe0) << 16);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 59 to 69
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)(input[8] & 0xfc) << 19);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 70 to 80
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0x80) << 14);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 81 to 91
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)(input[11] & 0xf0) << 17);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 5 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 60 to 70
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfe) << 20);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 71 to 81
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xc0) << 15);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 82 to 92
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf8) << 18);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 5 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 15
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 16 to 26
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xe0) << 16);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 27 to 37
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfc) << 19);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 38 to 48
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0x80) << 14);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 49 to 59
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf0) << 17);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 60 to 70
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)(input[8] & 0xfe) << 20);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 71 to 81
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xc0) << 15);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 82 to 92
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)(input[11] & 0xf8) << 18);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 6 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 61 to 71
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 72 to 82
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xe0) << 16);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 83 to 93
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xfc) << 19);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 6 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 16
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0x80) << 14);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 17 to 27
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf0) << 17);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 28 to 38
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)(input[4] & 0xfe) << 20);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 39 to 49
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xc0) << 15);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 50 to 60
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xf8) << 18);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 61 to 71
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 72 to 82
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xe0) << 16);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 83 to 93
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)(input[11] & 0xfc) << 19);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit signed
	// Skip 7 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 62 to 72
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0x80) << 14);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 73 to 83
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf0) << 17);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 84 to 94
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfe) << 20);
	output[7] = (double)(value >> 21);
}

static void unpack_8_11bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 11-bit unsigned
	// Skip 7 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 17
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xc0) << 15);
	output[0] = (double)(value >> 21);

	// read output[1]: from bit 18 to 28
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xf8) << 18);
	output[1] = (double)(value >> 21);

	// read output[2]: from bit 29 to 39
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21);
	output[2] = (double)(value >> 21);

	// read output[3]: from bit 40 to 50
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xe0) << 16);
	output[3] = (double)(value >> 21);

	// read output[4]: from bit 51 to 61
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfc) << 19);
	output[4] = (double)(value >> 21);

	// read output[5]: from bit 62 to 72
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0x80) << 14);
	output[5] = (double)(value >> 21);

	// read output[6]: from bit 73 to 83
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf0) << 17);
	output[6] = (double)(value >> 21);

	// read output[7]: from bit 84 to 94
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)(input[11] & 0xfe) << 20);
	output[7] = (double)(value >> 21);
}


unpack_func_t unpack_11bit[UNPACK_11BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_11bit_unsigned_0off,
			unpack_1_11bit_signed_0off,
		},
		{
			unpack_1_11bit_unsigned_1off,
			unpack_1_11bit_signed_1off,
		},
		{
			unpack_1_11bit_unsigned_2off,
			unpack_1_11bit_signed_2off,
		},
		{
			unpack_1_11bit_unsigned_3off,
			unpack_1_11bit_signed_3off,
		},
		{
			unpack_1_11bit_unsigned_4off,
			unpack_1_11bit_signed_4off,
		},
		{
			unpack_1_11bit_unsigned_5off,
			unpack_1_11bit_signed_5off,
		},
		{
			unpack_1_11bit_unsigned_6off,
			unpack_1_11bit_signed_6off,
		},
		{
			unpack_1_11bit_unsigned_7off,
			unpack_1_11bit_signed_7off,
		},
	},
	{
		{
			unpack_2_11bit_unsigned_0off,
			unpack_2_11bit_signed_0off,
		},
		{
			unpack_2_11bit_unsigned_1off,
			unpack_2_11bit_signed_1off,
		},
		{
			unpack_2_11bit_unsigned_2off,
			unpack_2_11bit_signed_2off,
		},
		{
			unpack_2_11bit_unsigned_3off,
			unpack_2_11bit_signed_3off,
		},
		{
			unpack_2_11bit_unsigned_4off,
			unpack_2_11bit_signed_4off,
		},
		{
			unpack_2_11bit_unsigned_5off,
			unpack_2_11bit_signed_5off,
		},
		{
			unpack_2_11bit_unsigned_6off,
			unpack_2_11bit_signed_6off,
		},
		{
			unpack_2_11bit_unsigned_7off,
			unpack_2_11bit_signed_7off,
		},
	},
	{
		{
			unpack_3_11bit_unsigned_0off,
			unpack_3_11bit_signed_0off,
		},
		{
			unpack_3_11bit_unsigned_1off,
			unpack_3_11bit_signed_1off,
		},
		{
			unpack_3_11bit_unsigned_2off,
			unpack_3_11bit_signed_2off,
		},
		{
			unpack_3_11bit_unsigned_3off,
			unpack_3_11bit_signed_3off,
		},
		{
			unpack_3_11bit_unsigned_4off,
			unpack_3_11bit_signed_4off,
		},
		{
			unpack_3_11bit_unsigned_5off,
			unpack_3_11bit_signed_5off,
		},
		{
			unpack_3_11bit_unsigned_6off,
			unpack_3_11bit_signed_6off,
		},
		{
			unpack_3_11bit_unsigned_7off,
			unpack_3_11bit_signed_7off,
		},
	},
	{
		{
			unpack_4_11bit_unsigned_0off,
			unpack_4_11bit_signed_0off,
		},
		{
			unpack_4_11bit_unsigned_1off,
			unpack_4_11bit_signed_1off,
		},
		{
			unpack_4_11bit_unsigned_2off,
			unpack_4_11bit_signed_2off,
		},
		{
			unpack_4_11bit_unsigned_3off,
			unpack_4_11bit_signed_3off,
		},
		{
			unpack_4_11bit_unsigned_4off,
			unpack_4_11bit_signed_4off,
		},
		{
			unpack_4_11bit_unsigned_5off,
			unpack_4_11bit_signed_5off,
		},
		{
			unpack_4_11bit_unsigned_6off,
			unpack_4_11bit_signed_6off,
		},
		{
			unpack_4_11bit_unsigned_7off,
			unpack_4_11bit_signed_7off,
		},
	},
	{
		{
			unpack_5_11bit_unsigned_0off,
			unpack_5_11bit_signed_0off,
		},
		{
			unpack_5_11bit_unsigned_1off,
			unpack_5_11bit_signed_1off,
		},
		{
			unpack_5_11bit_unsigned_2off,
			unpack_5_11bit_signed_2off,
		},
		{
			unpack_5_11bit_unsigned_3off,
			unpack_5_11bit_signed_3off,
		},
		{
			unpack_5_11bit_unsigned_4off,
			unpack_5_11bit_signed_4off,
		},
		{
			unpack_5_11bit_unsigned_5off,
			unpack_5_11bit_signed_5off,
		},
		{
			unpack_5_11bit_unsigned_6off,
			unpack_5_11bit_signed_6off,
		},
		{
			unpack_5_11bit_unsigned_7off,
			unpack_5_11bit_signed_7off,
		},
	},
	{
		{
			unpack_6_11bit_unsigned_0off,
			unpack_6_11bit_signed_0off,
		},
		{
			unpack_6_11bit_unsigned_1off,
			unpack_6_11bit_signed_1off,
		},
		{
			unpack_6_11bit_unsigned_2off,
			unpack_6_11bit_signed_2off,
		},
		{
			unpack_6_11bit_unsigned_3off,
			unpack_6_11bit_signed_3off,
		},
		{
			unpack_6_11bit_unsigned_4off,
			unpack_6_11bit_signed_4off,
		},
		{
			unpack_6_11bit_unsigned_5off,
			unpack_6_11bit_signed_5off,
		},
		{
			unpack_6_11bit_unsigned_6off,
			unpack_6_11bit_signed_6off,
		},
		{
			unpack_6_11bit_unsigned_7off,
			unpack_6_11bit_signed_7off,
		},
	},
	{
		{
			unpack_7_11bit_unsigned_0off,
			unpack_7_11bit_signed_0off,
		},
		{
			unpack_7_11bit_unsigned_1off,
			unpack_7_11bit_signed_1off,
		},
		{
			unpack_7_11bit_unsigned_2off,
			unpack_7_11bit_signed_2off,
		},
		{
			unpack_7_11bit_unsigned_3off,
			unpack_7_11bit_signed_3off,
		},
		{
			unpack_7_11bit_unsigned_4off,
			unpack_7_11bit_signed_4off,
		},
		{
			unpack_7_11bit_unsigned_5off,
			unpack_7_11bit_signed_5off,
		},
		{
			unpack_7_11bit_unsigned_6off,
			unpack_7_11bit_signed_6off,
		},
		{
			unpack_7_11bit_unsigned_7off,
			unpack_7_11bit_signed_7off,
		},
	},
	{
		{
			unpack_8_11bit_unsigned_0off,
			unpack_8_11bit_signed_0off,
		},
		{
			unpack_8_11bit_unsigned_1off,
			unpack_8_11bit_signed_1off,
		},
		{
			unpack_8_11bit_unsigned_2off,
			unpack_8_11bit_signed_2off,
		},
		{
			unpack_8_11bit_unsigned_3off,
			unpack_8_11bit_signed_3off,
		},
		{
			unpack_8_11bit_unsigned_4off,
			unpack_8_11bit_signed_4off,
		},
		{
			unpack_8_11bit_unsigned_5off,
			unpack_8_11bit_signed_5off,
		},
		{
			unpack_8_11bit_unsigned_6off,
			unpack_8_11bit_signed_6off,
		},
		{
			unpack_8_11bit_unsigned_7off,
			unpack_8_11bit_signed_7off,
		},
	},
};
