// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack12.h"



static void unpack_1_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 12 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 12 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 12 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 12 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 12 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 12 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);
}

static void unpack_1_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 12 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 24 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 24 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);
}

static void unpack_2_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 24 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);
}

static void unpack_3_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 48 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 48 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);
}

static void unpack_4_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);
}

static void unpack_5_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 72 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 72 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);
}

static void unpack_6_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);
}

static void unpack_7_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);
}

static void unpack_8_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);
}

static void unpack_9_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);
}

static void unpack_10_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);
}

static void unpack_11_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);
}

static void unpack_12_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 156 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);
}

static void unpack_13_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 156 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);
}

static void unpack_14_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);
}

static void unpack_15_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);
}

static void unpack_16_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 204 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 204 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 204 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 204 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 204 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 204 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);
}

static void unpack_17_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 204 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);
}

static void unpack_18_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 228 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 228 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 228 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 228 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 228 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 228 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);
}

static void unpack_19_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 228 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);
}

static void unpack_20_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);
}

static void unpack_21_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 264 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 264 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 256 to 267
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xf0) << 16);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 256 to 267
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xf0) << 16);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 257 to 268
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xf8) << 17);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 257 to 268
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xf8) << 17);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 258 to 269
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)(input[33] & 0xfc) << 18);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 258 to 269
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)(input[33] & 0xfc) << 18);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 259 to 270
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)(input[33] & 0xfe) << 19);
	output[21] = (double)(value >> 20);
}

static void unpack_22_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 259 to 270
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)(input[33] & 0xfe) << 19);
	output[21] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 264 to 275
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)(input[34] & 0xf0) << 16);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 264 to 275
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)(input[34] & 0xf0) << 16);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 265 to 276
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)(input[34] & 0xf8) << 17);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 265 to 276
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)(input[34] & 0xf8) << 17);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 266 to 277
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)(input[34] & 0xfc) << 18);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 266 to 277
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)(input[34] & 0xfc) << 18);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 267 to 278
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)(input[34] & 0xfe) << 19);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 267 to 278
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)(input[34] & 0xfe) << 19);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 256 to 267
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xf0) << 16);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 268 to 279
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 276 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 256 to 267
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xf0) << 16);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 268 to 279
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 276 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 257 to 268
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xf8) << 17);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 269 to 280
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0x80) << 13);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 276 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 257 to 268
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xf8) << 17);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 269 to 280
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0x80) << 13);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 276 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 258 to 269
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)(input[33] & 0xfc) << 18);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 270 to 281
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xc0) << 14);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 276 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 258 to 269
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)(input[33] & 0xfc) << 18);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 270 to 281
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xc0) << 14);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 276 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 259 to 270
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)(input[33] & 0xfe) << 19);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 271 to 282
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xe0) << 15);
	output[22] = (double)(value >> 20);
}

static void unpack_23_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 276 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 259 to 270
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)(input[33] & 0xfe) << 19);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 271 to 282
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xe0) << 15);
	output[22] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 264 to 275
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)(input[34] & 0xf0) << 16);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 276 to 287
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 264 to 275
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)(input[34] & 0xf0) << 16);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 276 to 287
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 265 to 276
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)(input[34] & 0xf8) << 17);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 277 to 288
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0x80) << 13);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 265 to 276
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)(input[34] & 0xf8) << 17);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 277 to 288
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0x80) << 13);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 266 to 277
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)(input[34] & 0xfc) << 18);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 278 to 289
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xc0) << 14);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 266 to 277
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)(input[34] & 0xfc) << 18);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 278 to 289
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xc0) << 14);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 267 to 278
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)(input[34] & 0xfe) << 19);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 279 to 290
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xe0) << 15);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 267 to 278
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)(input[34] & 0xfe) << 19);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 279 to 290
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xe0) << 15);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 256 to 267
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xf0) << 16);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 268 to 279
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 280 to 291
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xf0) << 16);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 232 to 243
	value = ((uint32_t)input[29] << 24) |
			((uint32_t)(input[30] & 0xf0) << 16);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 244 to 255
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 256 to 267
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xf0) << 16);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 268 to 279
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 280 to 291
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xf0) << 16);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 257 to 268
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xf8) << 17);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 269 to 280
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0x80) << 13);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 281 to 292
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xf8) << 17);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 16
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0x80) << 13);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 17 to 28
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xf8) << 17);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 29 to 40
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0x80) << 13);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 41 to 52
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)(input[6] & 0xf8) << 17);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 53 to 64
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0x80) << 13);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 65 to 76
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)(input[9] & 0xf8) << 17);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 77 to 88
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0x80) << 13);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 89 to 100
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xf8) << 17);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 101 to 112
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0x80) << 13);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 113 to 124
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xf8) << 17);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 125 to 136
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0x80) << 13);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 137 to 148
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)(input[18] & 0xf8) << 17);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 149 to 160
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0x80) << 13);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 161 to 172
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xf8) << 17);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 173 to 184
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0x80) << 13);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 185 to 196
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xf8) << 17);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 197 to 208
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0x80) << 13);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 209 to 220
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)(input[27] & 0xf8) << 17);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 221 to 232
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0x80) << 13);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 233 to 244
	value = ((uint32_t)(input[29] & 0x7f) << 25) |
			((uint32_t)(input[30] & 0xf8) << 17);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 245 to 256
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0x80) << 13);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 257 to 268
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xf8) << 17);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 269 to 280
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0x80) << 13);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 281 to 292
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xf8) << 17);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 258 to 269
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)(input[33] & 0xfc) << 18);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 270 to 281
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xc0) << 14);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 282 to 293
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)(input[36] & 0xfc) << 18);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 17
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xc0) << 14);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 18 to 29
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)(input[3] & 0xfc) << 18);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 30 to 41
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xc0) << 14);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 42 to 53
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)(input[6] & 0xfc) << 18);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 54 to 65
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xc0) << 14);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 66 to 77
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)(input[9] & 0xfc) << 18);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 78 to 89
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xc0) << 14);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 90 to 101
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)(input[12] & 0xfc) << 18);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 102 to 113
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xc0) << 14);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 114 to 125
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)(input[15] & 0xfc) << 18);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 126 to 137
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xc0) << 14);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 138 to 149
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)(input[18] & 0xfc) << 18);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 150 to 161
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xc0) << 14);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 162 to 173
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)(input[21] & 0xfc) << 18);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 174 to 185
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xc0) << 14);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 186 to 197
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)(input[24] & 0xfc) << 18);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 198 to 209
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xc0) << 14);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 210 to 221
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)(input[27] & 0xfc) << 18);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 222 to 233
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)(input[29] & 0xc0) << 14);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 234 to 245
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)(input[30] & 0xfc) << 18);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 246 to 257
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xc0) << 14);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 258 to 269
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)(input[33] & 0xfc) << 18);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 270 to 281
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xc0) << 14);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 282 to 293
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)(input[36] & 0xfc) << 18);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit signed
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 259 to 270
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)(input[33] & 0xfe) << 19);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 271 to 282
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xe0) << 15);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 283 to 294
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)(input[36] & 0xfe) << 19);
	output[23] = (double)(value >> 20);
}

static void unpack_24_12bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 12-bit unsigned
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 18
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xe0) << 15);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 19 to 30
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)(input[3] & 0xfe) << 19);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 31 to 42
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xe0) << 15);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 43 to 54
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)(input[6] & 0xfe) << 19);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 55 to 66
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xe0) << 15);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 67 to 78
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)(input[9] & 0xfe) << 19);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 79 to 90
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xe0) << 15);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 91 to 102
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)(input[12] & 0xfe) << 19);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 103 to 114
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xe0) << 15);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 115 to 126
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)(input[15] & 0xfe) << 19);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 127 to 138
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xe0) << 15);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 139 to 150
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)(input[18] & 0xfe) << 19);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 151 to 162
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xe0) << 15);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 163 to 174
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)(input[21] & 0xfe) << 19);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 175 to 186
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xe0) << 15);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 187 to 198
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)(input[24] & 0xfe) << 19);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 199 to 210
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xe0) << 15);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 211 to 222
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)(input[27] & 0xfe) << 19);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 223 to 234
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)(input[29] & 0xe0) << 15);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 235 to 246
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)(input[30] & 0xfe) << 19);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 247 to 258
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xe0) << 15);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 259 to 270
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)(input[33] & 0xfe) << 19);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 271 to 282
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xe0) << 15);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 283 to 294
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)(input[36] & 0xfe) << 19);
	output[23] = (double)(value >> 20);
}

static void unpack_25_12bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit signed
	// Skip 0 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 264 to 275
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)(input[34] & 0xf0) << 16);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 276 to 287
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 288 to 299
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)(input[37] & 0xf0) << 16);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit unsigned
	// Skip 0 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 11
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xf0) << 16);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 12 to 23
	value = ((uint32_t)(input[1] & 0x0f) << 28) |
			((uint32_t)input[2] << 20);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 24 to 35
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)(input[4] & 0xf0) << 16);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 36 to 47
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 48 to 59
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xf0) << 16);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 60 to 71
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 72 to 83
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xf0) << 16);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 84 to 95
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 96 to 107
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xf0) << 16);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 108 to 119
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 120 to 131
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)(input[16] & 0xf0) << 16);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 132 to 143
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 144 to 155
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xf0) << 16);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 156 to 167
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 168 to 179
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xf0) << 16);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 180 to 191
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 192 to 203
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)(input[25] & 0xf0) << 16);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 204 to 215
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 216 to 227
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xf0) << 16);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 228 to 239
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 240 to 251
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xf0) << 16);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 252 to 263
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 264 to 275
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)(input[34] & 0xf0) << 16);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 276 to 287
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 288 to 299
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)(input[37] & 0xf0) << 16);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit signed
	// Skip 1 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 265 to 276
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)(input[34] & 0xf8) << 17);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 277 to 288
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0x80) << 13);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 289 to 300
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)(input[37] & 0xf8) << 17);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit unsigned
	// Skip 1 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 12
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xf8) << 17);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 13 to 24
	value = ((uint32_t)(input[1] & 0x07) << 29) |
			((uint32_t)input[2] << 21) |
			((uint32_t)(input[3] & 0x80) << 13);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 25 to 36
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)(input[4] & 0xf8) << 17);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 37 to 48
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0x80) << 13);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 49 to 60
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xf8) << 17);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 61 to 72
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0x80) << 13);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 73 to 84
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xf8) << 17);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 85 to 96
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0x80) << 13);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 97 to 108
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)(input[13] & 0xf8) << 17);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 109 to 120
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0x80) << 13);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 121 to 132
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)(input[16] & 0xf8) << 17);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 133 to 144
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0x80) << 13);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 145 to 156
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xf8) << 17);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 157 to 168
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0x80) << 13);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 169 to 180
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xf8) << 17);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 181 to 192
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0x80) << 13);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 193 to 204
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)(input[25] & 0xf8) << 17);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 205 to 216
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0x80) << 13);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 217 to 228
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xf8) << 17);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 229 to 240
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0x80) << 13);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 241 to 252
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xf8) << 17);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 253 to 264
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0x80) << 13);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 265 to 276
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)(input[34] & 0xf8) << 17);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 277 to 288
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0x80) << 13);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 289 to 300
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)(input[37] & 0xf8) << 17);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit signed
	// Skip 2 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 266 to 277
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)(input[34] & 0xfc) << 18);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 278 to 289
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xc0) << 14);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 290 to 301
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)(input[37] & 0xfc) << 18);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit unsigned
	// Skip 2 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 13
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)(input[1] & 0xfc) << 18);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 14 to 25
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xc0) << 14);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 26 to 37
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)(input[4] & 0xfc) << 18);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 38 to 49
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xc0) << 14);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 50 to 61
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)(input[7] & 0xfc) << 18);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 62 to 73
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xc0) << 14);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 74 to 85
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)(input[10] & 0xfc) << 18);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 86 to 97
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xc0) << 14);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 98 to 109
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)(input[13] & 0xfc) << 18);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 110 to 121
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xc0) << 14);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 122 to 133
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)(input[16] & 0xfc) << 18);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 134 to 145
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xc0) << 14);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 146 to 157
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)(input[19] & 0xfc) << 18);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 158 to 169
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xc0) << 14);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 170 to 181
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)(input[22] & 0xfc) << 18);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 182 to 193
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xc0) << 14);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 194 to 205
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)(input[25] & 0xfc) << 18);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 206 to 217
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)(input[27] & 0xc0) << 14);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 218 to 229
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)(input[28] & 0xfc) << 18);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 230 to 241
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xc0) << 14);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 242 to 253
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)(input[31] & 0xfc) << 18);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 254 to 265
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xc0) << 14);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 266 to 277
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)(input[34] & 0xfc) << 18);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 278 to 289
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xc0) << 14);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 290 to 301
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)(input[37] & 0xfc) << 18);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit signed
	// Skip 3 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 267 to 278
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)(input[34] & 0xfe) << 19);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 279 to 290
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xe0) << 15);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 291 to 302
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)(input[37] & 0xfe) << 19);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit unsigned
	// Skip 3 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 14
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)(input[1] & 0xfe) << 19);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 15 to 26
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xe0) << 15);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 27 to 38
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)(input[4] & 0xfe) << 19);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 39 to 50
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xe0) << 15);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 51 to 62
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)(input[7] & 0xfe) << 19);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 63 to 74
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xe0) << 15);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 75 to 86
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)(input[10] & 0xfe) << 19);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 87 to 98
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xe0) << 15);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 99 to 110
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)(input[13] & 0xfe) << 19);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 111 to 122
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xe0) << 15);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 123 to 134
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)(input[16] & 0xfe) << 19);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 135 to 146
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xe0) << 15);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 147 to 158
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)(input[19] & 0xfe) << 19);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 159 to 170
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xe0) << 15);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 171 to 182
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)(input[22] & 0xfe) << 19);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 183 to 194
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xe0) << 15);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 195 to 206
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)(input[25] & 0xfe) << 19);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 207 to 218
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)(input[27] & 0xe0) << 15);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 219 to 230
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)(input[28] & 0xfe) << 19);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 231 to 242
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xe0) << 15);
	output[19] = (double)(value >> 20);

	// read output[20]: from bit 243 to 254
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)(input[31] & 0xfe) << 19);
	output[20] = (double)(value >> 20);

	// read output[21]: from bit 255 to 266
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xe0) << 15);
	output[21] = (double)(value >> 20);

	// read output[22]: from bit 267 to 278
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)(input[34] & 0xfe) << 19);
	output[22] = (double)(value >> 20);

	// read output[23]: from bit 279 to 290
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xe0) << 15);
	output[23] = (double)(value >> 20);

	// read output[24]: from bit 291 to 302
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)(input[37] & 0xfe) << 19);
	output[24] = (double)(value >> 20);
}

static void unpack_25_12bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 12-bit signed
	// Skip 4 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 15
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20);
	output[0] = (double)(value >> 20);

	// read output[1]: from bit 16 to 27
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xf0) << 16);
	output[1] = (double)(value >> 20);

	// read output[2]: from bit 28 to 39
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20);
	output[2] = (double)(value >> 20);

	// read output[3]: from bit 40 to 51
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)(input[6] & 0xf0) << 16);
	output[3] = (double)(value >> 20);

	// read output[4]: from bit 52 to 63
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20);
	output[4] = (double)(value >> 20);

	// read output[5]: from bit 64 to 75
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xf0) << 16);
	output[5] = (double)(value >> 20);

	// read output[6]: from bit 76 to 87
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20);
	output[6] = (double)(value >> 20);

	// read output[7]: from bit 88 to 99
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xf0) << 16);
	output[7] = (double)(value >> 20);

	// read output[8]: from bit 100 to 111
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20);
	output[8] = (double)(value >> 20);

	// read output[9]: from bit 112 to 123
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xf0) << 16);
	output[9] = (double)(value >> 20);

	// read output[10]: from bit 124 to 135
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20);
	output[10] = (double)(value >> 20);

	// read output[11]: from bit 136 to 147
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)(input[18] & 0xf0) << 16);
	output[11] = (double)(value >> 20);

	// read output[12]: from bit 148 to 159
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20);
	output[12] = (double)(value >> 20);

	// read output[13]: from bit 160 to 171
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xf0) << 16);
	output[13] = (double)(value >> 20);

	// read output[14]: from bit 172 to 183
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20);
	output[14] = (double)(value >> 20);

	// read output[15]: from bit 184 to 195
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xf0) << 16);
	output[15] = (double)(value >> 20);

	// read output[16]: from bit 196 to 207
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20);
	output[16] = (double)(value >> 20);

	// read output[17]: from bit 208 to 219
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)(input[27] & 0xf0) << 16);
	output[17] = (double)(value >> 20);

	// read output[18]: from bit 220 to 231
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20);
	output[18] = (double)(value >> 20);

	// read output[19]: from bit 