// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack14.h"



static void unpack_1_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 14 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);
}

static void unpack_1_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 14 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 28 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);
}

static void unpack_2_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 28 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 42 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);
}

static void unpack_3_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 42 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 56 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 56 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);
}

static void unpack_4_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 56 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 70 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);
}

static void unpack_5_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 70 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);
}

static void unpack_6_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 98 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 98 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);
}

static void unpack_7_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 98 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 112 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 112 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);
}

static void unpack_8_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);
}

static void unpack_9_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);
}

static void unpack_10_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 154 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);
}

static void unpack_11_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 154 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);
}

static void unpack_12_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 182 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);
}

static void unpack_13_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 182 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 196 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);
}

static void unpack_14_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 196 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 210 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 210 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);
}

static void unpack_15_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 210 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);
}

static void unpack_16_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 238 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 238 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 238 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 238 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 238 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 238 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);
}

static void unpack_17_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 238 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);
}

static void unpack_18_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 266 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 266 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);
}

static void unpack_19_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 266 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 280 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 280 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);
}

static void unpack_20_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 294 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 294 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 294 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 294 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 294 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 294 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);
}

static void unpack_21_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 294 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 294 to 307
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xf0) << 14);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 294 to 307
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xf0) << 14);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 295 to 308
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xf8) << 15);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 295 to 308
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xf8) << 15);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 296 to 309
	value = ((uint32_t)input[37] << 24) |
			((uint32_t)(input[38] & 0xfc) << 16);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 296 to 309
	value = ((uint32_t)input[37] << 24) |
			((uint32_t)(input[38] & 0xfc) << 16);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 297 to 310
	value = ((uint32_t)(input[37] & 0x7f) << 25) |
			((uint32_t)(input[38] & 0xfe) << 17);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 297 to 310
	value = ((uint32_t)(input[37] & 0x7f) << 25) |
			((uint32_t)(input[38] & 0xfe) << 17);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 298 to 311
	value = ((uint32_t)(input[37] & 0x3f) << 26) |
			((uint32_t)input[38] << 18);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 298 to 311
	value = ((uint32_t)(input[37] & 0x3f) << 26) |
			((uint32_t)input[38] << 18);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 299 to 312
	value = ((uint32_t)(input[37] & 0x1f) << 27) |
			((uint32_t)input[38] << 19) |
			((uint32_t)(input[39] & 0x80) << 11);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 299 to 312
	value = ((uint32_t)(input[37] & 0x1f) << 27) |
			((uint32_t)input[38] << 19) |
			((uint32_t)(input[39] & 0x80) << 11);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 300 to 313
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)(input[39] & 0xc0) << 12);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 300 to 313
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)(input[39] & 0xc0) << 12);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 301 to 314
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)(input[39] & 0xe0) << 13);
	output[21] = (double)(value >> 18);
}

static void unpack_22_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 301 to 314
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)(input[39] & 0xe0) << 13);
	output[21] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 294 to 307
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xf0) << 14);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 308 to 321
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xc0) << 12);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 294 to 307
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xf0) << 14);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 308 to 321
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xc0) << 12);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 295 to 308
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xf8) << 15);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 309 to 322
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xe0) << 13);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 295 to 308
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xf8) << 15);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 309 to 322
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xe0) << 13);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 296 to 309
	value = ((uint32_t)input[37] << 24) |
			((uint32_t)(input[38] & 0xfc) << 16);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 310 to 323
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xf0) << 14);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 296 to 309
	value = ((uint32_t)input[37] << 24) |
			((uint32_t)(input[38] & 0xfc) << 16);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 310 to 323
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xf0) << 14);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 297 to 310
	value = ((uint32_t)(input[37] & 0x7f) << 25) |
			((uint32_t)(input[38] & 0xfe) << 17);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 311 to 324
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xf8) << 15);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 297 to 310
	value = ((uint32_t)(input[37] & 0x7f) << 25) |
			((uint32_t)(input[38] & 0xfe) << 17);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 311 to 324
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xf8) << 15);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 298 to 311
	value = ((uint32_t)(input[37] & 0x3f) << 26) |
			((uint32_t)input[38] << 18);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 312 to 325
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)(input[40] & 0xfc) << 16);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 298 to 311
	value = ((uint32_t)(input[37] & 0x3f) << 26) |
			((uint32_t)input[38] << 18);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 312 to 325
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)(input[40] & 0xfc) << 16);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 299 to 312
	value = ((uint32_t)(input[37] & 0x1f) << 27) |
			((uint32_t)input[38] << 19) |
			((uint32_t)(input[39] & 0x80) << 11);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 313 to 326
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)(input[40] & 0xfe) << 17);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 299 to 312
	value = ((uint32_t)(input[37] & 0x1f) << 27) |
			((uint32_t)input[38] << 19) |
			((uint32_t)(input[39] & 0x80) << 11);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 313 to 326
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)(input[40] & 0xfe) << 17);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 300 to 313
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)(input[39] & 0xc0) << 12);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 314 to 327
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 322 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 300 to 313
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)(input[39] & 0xc0) << 12);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 314 to 327
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 322 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 301 to 314
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)(input[39] & 0xe0) << 13);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 315 to 328
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)(input[41] & 0x80) << 11);
	output[22] = (double)(value >> 18);
}

static void unpack_23_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 322 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 301 to 314
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)(input[39] & 0xe0) << 13);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 315 to 328
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)(input[41] & 0x80) << 11);
	output[22] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 294 to 307
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xf0) << 14);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 308 to 321
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xc0) << 12);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 322 to 335
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 14 to 27
	value = ((uint32_t)(input[1] & 0x03) << 30) |
			((uint32_t)input[2] << 22) |
			((uint32_t)(input[3] & 0xf0) << 14);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 28 to 41
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)(input[5] & 0xc0) << 12);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 42 to 55
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 56 to 69
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)(input[8] & 0xfc) << 16);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 70 to 83
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xf0) << 14);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 84 to 97
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xc0) << 12);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 98 to 111
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 112 to 125
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfc) << 16);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 126 to 139
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xf0) << 14);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 140 to 153
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xc0) << 12);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 154 to 167
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 168 to 181
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)(input[22] & 0xfc) << 16);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 182 to 195
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xf0) << 14);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 196 to 209
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xc0) << 12);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 210 to 223
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 224 to 237
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)(input[29] & 0xfc) << 16);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 238 to 251
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)(input[31] & 0xf0) << 14);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 252 to 265
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xc0) << 12);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 266 to 279
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 280 to 293
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)(input[36] & 0xfc) << 16);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 294 to 307
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xf0) << 14);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 308 to 321
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xc0) << 12);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 322 to 335
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 295 to 308
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xf8) << 15);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 309 to 322
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xe0) << 13);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 323 to 336
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0x80) << 11);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 14
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)(input[1] & 0xfe) << 17);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 15 to 28
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xf8) << 15);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 29 to 42
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)(input[5] & 0xe0) << 13);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 43 to 56
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0x80) << 11);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 57 to 70
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)(input[8] & 0xfe) << 17);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 71 to 84
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xf8) << 15);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 85 to 98
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xe0) << 13);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 99 to 112
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0x80) << 11);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 113 to 126
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)(input[15] & 0xfe) << 17);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 127 to 140
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)(input[17] & 0xf8) << 15);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 141 to 154
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)(input[19] & 0xe0) << 13);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 155 to 168
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)(input[21] & 0x80) << 11);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 169 to 182
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)(input[22] & 0xfe) << 17);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 183 to 196
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xf8) << 15);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 197 to 210
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xe0) << 13);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 211 to 224
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0x80) << 11);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 225 to 238
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)(input[29] & 0xfe) << 17);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 239 to 252
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)(input[31] & 0xf8) << 15);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 253 to 266
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xe0) << 13);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 267 to 280
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0x80) << 11);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 281 to 294
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)(input[36] & 0xfe) << 17);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 295 to 308
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xf8) << 15);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 309 to 322
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xe0) << 13);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 323 to 336
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0x80) << 11);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 296 to 309
	value = ((uint32_t)input[37] << 24) |
			((uint32_t)(input[38] & 0xfc) << 16);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 310 to 323
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xf0) << 14);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 324 to 337
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xc0) << 12);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 15
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 16 to 29
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfc) << 16);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 30 to 43
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf0) << 14);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 44 to 57
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xc0) << 12);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 58 to 71
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 72 to 85
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)(input[10] & 0xfc) << 16);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 86 to 99
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xf0) << 14);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 100 to 113
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xc0) << 12);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 114 to 127
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 128 to 141
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)(input[17] & 0xfc) << 16);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 142 to 155
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)(input[19] & 0xf0) << 14);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 156 to 169
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)(input[21] & 0xc0) << 12);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 170 to 183
	value = ((uint32_t)(input[21] & 0x3f) << 26) |
			((uint32_t)input[22] << 18);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 184 to 197
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)(input[24] & 0xfc) << 16);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 198 to 211
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xf0) << 14);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 212 to 225
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xc0) << 12);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 226 to 239
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 240 to 253
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)(input[31] & 0xfc) << 16);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 254 to 267
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)(input[33] & 0xf0) << 14);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 268 to 281
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)(input[35] & 0xc0) << 12);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 282 to 295
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 296 to 309
	value = ((uint32_t)input[37] << 24) |
			((uint32_t)(input[38] & 0xfc) << 16);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 310 to 323
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xf0) << 14);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 324 to 337
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xc0) << 12);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 297 to 310
	value = ((uint32_t)(input[37] & 0x7f) << 25) |
			((uint32_t)(input[38] & 0xfe) << 17);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 311 to 324
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xf8) << 15);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 325 to 338
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xe0) << 13);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 16
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0x80) << 11);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 17 to 30
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)(input[3] & 0xfe) << 17);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 31 to 44
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xf8) << 15);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 45 to 58
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xe0) << 13);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 59 to 72
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0x80) << 11);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 73 to 86
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)(input[10] & 0xfe) << 17);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 87 to 100
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xf8) << 15);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 101 to 114
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xe0) << 13);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 115 to 128
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0x80) << 11);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 129 to 142
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)(input[17] & 0xfe) << 17);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 143 to 156
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)(input[19] & 0xf8) << 15);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 157 to 170
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)(input[21] & 0xe0) << 13);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 171 to 184
	value = ((uint32_t)(input[21] & 0x1f) << 27) |
			((uint32_t)input[22] << 19) |
			((uint32_t)(input[23] & 0x80) << 11);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 185 to 198
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)(input[24] & 0xfe) << 17);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 199 to 212
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xf8) << 15);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 213 to 226
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xe0) << 13);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 227 to 240
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0x80) << 11);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 241 to 254
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)(input[31] & 0xfe) << 17);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 255 to 268
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)(input[33] & 0xf8) << 15);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 269 to 282
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)(input[35] & 0xe0) << 13);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 283 to 296
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0x80) << 11);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 297 to 310
	value = ((uint32_t)(input[37] & 0x7f) << 25) |
			((uint32_t)(input[38] & 0xfe) << 17);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 311 to 324
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xf8) << 15);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 325 to 338
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xe0) << 13);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 298 to 311
	value = ((uint32_t)(input[37] & 0x3f) << 26) |
			((uint32_t)input[38] << 18);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 312 to 325
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)(input[40] & 0xfc) << 16);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 326 to 339
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xf0) << 14);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 17
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xc0) << 12);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 18 to 31
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 32 to 45
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfc) << 16);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 46 to 59
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf0) << 14);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 60 to 73
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xc0) << 12);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 74 to 87
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 88 to 101
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)(input[12] & 0xfc) << 16);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 102 to 115
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xf0) << 14);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 116 to 129
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xc0) << 12);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 130 to 143
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 144 to 157
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)(input[19] & 0xfc) << 16);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 158 to 171
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)(input[21] & 0xf0) << 14);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 172 to 185
	value = ((uint32_t)(input[21] & 0x0f) << 28) |
			((uint32_t)input[22] << 20) |
			((uint32_t)(input[23] & 0xc0) << 12);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 186 to 199
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 200 to 213
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)(input[26] & 0xfc) << 16);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 214 to 227
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xf0) << 14);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 228 to 241
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xc0) << 12);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 242 to 255
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 256 to 269
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)(input[33] & 0xfc) << 16);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 270 to 283
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)(input[35] & 0xf0) << 14);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 284 to 297
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)(input[37] & 0xc0) << 12);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 298 to 311
	value = ((uint32_t)(input[37] & 0x3f) << 26) |
			((uint32_t)input[38] << 18);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 312 to 325
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)(input[40] & 0xfc) << 16);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 326 to 339
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xf0) << 14);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 299 to 312
	value = ((uint32_t)(input[37] & 0x1f) << 27) |
			((uint32_t)input[38] << 19) |
			((uint32_t)(input[39] & 0x80) << 11);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 313 to 326
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)(input[40] & 0xfe) << 17);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 327 to 340
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xf8) << 15);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 18
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xe0) << 13);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 19 to 32
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0x80) << 11);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 33 to 46
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)(input[5] & 0xfe) << 17);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 47 to 60
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xf8) << 15);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 61 to 74
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xe0) << 13);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 75 to 88
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0x80) << 11);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 89 to 102
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)(input[12] & 0xfe) << 17);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 103 to 116
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xf8) << 15);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 117 to 130
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xe0) << 13);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 131 to 144
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0x80) << 11);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 145 to 158
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)(input[19] & 0xfe) << 17);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 159 to 172
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)(input[21] & 0xf8) << 15);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 173 to 186
	value = ((uint32_t)(input[21] & 0x07) << 29) |
			((uint32_t)input[22] << 21) |
			((uint32_t)(input[23] & 0xe0) << 13);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 187 to 200
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0x80) << 11);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 201 to 214
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)(input[26] & 0xfe) << 17);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 215 to 228
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xf8) << 15);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 229 to 242
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xe0) << 13);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 243 to 256
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0x80) << 11);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 257 to 270
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)(input[33] & 0xfe) << 17);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 271 to 284
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)(input[35] & 0xf8) << 15);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 285 to 298
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)(input[37] & 0xe0) << 13);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 299 to 312
	value = ((uint32_t)(input[37] & 0x1f) << 27) |
			((uint32_t)input[38] << 19) |
			((uint32_t)(input[39] & 0x80) << 11);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 313 to 326
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)(input[40] & 0xfe) << 17);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 327 to 340
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xf8) << 15);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 300 to 313
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)(input[39] & 0xc0) << 12);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 314 to 327
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 328 to 341
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)(input[42] & 0xfc) << 16);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 19
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf0) << 14);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 20 to 33
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xc0) << 12);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 34 to 47
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 48 to 61
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfc) << 16);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 62 to 75
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf0) << 14);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 76 to 89
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xc0) << 12);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 90 to 103
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 104 to 117
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)(input[14] & 0xfc) << 16);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 118 to 131
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xf0) << 14);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 132 to 145
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xc0) << 12);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 146 to 159
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 160 to 173
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)(input[21] & 0xfc) << 16);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 174 to 187
	value = ((uint32_t)(input[21] & 0x03) << 30) |
			((uint32_t)input[22] << 22) |
			((uint32_t)(input[23] & 0xf0) << 14);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 188 to 201
	value = ((uint32_t)(input[23] & 0x0f) << 28) |
			((uint32_t)input[24] << 20) |
			((uint32_t)(input[25] & 0xc0) << 12);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 202 to 215
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 216 to 229
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)(input[28] & 0xfc) << 16);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 230 to 243
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xf0) << 14);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 244 to 257
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xc0) << 12);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 258 to 271
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 272 to 285
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)(input[35] & 0xfc) << 16);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 286 to 299
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)(input[37] & 0xf0) << 14);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 300 to 313
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)(input[39] & 0xc0) << 12);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 314 to 327
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 328 to 341
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)(input[42] & 0xfc) << 16);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit signed
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 301 to 314
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)(input[39] & 0xe0) << 13);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 315 to 328
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)(input[41] & 0x80) << 11);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 329 to 342
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)(input[42] & 0xfe) << 17);
	output[23] = (double)(value >> 18);
}

static void unpack_24_14bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 14-bit unsigned
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 20
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xf8) << 15);
	output[0] = (double)(value >> 18);

	// read output[1]: from bit 21 to 34
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xe0) << 13);
	output[1] = (double)(value >> 18);

	// read output[2]: from bit 35 to 48
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0x80) << 11);
	output[2] = (double)(value >> 18);

	// read output[3]: from bit 49 to 62
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)(input[7] & 0xfe) << 17);
	output[3] = (double)(value >> 18);

	// read output[4]: from bit 63 to 76
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xf8) << 15);
	output[4] = (double)(value >> 18);

	// read output[5]: from bit 77 to 90
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xe0) << 13);
	output[5] = (double)(value >> 18);

	// read output[6]: from bit 91 to 104
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0x80) << 11);
	output[6] = (double)(value >> 18);

	// read output[7]: from bit 105 to 118
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)(input[14] & 0xfe) << 17);
	output[7] = (double)(value >> 18);

	// read output[8]: from bit 119 to 132
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xf8) << 15);
	output[8] = (double)(value >> 18);

	// read output[9]: from bit 133 to 146
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xe0) << 13);
	output[9] = (double)(value >> 18);

	// read output[10]: from bit 147 to 160
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0x80) << 11);
	output[10] = (double)(value >> 18);

	// read output[11]: from bit 161 to 174
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)(input[21] & 0xfe) << 17);
	output[11] = (double)(value >> 18);

	// read output[12]: from bit 175 to 188
	value = ((uint32_t)(input[21] & 0x01) << 31) |
			((uint32_t)input[22] << 23) |
			((uint32_t)(input[23] & 0xf8) << 15);
	output[12] = (double)(value >> 18);

	// read output[13]: from bit 189 to 202
	value = ((uint32_t)(input[23] & 0x07) << 29) |
			((uint32_t)input[24] << 21) |
			((uint32_t)(input[25] & 0xe0) << 13);
	output[13] = (double)(value >> 18);

	// read output[14]: from bit 203 to 216
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0x80) << 11);
	output[14] = (double)(value >> 18);

	// read output[15]: from bit 217 to 230
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)(input[28] & 0xfe) << 17);
	output[15] = (double)(value >> 18);

	// read output[16]: from bit 231 to 244
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xf8) << 15);
	output[16] = (double)(value >> 18);

	// read output[17]: from bit 245 to 258
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xe0) << 13);
	output[17] = (double)(value >> 18);

	// read output[18]: from bit 259 to 272
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0x80) << 11);
	output[18] = (double)(value >> 18);

	// read output[19]: from bit 273 to 286
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)(input[35] & 0xfe) << 17);
	output[19] = (double)(value >> 18);

	// read output[20]: from bit 287 to 300
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)(input[37] & 0xf8) << 15);
	output[20] = (double)(value >> 18);

	// read output[21]: from bit 301 to 314
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)(input[39] & 0xe0) << 13);
	output[21] = (double)(value >> 18);

	// read output[22]: from bit 315 to 328
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)(input[41] & 0x80) << 11);
	output[22] = (double)(value >> 18);

	// read output[23]: from bit 329 to 342
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)(input[42] & 0xfe) << 17);
	output[23] = (double)(value >> 18);
}

static void unpack_25_14bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 25 values into output
	// Values are 14-bit signed
	// Skip 0 bits, read 350 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 13
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfc) << 16);
	output[0] = (doub