// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack15.h"



static void unpack_1_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 15 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 15 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 15 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 15 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);
}

static void unpack_1_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 15 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 30 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);
}

static void unpack_2_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 30 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 45 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);
}

static void unpack_3_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 45 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);
}

static void unpack_4_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 75 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);
}

static void unpack_5_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 75 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 75 to 89
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xc0) << 11);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 75 to 89
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xc0) << 11);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 76 to 90
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xe0) << 12);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 76 to 90
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xe0) << 12);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 77 to 91
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xf0) << 13);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 77 to 91
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xf0) << 13);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 78 to 92
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xf8) << 14);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 78 to 92
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xf8) << 14);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 79 to 93
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xfc) << 15);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 79 to 93
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xfc) << 15);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 80 to 94
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xfe) << 16);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 80 to 94
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xfe) << 16);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 81 to 95
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 81 to 95
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 82 to 96
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0x80) << 10);
	output[5] = (double)(value >> 17);
}

static void unpack_6_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 82 to 96
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0x80) << 10);
	output[5] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 75 to 89
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xc0) << 11);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 90 to 104
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0x80) << 10);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 75 to 89
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xc0) << 11);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 90 to 104
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0x80) << 10);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 76 to 90
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xe0) << 12);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 91 to 105
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xc0) << 11);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 76 to 90
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xe0) << 12);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 91 to 105
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xc0) << 11);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 77 to 91
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xf0) << 13);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 92 to 106
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xe0) << 12);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 77 to 91
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xf0) << 13);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 92 to 106
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xe0) << 12);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 78 to 92
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xf8) << 14);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 93 to 107
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xf0) << 13);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 78 to 92
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xf8) << 14);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 93 to 107
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xf0) << 13);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 79 to 93
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xfc) << 15);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 94 to 108
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)(input[13] & 0xf8) << 14);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 79 to 93
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xfc) << 15);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 94 to 108
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)(input[13] & 0xf8) << 14);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 80 to 94
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xfe) << 16);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 95 to 109
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0xfc) << 15);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 80 to 94
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xfe) << 16);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 95 to 109
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0xfc) << 15);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 81 to 95
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 96 to 110
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xfe) << 16);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 81 to 95
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 96 to 110
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xfe) << 16);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 82 to 96
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0x80) << 10);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 97 to 111
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17);
	output[6] = (double)(value >> 17);
}

static void unpack_7_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 82 to 96
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0x80) << 10);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 97 to 111
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17);
	output[6] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 75 to 89
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xc0) << 11);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 90 to 104
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0x80) << 10);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 105 to 119
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 14
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)(input[1] & 0xfe) << 16);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 15 to 29
	value = ((uint32_t)(input[1] & 0x01) << 31) |
			((uint32_t)input[2] << 23) |
			((uint32_t)(input[3] & 0xfc) << 15);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 30 to 44
	value = ((uint32_t)(input[3] & 0x03) << 30) |
			((uint32_t)input[4] << 22) |
			((uint32_t)(input[5] & 0xf8) << 14);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 45 to 59
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)(input[7] & 0xf0) << 13);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 60 to 74
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xe0) << 12);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 75 to 89
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xc0) << 11);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 90 to 104
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0x80) << 10);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 105 to 119
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 76 to 90
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xe0) << 12);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 91 to 105
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xc0) << 11);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 106 to 120
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0x80) << 10);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 15
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 16 to 30
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)(input[3] & 0xfe) << 16);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 31 to 45
	value = ((uint32_t)(input[3] & 0x01) << 31) |
			((uint32_t)input[4] << 23) |
			((uint32_t)(input[5] & 0xfc) << 15);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 46 to 60
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)(input[7] & 0xf8) << 14);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 61 to 75
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xf0) << 13);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 76 to 90
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xe0) << 12);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 91 to 105
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xc0) << 11);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 106 to 120
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0x80) << 10);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 77 to 91
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xf0) << 13);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 92 to 106
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xe0) << 12);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 107 to 121
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xc0) << 11);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 16
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0x80) << 10);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 17 to 31
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 32 to 46
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)(input[5] & 0xfe) << 16);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 47 to 61
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)(input[7] & 0xfc) << 15);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 62 to 76
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)(input[9] & 0xf8) << 14);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 77 to 91
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xf0) << 13);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 92 to 106
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xe0) << 12);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 107 to 121
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xc0) << 11);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 78 to 92
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xf8) << 14);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 93 to 107
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xf0) << 13);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 108 to 122
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xe0) << 12);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 17
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xc0) << 11);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 18 to 32
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0x80) << 10);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 33 to 47
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 48 to 62
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)(input[7] & 0xfe) << 16);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 63 to 77
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)(input[9] & 0xfc) << 15);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 78 to 92
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)(input[11] & 0xf8) << 14);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 93 to 107
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xf0) << 13);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 108 to 122
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xe0) << 12);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 79 to 93
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xfc) << 15);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 94 to 108
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)(input[13] & 0xf8) << 14);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 109 to 123
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xf0) << 13);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 18
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xe0) << 12);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 19 to 33
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xc0) << 11);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 34 to 48
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0x80) << 10);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 49 to 63
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 64 to 78
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)(input[9] & 0xfe) << 16);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 79 to 93
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)(input[11] & 0xfc) << 15);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 94 to 108
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)(input[13] & 0xf8) << 14);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 109 to 123
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xf0) << 13);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 80 to 94
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xfe) << 16);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 95 to 109
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0xfc) << 15);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 110 to 124
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xf8) << 14);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 19
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf0) << 13);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 20 to 34
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xe0) << 12);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 35 to 49
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xc0) << 11);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 50 to 64
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0x80) << 10);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 65 to 79
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 80 to 94
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)(input[11] & 0xfe) << 16);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 95 to 109
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)(input[13] & 0xfc) << 15);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 110 to 124
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)(input[15] & 0xf8) << 14);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 81 to 95
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 96 to 110
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xfe) << 16);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 111 to 125
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xfc) << 15);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 20
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xf8) << 14);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 21 to 35
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf0) << 13);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 36 to 50
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xe0) << 12);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 51 to 65
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xc0) << 11);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 66 to 80
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0x80) << 10);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 81 to 95
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 96 to 110
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)(input[13] & 0xfe) << 16);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 111 to 125
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)(input[15] & 0xfc) << 15);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit signed
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 82 to 96
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0x80) << 10);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 97 to 111
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 112 to 126
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfe) << 16);
	output[7] = (double)(value >> 17);
}

static void unpack_8_15bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 15-bit unsigned
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 21
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfc) << 15);
	output[0] = (double)(value >> 17);

	// read output[1]: from bit 22 to 36
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xf8) << 14);
	output[1] = (double)(value >> 17);

	// read output[2]: from bit 37 to 51
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf0) << 13);
	output[2] = (double)(value >> 17);

	// read output[3]: from bit 52 to 66
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xe0) << 12);
	output[3] = (double)(value >> 17);

	// read output[4]: from bit 67 to 81
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xc0) << 11);
	output[4] = (double)(value >> 17);

	// read output[5]: from bit 82 to 96
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0x80) << 10);
	output[5] = (double)(value >> 17);

	// read output[6]: from bit 97 to 111
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17);
	output[6] = (double)(value >> 17);

	// read output[7]: from bit 112 to 126
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)(input[15] & 0xfe) << 16);
	output[7] = (double)(value >> 17);
}


unpack_func_t unpack_15bit[UNPACK_15BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_15bit_unsigned_0off,
			unpack_1_15bit_signed_0off,
		},
		{
			unpack_1_15bit_unsigned_1off,
			unpack_1_15bit_signed_1off,
		},
		{
			unpack_1_15bit_unsigned_2off,
			unpack_1_15bit_signed_2off,
		},
		{
			unpack_1_15bit_unsigned_3off,
			unpack_1_15bit_signed_3off,
		},
		{
			unpack_1_15bit_unsigned_4off,
			unpack_1_15bit_signed_4off,
		},
		{
			unpack_1_15bit_unsigned_5off,
			unpack_1_15bit_signed_5off,
		},
		{
			unpack_1_15bit_unsigned_6off,
			unpack_1_15bit_signed_6off,
		},
		{
			unpack_1_15bit_unsigned_7off,
			unpack_1_15bit_signed_7off,
		},
	},
	{
		{
			unpack_2_15bit_unsigned_0off,
			unpack_2_15bit_signed_0off,
		},
		{
			unpack_2_15bit_unsigned_1off,
			unpack_2_15bit_signed_1off,
		},
		{
			unpack_2_15bit_unsigned_2off,
			unpack_2_15bit_signed_2off,
		},
		{
			unpack_2_15bit_unsigned_3off,
			unpack_2_15bit_signed_3off,
		},
		{
			unpack_2_15bit_unsigned_4off,
			unpack_2_15bit_signed_4off,
		},
		{
			unpack_2_15bit_unsigned_5off,
			unpack_2_15bit_signed_5off,
		},
		{
			unpack_2_15bit_unsigned_6off,
			unpack_2_15bit_signed_6off,
		},
		{
			unpack_2_15bit_unsigned_7off,
			unpack_2_15bit_signed_7off,
		},
	},
	{
		{
			unpack_3_15bit_unsigned_0off,
			unpack_3_15bit_signed_0off,
		},
		{
			unpack_3_15bit_unsigned_1off,
			unpack_3_15bit_signed_1off,
		},
		{
			unpack_3_15bit_unsigned_2off,
			unpack_3_15bit_signed_2off,
		},
		{
			unpack_3_15bit_unsigned_3off,
			unpack_3_15bit_signed_3off,
		},
		{
			unpack_3_15bit_unsigned_4off,
			unpack_3_15bit_signed_4off,
		},
		{
			unpack_3_15bit_unsigned_5off,
			unpack_3_15bit_signed_5off,
		},
		{
			unpack_3_15bit_unsigned_6off,
			unpack_3_15bit_signed_6off,
		},
		{
			unpack_3_15bit_unsigned_7off,
			unpack_3_15bit_signed_7off,
		},
	},
	{
		{
			unpack_4_15bit_unsigned_0off,
			unpack_4_15bit_signed_0off,
		},
		{
			unpack_4_15bit_unsigned_1off,
			unpack_4_15bit_signed_1off,
		},
		{
			unpack_4_15bit_unsigned_2off,
			unpack_4_15bit_signed_2off,
		},
		{
			unpack_4_15bit_unsigned_3off,
			unpack_4_15bit_signed_3off,
		},
		{
			unpack_4_15bit_unsigned_4off,
			unpack_4_15bit_signed_4off,
		},
		{
			unpack_4_15bit_unsigned_5off,
			unpack_4_15bit_signed_5off,
		},
		{
			unpack_4_15bit_unsigned_6off,
			unpack_4_15bit_signed_6off,
		},
		{
			unpack_4_15bit_unsigned_7off,
			unpack_4_15bit_signed_7off,
		},
	},
	{
		{
			unpack_5_15bit_unsigned_0off,
			unpack_5_15bit_signed_0off,
		},
		{
			unpack_5_15bit_unsigned_1off,
			unpack_5_15bit_signed_1off,
		},
		{
			unpack_5_15bit_unsigned_2off,
			unpack_5_15bit_signed_2off,
		},
		{
			unpack_5_15bit_unsigned_3off,
			unpack_5_15bit_signed_3off,
		},
		{
			unpack_5_15bit_unsigned_4off,
			unpack_5_15bit_signed_4off,
		},
		{
			unpack_5_15bit_unsigned_5off,
			unpack_5_15bit_signed_5off,
		},
		{
			unpack_5_15bit_unsigned_6off,
			unpack_5_15bit_signed_6off,
		},
		{
			unpack_5_15bit_unsigned_7off,
			unpack_5_15bit_signed_7off,
		},
	},
	{
		{
			unpack_6_15bit_unsigned_0off,
			unpack_6_15bit_signed_0off,
		},
		{
			unpack_6_15bit_unsigned_1off,
			unpack_6_15bit_signed_1off,
		},
		{
			unpack_6_15bit_unsigned_2off,
			unpack_6_15bit_signed_2off,
		},
		{
			unpack_6_15bit_unsigned_3off,
			unpack_6_15bit_signed_3off,
		},
		{
			unpack_6_15bit_unsigned_4off,
			unpack_6_15bit_signed_4off,
		},
		{
			unpack_6_15bit_unsigned_5off,
			unpack_6_15bit_signed_5off,
		},
		{
			unpack_6_15bit_unsigned_6off,
			unpack_6_15bit_signed_6off,
		},
		{
			unpack_6_15bit_unsigned_7off,
			unpack_6_15bit_signed_7off,
		},
	},
	{
		{
			unpack_7_15bit_unsigned_0off,
			unpack_7_15bit_signed_0off,
		},
		{
			unpack_7_15bit_unsigned_1off,
			unpack_7_15bit_signed_1off,
		},
		{
			unpack_7_15bit_unsigned_2off,
			unpack_7_15bit_signed_2off,
		},
		{
			unpack_7_15bit_unsigned_3off,
			unpack_7_15bit_signed_3off,
		},
		{
			unpack_7_15bit_unsigned_4off,
			unpack_7_15bit_signed_4off,
		},
		{
			unpack_7_15bit_unsigned_5off,
			unpack_7_15bit_signed_5off,
		},
		{
			unpack_7_15bit_unsigned_6off,
			unpack_7_15bit_signed_6off,
		},
		{
			unpack_7_15bit_unsigned_7off,
			unpack_7_15bit_signed_7off,
		},
	},
	{
		{
			unpack_8_15bit_unsigned_0off,
			unpack_8_15bit_signed_0off,
		},
		{
			unpack_8_15bit_unsigned_1off,
			unpack_8_15bit_signed_1off,
		},
		{
			unpack_8_15bit_unsigned_2off,
			unpack_8_15bit_signed_2off,
		},
		{
			unpack_8_15bit_unsigned_3off,
			unpack_8_15bit_signed_3off,
		},
		{
			unpack_8_15bit_unsigned_4off,
			unpack_8_15bit_signed_4off,
		},
		{
			unpack_8_15bit_unsigned_5off,
			unpack_8_15bit_signed_5off,
		},
		{
			unpack_8_15bit_unsigned_6off,
			unpack_8_15bit_signed_6off,
		},
		{
			unpack_8_15bit_unsigned_7off,
			unpack_8_15bit_signed_7off,
		},
	},
};
