// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack16.h"



static void unpack_1_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 16 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 16 bits of data.
	// Input must be at least 2 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);
}

static void unpack_1_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 16 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 32 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 32 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);
}

static void unpack_2_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 32 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 48 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 48 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);
}

static void unpack_3_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 48 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 64 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 64 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);
}

static void unpack_4_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 64 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 80 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 80 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);
}

static void unpack_5_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 96 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);
}

static void unpack_6_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 96 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 112 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 112 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);
}

static void unpack_7_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 112 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 128 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 128 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);
}

static void unpack_8_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 128 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);
}

static void unpack_9_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);
}

static void unpack_10_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 176 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 176 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);
}

static void unpack_11_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 192 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);
}

static void unpack_12_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 192 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 208 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 208 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);
}

static void unpack_13_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 208 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 224 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);
}

static void unpack_14_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 224 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);
}

static void unpack_15_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 256 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 256 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);
}

static void unpack_16_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 256 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 272 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 272 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);
}

static void unpack_17_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 272 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);
}

static void unpack_18_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 304 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 304 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);
}

static void unpack_19_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 304 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 320 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 320 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);
}

static void unpack_20_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 336 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 324 to 339
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xf0) << 12);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 324 to 339
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xf0) << 12);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 325 to 340
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xf8) << 13);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 325 to 340
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xf8) << 13);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 326 to 341
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xfc) << 14);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 326 to 341
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xfc) << 14);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 327 to 342
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xfe) << 15);
	output[20] = (double)(value >> 16);
}

static void unpack_21_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 336 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 327 to 342
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xfe) << 15);
	output[20] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 352 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 336 to 351
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 352 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 336 to 351
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 337 to 352
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0x80) << 9);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 337 to 352
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0x80) << 9);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 338 to 353
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)(input[44] & 0xc0) << 10);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 338 to 353
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)(input[44] & 0xc0) << 10);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 339 to 354
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)(input[44] & 0xe0) << 11);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 339 to 354
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)(input[44] & 0xe0) << 11);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 324 to 339
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xf0) << 12);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 340 to 355
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)(input[44] & 0xf0) << 12);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 324 to 339
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xf0) << 12);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 340 to 355
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)(input[44] & 0xf0) << 12);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 325 to 340
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xf8) << 13);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 341 to 356
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)(input[44] & 0xf8) << 13);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 325 to 340
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xf8) << 13);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 341 to 356
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)(input[44] & 0xf8) << 13);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 326 to 341
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xfc) << 14);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 342 to 357
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)(input[44] & 0xfc) << 14);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 326 to 341
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xfc) << 14);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 342 to 357
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)(input[44] & 0xfc) << 14);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 327 to 342
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xfe) << 15);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 343 to 358
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)(input[44] & 0xfe) << 15);
	output[21] = (double)(value >> 16);
}

static void unpack_22_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 327 to 342
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xfe) << 15);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 343 to 358
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)(input[44] & 0xfe) << 15);
	output[21] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 368 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 336 to 351
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 352 to 367
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 368 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 336 to 351
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 352 to 367
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 337 to 352
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0x80) << 9);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 353 to 368
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0x80) << 9);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 337 to 352
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0x80) << 9);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 353 to 368
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0x80) << 9);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 338 to 353
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)(input[44] & 0xc0) << 10);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 354 to 369
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)(input[46] & 0xc0) << 10);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 338 to 353
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)(input[44] & 0xc0) << 10);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 354 to 369
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)(input[46] & 0xc0) << 10);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 339 to 354
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)(input[44] & 0xe0) << 11);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 355 to 370
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)(input[46] & 0xe0) << 11);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 339 to 354
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)(input[44] & 0xe0) << 11);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 355 to 370
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)(input[46] & 0xe0) << 11);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 324 to 339
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xf0) << 12);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 340 to 355
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)(input[44] & 0xf0) << 12);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 356 to 371
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)(input[46] & 0xf0) << 12);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 4 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xf0) << 12);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 116 to 131
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xf0) << 12);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 132 to 147
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xf0) << 12);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 148 to 163
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xf0) << 12);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 164 to 179
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xf0) << 12);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 180 to 195
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xf0) << 12);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 196 to 211
	value = ((uint32_t)(input[24] & 0x0f) << 28) |
			((uint32_t)input[25] << 20) |
			((uint32_t)(input[26] & 0xf0) << 12);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 212 to 227
	value = ((uint32_t)(input[26] & 0x0f) << 28) |
			((uint32_t)input[27] << 20) |
			((uint32_t)(input[28] & 0xf0) << 12);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 228 to 243
	value = ((uint32_t)(input[28] & 0x0f) << 28) |
			((uint32_t)input[29] << 20) |
			((uint32_t)(input[30] & 0xf0) << 12);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 244 to 259
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)(input[32] & 0xf0) << 12);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 260 to 275
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)(input[34] & 0xf0) << 12);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 276 to 291
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xf0) << 12);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 292 to 307
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xf0) << 12);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 308 to 323
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xf0) << 12);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 324 to 339
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xf0) << 12);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 340 to 355
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)(input[44] & 0xf0) << 12);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 356 to 371
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)(input[46] & 0xf0) << 12);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 5 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 325 to 340
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xf8) << 13);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 341 to 356
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)(input[44] & 0xf8) << 13);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 357 to 372
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)(input[46] & 0xf8) << 13);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 5 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 20
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xf8) << 13);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 21 to 36
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xf8) << 13);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 37 to 52
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xf8) << 13);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 53 to 68
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xf8) << 13);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 69 to 84
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xf8) << 13);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 85 to 100
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xf8) << 13);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 101 to 116
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)(input[14] & 0xf8) << 13);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 117 to 132
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)(input[16] & 0xf8) << 13);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 133 to 148
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xf8) << 13);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 149 to 164
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xf8) << 13);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 165 to 180
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xf8) << 13);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 181 to 196
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xf8) << 13);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 197 to 212
	value = ((uint32_t)(input[24] & 0x07) << 29) |
			((uint32_t)input[25] << 21) |
			((uint32_t)(input[26] & 0xf8) << 13);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 213 to 228
	value = ((uint32_t)(input[26] & 0x07) << 29) |
			((uint32_t)input[27] << 21) |
			((uint32_t)(input[28] & 0xf8) << 13);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 229 to 244
	value = ((uint32_t)(input[28] & 0x07) << 29) |
			((uint32_t)input[29] << 21) |
			((uint32_t)(input[30] & 0xf8) << 13);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 245 to 260
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)(input[32] & 0xf8) << 13);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 261 to 276
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)(input[34] & 0xf8) << 13);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 277 to 292
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xf8) << 13);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 293 to 308
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xf8) << 13);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 309 to 324
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xf8) << 13);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 325 to 340
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xf8) << 13);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 341 to 356
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)(input[44] & 0xf8) << 13);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 357 to 372
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)(input[46] & 0xf8) << 13);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 6 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 326 to 341
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xfc) << 14);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 342 to 357
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)(input[44] & 0xfc) << 14);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 358 to 373
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)(input[46] & 0xfc) << 14);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 6 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 21
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfc) << 14);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 22 to 37
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfc) << 14);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 38 to 53
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfc) << 14);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 54 to 69
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfc) << 14);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 70 to 85
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfc) << 14);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 86 to 101
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfc) << 14);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 102 to 117
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfc) << 14);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 118 to 133
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)(input[16] & 0xfc) << 14);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 134 to 149
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)(input[18] & 0xfc) << 14);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 150 to 165
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)(input[20] & 0xfc) << 14);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 166 to 181
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)(input[22] & 0xfc) << 14);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 182 to 197
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)(input[24] & 0xfc) << 14);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 198 to 213
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)(input[26] & 0xfc) << 14);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 214 to 229
	value = ((uint32_t)(input[26] & 0x03) << 30) |
			((uint32_t)input[27] << 22) |
			((uint32_t)(input[28] & 0xfc) << 14);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 230 to 245
	value = ((uint32_t)(input[28] & 0x03) << 30) |
			((uint32_t)input[29] << 22) |
			((uint32_t)(input[30] & 0xfc) << 14);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 246 to 261
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)(input[32] & 0xfc) << 14);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 262 to 277
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)(input[34] & 0xfc) << 14);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 278 to 293
	value = ((uint32_t)(input[34] & 0x03) << 30) |
			((uint32_t)input[35] << 22) |
			((uint32_t)(input[36] & 0xfc) << 14);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 294 to 309
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)(input[38] & 0xfc) << 14);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 310 to 325
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)(input[40] & 0xfc) << 14);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 326 to 341
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)(input[42] & 0xfc) << 14);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 342 to 357
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)(input[44] & 0xfc) << 14);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 358 to 373
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)(input[46] & 0xfc) << 14);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit signed
	// Skip 7 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 327 to 342
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xfe) << 15);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 343 to 358
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)(input[44] & 0xfe) << 15);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 359 to 374
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)(input[46] & 0xfe) << 15);
	output[22] = (double)(value >> 16);
}

static void unpack_23_16bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 16-bit unsigned
	// Skip 7 bits, read 368 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 22
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)(input[2] & 0xfe) << 15);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 23 to 38
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)(input[4] & 0xfe) << 15);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 39 to 54
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)(input[6] & 0xfe) << 15);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 55 to 70
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)(input[8] & 0xfe) << 15);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 71 to 86
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)(input[10] & 0xfe) << 15);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 87 to 102
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)(input[12] & 0xfe) << 15);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 103 to 118
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)(input[14] & 0xfe) << 15);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 119 to 134
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)(input[16] & 0xfe) << 15);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 135 to 150
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)(input[18] & 0xfe) << 15);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 151 to 166
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)(input[20] & 0xfe) << 15);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 167 to 182
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)(input[22] & 0xfe) << 15);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 183 to 198
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)(input[24] & 0xfe) << 15);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 199 to 214
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)(input[26] & 0xfe) << 15);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 215 to 230
	value = ((uint32_t)(input[26] & 0x01) << 31) |
			((uint32_t)input[27] << 23) |
			((uint32_t)(input[28] & 0xfe) << 15);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 231 to 246
	value = ((uint32_t)(input[28] & 0x01) << 31) |
			((uint32_t)input[29] << 23) |
			((uint32_t)(input[30] & 0xfe) << 15);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 247 to 262
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)(input[32] & 0xfe) << 15);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 263 to 278
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)(input[34] & 0xfe) << 15);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 279 to 294
	value = ((uint32_t)(input[34] & 0x01) << 31) |
			((uint32_t)input[35] << 23) |
			((uint32_t)(input[36] & 0xfe) << 15);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 295 to 310
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)(input[38] & 0xfe) << 15);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 311 to 326
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)(input[40] & 0xfe) << 15);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 327 to 342
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)(input[42] & 0xfe) << 15);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 343 to 358
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)(input[44] & 0xfe) << 15);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 359 to 374
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)(input[46] & 0xfe) << 15);
	output[22] = (double)(value >> 16);
}

static void unpack_24_16bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit signed
	// Skip 0 bits, read 384 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 336 to 351
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 352 to 367
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 368 to 383
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit unsigned
	// Skip 0 bits, read 384 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 15
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 16 to 31
	value = ((uint32_t)input[2] << 24) |
			((uint32_t)input[3] << 16);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 32 to 47
	value = ((uint32_t)input[4] << 24) |
			((uint32_t)input[5] << 16);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 48 to 63
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 64 to 79
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 80 to 95
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 96 to 111
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 112 to 127
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 128 to 143
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 144 to 159
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 160 to 175
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 176 to 191
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 192 to 207
	value = ((uint32_t)input[24] << 24) |
			((uint32_t)input[25] << 16);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 208 to 223
	value = ((uint32_t)input[26] << 24) |
			((uint32_t)input[27] << 16);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 224 to 239
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 240 to 255
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 256 to 271
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 272 to 287
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 288 to 303
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 304 to 319
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 320 to 335
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 336 to 351
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 352 to 367
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 368 to 383
	value = ((uint32_t)input[46] << 24) |
			((uint32_t)input[47] << 16);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit signed
	// Skip 1 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 337 to 352
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0x80) << 9);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 353 to 368
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0x80) << 9);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 369 to 384
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)(input[48] & 0x80) << 9);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit unsigned
	// Skip 1 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 16
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0x80) << 9);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 17 to 32
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0x80) << 9);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 33 to 48
	value = ((uint32_t)(input[4] & 0x7f) << 25) |
			((uint32_t)input[5] << 17) |
			((uint32_t)(input[6] & 0x80) << 9);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 49 to 64
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0x80) << 9);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 65 to 80
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0x80) << 9);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 81 to 96
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0x80) << 9);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 97 to 112
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0x80) << 9);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 113 to 128
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0x80) << 9);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 129 to 144
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0x80) << 9);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 145 to 160
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0x80) << 9);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 161 to 176
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0x80) << 9);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 177 to 192
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0x80) << 9);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 193 to 208
	value = ((uint32_t)(input[24] & 0x7f) << 25) |
			((uint32_t)input[25] << 17) |
			((uint32_t)(input[26] & 0x80) << 9);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 209 to 224
	value = ((uint32_t)(input[26] & 0x7f) << 25) |
			((uint32_t)input[27] << 17) |
			((uint32_t)(input[28] & 0x80) << 9);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 225 to 240
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0x80) << 9);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 241 to 256
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0x80) << 9);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 257 to 272
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0x80) << 9);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 273 to 288
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0x80) << 9);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 289 to 304
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0x80) << 9);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 305 to 320
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0x80) << 9);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 321 to 336
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0x80) << 9);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 337 to 352
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0x80) << 9);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 353 to 368
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0x80) << 9);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 369 to 384
	value = ((uint32_t)(input[46] & 0x7f) << 25) |
			((uint32_t)input[47] << 17) |
			((uint32_t)(input[48] & 0x80) << 9);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit signed
	// Skip 2 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 338 to 353
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)(input[44] & 0xc0) << 10);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 354 to 369
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)(input[46] & 0xc0) << 10);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 370 to 385
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)(input[48] & 0xc0) << 10);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit unsigned
	// Skip 2 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 17
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xc0) << 10);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 18 to 33
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xc0) << 10);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 34 to 49
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xc0) << 10);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 50 to 65
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)(input[8] & 0xc0) << 10);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 66 to 81
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xc0) << 10);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 82 to 97
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xc0) << 10);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 98 to 113
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xc0) << 10);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 114 to 129
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xc0) << 10);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 130 to 145
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xc0) << 10);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 146 to 161
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xc0) << 10);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 162 to 177
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xc0) << 10);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 178 to 193
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)(input[24] & 0xc0) << 10);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 194 to 209
	value = ((uint32_t)(input[24] & 0x3f) << 26) |
			((uint32_t)input[25] << 18) |
			((uint32_t)(input[26] & 0xc0) << 10);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 210 to 225
	value = ((uint32_t)(input[26] & 0x3f) << 26) |
			((uint32_t)input[27] << 18) |
			((uint32_t)(input[28] & 0xc0) << 10);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 226 to 241
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xc0) << 10);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 242 to 257
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xc0) << 10);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 258 to 273
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xc0) << 10);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 274 to 289
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xc0) << 10);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 290 to 305
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xc0) << 10);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 306 to 321
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xc0) << 10);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 322 to 337
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xc0) << 10);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 338 to 353
	value = ((uint32_t)(input[42] & 0x3f) << 26) |
			((uint32_t)input[43] << 18) |
			((uint32_t)(input[44] & 0xc0) << 10);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 354 to 369
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)(input[46] & 0xc0) << 10);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 370 to 385
	value = ((uint32_t)(input[46] & 0x3f) << 26) |
			((uint32_t)input[47] << 18) |
			((uint32_t)(input[48] & 0xc0) << 10);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit signed
	// Skip 3 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 339 to 354
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)(input[44] & 0xe0) << 11);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 355 to 370
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)(input[46] & 0xe0) << 11);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 371 to 386
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)(input[48] & 0xe0) << 11);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit unsigned
	// Skip 3 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 18
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xe0) << 11);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 19 to 34
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xe0) << 11);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 35 to 50
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xe0) << 11);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 51 to 66
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xe0) << 11);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 67 to 82
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xe0) << 11);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 83 to 98
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xe0) << 11);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 99 to 114
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xe0) << 11);
	output[6] = (double)(value >> 16);

	// read output[7]: from bit 115 to 130
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xe0) << 11);
	output[7] = (double)(value >> 16);

	// read output[8]: from bit 131 to 146
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xe0) << 11);
	output[8] = (double)(value >> 16);

	// read output[9]: from bit 147 to 162
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xe0) << 11);
	output[9] = (double)(value >> 16);

	// read output[10]: from bit 163 to 178
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xe0) << 11);
	output[10] = (double)(value >> 16);

	// read output[11]: from bit 179 to 194
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)(input[24] & 0xe0) << 11);
	output[11] = (double)(value >> 16);

	// read output[12]: from bit 195 to 210
	value = ((uint32_t)(input[24] & 0x1f) << 27) |
			((uint32_t)input[25] << 19) |
			((uint32_t)(input[26] & 0xe0) << 11);
	output[12] = (double)(value >> 16);

	// read output[13]: from bit 211 to 226
	value = ((uint32_t)(input[26] & 0x1f) << 27) |
			((uint32_t)input[27] << 19) |
			((uint32_t)(input[28] & 0xe0) << 11);
	output[13] = (double)(value >> 16);

	// read output[14]: from bit 227 to 242
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xe0) << 11);
	output[14] = (double)(value >> 16);

	// read output[15]: from bit 243 to 258
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xe0) << 11);
	output[15] = (double)(value >> 16);

	// read output[16]: from bit 259 to 274
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xe0) << 11);
	output[16] = (double)(value >> 16);

	// read output[17]: from bit 275 to 290
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xe0) << 11);
	output[17] = (double)(value >> 16);

	// read output[18]: from bit 291 to 306
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xe0) << 11);
	output[18] = (double)(value >> 16);

	// read output[19]: from bit 307 to 322
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xe0) << 11);
	output[19] = (double)(value >> 16);

	// read output[20]: from bit 323 to 338
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xe0) << 11);
	output[20] = (double)(value >> 16);

	// read output[21]: from bit 339 to 354
	value = ((uint32_t)(input[42] & 0x1f) << 27) |
			((uint32_t)input[43] << 19) |
			((uint32_t)(input[44] & 0xe0) << 11);
	output[21] = (double)(value >> 16);

	// read output[22]: from bit 355 to 370
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)(input[46] & 0xe0) << 11);
	output[22] = (double)(value >> 16);

	// read output[23]: from bit 371 to 386
	value = ((uint32_t)(input[46] & 0x1f) << 27) |
			((uint32_t)input[47] << 19) |
			((uint32_t)(input[48] & 0xe0) << 11);
	output[23] = (double)(value >> 16);
}

static void unpack_24_16bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 16-bit signed
	// Skip 4 bits, read 384 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 19
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf0) << 12);
	output[0] = (double)(value >> 16);

	// read output[1]: from bit 20 to 35
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf0) << 12);
	output[1] = (double)(value >> 16);

	// read output[2]: from bit 36 to 51
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf0) << 12);
	output[2] = (double)(value >> 16);

	// read output[3]: from bit 52 to 67
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf0) << 12);
	output[3] = (double)(value >> 16);

	// read output[4]: from bit 68 to 83
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf0) << 12);
	output[4] = (double)(value >> 16);

	// read output[5]: from bit 84 to 99
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)(input[12] & 0xf0) << 12);
	output[5] = (double)(value >> 16);

	// read output[6]: from bit 100 to 115
	val