// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack17.h"



static void unpack_1_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);
}

static void unpack_1_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 17 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 34 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 34 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);
}

static void unpack_2_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 34 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 51 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 51 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 51 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 51 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);
}

static void unpack_3_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 51 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 68 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 68 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 68 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 68 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 68 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 68 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);
}

static void unpack_4_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 68 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 85 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);
}

static void unpack_5_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 85 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 102 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 85 to 101
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xfc) << 13);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 102 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 85 to 101
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xfc) << 13);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 102 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 86 to 102
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfe) << 14);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 102 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 86 to 102
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfe) << 14);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 102 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 87 to 103
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 102 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 87 to 103
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 88 to 104
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0x80) << 8);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 88 to 104
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0x80) << 8);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 89 to 105
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xc0) << 9);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 89 to 105
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xc0) << 9);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 90 to 106
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xe0) << 10);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 90 to 106
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xe0) << 10);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 91 to 107
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf0) << 11);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 91 to 107
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf0) << 11);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 92 to 108
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xf8) << 12);
	output[5] = (double)(value >> 15);
}

static void unpack_6_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 102 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 92 to 108
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xf8) << 12);
	output[5] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 119 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 85 to 101
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xfc) << 13);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 102 to 118
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfe) << 14);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 119 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 85 to 101
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xfc) << 13);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 102 to 118
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfe) << 14);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 119 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 86 to 102
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfe) << 14);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 103 to 119
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 119 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 86 to 102
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfe) << 14);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 103 to 119
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 87 to 103
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 104 to 120
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0x80) << 8);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 87 to 103
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 104 to 120
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0x80) << 8);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 88 to 104
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0x80) << 8);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 105 to 121
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xc0) << 9);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 88 to 104
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0x80) << 8);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 105 to 121
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xc0) << 9);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 89 to 105
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xc0) << 9);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 106 to 122
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xe0) << 10);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 89 to 105
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xc0) << 9);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 106 to 122
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xe0) << 10);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 90 to 106
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xe0) << 10);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 107 to 123
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xf0) << 11);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 90 to 106
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xe0) << 10);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 107 to 123
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xf0) << 11);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 91 to 107
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf0) << 11);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 108 to 124
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xf8) << 12);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 91 to 107
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf0) << 11);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 108 to 124
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xf8) << 12);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 92 to 108
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xf8) << 12);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 109 to 125
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfc) << 13);
	output[6] = (double)(value >> 15);
}

static void unpack_7_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 119 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 92 to 108
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xf8) << 12);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 109 to 125
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfc) << 13);
	output[6] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 0 bits, read 136 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 85 to 101
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xfc) << 13);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 102 to 118
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfe) << 14);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 119 to 135
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 0 bits, read 136 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 16
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0x80) << 8);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 17 to 33
	value = ((uint32_t)(input[2] & 0x7f) << 25) |
			((uint32_t)input[3] << 17) |
			((uint32_t)(input[4] & 0xc0) << 9);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 34 to 50
	value = ((uint32_t)(input[4] & 0x3f) << 26) |
			((uint32_t)input[5] << 18) |
			((uint32_t)(input[6] & 0xe0) << 10);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 51 to 67
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)(input[8] & 0xf0) << 11);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 68 to 84
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)(input[10] & 0xf8) << 12);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 85 to 101
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)(input[12] & 0xfc) << 13);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 102 to 118
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)(input[14] & 0xfe) << 14);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 119 to 135
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 1 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 86 to 102
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfe) << 14);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 103 to 119
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 120 to 136
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0x80) << 8);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 1 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 17
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xc0) << 9);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 18 to 34
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xe0) << 10);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 35 to 51
	value = ((uint32_t)(input[4] & 0x1f) << 27) |
			((uint32_t)input[5] << 19) |
			((uint32_t)(input[6] & 0xf0) << 11);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 52 to 68
	value = ((uint32_t)(input[6] & 0x0f) << 28) |
			((uint32_t)input[7] << 20) |
			((uint32_t)(input[8] & 0xf8) << 12);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 69 to 85
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)(input[10] & 0xfc) << 13);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 86 to 102
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)(input[12] & 0xfe) << 14);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 103 to 119
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 120 to 136
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0x80) << 8);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 2 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 87 to 103
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 104 to 120
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0x80) << 8);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 121 to 137
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xc0) << 9);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 2 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 18
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xe0) << 10);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 19 to 35
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf0) << 11);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 36 to 52
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xf8) << 12);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 53 to 69
	value = ((uint32_t)(input[6] & 0x07) << 29) |
			((uint32_t)input[7] << 21) |
			((uint32_t)(input[8] & 0xfc) << 13);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 70 to 86
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)(input[10] & 0xfe) << 14);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 87 to 103
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 104 to 120
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0x80) << 8);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 121 to 137
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xc0) << 9);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 3 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 88 to 104
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0x80) << 8);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 105 to 121
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xc0) << 9);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 122 to 138
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xe0) << 10);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 3 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 19
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf0) << 11);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 20 to 36
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xf8) << 12);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 37 to 53
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfc) << 13);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 54 to 70
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)(input[8] & 0xfe) << 14);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 71 to 87
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 88 to 104
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0x80) << 8);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 105 to 121
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xc0) << 9);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 122 to 138
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xe0) << 10);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 4 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 89 to 105
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xc0) << 9);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 106 to 122
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xe0) << 10);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 123 to 139
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xf0) << 11);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 4 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 20
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xf8) << 12);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 21 to 37
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfc) << 13);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 38 to 54
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)(input[6] & 0xfe) << 14);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 55 to 71
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 72 to 88
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0x80) << 8);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 89 to 105
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xc0) << 9);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 106 to 122
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xe0) << 10);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 123 to 139
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xf0) << 11);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 5 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 90 to 106
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xe0) << 10);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 107 to 123
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xf0) << 11);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 124 to 140
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)(input[17] & 0xf8) << 12);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 5 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 21
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfc) << 13);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 22 to 38
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)(input[4] & 0xfe) << 14);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 39 to 55
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 56 to 72
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0x80) << 8);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 73 to 89
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xc0) << 9);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 90 to 106
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xe0) << 10);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 107 to 123
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xf0) << 11);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 124 to 140
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)(input[17] & 0xf8) << 12);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 6 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 91 to 107
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf0) << 11);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 108 to 124
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xf8) << 12);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 125 to 141
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0xfc) << 13);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 6 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 22
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)(input[2] & 0xfe) << 14);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 23 to 39
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 40 to 56
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0x80) << 8);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 57 to 73
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xc0) << 9);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 74 to 90
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xe0) << 10);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 91 to 107
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf0) << 11);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 108 to 124
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xf8) << 12);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 125 to 141
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)(input[17] & 0xfc) << 13);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit signed
	// Skip 7 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 92 to 108
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xf8) << 12);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 109 to 125
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfc) << 13);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 126 to 142
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xfe) << 14);
	output[7] = (double)(value >> 15);
}

static void unpack_8_17bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 17-bit unsigned
	// Skip 7 bits, read 136 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 23
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15);
	output[0] = (double)(value >> 15);

	// read output[1]: from bit 24 to 40
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0x80) << 8);
	output[1] = (double)(value >> 15);

	// read output[2]: from bit 41 to 57
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xc0) << 9);
	output[2] = (double)(value >> 15);

	// read output[3]: from bit 58 to 74
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xe0) << 10);
	output[3] = (double)(value >> 15);

	// read output[4]: from bit 75 to 91
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf0) << 11);
	output[4] = (double)(value >> 15);

	// read output[5]: from bit 92 to 108
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xf8) << 12);
	output[5] = (double)(value >> 15);

	// read output[6]: from bit 109 to 125
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfc) << 13);
	output[6] = (double)(value >> 15);

	// read output[7]: from bit 126 to 142
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)(input[17] & 0xfe) << 14);
	output[7] = (double)(value >> 15);
}


unpack_func_t unpack_17bit[UNPACK_17BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_17bit_unsigned_0off,
			unpack_1_17bit_signed_0off,
		},
		{
			unpack_1_17bit_unsigned_1off,
			unpack_1_17bit_signed_1off,
		},
		{
			unpack_1_17bit_unsigned_2off,
			unpack_1_17bit_signed_2off,
		},
		{
			unpack_1_17bit_unsigned_3off,
			unpack_1_17bit_signed_3off,
		},
		{
			unpack_1_17bit_unsigned_4off,
			unpack_1_17bit_signed_4off,
		},
		{
			unpack_1_17bit_unsigned_5off,
			unpack_1_17bit_signed_5off,
		},
		{
			unpack_1_17bit_unsigned_6off,
			unpack_1_17bit_signed_6off,
		},
		{
			unpack_1_17bit_unsigned_7off,
			unpack_1_17bit_signed_7off,
		},
	},
	{
		{
			unpack_2_17bit_unsigned_0off,
			unpack_2_17bit_signed_0off,
		},
		{
			unpack_2_17bit_unsigned_1off,
			unpack_2_17bit_signed_1off,
		},
		{
			unpack_2_17bit_unsigned_2off,
			unpack_2_17bit_signed_2off,
		},
		{
			unpack_2_17bit_unsigned_3off,
			unpack_2_17bit_signed_3off,
		},
		{
			unpack_2_17bit_unsigned_4off,
			unpack_2_17bit_signed_4off,
		},
		{
			unpack_2_17bit_unsigned_5off,
			unpack_2_17bit_signed_5off,
		},
		{
			unpack_2_17bit_unsigned_6off,
			unpack_2_17bit_signed_6off,
		},
		{
			unpack_2_17bit_unsigned_7off,
			unpack_2_17bit_signed_7off,
		},
	},
	{
		{
			unpack_3_17bit_unsigned_0off,
			unpack_3_17bit_signed_0off,
		},
		{
			unpack_3_17bit_unsigned_1off,
			unpack_3_17bit_signed_1off,
		},
		{
			unpack_3_17bit_unsigned_2off,
			unpack_3_17bit_signed_2off,
		},
		{
			unpack_3_17bit_unsigned_3off,
			unpack_3_17bit_signed_3off,
		},
		{
			unpack_3_17bit_unsigned_4off,
			unpack_3_17bit_signed_4off,
		},
		{
			unpack_3_17bit_unsigned_5off,
			unpack_3_17bit_signed_5off,
		},
		{
			unpack_3_17bit_unsigned_6off,
			unpack_3_17bit_signed_6off,
		},
		{
			unpack_3_17bit_unsigned_7off,
			unpack_3_17bit_signed_7off,
		},
	},
	{
		{
			unpack_4_17bit_unsigned_0off,
			unpack_4_17bit_signed_0off,
		},
		{
			unpack_4_17bit_unsigned_1off,
			unpack_4_17bit_signed_1off,
		},
		{
			unpack_4_17bit_unsigned_2off,
			unpack_4_17bit_signed_2off,
		},
		{
			unpack_4_17bit_unsigned_3off,
			unpack_4_17bit_signed_3off,
		},
		{
			unpack_4_17bit_unsigned_4off,
			unpack_4_17bit_signed_4off,
		},
		{
			unpack_4_17bit_unsigned_5off,
			unpack_4_17bit_signed_5off,
		},
		{
			unpack_4_17bit_unsigned_6off,
			unpack_4_17bit_signed_6off,
		},
		{
			unpack_4_17bit_unsigned_7off,
			unpack_4_17bit_signed_7off,
		},
	},
	{
		{
			unpack_5_17bit_unsigned_0off,
			unpack_5_17bit_signed_0off,
		},
		{
			unpack_5_17bit_unsigned_1off,
			unpack_5_17bit_signed_1off,
		},
		{
			unpack_5_17bit_unsigned_2off,
			unpack_5_17bit_signed_2off,
		},
		{
			unpack_5_17bit_unsigned_3off,
			unpack_5_17bit_signed_3off,
		},
		{
			unpack_5_17bit_unsigned_4off,
			unpack_5_17bit_signed_4off,
		},
		{
			unpack_5_17bit_unsigned_5off,
			unpack_5_17bit_signed_5off,
		},
		{
			unpack_5_17bit_unsigned_6off,
			unpack_5_17bit_signed_6off,
		},
		{
			unpack_5_17bit_unsigned_7off,
			unpack_5_17bit_signed_7off,
		},
	},
	{
		{
			unpack_6_17bit_unsigned_0off,
			unpack_6_17bit_signed_0off,
		},
		{
			unpack_6_17bit_unsigned_1off,
			unpack_6_17bit_signed_1off,
		},
		{
			unpack_6_17bit_unsigned_2off,
			unpack_6_17bit_signed_2off,
		},
		{
			unpack_6_17bit_unsigned_3off,
			unpack_6_17bit_signed_3off,
		},
		{
			unpack_6_17bit_unsigned_4off,
			unpack_6_17bit_signed_4off,
		},
		{
			unpack_6_17bit_unsigned_5off,
			unpack_6_17bit_signed_5off,
		},
		{
			unpack_6_17bit_unsigned_6off,
			unpack_6_17bit_signed_6off,
		},
		{
			unpack_6_17bit_unsigned_7off,
			unpack_6_17bit_signed_7off,
		},
	},
	{
		{
			unpack_7_17bit_unsigned_0off,
			unpack_7_17bit_signed_0off,
		},
		{
			unpack_7_17bit_unsigned_1off,
			unpack_7_17bit_signed_1off,
		},
		{
			unpack_7_17bit_unsigned_2off,
			unpack_7_17bit_signed_2off,
		},
		{
			unpack_7_17bit_unsigned_3off,
			unpack_7_17bit_signed_3off,
		},
		{
			unpack_7_17bit_unsigned_4off,
			unpack_7_17bit_signed_4off,
		},
		{
			unpack_7_17bit_unsigned_5off,
			unpack_7_17bit_signed_5off,
		},
		{
			unpack_7_17bit_unsigned_6off,
			unpack_7_17bit_signed_6off,
		},
		{
			unpack_7_17bit_unsigned_7off,
			unpack_7_17bit_signed_7off,
		},
	},
	{
		{
			unpack_8_17bit_unsigned_0off,
			unpack_8_17bit_signed_0off,
		},
		{
			unpack_8_17bit_unsigned_1off,
			unpack_8_17bit_signed_1off,
		},
		{
			unpack_8_17bit_unsigned_2off,
			unpack_8_17bit_signed_2off,
		},
		{
			unpack_8_17bit_unsigned_3off,
			unpack_8_17bit_signed_3off,
		},
		{
			unpack_8_17bit_unsigned_4off,
			unpack_8_17bit_signed_4off,
		},
		{
			unpack_8_17bit_unsigned_5off,
			unpack_8_17bit_signed_5off,
		},
		{
			unpack_8_17bit_unsigned_6off,
			unpack_8_17bit_signed_6off,
		},
		{
			unpack_8_17bit_unsigned_7off,
			unpack_8_17bit_signed_7off,
		},
	},
};
