// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack18.h"



static void unpack_1_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 18 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 18 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);
}

static void unpack_1_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 18 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 36 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);
}

static void unpack_2_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 36 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 54 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);
}

static void unpack_3_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 54 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 72 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 72 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);
}

static void unpack_4_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 72 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 90 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);
}

static void unpack_5_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 90 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 108 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);
}

static void unpack_6_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 108 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);
}

static void unpack_7_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 144 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);
}

static void unpack_8_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 144 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 162 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 162 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);
}

static void unpack_9_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 162 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);
}

static void unpack_10_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);
}

static void unpack_11_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 216 bits of data.
	// Input must be at least 27 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);
}

static void unpack_12_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 216 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 234 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 234 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);
}

static void unpack_13_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 234 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 252 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);
}

static void unpack_14_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 252 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 270 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);
}

static void unpack_15_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 270 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 288 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);
}

static void unpack_16_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 288 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 306 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 306 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);
}

static void unpack_17_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 306 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 324 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 324 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 324 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 324 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 324 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 324 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);
}

static void unpack_18_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 324 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 342 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 342 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 342 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 342 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 342 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 342 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);
}

static void unpack_19_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 342 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);
}

static void unpack_20_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 360 to 377
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xc0) << 8);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 360 to 377
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xc0) << 8);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 361 to 378
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xe0) << 9);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 361 to 378
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xe0) << 9);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 362 to 379
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xf0) << 10);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 362 to 379
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xf0) << 10);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 363 to 380
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xf8) << 11);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 363 to 380
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xf8) << 11);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 364 to 381
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)(input[47] & 0xfc) << 12);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 364 to 381
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)(input[47] & 0xfc) << 12);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 365 to 382
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)(input[47] & 0xfe) << 13);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 365 to 382
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)(input[47] & 0xfe) << 13);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 366 to 383
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 378 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 366 to 383
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 378 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 367 to 384
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0x80) << 7);
	output[20] = (double)(value >> 14);
}

static void unpack_21_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 378 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 367 to 384
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0x80) << 7);
	output[20] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 360 to 377
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xc0) << 8);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 378 to 395
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)(input[49] & 0xf0) << 10);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 360 to 377
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xc0) << 8);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 378 to 395
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)(input[49] & 0xf0) << 10);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 361 to 378
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xe0) << 9);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 379 to 396
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)(input[49] & 0xf8) << 11);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 361 to 378
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xe0) << 9);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 379 to 396
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)(input[49] & 0xf8) << 11);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 362 to 379
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xf0) << 10);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 380 to 397
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)(input[49] & 0xfc) << 12);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 362 to 379
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xf0) << 10);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 380 to 397
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)(input[49] & 0xfc) << 12);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 363 to 380
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xf8) << 11);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 381 to 398
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)(input[49] & 0xfe) << 13);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 363 to 380
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xf8) << 11);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 381 to 398
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)(input[49] & 0xfe) << 13);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 364 to 381
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)(input[47] & 0xfc) << 12);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 382 to 399
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 364 to 381
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)(input[47] & 0xfc) << 12);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 382 to 399
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 365 to 382
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)(input[47] & 0xfe) << 13);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 383 to 400
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0x80) << 7);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 365 to 382
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)(input[47] & 0xfe) << 13);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 383 to 400
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0x80) << 7);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 366 to 383
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 384 to 401
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xc0) << 8);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 366 to 383
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 384 to 401
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xc0) << 8);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 367 to 384
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0x80) << 7);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 385 to 402
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xe0) << 9);
	output[21] = (double)(value >> 14);
}

static void unpack_22_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 367 to 384
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0x80) << 7);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 385 to 402
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xe0) << 9);
	output[21] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 414 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 360 to 377
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xc0) << 8);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 378 to 395
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)(input[49] & 0xf0) << 10);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 396 to 413
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)(input[51] & 0xfc) << 12);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 0 bits, read 414 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 360 to 377
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xc0) << 8);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 378 to 395
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)(input[49] & 0xf0) << 10);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 396 to 413
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)(input[51] & 0xfc) << 12);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 1 bits, read 414 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 361 to 378
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xe0) << 9);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 379 to 396
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)(input[49] & 0xf8) << 11);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 397 to 414
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)(input[51] & 0xfe) << 13);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 1 bits, read 414 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 18
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xe0) << 9);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 19 to 36
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xf8) << 11);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 37 to 54
	value = ((uint32_t)(input[4] & 0x07) << 29) |
			((uint32_t)input[5] << 21) |
			((uint32_t)(input[6] & 0xfe) << 13);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 55 to 72
	value = ((uint32_t)(input[6] & 0x01) << 31) |
			((uint32_t)input[7] << 23) |
			((uint32_t)input[8] << 15) |
			((uint32_t)(input[9] & 0x80) << 7);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 73 to 90
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xe0) << 9);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 91 to 108
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)(input[13] & 0xf8) << 11);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 109 to 126
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)(input[15] & 0xfe) << 13);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 127 to 144
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0x80) << 7);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 145 to 162
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xe0) << 9);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 163 to 180
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xf8) << 11);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 181 to 198
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)(input[24] & 0xfe) << 13);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 199 to 216
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0x80) << 7);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 217 to 234
	value = ((uint32_t)(input[27] & 0x7f) << 25) |
			((uint32_t)input[28] << 17) |
			((uint32_t)(input[29] & 0xe0) << 9);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 235 to 252
	value = ((uint32_t)(input[29] & 0x1f) << 27) |
			((uint32_t)input[30] << 19) |
			((uint32_t)(input[31] & 0xf8) << 11);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 253 to 270
	value = ((uint32_t)(input[31] & 0x07) << 29) |
			((uint32_t)input[32] << 21) |
			((uint32_t)(input[33] & 0xfe) << 13);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 271 to 288
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0x80) << 7);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 289 to 306
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xe0) << 9);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 307 to 324
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xf8) << 11);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 325 to 342
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)(input[42] & 0xfe) << 13);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 343 to 360
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0x80) << 7);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 361 to 378
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xe0) << 9);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 379 to 396
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)(input[49] & 0xf8) << 11);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 397 to 414
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)(input[51] & 0xfe) << 13);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 2 bits, read 414 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 362 to 379
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xf0) << 10);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 380 to 397
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)(input[49] & 0xfc) << 12);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 398 to 415
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 2 bits, read 414 bits of data.
	// Input must be at least 52 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 19
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf0) << 10);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 20 to 37
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfc) << 12);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 38 to 55
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 56 to 73
	value = ((uint32_t)input[7] << 24) |
			((uint32_t)input[8] << 16) |
			((uint32_t)(input[9] & 0xc0) << 8);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 74 to 91
	value = ((uint32_t)(input[9] & 0x3f) << 26) |
			((uint32_t)input[10] << 18) |
			((uint32_t)(input[11] & 0xf0) << 10);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 92 to 109
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)(input[13] & 0xfc) << 12);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 110 to 127
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 128 to 145
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xc0) << 8);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 146 to 163
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xf0) << 10);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 164 to 181
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)(input[22] & 0xfc) << 12);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 182 to 199
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 200 to 217
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xc0) << 8);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 218 to 235
	value = ((uint32_t)(input[27] & 0x3f) << 26) |
			((uint32_t)input[28] << 18) |
			((uint32_t)(input[29] & 0xf0) << 10);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 236 to 253
	value = ((uint32_t)(input[29] & 0x0f) << 28) |
			((uint32_t)input[30] << 20) |
			((uint32_t)(input[31] & 0xfc) << 12);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 254 to 271
	value = ((uint32_t)(input[31] & 0x03) << 30) |
			((uint32_t)input[32] << 22) |
			((uint32_t)input[33] << 14);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 272 to 289
	value = ((uint32_t)input[34] << 24) |
			((uint32_t)input[35] << 16) |
			((uint32_t)(input[36] & 0xc0) << 8);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 290 to 307
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)(input[38] & 0xf0) << 10);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 308 to 325
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)(input[40] & 0xfc) << 12);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 326 to 343
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 344 to 361
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xc0) << 8);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 362 to 379
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xf0) << 10);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 380 to 397
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)(input[49] & 0xfc) << 12);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 398 to 415
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 3 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 363 to 380
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xf8) << 11);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 381 to 398
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)(input[49] & 0xfe) << 13);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 399 to 416
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0x80) << 7);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 3 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 20
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xf8) << 11);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 21 to 38
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)(input[4] & 0xfe) << 13);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 39 to 56
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0x80) << 7);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 57 to 74
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xe0) << 9);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 75 to 92
	value = ((uint32_t)(input[9] & 0x1f) << 27) |
			((uint32_t)input[10] << 19) |
			((uint32_t)(input[11] & 0xf8) << 11);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 93 to 110
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)(input[13] & 0xfe) << 13);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 111 to 128
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0x80) << 7);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 129 to 146
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xe0) << 9);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 147 to 164
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xf8) << 11);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 165 to 182
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)(input[22] & 0xfe) << 13);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 183 to 200
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0x80) << 7);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 201 to 218
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xe0) << 9);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 219 to 236
	value = ((uint32_t)(input[27] & 0x1f) << 27) |
			((uint32_t)input[28] << 19) |
			((uint32_t)(input[29] & 0xf8) << 11);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 237 to 254
	value = ((uint32_t)(input[29] & 0x07) << 29) |
			((uint32_t)input[30] << 21) |
			((uint32_t)(input[31] & 0xfe) << 13);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 255 to 272
	value = ((uint32_t)(input[31] & 0x01) << 31) |
			((uint32_t)input[32] << 23) |
			((uint32_t)input[33] << 15) |
			((uint32_t)(input[34] & 0x80) << 7);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 273 to 290
	value = ((uint32_t)(input[34] & 0x7f) << 25) |
			((uint32_t)input[35] << 17) |
			((uint32_t)(input[36] & 0xe0) << 9);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 291 to 308
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)(input[38] & 0xf8) << 11);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 309 to 326
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)(input[40] & 0xfe) << 13);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 327 to 344
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0x80) << 7);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 345 to 362
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xe0) << 9);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 363 to 380
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xf8) << 11);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 381 to 398
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)(input[49] & 0xfe) << 13);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 399 to 416
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0x80) << 7);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 4 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 364 to 381
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)(input[47] & 0xfc) << 12);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 382 to 399
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 400 to 417
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xc0) << 8);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 4 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 21
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfc) << 12);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 22 to 39
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 40 to 57
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xc0) << 8);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 58 to 75
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf0) << 10);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 76 to 93
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfc) << 12);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 94 to 111
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 112 to 129
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xc0) << 8);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 130 to 147
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xf0) << 10);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 148 to 165
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)(input[20] & 0xfc) << 12);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 166 to 183
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 184 to 201
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xc0) << 8);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 202 to 219
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xf0) << 10);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 220 to 237
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)(input[29] & 0xfc) << 12);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 238 to 255
	value = ((uint32_t)(input[29] & 0x03) << 30) |
			((uint32_t)input[30] << 22) |
			((uint32_t)input[31] << 14);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 256 to 273
	value = ((uint32_t)input[32] << 24) |
			((uint32_t)input[33] << 16) |
			((uint32_t)(input[34] & 0xc0) << 8);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 274 to 291
	value = ((uint32_t)(input[34] & 0x3f) << 26) |
			((uint32_t)input[35] << 18) |
			((uint32_t)(input[36] & 0xf0) << 10);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 292 to 309
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)(input[38] & 0xfc) << 12);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 310 to 327
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 328 to 345
	value = ((uint32_t)input[41] << 24) |
			((uint32_t)input[42] << 16) |
			((uint32_t)(input[43] & 0xc0) << 8);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 346 to 363
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xf0) << 10);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 364 to 381
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)(input[47] & 0xfc) << 12);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 382 to 399
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 400 to 417
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xc0) << 8);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 5 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 365 to 382
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)(input[47] & 0xfe) << 13);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 383 to 400
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0x80) << 7);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 401 to 418
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xe0) << 9);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 5 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 22
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)(input[2] & 0xfe) << 13);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 23 to 40
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0x80) << 7);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 41 to 58
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xe0) << 9);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 59 to 76
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xf8) << 11);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 77 to 94
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)(input[11] & 0xfe) << 13);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 95 to 112
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0x80) << 7);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 113 to 130
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xe0) << 9);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 131 to 148
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)(input[18] & 0xf8) << 11);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 149 to 166
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)(input[20] & 0xfe) << 13);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 167 to 184
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0x80) << 7);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 185 to 202
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xe0) << 9);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 203 to 220
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xf8) << 11);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 221 to 238
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)(input[29] & 0xfe) << 13);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 239 to 256
	value = ((uint32_t)(input[29] & 0x01) << 31) |
			((uint32_t)input[30] << 23) |
			((uint32_t)input[31] << 15) |
			((uint32_t)(input[32] & 0x80) << 7);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 257 to 274
	value = ((uint32_t)(input[32] & 0x7f) << 25) |
			((uint32_t)input[33] << 17) |
			((uint32_t)(input[34] & 0xe0) << 9);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 275 to 292
	value = ((uint32_t)(input[34] & 0x1f) << 27) |
			((uint32_t)input[35] << 19) |
			((uint32_t)(input[36] & 0xf8) << 11);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 293 to 310
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)(input[38] & 0xfe) << 13);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 311 to 328
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0x80) << 7);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 329 to 346
	value = ((uint32_t)(input[41] & 0x7f) << 25) |
			((uint32_t)input[42] << 17) |
			((uint32_t)(input[43] & 0xe0) << 9);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 347 to 364
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xf8) << 11);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 365 to 382
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)(input[47] & 0xfe) << 13);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 383 to 400
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0x80) << 7);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 401 to 418
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xe0) << 9);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 6 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 366 to 383
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 384 to 401
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xc0) << 8);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 402 to 419
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xf0) << 10);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 6 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 23
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 24 to 41
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xc0) << 8);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 42 to 59
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf0) << 10);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 60 to 77
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfc) << 12);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 78 to 95
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 96 to 113
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xc0) << 8);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 114 to 131
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf0) << 10);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 132 to 149
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)(input[18] & 0xfc) << 12);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 150 to 167
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 168 to 185
	value = ((uint32_t)input[21] << 24) |
			((uint32_t)input[22] << 16) |
			((uint32_t)(input[23] & 0xc0) << 8);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 186 to 203
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xf0) << 10);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 204 to 221
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)(input[27] & 0xfc) << 12);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 222 to 239
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 240 to 257
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xc0) << 8);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 258 to 275
	value = ((uint32_t)(input[32] & 0x3f) << 26) |
			((uint32_t)input[33] << 18) |
			((uint32_t)(input[34] & 0xf0) << 10);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 276 to 293
	value = ((uint32_t)(input[34] & 0x0f) << 28) |
			((uint32_t)input[35] << 20) |
			((uint32_t)(input[36] & 0xfc) << 12);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 294 to 311
	value = ((uint32_t)(input[36] & 0x03) << 30) |
			((uint32_t)input[37] << 22) |
			((uint32_t)input[38] << 14);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 312 to 329
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xc0) << 8);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 330 to 347
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)(input[43] & 0xf0) << 10);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 348 to 365
	value = ((uint32_t)(input[43] & 0x0f) << 28) |
			((uint32_t)input[44] << 20) |
			((uint32_t)(input[45] & 0xfc) << 12);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 366 to 383
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 384 to 401
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xc0) << 8);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 402 to 419
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xf0) << 10);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit signed
	// Skip 7 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 367 to 384
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0x80) << 7);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 385 to 402
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xe0) << 9);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 403 to 420
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xf8) << 11);
	output[22] = (double)(value >> 14);
}

static void unpack_23_18bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 18-bit unsigned
	// Skip 7 bits, read 414 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 24
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0x80) << 7);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 25 to 42
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xe0) << 9);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 43 to 60
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xf8) << 11);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 61 to 78
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)(input[9] & 0xfe) << 13);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 79 to 96
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0x80) << 7);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 97 to 114
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xe0) << 9);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 115 to 132
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xf8) << 11);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 133 to 150
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)(input[18] & 0xfe) << 13);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 151 to 168
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0x80) << 7);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 169 to 186
	value = ((uint32_t)(input[21] & 0x7f) << 25) |
			((uint32_t)input[22] << 17) |
			((uint32_t)(input[23] & 0xe0) << 9);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 187 to 204
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xf8) << 11);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 205 to 222
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)(input[27] & 0xfe) << 13);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 223 to 240
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0x80) << 7);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 241 to 258
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xe0) << 9);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 259 to 276
	value = ((uint32_t)(input[32] & 0x1f) << 27) |
			((uint32_t)input[33] << 19) |
			((uint32_t)(input[34] & 0xf8) << 11);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 277 to 294
	value = ((uint32_t)(input[34] & 0x07) << 29) |
			((uint32_t)input[35] << 21) |
			((uint32_t)(input[36] & 0xfe) << 13);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 295 to 312
	value = ((uint32_t)(input[36] & 0x01) << 31) |
			((uint32_t)input[37] << 23) |
			((uint32_t)input[38] << 15) |
			((uint32_t)(input[39] & 0x80) << 7);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 313 to 330
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xe0) << 9);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 331 to 348
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)(input[43] & 0xf8) << 11);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 349 to 366
	value = ((uint32_t)(input[43] & 0x07) << 29) |
			((uint32_t)input[44] << 21) |
			((uint32_t)(input[45] & 0xfe) << 13);
	output[19] = (double)(value >> 14);

	// read output[20]: from bit 367 to 384
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0x80) << 7);
	output[20] = (double)(value >> 14);

	// read output[21]: from bit 385 to 402
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xe0) << 9);
	output[21] = (double)(value >> 14);

	// read output[22]: from bit 403 to 420
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xf8) << 11);
	output[22] = (double)(value >> 14);
}

static void unpack_24_18bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 24 values into output
	// Values are 18-bit signed
	// Skip 0 bits, read 432 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 17
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xc0) << 8);
	output[0] = (double)(value >> 14);

	// read output[1]: from bit 18 to 35
	value = ((uint32_t)(input[2] & 0x3f) << 26) |
			((uint32_t)input[3] << 18) |
			((uint32_t)(input[4] & 0xf0) << 10);
	output[1] = (double)(value >> 14);

	// read output[2]: from bit 36 to 53
	value = ((uint32_t)(input[4] & 0x0f) << 28) |
			((uint32_t)input[5] << 20) |
			((uint32_t)(input[6] & 0xfc) << 12);
	output[2] = (double)(value >> 14);

	// read output[3]: from bit 54 to 71
	value = ((uint32_t)(input[6] & 0x03) << 30) |
			((uint32_t)input[7] << 22) |
			((uint32_t)input[8] << 14);
	output[3] = (double)(value >> 14);

	// read output[4]: from bit 72 to 89
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xc0) << 8);
	output[4] = (double)(value >> 14);

	// read output[5]: from bit 90 to 107
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xf0) << 10);
	output[5] = (double)(value >> 14);

	// read output[6]: from bit 108 to 125
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)(input[15] & 0xfc) << 12);
	output[6] = (double)(value >> 14);

	// read output[7]: from bit 126 to 143
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14);
	output[7] = (double)(value >> 14);

	// read output[8]: from bit 144 to 161
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xc0) << 8);
	output[8] = (double)(value >> 14);

	// read output[9]: from bit 162 to 179
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xf0) << 10);
	output[9] = (double)(value >> 14);

	// read output[10]: from bit 180 to 197
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)(input[24] & 0xfc) << 12);
	output[10] = (double)(value >> 14);

	// read output[11]: from bit 198 to 215
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14);
	output[11] = (double)(value >> 14);

	// read output[12]: from bit 216 to 233
	value = ((uint32_t)input[27] << 24) |
			((uint32_t)input[28] << 16) |
			((uint32_t)(input[29] & 0xc0) << 8);
	output[12] = (double)(value >> 14);

	// read output[13]: from bit 234 to 251
	value = ((uint32_t)(input[29] & 0x3f) << 26) |
			((uint32_t)input[30] << 18) |
			((uint32_t)(input[31] & 0xf0) << 10);
	output[13] = (double)(value >> 14);

	// read output[14]: from bit 252 to 269
	value = ((uint32_t)(input[31] & 0x0f) << 28) |
			((uint32_t)input[32] << 20) |
			((uint32_t)(input[33] & 0xfc) << 12);
	output[14] = (double)(value >> 14);

	// read output[15]: from bit 270 to 287
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14);
	output[15] = (double)(value >> 14);

	// read output[16]: from bit 288 to 305
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xc0) << 8);
	output[16] = (double)(value >> 14);

	// read output[17]: from bit 306 to 323
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xf0) << 10);
	output[17] = (double)(value >> 14);

	// read output[18]: from bit 324 to 341
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)(input[42] & 0xfc) << 12);
	output[18] = (double)(value >> 14);

	// read output[19]: from bit 342 to 359
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input