// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack19.h"



static void unpack_1_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 19 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 19 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 19 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 19 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);
}

static void unpack_1_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 19 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 38 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 38 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 38 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 38 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 38 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 38 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);
}

static void unpack_2_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 38 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);
}

static void unpack_3_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 57 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 76 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 76 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 76 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 76 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 76 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 76 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);
}

static void unpack_4_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 76 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 95 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 95 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 95 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 95 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);
}

static void unpack_5_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 95 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 95 to 113
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xc0) << 7);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 95 to 113
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xc0) << 7);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 96 to 114
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xe0) << 8);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 96 to 114
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xe0) << 8);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 97 to 115
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xf0) << 9);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 97 to 115
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xf0) << 9);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 98 to 116
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xf8) << 10);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 98 to 116
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xf8) << 10);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 99 to 117
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xfc) << 11);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 99 to 117
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xfc) << 11);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 100 to 118
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xfe) << 12);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 100 to 118
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xfe) << 12);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 101 to 119
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 114 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 101 to 119
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 114 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 102 to 120
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0x80) << 6);
	output[5] = (double)(value >> 13);
}

static void unpack_6_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 114 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 102 to 120
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0x80) << 6);
	output[5] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 95 to 113
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xc0) << 7);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 114 to 132
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf8) << 10);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 95 to 113
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xc0) << 7);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 114 to 132
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf8) << 10);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 96 to 114
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xe0) << 8);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 115 to 133
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xfc) << 11);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 96 to 114
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xe0) << 8);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 115 to 133
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xfc) << 11);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 97 to 115
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xf0) << 9);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 116 to 134
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xfe) << 12);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 97 to 115
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xf0) << 9);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 116 to 134
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xfe) << 12);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 98 to 116
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xf8) << 10);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 117 to 135
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 133 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 98 to 116
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xf8) << 10);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 117 to 135
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 99 to 117
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xfc) << 11);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 118 to 136
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0x80) << 6);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 99 to 117
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xfc) << 11);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 118 to 136
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0x80) << 6);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 100 to 118
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xfe) << 12);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 119 to 137
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xc0) << 7);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 100 to 118
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xfe) << 12);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 119 to 137
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xc0) << 7);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 101 to 119
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 120 to 138
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xe0) << 8);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 101 to 119
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 120 to 138
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xe0) << 8);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 102 to 120
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0x80) << 6);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 121 to 139
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf0) << 9);
	output[6] = (double)(value >> 13);
}

static void unpack_7_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 133 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 102 to 120
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0x80) << 6);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 121 to 139
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf0) << 9);
	output[6] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 0 bits, read 152 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 95 to 113
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xc0) << 7);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 114 to 132
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf8) << 10);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 133 to 151
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 0 bits, read 152 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 18
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xe0) << 8);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 19 to 37
	value = ((uint32_t)(input[2] & 0x1f) << 27) |
			((uint32_t)input[3] << 19) |
			((uint32_t)(input[4] & 0xfc) << 11);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 38 to 56
	value = ((uint32_t)(input[4] & 0x03) << 30) |
			((uint32_t)input[5] << 22) |
			((uint32_t)input[6] << 14) |
			((uint32_t)(input[7] & 0x80) << 6);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 57 to 75
	value = ((uint32_t)(input[7] & 0x7f) << 25) |
			((uint32_t)input[8] << 17) |
			((uint32_t)(input[9] & 0xf0) << 9);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 76 to 94
	value = ((uint32_t)(input[9] & 0x0f) << 28) |
			((uint32_t)input[10] << 20) |
			((uint32_t)(input[11] & 0xfe) << 12);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 95 to 113
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xc0) << 7);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 114 to 132
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)(input[16] & 0xf8) << 10);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 133 to 151
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 1 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 96 to 114
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xe0) << 8);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 115 to 133
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xfc) << 11);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 134 to 152
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0x80) << 6);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 1 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 19
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf0) << 9);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 20 to 38
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)(input[4] & 0xfe) << 12);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 39 to 57
	value = ((uint32_t)(input[4] & 0x01) << 31) |
			((uint32_t)input[5] << 23) |
			((uint32_t)input[6] << 15) |
			((uint32_t)(input[7] & 0xc0) << 7);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 58 to 76
	value = ((uint32_t)(input[7] & 0x3f) << 26) |
			((uint32_t)input[8] << 18) |
			((uint32_t)(input[9] & 0xf8) << 10);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 77 to 95
	value = ((uint32_t)(input[9] & 0x07) << 29) |
			((uint32_t)input[10] << 21) |
			((uint32_t)input[11] << 13);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 96 to 114
	value = ((uint32_t)input[12] << 24) |
			((uint32_t)input[13] << 16) |
			((uint32_t)(input[14] & 0xe0) << 8);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 115 to 133
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)(input[16] & 0xfc) << 11);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 134 to 152
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0x80) << 6);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 2 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 97 to 115
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xf0) << 9);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 116 to 134
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xfe) << 12);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 135 to 153
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xc0) << 7);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 2 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 20
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xf8) << 10);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 21 to 39
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 40 to 58
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xe0) << 8);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 59 to 77
	value = ((uint32_t)(input[7] & 0x1f) << 27) |
			((uint32_t)input[8] << 19) |
			((uint32_t)(input[9] & 0xfc) << 11);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 78 to 96
	value = ((uint32_t)(input[9] & 0x03) << 30) |
			((uint32_t)input[10] << 22) |
			((uint32_t)input[11] << 14) |
			((uint32_t)(input[12] & 0x80) << 6);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 97 to 115
	value = ((uint32_t)(input[12] & 0x7f) << 25) |
			((uint32_t)input[13] << 17) |
			((uint32_t)(input[14] & 0xf0) << 9);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 116 to 134
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)(input[16] & 0xfe) << 12);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 135 to 153
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xc0) << 7);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 3 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 98 to 116
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xf8) << 10);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 117 to 135
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 136 to 154
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xe0) << 8);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 3 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 21
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfc) << 11);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 22 to 40
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0x80) << 6);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 41 to 59
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf0) << 9);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 60 to 78
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)(input[9] & 0xfe) << 12);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 79 to 97
	value = ((uint32_t)(input[9] & 0x01) << 31) |
			((uint32_t)input[10] << 23) |
			((uint32_t)input[11] << 15) |
			((uint32_t)(input[12] & 0xc0) << 7);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 98 to 116
	value = ((uint32_t)(input[12] & 0x3f) << 26) |
			((uint32_t)input[13] << 18) |
			((uint32_t)(input[14] & 0xf8) << 10);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 117 to 135
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 136 to 154
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xe0) << 8);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 4 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 99 to 117
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xfc) << 11);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 118 to 136
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0x80) << 6);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 137 to 155
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xf0) << 9);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 4 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 22
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)(input[2] & 0xfe) << 12);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 23 to 41
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xc0) << 7);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 42 to 60
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xf8) << 10);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 61 to 79
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 80 to 98
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xe0) << 8);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 99 to 117
	value = ((uint32_t)(input[12] & 0x1f) << 27) |
			((uint32_t)input[13] << 19) |
			((uint32_t)(input[14] & 0xfc) << 11);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 118 to 136
	value = ((uint32_t)(input[14] & 0x03) << 30) |
			((uint32_t)input[15] << 22) |
			((uint32_t)input[16] << 14) |
			((uint32_t)(input[17] & 0x80) << 6);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 137 to 155
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xf0) << 9);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 5 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 100 to 118
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xfe) << 12);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 119 to 137
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xc0) << 7);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 138 to 156
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)(input[19] & 0xf8) << 10);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 5 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 23
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 24 to 42
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xe0) << 8);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 43 to 61
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfc) << 11);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 62 to 80
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0x80) << 6);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 81 to 99
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf0) << 9);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 100 to 118
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)(input[14] & 0xfe) << 12);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 119 to 137
	value = ((uint32_t)(input[14] & 0x01) << 31) |
			((uint32_t)input[15] << 23) |
			((uint32_t)input[16] << 15) |
			((uint32_t)(input[17] & 0xc0) << 7);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 138 to 156
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)(input[19] & 0xf8) << 10);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 6 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 101 to 119
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 120 to 138
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xe0) << 8);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 139 to 157
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)(input[19] & 0xfc) << 11);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 6 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 24
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0x80) << 6);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 25 to 43
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf0) << 9);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 44 to 62
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)(input[7] & 0xfe) << 12);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 63 to 81
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xc0) << 7);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 82 to 100
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xf8) << 10);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 101 to 119
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 120 to 138
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xe0) << 8);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 139 to 157
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)(input[19] & 0xfc) << 11);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit signed
	// Skip 7 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 102 to 120
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0x80) << 6);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 121 to 139
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf0) << 9);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 140 to 158
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xfe) << 12);
	output[7] = (double)(value >> 13);
}

static void unpack_8_19bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 19-bit unsigned
	// Skip 7 bits, read 152 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 25
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xc0) << 7);
	output[0] = (double)(value >> 13);

	// read output[1]: from bit 26 to 44
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xf8) << 10);
	output[1] = (double)(value >> 13);

	// read output[2]: from bit 45 to 63
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13);
	output[2] = (double)(value >> 13);

	// read output[3]: from bit 64 to 82
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xe0) << 8);
	output[3] = (double)(value >> 13);

	// read output[4]: from bit 83 to 101
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfc) << 11);
	output[4] = (double)(value >> 13);

	// read output[5]: from bit 102 to 120
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0x80) << 6);
	output[5] = (double)(value >> 13);

	// read output[6]: from bit 121 to 139
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf0) << 9);
	output[6] = (double)(value >> 13);

	// read output[7]: from bit 140 to 158
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)(input[19] & 0xfe) << 12);
	output[7] = (double)(value >> 13);
}


unpack_func_t unpack_19bit[UNPACK_19BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_19bit_unsigned_0off,
			unpack_1_19bit_signed_0off,
		},
		{
			unpack_1_19bit_unsigned_1off,
			unpack_1_19bit_signed_1off,
		},
		{
			unpack_1_19bit_unsigned_2off,
			unpack_1_19bit_signed_2off,
		},
		{
			unpack_1_19bit_unsigned_3off,
			unpack_1_19bit_signed_3off,
		},
		{
			unpack_1_19bit_unsigned_4off,
			unpack_1_19bit_signed_4off,
		},
		{
			unpack_1_19bit_unsigned_5off,
			unpack_1_19bit_signed_5off,
		},
		{
			unpack_1_19bit_unsigned_6off,
			unpack_1_19bit_signed_6off,
		},
		{
			unpack_1_19bit_unsigned_7off,
			unpack_1_19bit_signed_7off,
		},
	},
	{
		{
			unpack_2_19bit_unsigned_0off,
			unpack_2_19bit_signed_0off,
		},
		{
			unpack_2_19bit_unsigned_1off,
			unpack_2_19bit_signed_1off,
		},
		{
			unpack_2_19bit_unsigned_2off,
			unpack_2_19bit_signed_2off,
		},
		{
			unpack_2_19bit_unsigned_3off,
			unpack_2_19bit_signed_3off,
		},
		{
			unpack_2_19bit_unsigned_4off,
			unpack_2_19bit_signed_4off,
		},
		{
			unpack_2_19bit_unsigned_5off,
			unpack_2_19bit_signed_5off,
		},
		{
			unpack_2_19bit_unsigned_6off,
			unpack_2_19bit_signed_6off,
		},
		{
			unpack_2_19bit_unsigned_7off,
			unpack_2_19bit_signed_7off,
		},
	},
	{
		{
			unpack_3_19bit_unsigned_0off,
			unpack_3_19bit_signed_0off,
		},
		{
			unpack_3_19bit_unsigned_1off,
			unpack_3_19bit_signed_1off,
		},
		{
			unpack_3_19bit_unsigned_2off,
			unpack_3_19bit_signed_2off,
		},
		{
			unpack_3_19bit_unsigned_3off,
			unpack_3_19bit_signed_3off,
		},
		{
			unpack_3_19bit_unsigned_4off,
			unpack_3_19bit_signed_4off,
		},
		{
			unpack_3_19bit_unsigned_5off,
			unpack_3_19bit_signed_5off,
		},
		{
			unpack_3_19bit_unsigned_6off,
			unpack_3_19bit_signed_6off,
		},
		{
			unpack_3_19bit_unsigned_7off,
			unpack_3_19bit_signed_7off,
		},
	},
	{
		{
			unpack_4_19bit_unsigned_0off,
			unpack_4_19bit_signed_0off,
		},
		{
			unpack_4_19bit_unsigned_1off,
			unpack_4_19bit_signed_1off,
		},
		{
			unpack_4_19bit_unsigned_2off,
			unpack_4_19bit_signed_2off,
		},
		{
			unpack_4_19bit_unsigned_3off,
			unpack_4_19bit_signed_3off,
		},
		{
			unpack_4_19bit_unsigned_4off,
			unpack_4_19bit_signed_4off,
		},
		{
			unpack_4_19bit_unsigned_5off,
			unpack_4_19bit_signed_5off,
		},
		{
			unpack_4_19bit_unsigned_6off,
			unpack_4_19bit_signed_6off,
		},
		{
			unpack_4_19bit_unsigned_7off,
			unpack_4_19bit_signed_7off,
		},
	},
	{
		{
			unpack_5_19bit_unsigned_0off,
			unpack_5_19bit_signed_0off,
		},
		{
			unpack_5_19bit_unsigned_1off,
			unpack_5_19bit_signed_1off,
		},
		{
			unpack_5_19bit_unsigned_2off,
			unpack_5_19bit_signed_2off,
		},
		{
			unpack_5_19bit_unsigned_3off,
			unpack_5_19bit_signed_3off,
		},
		{
			unpack_5_19bit_unsigned_4off,
			unpack_5_19bit_signed_4off,
		},
		{
			unpack_5_19bit_unsigned_5off,
			unpack_5_19bit_signed_5off,
		},
		{
			unpack_5_19bit_unsigned_6off,
			unpack_5_19bit_signed_6off,
		},
		{
			unpack_5_19bit_unsigned_7off,
			unpack_5_19bit_signed_7off,
		},
	},
	{
		{
			unpack_6_19bit_unsigned_0off,
			unpack_6_19bit_signed_0off,
		},
		{
			unpack_6_19bit_unsigned_1off,
			unpack_6_19bit_signed_1off,
		},
		{
			unpack_6_19bit_unsigned_2off,
			unpack_6_19bit_signed_2off,
		},
		{
			unpack_6_19bit_unsigned_3off,
			unpack_6_19bit_signed_3off,
		},
		{
			unpack_6_19bit_unsigned_4off,
			unpack_6_19bit_signed_4off,
		},
		{
			unpack_6_19bit_unsigned_5off,
			unpack_6_19bit_signed_5off,
		},
		{
			unpack_6_19bit_unsigned_6off,
			unpack_6_19bit_signed_6off,
		},
		{
			unpack_6_19bit_unsigned_7off,
			unpack_6_19bit_signed_7off,
		},
	},
	{
		{
			unpack_7_19bit_unsigned_0off,
			unpack_7_19bit_signed_0off,
		},
		{
			unpack_7_19bit_unsigned_1off,
			unpack_7_19bit_signed_1off,
		},
		{
			unpack_7_19bit_unsigned_2off,
			unpack_7_19bit_signed_2off,
		},
		{
			unpack_7_19bit_unsigned_3off,
			unpack_7_19bit_signed_3off,
		},
		{
			unpack_7_19bit_unsigned_4off,
			unpack_7_19bit_signed_4off,
		},
		{
			unpack_7_19bit_unsigned_5off,
			unpack_7_19bit_signed_5off,
		},
		{
			unpack_7_19bit_unsigned_6off,
			unpack_7_19bit_signed_6off,
		},
		{
			unpack_7_19bit_unsigned_7off,
			unpack_7_19bit_signed_7off,
		},
	},
	{
		{
			unpack_8_19bit_unsigned_0off,
			unpack_8_19bit_signed_0off,
		},
		{
			unpack_8_19bit_unsigned_1off,
			unpack_8_19bit_signed_1off,
		},
		{
			unpack_8_19bit_unsigned_2off,
			unpack_8_19bit_signed_2off,
		},
		{
			unpack_8_19bit_unsigned_3off,
			unpack_8_19bit_signed_3off,
		},
		{
			unpack_8_19bit_unsigned_4off,
			unpack_8_19bit_signed_4off,
		},
		{
			unpack_8_19bit_unsigned_5off,
			unpack_8_19bit_signed_5off,
		},
		{
			unpack_8_19bit_unsigned_6off,
			unpack_8_19bit_signed_6off,
		},
		{
			unpack_8_19bit_unsigned_7off,
			unpack_8_19bit_signed_7off,
		},
	},
};
