// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack20.h"



static void unpack_1_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 20 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);
}

static void unpack_1_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 20 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 40 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 40 bits of data.
	// Input must be at least 5 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);
}

static void unpack_2_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 40 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 60 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);
}

static void unpack_3_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 60 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 80 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 80 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);
}

static void unpack_4_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 80 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 100 bits of data.
	// Input must be at least 13 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);
}

static void unpack_5_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 100 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 120 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);
}

static void unpack_6_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 120 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 140 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);
}

static void unpack_7_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 140 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 160 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);
}

static void unpack_8_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 160 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 180 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);
}

static void unpack_9_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 180 bits of data.
	// Input must be at least 24 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 200 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 200 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);
}

static void unpack_10_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 200 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);
}

static void unpack_11_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 240 bits of data.
	// Input must be at least 30 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);
}

static void unpack_12_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 240 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 260 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);
}

static void unpack_13_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 260 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 280 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 280 bits of data.
	// Input must be at least 35 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);
}

static void unpack_14_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 280 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 300 bits of data.
	// Input must be at least 38 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);
}

static void unpack_15_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 300 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 320 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 320 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);
}

static void unpack_16_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 320 bits of data.
	// Input must be at least 41 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 340 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 340 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 340 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 340 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 340 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 340 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);
}

static void unpack_17_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 340 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 360 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);
}

static void unpack_18_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 360 bits of data.
	// Input must be at least 46 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 380 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 380 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 380 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 380 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 380 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 380 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);
}

static void unpack_19_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 380 bits of data.
	// Input must be at least 49 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 400 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 400 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 385 to 404
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xf8) << 9);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 385 to 404
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xf8) << 9);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 386 to 405
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)(input[50] & 0xfc) << 10);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 386 to 405
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)(input[50] & 0xfc) << 10);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 387 to 406
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)(input[50] & 0xfe) << 11);
	output[19] = (double)(value >> 12);
}

static void unpack_20_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 400 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 387 to 406
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)(input[50] & 0xfe) << 11);
	output[19] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 400 to 419
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xf0) << 8);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 400 to 419
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xf0) << 8);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 401 to 420
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xf8) << 9);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 401 to 420
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xf8) << 9);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 402 to 421
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xfc) << 10);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 402 to 421
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xfc) << 10);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 403 to 422
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xfe) << 11);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 403 to 422
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xfe) << 11);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 404 to 423
	value = ((uint32_t)(input[50] & 0x0f) << 28) |
			((uint32_t)input[51] << 20) |
			((uint32_t)input[52] << 12);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 420 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 404 to 423
	value = ((uint32_t)(input[50] & 0x0f) << 28) |
			((uint32_t)input[51] << 20) |
			((uint32_t)input[52] << 12);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 385 to 404
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xf8) << 9);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 405 to 424
	value = ((uint32_t)(input[50] & 0x07) << 29) |
			((uint32_t)input[51] << 21) |
			((uint32_t)input[52] << 13) |
			((uint32_t)(input[53] & 0x80) << 5);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 385 to 404
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xf8) << 9);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 405 to 424
	value = ((uint32_t)(input[50] & 0x07) << 29) |
			((uint32_t)input[51] << 21) |
			((uint32_t)input[52] << 13) |
			((uint32_t)(input[53] & 0x80) << 5);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 386 to 405
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)(input[50] & 0xfc) << 10);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 406 to 425
	value = ((uint32_t)(input[50] & 0x03) << 30) |
			((uint32_t)input[51] << 22) |
			((uint32_t)input[52] << 14) |
			((uint32_t)(input[53] & 0xc0) << 6);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 386 to 405
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)(input[50] & 0xfc) << 10);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 406 to 425
	value = ((uint32_t)(input[50] & 0x03) << 30) |
			((uint32_t)input[51] << 22) |
			((uint32_t)input[52] << 14) |
			((uint32_t)(input[53] & 0xc0) << 6);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 387 to 406
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)(input[50] & 0xfe) << 11);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 407 to 426
	value = ((uint32_t)(input[50] & 0x01) << 31) |
			((uint32_t)input[51] << 23) |
			((uint32_t)input[52] << 15) |
			((uint32_t)(input[53] & 0xe0) << 7);
	output[20] = (double)(value >> 12);
}

static void unpack_21_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 420 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 387 to 406
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)(input[50] & 0xfe) << 11);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 407 to 426
	value = ((uint32_t)(input[50] & 0x01) << 31) |
			((uint32_t)input[51] << 23) |
			((uint32_t)input[52] << 15) |
			((uint32_t)(input[53] & 0xe0) << 7);
	output[20] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 440 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 400 to 419
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xf0) << 8);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 420 to 439
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 440 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 400 to 419
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xf0) << 8);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 420 to 439
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 401 to 420
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xf8) << 9);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 421 to 440
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0x80) << 5);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 401 to 420
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xf8) << 9);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 421 to 440
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0x80) << 5);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 402 to 421
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xfc) << 10);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 422 to 441
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xc0) << 6);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 402 to 421
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xfc) << 10);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 422 to 441
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xc0) << 6);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 403 to 422
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xfe) << 11);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 423 to 442
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xe0) << 7);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 403 to 422
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xfe) << 11);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 423 to 442
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xe0) << 7);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 404 to 423
	value = ((uint32_t)(input[50] & 0x0f) << 28) |
			((uint32_t)input[51] << 20) |
			((uint32_t)input[52] << 12);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 424 to 443
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xf0) << 8);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 404 to 423
	value = ((uint32_t)(input[50] & 0x0f) << 28) |
			((uint32_t)input[51] << 20) |
			((uint32_t)input[52] << 12);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 424 to 443
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xf0) << 8);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 5 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 385 to 404
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xf8) << 9);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 405 to 424
	value = ((uint32_t)(input[50] & 0x07) << 29) |
			((uint32_t)input[51] << 21) |
			((uint32_t)input[52] << 13) |
			((uint32_t)(input[53] & 0x80) << 5);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 425 to 444
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xf8) << 9);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 5 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 24
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0x80) << 5);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 25 to 44
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xf8) << 9);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 45 to 64
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0x80) << 5);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 65 to 84
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xf8) << 9);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 85 to 104
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0x80) << 5);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 105 to 124
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xf8) << 9);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 125 to 144
	value = ((uint32_t)(input[15] & 0x07) << 29) |
			((uint32_t)input[16] << 21) |
			((uint32_t)input[17] << 13) |
			((uint32_t)(input[18] & 0x80) << 5);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 145 to 164
	value = ((uint32_t)(input[18] & 0x7f) << 25) |
			((uint32_t)input[19] << 17) |
			((uint32_t)(input[20] & 0xf8) << 9);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 165 to 184
	value = ((uint32_t)(input[20] & 0x07) << 29) |
			((uint32_t)input[21] << 21) |
			((uint32_t)input[22] << 13) |
			((uint32_t)(input[23] & 0x80) << 5);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 185 to 204
	value = ((uint32_t)(input[23] & 0x7f) << 25) |
			((uint32_t)input[24] << 17) |
			((uint32_t)(input[25] & 0xf8) << 9);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 205 to 224
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0x80) << 5);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 225 to 244
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xf8) << 9);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 245 to 264
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0x80) << 5);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 265 to 284
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xf8) << 9);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 285 to 304
	value = ((uint32_t)(input[35] & 0x07) << 29) |
			((uint32_t)input[36] << 21) |
			((uint32_t)input[37] << 13) |
			((uint32_t)(input[38] & 0x80) << 5);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 305 to 324
	value = ((uint32_t)(input[38] & 0x7f) << 25) |
			((uint32_t)input[39] << 17) |
			((uint32_t)(input[40] & 0xf8) << 9);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 325 to 344
	value = ((uint32_t)(input[40] & 0x07) << 29) |
			((uint32_t)input[41] << 21) |
			((uint32_t)input[42] << 13) |
			((uint32_t)(input[43] & 0x80) << 5);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 345 to 364
	value = ((uint32_t)(input[43] & 0x7f) << 25) |
			((uint32_t)input[44] << 17) |
			((uint32_t)(input[45] & 0xf8) << 9);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 365 to 384
	value = ((uint32_t)(input[45] & 0x07) << 29) |
			((uint32_t)input[46] << 21) |
			((uint32_t)input[47] << 13) |
			((uint32_t)(input[48] & 0x80) << 5);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 385 to 404
	value = ((uint32_t)(input[48] & 0x7f) << 25) |
			((uint32_t)input[49] << 17) |
			((uint32_t)(input[50] & 0xf8) << 9);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 405 to 424
	value = ((uint32_t)(input[50] & 0x07) << 29) |
			((uint32_t)input[51] << 21) |
			((uint32_t)input[52] << 13) |
			((uint32_t)(input[53] & 0x80) << 5);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 425 to 444
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xf8) << 9);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 6 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 386 to 405
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)(input[50] & 0xfc) << 10);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 406 to 425
	value = ((uint32_t)(input[50] & 0x03) << 30) |
			((uint32_t)input[51] << 22) |
			((uint32_t)input[52] << 14) |
			((uint32_t)(input[53] & 0xc0) << 6);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 426 to 445
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)(input[55] & 0xfc) << 10);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 6 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 25
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xc0) << 6);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 26 to 45
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfc) << 10);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 46 to 65
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xc0) << 6);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 66 to 85
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfc) << 10);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 86 to 105
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xc0) << 6);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 106 to 125
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfc) << 10);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 126 to 145
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xc0) << 6);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 146 to 165
	value = ((uint32_t)(input[18] & 0x3f) << 26) |
			((uint32_t)input[19] << 18) |
			((uint32_t)(input[20] & 0xfc) << 10);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 166 to 185
	value = ((uint32_t)(input[20] & 0x03) << 30) |
			((uint32_t)input[21] << 22) |
			((uint32_t)input[22] << 14) |
			((uint32_t)(input[23] & 0xc0) << 6);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 186 to 205
	value = ((uint32_t)(input[23] & 0x3f) << 26) |
			((uint32_t)input[24] << 18) |
			((uint32_t)(input[25] & 0xfc) << 10);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 206 to 225
	value = ((uint32_t)(input[25] & 0x03) << 30) |
			((uint32_t)input[26] << 22) |
			((uint32_t)input[27] << 14) |
			((uint32_t)(input[28] & 0xc0) << 6);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 226 to 245
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)(input[30] & 0xfc) << 10);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 246 to 265
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xc0) << 6);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 266 to 285
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)(input[35] & 0xfc) << 10);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 286 to 305
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xc0) << 6);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 306 to 325
	value = ((uint32_t)(input[38] & 0x3f) << 26) |
			((uint32_t)input[39] << 18) |
			((uint32_t)(input[40] & 0xfc) << 10);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 326 to 345
	value = ((uint32_t)(input[40] & 0x03) << 30) |
			((uint32_t)input[41] << 22) |
			((uint32_t)input[42] << 14) |
			((uint32_t)(input[43] & 0xc0) << 6);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 346 to 365
	value = ((uint32_t)(input[43] & 0x3f) << 26) |
			((uint32_t)input[44] << 18) |
			((uint32_t)(input[45] & 0xfc) << 10);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 366 to 385
	value = ((uint32_t)(input[45] & 0x03) << 30) |
			((uint32_t)input[46] << 22) |
			((uint32_t)input[47] << 14) |
			((uint32_t)(input[48] & 0xc0) << 6);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 386 to 405
	value = ((uint32_t)(input[48] & 0x3f) << 26) |
			((uint32_t)input[49] << 18) |
			((uint32_t)(input[50] & 0xfc) << 10);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 406 to 425
	value = ((uint32_t)(input[50] & 0x03) << 30) |
			((uint32_t)input[51] << 22) |
			((uint32_t)input[52] << 14) |
			((uint32_t)(input[53] & 0xc0) << 6);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 426 to 445
	value = ((uint32_t)(input[53] & 0x3f) << 26) |
			((uint32_t)input[54] << 18) |
			((uint32_t)(input[55] & 0xfc) << 10);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit signed
	// Skip 7 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 387 to 406
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)(input[50] & 0xfe) << 11);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 407 to 426
	value = ((uint32_t)(input[50] & 0x01) << 31) |
			((uint32_t)input[51] << 23) |
			((uint32_t)input[52] << 15) |
			((uint32_t)(input[53] & 0xe0) << 7);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 427 to 446
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)(input[55] & 0xfe) << 11);
	output[21] = (double)(value >> 12);
}

static void unpack_22_20bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 20-bit unsigned
	// Skip 7 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 26
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xe0) << 7);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 27 to 46
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)(input[5] & 0xfe) << 11);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 47 to 66
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xe0) << 7);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 67 to 86
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)(input[10] & 0xfe) << 11);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 87 to 106
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xe0) << 7);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 107 to 126
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)(input[15] & 0xfe) << 11);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 127 to 146
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xe0) << 7);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 147 to 166
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)(input[20] & 0xfe) << 11);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 167 to 186
	value = ((uint32_t)(input[20] & 0x01) << 31) |
			((uint32_t)input[21] << 23) |
			((uint32_t)input[22] << 15) |
			((uint32_t)(input[23] & 0xe0) << 7);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 187 to 206
	value = ((uint32_t)(input[23] & 0x1f) << 27) |
			((uint32_t)input[24] << 19) |
			((uint32_t)(input[25] & 0xfe) << 11);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 207 to 226
	value = ((uint32_t)(input[25] & 0x01) << 31) |
			((uint32_t)input[26] << 23) |
			((uint32_t)input[27] << 15) |
			((uint32_t)(input[28] & 0xe0) << 7);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 227 to 246
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)(input[30] & 0xfe) << 11);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 247 to 266
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xe0) << 7);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 267 to 286
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)(input[35] & 0xfe) << 11);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 287 to 306
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xe0) << 7);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 307 to 326
	value = ((uint32_t)(input[38] & 0x1f) << 27) |
			((uint32_t)input[39] << 19) |
			((uint32_t)(input[40] & 0xfe) << 11);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 327 to 346
	value = ((uint32_t)(input[40] & 0x01) << 31) |
			((uint32_t)input[41] << 23) |
			((uint32_t)input[42] << 15) |
			((uint32_t)(input[43] & 0xe0) << 7);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 347 to 366
	value = ((uint32_t)(input[43] & 0x1f) << 27) |
			((uint32_t)input[44] << 19) |
			((uint32_t)(input[45] & 0xfe) << 11);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 367 to 386
	value = ((uint32_t)(input[45] & 0x01) << 31) |
			((uint32_t)input[46] << 23) |
			((uint32_t)input[47] << 15) |
			((uint32_t)(input[48] & 0xe0) << 7);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 387 to 406
	value = ((uint32_t)(input[48] & 0x1f) << 27) |
			((uint32_t)input[49] << 19) |
			((uint32_t)(input[50] & 0xfe) << 11);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 407 to 426
	value = ((uint32_t)(input[50] & 0x01) << 31) |
			((uint32_t)input[51] << 23) |
			((uint32_t)input[52] << 15) |
			((uint32_t)(input[53] & 0xe0) << 7);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 427 to 446
	value = ((uint32_t)(input[53] & 0x1f) << 27) |
			((uint32_t)input[54] << 19) |
			((uint32_t)(input[55] & 0xfe) << 11);
	output[21] = (double)(value >> 12);
}

static void unpack_23_20bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit signed
	// Skip 0 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 400 to 419
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xf0) << 8);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 420 to 439
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 440 to 459
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xf0) << 8);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit unsigned
	// Skip 0 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 19
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf0) << 8);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 20 to 39
	value = ((uint32_t)(input[2] & 0x0f) << 28) |
			((uint32_t)input[3] << 20) |
			((uint32_t)input[4] << 12);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 40 to 59
	value = ((uint32_t)input[5] << 24) |
			((uint32_t)input[6] << 16) |
			((uint32_t)(input[7] & 0xf0) << 8);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 60 to 79
	value = ((uint32_t)(input[7] & 0x0f) << 28) |
			((uint32_t)input[8] << 20) |
			((uint32_t)input[9] << 12);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 80 to 99
	value = ((uint32_t)input[10] << 24) |
			((uint32_t)input[11] << 16) |
			((uint32_t)(input[12] & 0xf0) << 8);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 100 to 119
	value = ((uint32_t)(input[12] & 0x0f) << 28) |
			((uint32_t)input[13] << 20) |
			((uint32_t)input[14] << 12);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 120 to 139
	value = ((uint32_t)input[15] << 24) |
			((uint32_t)input[16] << 16) |
			((uint32_t)(input[17] & 0xf0) << 8);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 140 to 159
	value = ((uint32_t)(input[17] & 0x0f) << 28) |
			((uint32_t)input[18] << 20) |
			((uint32_t)input[19] << 12);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 160 to 179
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xf0) << 8);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 180 to 199
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 200 to 219
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xf0) << 8);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 220 to 239
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 240 to 259
	value = ((uint32_t)input[30] << 24) |
			((uint32_t)input[31] << 16) |
			((uint32_t)(input[32] & 0xf0) << 8);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 260 to 279
	value = ((uint32_t)(input[32] & 0x0f) << 28) |
			((uint32_t)input[33] << 20) |
			((uint32_t)input[34] << 12);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 280 to 299
	value = ((uint32_t)input[35] << 24) |
			((uint32_t)input[36] << 16) |
			((uint32_t)(input[37] & 0xf0) << 8);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 300 to 319
	value = ((uint32_t)(input[37] & 0x0f) << 28) |
			((uint32_t)input[38] << 20) |
			((uint32_t)input[39] << 12);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 320 to 339
	value = ((uint32_t)input[40] << 24) |
			((uint32_t)input[41] << 16) |
			((uint32_t)(input[42] & 0xf0) << 8);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 340 to 359
	value = ((uint32_t)(input[42] & 0x0f) << 28) |
			((uint32_t)input[43] << 20) |
			((uint32_t)input[44] << 12);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 360 to 379
	value = ((uint32_t)input[45] << 24) |
			((uint32_t)input[46] << 16) |
			((uint32_t)(input[47] & 0xf0) << 8);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 380 to 399
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 400 to 419
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xf0) << 8);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 420 to 439
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 440 to 459
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xf0) << 8);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit signed
	// Skip 1 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 401 to 420
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xf8) << 9);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 421 to 440
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0x80) << 5);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 441 to 460
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xf8) << 9);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit unsigned
	// Skip 1 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 20
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xf8) << 9);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 21 to 40
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0x80) << 5);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 41 to 60
	value = ((uint32_t)(input[5] & 0x7f) << 25) |
			((uint32_t)input[6] << 17) |
			((uint32_t)(input[7] & 0xf8) << 9);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 61 to 80
	value = ((uint32_t)(input[7] & 0x07) << 29) |
			((uint32_t)input[8] << 21) |
			((uint32_t)input[9] << 13) |
			((uint32_t)(input[10] & 0x80) << 5);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 81 to 100
	value = ((uint32_t)(input[10] & 0x7f) << 25) |
			((uint32_t)input[11] << 17) |
			((uint32_t)(input[12] & 0xf8) << 9);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 101 to 120
	value = ((uint32_t)(input[12] & 0x07) << 29) |
			((uint32_t)input[13] << 21) |
			((uint32_t)input[14] << 13) |
			((uint32_t)(input[15] & 0x80) << 5);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 121 to 140
	value = ((uint32_t)(input[15] & 0x7f) << 25) |
			((uint32_t)input[16] << 17) |
			((uint32_t)(input[17] & 0xf8) << 9);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 141 to 160
	value = ((uint32_t)(input[17] & 0x07) << 29) |
			((uint32_t)input[18] << 21) |
			((uint32_t)input[19] << 13) |
			((uint32_t)(input[20] & 0x80) << 5);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 161 to 180
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xf8) << 9);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 181 to 200
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0x80) << 5);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 201 to 220
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xf8) << 9);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 221 to 240
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0x80) << 5);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 241 to 260
	value = ((uint32_t)(input[30] & 0x7f) << 25) |
			((uint32_t)input[31] << 17) |
			((uint32_t)(input[32] & 0xf8) << 9);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 261 to 280
	value = ((uint32_t)(input[32] & 0x07) << 29) |
			((uint32_t)input[33] << 21) |
			((uint32_t)input[34] << 13) |
			((uint32_t)(input[35] & 0x80) << 5);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 281 to 300
	value = ((uint32_t)(input[35] & 0x7f) << 25) |
			((uint32_t)input[36] << 17) |
			((uint32_t)(input[37] & 0xf8) << 9);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 301 to 320
	value = ((uint32_t)(input[37] & 0x07) << 29) |
			((uint32_t)input[38] << 21) |
			((uint32_t)input[39] << 13) |
			((uint32_t)(input[40] & 0x80) << 5);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 321 to 340
	value = ((uint32_t)(input[40] & 0x7f) << 25) |
			((uint32_t)input[41] << 17) |
			((uint32_t)(input[42] & 0xf8) << 9);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 341 to 360
	value = ((uint32_t)(input[42] & 0x07) << 29) |
			((uint32_t)input[43] << 21) |
			((uint32_t)input[44] << 13) |
			((uint32_t)(input[45] & 0x80) << 5);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 361 to 380
	value = ((uint32_t)(input[45] & 0x7f) << 25) |
			((uint32_t)input[46] << 17) |
			((uint32_t)(input[47] & 0xf8) << 9);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 381 to 400
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0x80) << 5);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 401 to 420
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xf8) << 9);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 421 to 440
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0x80) << 5);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 441 to 460
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xf8) << 9);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit signed
	// Skip 2 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 402 to 421
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xfc) << 10);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 422 to 441
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xc0) << 6);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 442 to 461
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)(input[57] & 0xfc) << 10);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit unsigned
	// Skip 2 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 21
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfc) << 10);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 22 to 41
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xc0) << 6);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 42 to 61
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfc) << 10);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 62 to 81
	value = ((uint32_t)(input[7] & 0x03) << 30) |
			((uint32_t)input[8] << 22) |
			((uint32_t)input[9] << 14) |
			((uint32_t)(input[10] & 0xc0) << 6);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 82 to 101
	value = ((uint32_t)(input[10] & 0x3f) << 26) |
			((uint32_t)input[11] << 18) |
			((uint32_t)(input[12] & 0xfc) << 10);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 102 to 121
	value = ((uint32_t)(input[12] & 0x03) << 30) |
			((uint32_t)input[13] << 22) |
			((uint32_t)input[14] << 14) |
			((uint32_t)(input[15] & 0xc0) << 6);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 122 to 141
	value = ((uint32_t)(input[15] & 0x3f) << 26) |
			((uint32_t)input[16] << 18) |
			((uint32_t)(input[17] & 0xfc) << 10);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 142 to 161
	value = ((uint32_t)(input[17] & 0x03) << 30) |
			((uint32_t)input[18] << 22) |
			((uint32_t)input[19] << 14) |
			((uint32_t)(input[20] & 0xc0) << 6);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 162 to 181
	value = ((uint32_t)(input[20] & 0x3f) << 26) |
			((uint32_t)input[21] << 18) |
			((uint32_t)(input[22] & 0xfc) << 10);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 182 to 201
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xc0) << 6);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 202 to 221
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)(input[27] & 0xfc) << 10);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 222 to 241
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xc0) << 6);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 242 to 261
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)(input[32] & 0xfc) << 10);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 262 to 281
	value = ((uint32_t)(input[32] & 0x03) << 30) |
			((uint32_t)input[33] << 22) |
			((uint32_t)input[34] << 14) |
			((uint32_t)(input[35] & 0xc0) << 6);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 282 to 301
	value = ((uint32_t)(input[35] & 0x3f) << 26) |
			((uint32_t)input[36] << 18) |
			((uint32_t)(input[37] & 0xfc) << 10);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 302 to 321
	value = ((uint32_t)(input[37] & 0x03) << 30) |
			((uint32_t)input[38] << 22) |
			((uint32_t)input[39] << 14) |
			((uint32_t)(input[40] & 0xc0) << 6);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 322 to 341
	value = ((uint32_t)(input[40] & 0x3f) << 26) |
			((uint32_t)input[41] << 18) |
			((uint32_t)(input[42] & 0xfc) << 10);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 342 to 361
	value = ((uint32_t)(input[42] & 0x03) << 30) |
			((uint32_t)input[43] << 22) |
			((uint32_t)input[44] << 14) |
			((uint32_t)(input[45] & 0xc0) << 6);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 362 to 381
	value = ((uint32_t)(input[45] & 0x3f) << 26) |
			((uint32_t)input[46] << 18) |
			((uint32_t)(input[47] & 0xfc) << 10);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 382 to 401
	value = ((uint32_t)(input[47] & 0x03) << 30) |
			((uint32_t)input[48] << 22) |
			((uint32_t)input[49] << 14) |
			((uint32_t)(input[50] & 0xc0) << 6);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 402 to 421
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)(input[52] & 0xfc) << 10);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 422 to 441
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xc0) << 6);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 442 to 461
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)(input[57] & 0xfc) << 10);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit signed
	// Skip 3 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 403 to 422
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xfe) << 11);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 423 to 442
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xe0) << 7);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 443 to 462
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)(input[57] & 0xfe) << 11);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit unsigned
	// Skip 3 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 22
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)(input[2] & 0xfe) << 11);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 23 to 42
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xe0) << 7);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 43 to 62
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)(input[7] & 0xfe) << 11);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 63 to 82
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xe0) << 7);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 83 to 102
	value = ((uint32_t)(input[10] & 0x1f) << 27) |
			((uint32_t)input[11] << 19) |
			((uint32_t)(input[12] & 0xfe) << 11);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 103 to 122
	value = ((uint32_t)(input[12] & 0x01) << 31) |
			((uint32_t)input[13] << 23) |
			((uint32_t)input[14] << 15) |
			((uint32_t)(input[15] & 0xe0) << 7);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 123 to 142
	value = ((uint32_t)(input[15] & 0x1f) << 27) |
			((uint32_t)input[16] << 19) |
			((uint32_t)(input[17] & 0xfe) << 11);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 143 to 162
	value = ((uint32_t)(input[17] & 0x01) << 31) |
			((uint32_t)input[18] << 23) |
			((uint32_t)input[19] << 15) |
			((uint32_t)(input[20] & 0xe0) << 7);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 163 to 182
	value = ((uint32_t)(input[20] & 0x1f) << 27) |
			((uint32_t)input[21] << 19) |
			((uint32_t)(input[22] & 0xfe) << 11);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 183 to 202
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xe0) << 7);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 203 to 222
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)(input[27] & 0xfe) << 11);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 223 to 242
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xe0) << 7);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 243 to 262
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)(input[32] & 0xfe) << 11);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 263 to 282
	value = ((uint32_t)(input[32] & 0x01) << 31) |
			((uint32_t)input[33] << 23) |
			((uint32_t)input[34] << 15) |
			((uint32_t)(input[35] & 0xe0) << 7);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 283 to 302
	value = ((uint32_t)(input[35] & 0x1f) << 27) |
			((uint32_t)input[36] << 19) |
			((uint32_t)(input[37] & 0xfe) << 11);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 303 to 322
	value = ((uint32_t)(input[37] & 0x01) << 31) |
			((uint32_t)input[38] << 23) |
			((uint32_t)input[39] << 15) |
			((uint32_t)(input[40] & 0xe0) << 7);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 323 to 342
	value = ((uint32_t)(input[40] & 0x1f) << 27) |
			((uint32_t)input[41] << 19) |
			((uint32_t)(input[42] & 0xfe) << 11);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 343 to 362
	value = ((uint32_t)(input[42] & 0x01) << 31) |
			((uint32_t)input[43] << 23) |
			((uint32_t)input[44] << 15) |
			((uint32_t)(input[45] & 0xe0) << 7);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 363 to 382
	value = ((uint32_t)(input[45] & 0x1f) << 27) |
			((uint32_t)input[46] << 19) |
			((uint32_t)(input[47] & 0xfe) << 11);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 383 to 402
	value = ((uint32_t)(input[47] & 0x01) << 31) |
			((uint32_t)input[48] << 23) |
			((uint32_t)input[49] << 15) |
			((uint32_t)(input[50] & 0xe0) << 7);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 403 to 422
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)(input[52] & 0xfe) << 11);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 423 to 442
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xe0) << 7);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 443 to 462
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)(input[57] & 0xfe) << 11);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit signed
	// Skip 4 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 404 to 423
	value = ((uint32_t)(input[50] & 0x0f) << 28) |
			((uint32_t)input[51] << 20) |
			((uint32_t)input[52] << 12);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 424 to 443
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xf0) << 8);
	output[21] = (double)(value >> 12);

	// read output[22]: from bit 444 to 463
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12);
	output[22] = (double)(value >> 12);
}

static void unpack_23_20bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 20-bit unsigned
	// Skip 4 bits, read 460 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 23
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12);
	output[0] = (double)(value >> 12);

	// read output[1]: from bit 24 to 43
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf0) << 8);
	output[1] = (double)(value >> 12);

	// read output[2]: from bit 44 to 63
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12);
	output[2] = (double)(value >> 12);

	// read output[3]: from bit 64 to 83
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf0) << 8);
	output[3] = (double)(value >> 12);

	// read output[4]: from bit 84 to 103
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12);
	output[4] = (double)(value >> 12);

	// read output[5]: from bit 104 to 123
	value = ((uint32_t)input[13] << 24) |
			((uint32_t)input[14] << 16) |
			((uint32_t)(input[15] & 0xf0) << 8);
	output[5] = (double)(value >> 12);

	// read output[6]: from bit 124 to 143
	value = ((uint32_t)(input[15] & 0x0f) << 28) |
			((uint32_t)input[16] << 20) |
			((uint32_t)input[17] << 12);
	output[6] = (double)(value >> 12);

	// read output[7]: from bit 144 to 163
	value = ((uint32_t)input[18] << 24) |
			((uint32_t)input[19] << 16) |
			((uint32_t)(input[20] & 0xf0) << 8);
	output[7] = (double)(value >> 12);

	// read output[8]: from bit 164 to 183
	value = ((uint32_t)(input[20] & 0x0f) << 28) |
			((uint32_t)input[21] << 20) |
			((uint32_t)input[22] << 12);
	output[8] = (double)(value >> 12);

	// read output[9]: from bit 184 to 203
	value = ((uint32_t)input[23] << 24) |
			((uint32_t)input[24] << 16) |
			((uint32_t)(input[25] & 0xf0) << 8);
	output[9] = (double)(value >> 12);

	// read output[10]: from bit 204 to 223
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12);
	output[10] = (double)(value >> 12);

	// read output[11]: from bit 224 to 243
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xf0) << 8);
	output[11] = (double)(value >> 12);

	// read output[12]: from bit 244 to 263
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12);
	output[12] = (double)(value >> 12);

	// read output[13]: from bit 264 to 283
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xf0) << 8);
	output[13] = (double)(value >> 12);

	// read output[14]: from bit 284 to 303
	value = ((uint32_t)(input[35] & 0x0f) << 28) |
			((uint32_t)input[36] << 20) |
			((uint32_t)input[37] << 12);
	output[14] = (double)(value >> 12);

	// read output[15]: from bit 304 to 323
	value = ((uint32_t)input[38] << 24) |
			((uint32_t)input[39] << 16) |
			((uint32_t)(input[40] & 0xf0) << 8);
	output[15] = (double)(value >> 12);

	// read output[16]: from bit 324 to 343
	value = ((uint32_t)(input[40] & 0x0f) << 28) |
			((uint32_t)input[41] << 20) |
			((uint32_t)input[42] << 12);
	output[16] = (double)(value >> 12);

	// read output[17]: from bit 344 to 363
	value = ((uint32_t)input[43] << 24) |
			((uint32_t)input[44] << 16) |
			((uint32_t)(input[45] & 0xf0) << 8);
	output[17] = (double)(value >> 12);

	// read output[18]: from bit 364 to 383
	value = ((uint32_t)(input[45] & 0x0f) << 28) |
			((uint32_t)input[46] << 20) |
			((uint32_t)input[47] << 12);
	output[18] = (double)(value >> 12);

	// read output[19]: from bit 384 to 403
	value = ((uint32_t)input[48] << 24) |
			((uint32_t)input[49] << 16) |
			((uint32_t)(input[50] & 0xf0) << 8);
	output[19] = (double)(value >> 12);

	// read output[20]: from bit 404 to 423
	value = ((uint32_t)(input[50] & 0x0f) << 28) |
			((uint32_t)input[51] << 20) |
			((uint32_t)input[52] << 12);
	output[20] = (double)(value >> 12);

	// read output[21]: from bit 424 to 443
	value