// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack21.h"



static void unpack_1_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 21 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);
}

static void unpack_1_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 21 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 42 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 42 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);
}

static void unpack_2_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 42 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 63 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 63 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 63 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 63 bits of data.
	// Input must be at least 8 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);
}

static void unpack_3_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 63 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 84 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);
}

static void unpack_4_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 84 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);
}

static void unpack_5_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 105 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 105 to 125
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xfc) << 9);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 105 to 125
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xfc) << 9);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 106 to 126
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfe) << 10);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 106 to 126
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfe) << 10);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 107 to 127
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 126 bits of data.
	// Input must be at least 16 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 107 to 127
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 108 to 128
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0x80) << 4);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 108 to 128
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0x80) << 4);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 109 to 129
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xc0) << 5);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 109 to 129
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xc0) << 5);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 110 to 130
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xe0) << 6);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 110 to 130
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xe0) << 6);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 111 to 131
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf0) << 7);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 111 to 131
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf0) << 7);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 112 to 132
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xf8) << 8);
	output[5] = (double)(value >> 11);
}

static void unpack_6_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 126 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 112 to 132
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xf8) << 8);
	output[5] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 105 to 125
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xfc) << 9);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 126 to 146
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xe0) << 6);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 105 to 125
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xfc) << 9);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 126 to 146
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xe0) << 6);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 106 to 126
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfe) << 10);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 127 to 147
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xf0) << 7);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 106 to 126
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfe) << 10);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 127 to 147
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xf0) << 7);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 107 to 127
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 128 to 148
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xf8) << 8);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 107 to 127
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 128 to 148
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xf8) << 8);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 108 to 128
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0x80) << 4);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 129 to 149
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xfc) << 9);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 108 to 128
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0x80) << 4);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 129 to 149
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xfc) << 9);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 109 to 129
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xc0) << 5);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 130 to 150
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xfe) << 10);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 109 to 129
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xc0) << 5);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 130 to 150
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xfe) << 10);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 110 to 130
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xe0) << 6);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 131 to 151
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 147 bits of data.
	// Input must be at least 19 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 110 to 130
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xe0) << 6);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 131 to 151
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 147 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 111 to 131
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf0) << 7);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 132 to 152
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0x80) << 4);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 147 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 111 to 131
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf0) << 7);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 132 to 152
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0x80) << 4);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 147 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 112 to 132
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xf8) << 8);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 133 to 153
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xc0) << 5);
	output[6] = (double)(value >> 11);
}

static void unpack_7_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 147 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 112 to 132
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xf8) << 8);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 133 to 153
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xc0) << 5);
	output[6] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 105 to 125
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xfc) << 9);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 126 to 146
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xe0) << 6);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 147 to 167
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 0 bits, read 168 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 20
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xf8) << 8);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 21 to 41
	value = ((uint32_t)(input[2] & 0x07) << 29) |
			((uint32_t)input[3] << 21) |
			((uint32_t)input[4] << 13) |
			((uint32_t)(input[5] & 0xc0) << 5);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 42 to 62
	value = ((uint32_t)(input[5] & 0x3f) << 26) |
			((uint32_t)input[6] << 18) |
			((uint32_t)(input[7] & 0xfe) << 10);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 63 to 83
	value = ((uint32_t)(input[7] & 0x01) << 31) |
			((uint32_t)input[8] << 23) |
			((uint32_t)input[9] << 15) |
			((uint32_t)(input[10] & 0xf0) << 7);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 84 to 104
	value = ((uint32_t)(input[10] & 0x0f) << 28) |
			((uint32_t)input[11] << 20) |
			((uint32_t)input[12] << 12) |
			((uint32_t)(input[13] & 0x80) << 4);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 105 to 125
	value = ((uint32_t)(input[13] & 0x7f) << 25) |
			((uint32_t)input[14] << 17) |
			((uint32_t)(input[15] & 0xfc) << 9);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 126 to 146
	value = ((uint32_t)(input[15] & 0x03) << 30) |
			((uint32_t)input[16] << 22) |
			((uint32_t)input[17] << 14) |
			((uint32_t)(input[18] & 0xe0) << 6);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 147 to 167
	value = ((uint32_t)(input[18] & 0x1f) << 27) |
			((uint32_t)input[19] << 19) |
			((uint32_t)input[20] << 11);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 106 to 126
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfe) << 10);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 127 to 147
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xf0) << 7);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 148 to 168
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0x80) << 4);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 1 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 21
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfc) << 9);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 22 to 42
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xe0) << 6);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 43 to 63
	value = ((uint32_t)(input[5] & 0x1f) << 27) |
			((uint32_t)input[6] << 19) |
			((uint32_t)input[7] << 11);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 64 to 84
	value = ((uint32_t)input[8] << 24) |
			((uint32_t)input[9] << 16) |
			((uint32_t)(input[10] & 0xf8) << 8);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 85 to 105
	value = ((uint32_t)(input[10] & 0x07) << 29) |
			((uint32_t)input[11] << 21) |
			((uint32_t)input[12] << 13) |
			((uint32_t)(input[13] & 0xc0) << 5);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 106 to 126
	value = ((uint32_t)(input[13] & 0x3f) << 26) |
			((uint32_t)input[14] << 18) |
			((uint32_t)(input[15] & 0xfe) << 10);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 127 to 147
	value = ((uint32_t)(input[15] & 0x01) << 31) |
			((uint32_t)input[16] << 23) |
			((uint32_t)input[17] << 15) |
			((uint32_t)(input[18] & 0xf0) << 7);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 148 to 168
	value = ((uint32_t)(input[18] & 0x0f) << 28) |
			((uint32_t)input[19] << 20) |
			((uint32_t)input[20] << 12) |
			((uint32_t)(input[21] & 0x80) << 4);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 107 to 127
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 128 to 148
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xf8) << 8);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 149 to 169
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xc0) << 5);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 2 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 22
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)(input[2] & 0xfe) << 10);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 23 to 43
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf0) << 7);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 44 to 64
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0x80) << 4);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 65 to 85
	value = ((uint32_t)(input[8] & 0x7f) << 25) |
			((uint32_t)input[9] << 17) |
			((uint32_t)(input[10] & 0xfc) << 9);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 86 to 106
	value = ((uint32_t)(input[10] & 0x03) << 30) |
			((uint32_t)input[11] << 22) |
			((uint32_t)input[12] << 14) |
			((uint32_t)(input[13] & 0xe0) << 6);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 107 to 127
	value = ((uint32_t)(input[13] & 0x1f) << 27) |
			((uint32_t)input[14] << 19) |
			((uint32_t)input[15] << 11);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 128 to 148
	value = ((uint32_t)input[16] << 24) |
			((uint32_t)input[17] << 16) |
			((uint32_t)(input[18] & 0xf8) << 8);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 149 to 169
	value = ((uint32_t)(input[18] & 0x07) << 29) |
			((uint32_t)input[19] << 21) |
			((uint32_t)input[20] << 13) |
			((uint32_t)(input[21] & 0xc0) << 5);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 108 to 128
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0x80) << 4);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 129 to 149
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xfc) << 9);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 150 to 170
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xe0) << 6);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 3 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 23
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 24 to 44
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xf8) << 8);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 45 to 65
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xc0) << 5);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 66 to 86
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)(input[10] & 0xfe) << 10);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 87 to 107
	value = ((uint32_t)(input[10] & 0x01) << 31) |
			((uint32_t)input[11] << 23) |
			((uint32_t)input[12] << 15) |
			((uint32_t)(input[13] & 0xf0) << 7);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 108 to 128
	value = ((uint32_t)(input[13] & 0x0f) << 28) |
			((uint32_t)input[14] << 20) |
			((uint32_t)input[15] << 12) |
			((uint32_t)(input[16] & 0x80) << 4);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 129 to 149
	value = ((uint32_t)(input[16] & 0x7f) << 25) |
			((uint32_t)input[17] << 17) |
			((uint32_t)(input[18] & 0xfc) << 9);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 150 to 170
	value = ((uint32_t)(input[18] & 0x03) << 30) |
			((uint32_t)input[19] << 22) |
			((uint32_t)input[20] << 14) |
			((uint32_t)(input[21] & 0xe0) << 6);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 109 to 129
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xc0) << 5);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 130 to 150
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xfe) << 10);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 151 to 171
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xf0) << 7);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 4 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 24
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0x80) << 4);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 25 to 45
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfc) << 9);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 46 to 66
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xe0) << 6);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 67 to 87
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 88 to 108
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xf8) << 8);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 109 to 129
	value = ((uint32_t)(input[13] & 0x07) << 29) |
			((uint32_t)input[14] << 21) |
			((uint32_t)input[15] << 13) |
			((uint32_t)(input[16] & 0xc0) << 5);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 130 to 150
	value = ((uint32_t)(input[16] & 0x3f) << 26) |
			((uint32_t)input[17] << 18) |
			((uint32_t)(input[18] & 0xfe) << 10);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 151 to 171
	value = ((uint32_t)(input[18] & 0x01) << 31) |
			((uint32_t)input[19] << 23) |
			((uint32_t)input[20] << 15) |
			((uint32_t)(input[21] & 0xf0) << 7);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 110 to 130
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xe0) << 6);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 131 to 151
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 152 to 172
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)(input[21] & 0xf8) << 8);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 5 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 25
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xc0) << 5);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 26 to 46
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)(input[5] & 0xfe) << 10);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 47 to 67
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf0) << 7);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 68 to 88
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0x80) << 4);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 89 to 109
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfc) << 9);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 110 to 130
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xe0) << 6);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 131 to 151
	value = ((uint32_t)(input[16] & 0x1f) << 27) |
			((uint32_t)input[17] << 19) |
			((uint32_t)input[18] << 11);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 152 to 172
	value = ((uint32_t)input[19] << 24) |
			((uint32_t)input[20] << 16) |
			((uint32_t)(input[21] & 0xf8) << 8);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 111 to 131
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf0) << 7);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 132 to 152
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0x80) << 4);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 153 to 173
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)(input[21] & 0xfc) << 9);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 6 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 26
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xe0) << 6);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 27 to 47
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 48 to 68
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xf8) << 8);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 69 to 89
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xc0) << 5);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 90 to 110
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)(input[13] & 0xfe) << 10);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 111 to 131
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf0) << 7);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 132 to 152
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0x80) << 4);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 153 to 173
	value = ((uint32_t)(input[19] & 0x7f) << 25) |
			((uint32_t)input[20] << 17) |
			((uint32_t)(input[21] & 0xfc) << 9);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit signed
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 112 to 132
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xf8) << 8);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 133 to 153
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xc0) << 5);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 154 to 174
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)(input[21] & 0xfe) << 10);
	output[7] = (double)(value >> 11);
}

static void unpack_8_21bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 21-bit unsigned
	// Skip 7 bits, read 168 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 27
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf0) << 7);
	output[0] = (double)(value >> 11);

	// read output[1]: from bit 28 to 48
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0x80) << 4);
	output[1] = (double)(value >> 11);

	// read output[2]: from bit 49 to 69
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfc) << 9);
	output[2] = (double)(value >> 11);

	// read output[3]: from bit 70 to 90
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xe0) << 6);
	output[3] = (double)(value >> 11);

	// read output[4]: from bit 91 to 111
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11);
	output[4] = (double)(value >> 11);

	// read output[5]: from bit 112 to 132
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xf8) << 8);
	output[5] = (double)(value >> 11);

	// read output[6]: from bit 133 to 153
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xc0) << 5);
	output[6] = (double)(value >> 11);

	// read output[7]: from bit 154 to 174
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)(input[21] & 0xfe) << 10);
	output[7] = (double)(value >> 11);
}


unpack_func_t unpack_21bit[UNPACK_21BIT_MAX_COUNT][8][2] = {
	{
		{
			unpack_1_21bit_unsigned_0off,
			unpack_1_21bit_signed_0off,
		},
		{
			unpack_1_21bit_unsigned_1off,
			unpack_1_21bit_signed_1off,
		},
		{
			unpack_1_21bit_unsigned_2off,
			unpack_1_21bit_signed_2off,
		},
		{
			unpack_1_21bit_unsigned_3off,
			unpack_1_21bit_signed_3off,
		},
		{
			unpack_1_21bit_unsigned_4off,
			unpack_1_21bit_signed_4off,
		},
		{
			unpack_1_21bit_unsigned_5off,
			unpack_1_21bit_signed_5off,
		},
		{
			unpack_1_21bit_unsigned_6off,
			unpack_1_21bit_signed_6off,
		},
		{
			unpack_1_21bit_unsigned_7off,
			unpack_1_21bit_signed_7off,
		},
	},
	{
		{
			unpack_2_21bit_unsigned_0off,
			unpack_2_21bit_signed_0off,
		},
		{
			unpack_2_21bit_unsigned_1off,
			unpack_2_21bit_signed_1off,
		},
		{
			unpack_2_21bit_unsigned_2off,
			unpack_2_21bit_signed_2off,
		},
		{
			unpack_2_21bit_unsigned_3off,
			unpack_2_21bit_signed_3off,
		},
		{
			unpack_2_21bit_unsigned_4off,
			unpack_2_21bit_signed_4off,
		},
		{
			unpack_2_21bit_unsigned_5off,
			unpack_2_21bit_signed_5off,
		},
		{
			unpack_2_21bit_unsigned_6off,
			unpack_2_21bit_signed_6off,
		},
		{
			unpack_2_21bit_unsigned_7off,
			unpack_2_21bit_signed_7off,
		},
	},
	{
		{
			unpack_3_21bit_unsigned_0off,
			unpack_3_21bit_signed_0off,
		},
		{
			unpack_3_21bit_unsigned_1off,
			unpack_3_21bit_signed_1off,
		},
		{
			unpack_3_21bit_unsigned_2off,
			unpack_3_21bit_signed_2off,
		},
		{
			unpack_3_21bit_unsigned_3off,
			unpack_3_21bit_signed_3off,
		},
		{
			unpack_3_21bit_unsigned_4off,
			unpack_3_21bit_signed_4off,
		},
		{
			unpack_3_21bit_unsigned_5off,
			unpack_3_21bit_signed_5off,
		},
		{
			unpack_3_21bit_unsigned_6off,
			unpack_3_21bit_signed_6off,
		},
		{
			unpack_3_21bit_unsigned_7off,
			unpack_3_21bit_signed_7off,
		},
	},
	{
		{
			unpack_4_21bit_unsigned_0off,
			unpack_4_21bit_signed_0off,
		},
		{
			unpack_4_21bit_unsigned_1off,
			unpack_4_21bit_signed_1off,
		},
		{
			unpack_4_21bit_unsigned_2off,
			unpack_4_21bit_signed_2off,
		},
		{
			unpack_4_21bit_unsigned_3off,
			unpack_4_21bit_signed_3off,
		},
		{
			unpack_4_21bit_unsigned_4off,
			unpack_4_21bit_signed_4off,
		},
		{
			unpack_4_21bit_unsigned_5off,
			unpack_4_21bit_signed_5off,
		},
		{
			unpack_4_21bit_unsigned_6off,
			unpack_4_21bit_signed_6off,
		},
		{
			unpack_4_21bit_unsigned_7off,
			unpack_4_21bit_signed_7off,
		},
	},
	{
		{
			unpack_5_21bit_unsigned_0off,
			unpack_5_21bit_signed_0off,
		},
		{
			unpack_5_21bit_unsigned_1off,
			unpack_5_21bit_signed_1off,
		},
		{
			unpack_5_21bit_unsigned_2off,
			unpack_5_21bit_signed_2off,
		},
		{
			unpack_5_21bit_unsigned_3off,
			unpack_5_21bit_signed_3off,
		},
		{
			unpack_5_21bit_unsigned_4off,
			unpack_5_21bit_signed_4off,
		},
		{
			unpack_5_21bit_unsigned_5off,
			unpack_5_21bit_signed_5off,
		},
		{
			unpack_5_21bit_unsigned_6off,
			unpack_5_21bit_signed_6off,
		},
		{
			unpack_5_21bit_unsigned_7off,
			unpack_5_21bit_signed_7off,
		},
	},
	{
		{
			unpack_6_21bit_unsigned_0off,
			unpack_6_21bit_signed_0off,
		},
		{
			unpack_6_21bit_unsigned_1off,
			unpack_6_21bit_signed_1off,
		},
		{
			unpack_6_21bit_unsigned_2off,
			unpack_6_21bit_signed_2off,
		},
		{
			unpack_6_21bit_unsigned_3off,
			unpack_6_21bit_signed_3off,
		},
		{
			unpack_6_21bit_unsigned_4off,
			unpack_6_21bit_signed_4off,
		},
		{
			unpack_6_21bit_unsigned_5off,
			unpack_6_21bit_signed_5off,
		},
		{
			unpack_6_21bit_unsigned_6off,
			unpack_6_21bit_signed_6off,
		},
		{
			unpack_6_21bit_unsigned_7off,
			unpack_6_21bit_signed_7off,
		},
	},
	{
		{
			unpack_7_21bit_unsigned_0off,
			unpack_7_21bit_signed_0off,
		},
		{
			unpack_7_21bit_unsigned_1off,
			unpack_7_21bit_signed_1off,
		},
		{
			unpack_7_21bit_unsigned_2off,
			unpack_7_21bit_signed_2off,
		},
		{
			unpack_7_21bit_unsigned_3off,
			unpack_7_21bit_signed_3off,
		},
		{
			unpack_7_21bit_unsigned_4off,
			unpack_7_21bit_signed_4off,
		},
		{
			unpack_7_21bit_unsigned_5off,
			unpack_7_21bit_signed_5off,
		},
		{
			unpack_7_21bit_unsigned_6off,
			unpack_7_21bit_signed_6off,
		},
		{
			unpack_7_21bit_unsigned_7off,
			unpack_7_21bit_signed_7off,
		},
	},
	{
		{
			unpack_8_21bit_unsigned_0off,
			unpack_8_21bit_signed_0off,
		},
		{
			unpack_8_21bit_unsigned_1off,
			unpack_8_21bit_signed_1off,
		},
		{
			unpack_8_21bit_unsigned_2off,
			unpack_8_21bit_signed_2off,
		},
		{
			unpack_8_21bit_unsigned_3off,
			unpack_8_21bit_signed_3off,
		},
		{
			unpack_8_21bit_unsigned_4off,
			unpack_8_21bit_signed_4off,
		},
		{
			unpack_8_21bit_unsigned_5off,
			unpack_8_21bit_signed_5off,
		},
		{
			unpack_8_21bit_unsigned_6off,
			unpack_8_21bit_signed_6off,
		},
		{
			unpack_8_21bit_unsigned_7off,
			unpack_8_21bit_signed_7off,
		},
	},
};
