// AUTOGENERATED FILE. DO NOT MODIFY.

#include <stdlib.h>
#include <stdint.h>

#include "unpack22.h"



static void unpack_1_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 22 bits of data.
	// Input must be at least 3 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);
}

static void unpack_1_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 1 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 22 bits of data.
	// Input must be at least 4 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 44 bits of data.
	// Input must be at least 6 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);
}

static void unpack_2_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 2 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 44 bits of data.
	// Input must be at least 7 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 66 bits of data.
	// Input must be at least 9 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 66 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);
}

static void unpack_3_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 3 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 66 bits of data.
	// Input must be at least 10 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 88 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 88 bits of data.
	// Input must be at least 11 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);
}

static void unpack_4_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 4 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 88 bits of data.
	// Input must be at least 12 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 110 bits of data.
	// Input must be at least 14 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);
}

static void unpack_5_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 5 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 110 bits of data.
	// Input must be at least 15 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 132 bits of data.
	// Input must be at least 17 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);
}

static void unpack_6_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 6 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 132 bits of data.
	// Input must be at least 18 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 154 bits of data.
	// Input must be at least 20 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 154 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);
}

static void unpack_7_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 7 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 154 bits of data.
	// Input must be at least 21 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 176 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 176 bits of data.
	// Input must be at least 22 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);
}

static void unpack_8_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 8 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 176 bits of data.
	// Input must be at least 23 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 198 bits of data.
	// Input must be at least 25 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);
}

static void unpack_9_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 9 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 198 bits of data.
	// Input must be at least 26 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 220 bits of data.
	// Input must be at least 28 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);
}

static void unpack_10_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 10 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 220 bits of data.
	// Input must be at least 29 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 242 bits of data.
	// Input must be at least 31 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 242 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);
}

static void unpack_11_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 11 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 242 bits of data.
	// Input must be at least 32 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 264 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 264 bits of data.
	// Input must be at least 33 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);
}

static void unpack_12_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 12 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 264 bits of data.
	// Input must be at least 34 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 286 bits of data.
	// Input must be at least 36 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);
}

static void unpack_13_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 13 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 286 bits of data.
	// Input must be at least 37 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 308 bits of data.
	// Input must be at least 39 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);
}

static void unpack_14_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 14 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 308 bits of data.
	// Input must be at least 40 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 330 bits of data.
	// Input must be at least 42 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 330 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);
}

static void unpack_15_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 15 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 330 bits of data.
	// Input must be at least 43 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 352 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 352 bits of data.
	// Input must be at least 44 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);
}

static void unpack_16_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 16 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 352 bits of data.
	// Input must be at least 45 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 374 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 374 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 374 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 374 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 374 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 374 bits of data.
	// Input must be at least 47 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);
}

static void unpack_17_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 17 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 374 bits of data.
	// Input must be at least 48 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 396 bits of data.
	// Input must be at least 50 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);
}

static void unpack_18_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 18 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 396 bits of data.
	// Input must be at least 51 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 418 bits of data.
	// Input must be at least 53 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 418 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);
}

static void unpack_19_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 19 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 418 bits of data.
	// Input must be at least 54 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 440 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 440 bits of data.
	// Input must be at least 55 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 420 to 441
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xc0) << 4);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 420 to 441
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xc0) << 4);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 421 to 442
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xe0) << 5);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 421 to 442
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xe0) << 5);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 422 to 443
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xf0) << 6);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 422 to 443
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xf0) << 6);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 423 to 444
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xf8) << 7);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 423 to 444
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xf8) << 7);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 424 to 445
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xfc) << 8);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 424 to 445
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xfc) << 8);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 425 to 446
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xfe) << 9);
	output[19] = (double)(value >> 10);
}

static void unpack_20_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 20 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 440 bits of data.
	// Input must be at least 56 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 425 to 446
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xfe) << 9);
	output[19] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 462 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 440 to 461
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xfc) << 8);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 462 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 440 to 461
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xfc) << 8);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 462 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 441 to 462
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xfe) << 9);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 462 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 441 to 462
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xfe) << 9);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 462 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 420 to 441
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xc0) << 4);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 442 to 463
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 462 bits of data.
	// Input must be at least 58 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 420 to 441
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xc0) << 4);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 442 to 463
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 421 to 442
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xe0) << 5);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 443 to 464
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0x80) << 3);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 421 to 442
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xe0) << 5);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 443 to 464
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0x80) << 3);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 422 to 443
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xf0) << 6);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 444 to 465
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xc0) << 4);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 422 to 443
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xf0) << 6);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 444 to 465
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xc0) << 4);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 423 to 444
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xf8) << 7);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 445 to 466
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xe0) << 5);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 423 to 444
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xf8) << 7);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 445 to 466
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xe0) << 5);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 424 to 445
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xfc) << 8);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 446 to 467
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)(input[58] & 0xf0) << 6);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 424 to 445
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xfc) << 8);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 446 to 467
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)(input[58] & 0xf0) << 6);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 425 to 446
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xfe) << 9);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 447 to 468
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)(input[58] & 0xf8) << 7);
	output[20] = (double)(value >> 10);
}

static void unpack_21_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 21 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 462 bits of data.
	// Input must be at least 59 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 425 to 446
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xfe) << 9);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 447 to 468
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)(input[58] & 0xf8) << 7);
	output[20] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 440 to 461
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xfc) << 8);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 462 to 483
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xf0) << 6);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 440 to 461
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xfc) << 8);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 462 to 483
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xf0) << 6);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 441 to 462
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xfe) << 9);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 463 to 484
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xf8) << 7);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 441 to 462
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xfe) << 9);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 463 to 484
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xf8) << 7);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 2 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 420 to 441
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xc0) << 4);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 442 to 463
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 464 to 485
	value = ((uint32_t)input[58] << 24) |
			((uint32_t)input[59] << 16) |
			((uint32_t)(input[60] & 0xfc) << 8);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_2off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 2 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 2 to 23
	value = ((uint32_t)(input[0] & 0x3f) << 26) |
			((uint32_t)input[1] << 18) |
			((uint32_t)input[2] << 10);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 24 to 45
	value = ((uint32_t)input[3] << 24) |
			((uint32_t)input[4] << 16) |
			((uint32_t)(input[5] & 0xfc) << 8);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 46 to 67
	value = ((uint32_t)(input[5] & 0x03) << 30) |
			((uint32_t)input[6] << 22) |
			((uint32_t)input[7] << 14) |
			((uint32_t)(input[8] & 0xf0) << 6);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 68 to 89
	value = ((uint32_t)(input[8] & 0x0f) << 28) |
			((uint32_t)input[9] << 20) |
			((uint32_t)input[10] << 12) |
			((uint32_t)(input[11] & 0xc0) << 4);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 90 to 111
	value = ((uint32_t)(input[11] & 0x3f) << 26) |
			((uint32_t)input[12] << 18) |
			((uint32_t)input[13] << 10);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 112 to 133
	value = ((uint32_t)input[14] << 24) |
			((uint32_t)input[15] << 16) |
			((uint32_t)(input[16] & 0xfc) << 8);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 134 to 155
	value = ((uint32_t)(input[16] & 0x03) << 30) |
			((uint32_t)input[17] << 22) |
			((uint32_t)input[18] << 14) |
			((uint32_t)(input[19] & 0xf0) << 6);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 156 to 177
	value = ((uint32_t)(input[19] & 0x0f) << 28) |
			((uint32_t)input[20] << 20) |
			((uint32_t)input[21] << 12) |
			((uint32_t)(input[22] & 0xc0) << 4);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 178 to 199
	value = ((uint32_t)(input[22] & 0x3f) << 26) |
			((uint32_t)input[23] << 18) |
			((uint32_t)input[24] << 10);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 200 to 221
	value = ((uint32_t)input[25] << 24) |
			((uint32_t)input[26] << 16) |
			((uint32_t)(input[27] & 0xfc) << 8);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 222 to 243
	value = ((uint32_t)(input[27] & 0x03) << 30) |
			((uint32_t)input[28] << 22) |
			((uint32_t)input[29] << 14) |
			((uint32_t)(input[30] & 0xf0) << 6);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 244 to 265
	value = ((uint32_t)(input[30] & 0x0f) << 28) |
			((uint32_t)input[31] << 20) |
			((uint32_t)input[32] << 12) |
			((uint32_t)(input[33] & 0xc0) << 4);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 266 to 287
	value = ((uint32_t)(input[33] & 0x3f) << 26) |
			((uint32_t)input[34] << 18) |
			((uint32_t)input[35] << 10);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 288 to 309
	value = ((uint32_t)input[36] << 24) |
			((uint32_t)input[37] << 16) |
			((uint32_t)(input[38] & 0xfc) << 8);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 310 to 331
	value = ((uint32_t)(input[38] & 0x03) << 30) |
			((uint32_t)input[39] << 22) |
			((uint32_t)input[40] << 14) |
			((uint32_t)(input[41] & 0xf0) << 6);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 332 to 353
	value = ((uint32_t)(input[41] & 0x0f) << 28) |
			((uint32_t)input[42] << 20) |
			((uint32_t)input[43] << 12) |
			((uint32_t)(input[44] & 0xc0) << 4);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 354 to 375
	value = ((uint32_t)(input[44] & 0x3f) << 26) |
			((uint32_t)input[45] << 18) |
			((uint32_t)input[46] << 10);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 376 to 397
	value = ((uint32_t)input[47] << 24) |
			((uint32_t)input[48] << 16) |
			((uint32_t)(input[49] & 0xfc) << 8);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 398 to 419
	value = ((uint32_t)(input[49] & 0x03) << 30) |
			((uint32_t)input[50] << 22) |
			((uint32_t)input[51] << 14) |
			((uint32_t)(input[52] & 0xf0) << 6);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 420 to 441
	value = ((uint32_t)(input[52] & 0x0f) << 28) |
			((uint32_t)input[53] << 20) |
			((uint32_t)input[54] << 12) |
			((uint32_t)(input[55] & 0xc0) << 4);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 442 to 463
	value = ((uint32_t)(input[55] & 0x3f) << 26) |
			((uint32_t)input[56] << 18) |
			((uint32_t)input[57] << 10);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 464 to 485
	value = ((uint32_t)input[58] << 24) |
			((uint32_t)input[59] << 16) |
			((uint32_t)(input[60] & 0xfc) << 8);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 3 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 421 to 442
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xe0) << 5);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 443 to 464
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0x80) << 3);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 465 to 486
	value = ((uint32_t)(input[58] & 0x7f) << 25) |
			((uint32_t)input[59] << 17) |
			((uint32_t)(input[60] & 0xfe) << 9);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_3off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 3 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 3 to 24
	value = ((uint32_t)(input[0] & 0x1f) << 27) |
			((uint32_t)input[1] << 19) |
			((uint32_t)input[2] << 11) |
			((uint32_t)(input[3] & 0x80) << 3);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 25 to 46
	value = ((uint32_t)(input[3] & 0x7f) << 25) |
			((uint32_t)input[4] << 17) |
			((uint32_t)(input[5] & 0xfe) << 9);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 47 to 68
	value = ((uint32_t)(input[5] & 0x01) << 31) |
			((uint32_t)input[6] << 23) |
			((uint32_t)input[7] << 15) |
			((uint32_t)(input[8] & 0xf8) << 7);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 69 to 90
	value = ((uint32_t)(input[8] & 0x07) << 29) |
			((uint32_t)input[9] << 21) |
			((uint32_t)input[10] << 13) |
			((uint32_t)(input[11] & 0xe0) << 5);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 91 to 112
	value = ((uint32_t)(input[11] & 0x1f) << 27) |
			((uint32_t)input[12] << 19) |
			((uint32_t)input[13] << 11) |
			((uint32_t)(input[14] & 0x80) << 3);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 113 to 134
	value = ((uint32_t)(input[14] & 0x7f) << 25) |
			((uint32_t)input[15] << 17) |
			((uint32_t)(input[16] & 0xfe) << 9);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 135 to 156
	value = ((uint32_t)(input[16] & 0x01) << 31) |
			((uint32_t)input[17] << 23) |
			((uint32_t)input[18] << 15) |
			((uint32_t)(input[19] & 0xf8) << 7);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 157 to 178
	value = ((uint32_t)(input[19] & 0x07) << 29) |
			((uint32_t)input[20] << 21) |
			((uint32_t)input[21] << 13) |
			((uint32_t)(input[22] & 0xe0) << 5);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 179 to 200
	value = ((uint32_t)(input[22] & 0x1f) << 27) |
			((uint32_t)input[23] << 19) |
			((uint32_t)input[24] << 11) |
			((uint32_t)(input[25] & 0x80) << 3);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 201 to 222
	value = ((uint32_t)(input[25] & 0x7f) << 25) |
			((uint32_t)input[26] << 17) |
			((uint32_t)(input[27] & 0xfe) << 9);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 223 to 244
	value = ((uint32_t)(input[27] & 0x01) << 31) |
			((uint32_t)input[28] << 23) |
			((uint32_t)input[29] << 15) |
			((uint32_t)(input[30] & 0xf8) << 7);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 245 to 266
	value = ((uint32_t)(input[30] & 0x07) << 29) |
			((uint32_t)input[31] << 21) |
			((uint32_t)input[32] << 13) |
			((uint32_t)(input[33] & 0xe0) << 5);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 267 to 288
	value = ((uint32_t)(input[33] & 0x1f) << 27) |
			((uint32_t)input[34] << 19) |
			((uint32_t)input[35] << 11) |
			((uint32_t)(input[36] & 0x80) << 3);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 289 to 310
	value = ((uint32_t)(input[36] & 0x7f) << 25) |
			((uint32_t)input[37] << 17) |
			((uint32_t)(input[38] & 0xfe) << 9);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 311 to 332
	value = ((uint32_t)(input[38] & 0x01) << 31) |
			((uint32_t)input[39] << 23) |
			((uint32_t)input[40] << 15) |
			((uint32_t)(input[41] & 0xf8) << 7);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 333 to 354
	value = ((uint32_t)(input[41] & 0x07) << 29) |
			((uint32_t)input[42] << 21) |
			((uint32_t)input[43] << 13) |
			((uint32_t)(input[44] & 0xe0) << 5);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 355 to 376
	value = ((uint32_t)(input[44] & 0x1f) << 27) |
			((uint32_t)input[45] << 19) |
			((uint32_t)input[46] << 11) |
			((uint32_t)(input[47] & 0x80) << 3);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 377 to 398
	value = ((uint32_t)(input[47] & 0x7f) << 25) |
			((uint32_t)input[48] << 17) |
			((uint32_t)(input[49] & 0xfe) << 9);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 399 to 420
	value = ((uint32_t)(input[49] & 0x01) << 31) |
			((uint32_t)input[50] << 23) |
			((uint32_t)input[51] << 15) |
			((uint32_t)(input[52] & 0xf8) << 7);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 421 to 442
	value = ((uint32_t)(input[52] & 0x07) << 29) |
			((uint32_t)input[53] << 21) |
			((uint32_t)input[54] << 13) |
			((uint32_t)(input[55] & 0xe0) << 5);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 443 to 464
	value = ((uint32_t)(input[55] & 0x1f) << 27) |
			((uint32_t)input[56] << 19) |
			((uint32_t)input[57] << 11) |
			((uint32_t)(input[58] & 0x80) << 3);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 465 to 486
	value = ((uint32_t)(input[58] & 0x7f) << 25) |
			((uint32_t)input[59] << 17) |
			((uint32_t)(input[60] & 0xfe) << 9);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 4 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 422 to 443
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xf0) << 6);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 444 to 465
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xc0) << 4);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 466 to 487
	value = ((uint32_t)(input[58] & 0x3f) << 26) |
			((uint32_t)input[59] << 18) |
			((uint32_t)input[60] << 10);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_4off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 4 bits, read 484 bits of data.
	// Input must be at least 61 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 4 to 25
	value = ((uint32_t)(input[0] & 0x0f) << 28) |
			((uint32_t)input[1] << 20) |
			((uint32_t)input[2] << 12) |
			((uint32_t)(input[3] & 0xc0) << 4);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 26 to 47
	value = ((uint32_t)(input[3] & 0x3f) << 26) |
			((uint32_t)input[4] << 18) |
			((uint32_t)input[5] << 10);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 48 to 69
	value = ((uint32_t)input[6] << 24) |
			((uint32_t)input[7] << 16) |
			((uint32_t)(input[8] & 0xfc) << 8);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 70 to 91
	value = ((uint32_t)(input[8] & 0x03) << 30) |
			((uint32_t)input[9] << 22) |
			((uint32_t)input[10] << 14) |
			((uint32_t)(input[11] & 0xf0) << 6);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 92 to 113
	value = ((uint32_t)(input[11] & 0x0f) << 28) |
			((uint32_t)input[12] << 20) |
			((uint32_t)input[13] << 12) |
			((uint32_t)(input[14] & 0xc0) << 4);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 114 to 135
	value = ((uint32_t)(input[14] & 0x3f) << 26) |
			((uint32_t)input[15] << 18) |
			((uint32_t)input[16] << 10);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 136 to 157
	value = ((uint32_t)input[17] << 24) |
			((uint32_t)input[18] << 16) |
			((uint32_t)(input[19] & 0xfc) << 8);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 158 to 179
	value = ((uint32_t)(input[19] & 0x03) << 30) |
			((uint32_t)input[20] << 22) |
			((uint32_t)input[21] << 14) |
			((uint32_t)(input[22] & 0xf0) << 6);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 180 to 201
	value = ((uint32_t)(input[22] & 0x0f) << 28) |
			((uint32_t)input[23] << 20) |
			((uint32_t)input[24] << 12) |
			((uint32_t)(input[25] & 0xc0) << 4);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 202 to 223
	value = ((uint32_t)(input[25] & 0x3f) << 26) |
			((uint32_t)input[26] << 18) |
			((uint32_t)input[27] << 10);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 224 to 245
	value = ((uint32_t)input[28] << 24) |
			((uint32_t)input[29] << 16) |
			((uint32_t)(input[30] & 0xfc) << 8);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 246 to 267
	value = ((uint32_t)(input[30] & 0x03) << 30) |
			((uint32_t)input[31] << 22) |
			((uint32_t)input[32] << 14) |
			((uint32_t)(input[33] & 0xf0) << 6);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 268 to 289
	value = ((uint32_t)(input[33] & 0x0f) << 28) |
			((uint32_t)input[34] << 20) |
			((uint32_t)input[35] << 12) |
			((uint32_t)(input[36] & 0xc0) << 4);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 290 to 311
	value = ((uint32_t)(input[36] & 0x3f) << 26) |
			((uint32_t)input[37] << 18) |
			((uint32_t)input[38] << 10);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 312 to 333
	value = ((uint32_t)input[39] << 24) |
			((uint32_t)input[40] << 16) |
			((uint32_t)(input[41] & 0xfc) << 8);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 334 to 355
	value = ((uint32_t)(input[41] & 0x03) << 30) |
			((uint32_t)input[42] << 22) |
			((uint32_t)input[43] << 14) |
			((uint32_t)(input[44] & 0xf0) << 6);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 356 to 377
	value = ((uint32_t)(input[44] & 0x0f) << 28) |
			((uint32_t)input[45] << 20) |
			((uint32_t)input[46] << 12) |
			((uint32_t)(input[47] & 0xc0) << 4);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 378 to 399
	value = ((uint32_t)(input[47] & 0x3f) << 26) |
			((uint32_t)input[48] << 18) |
			((uint32_t)input[49] << 10);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 400 to 421
	value = ((uint32_t)input[50] << 24) |
			((uint32_t)input[51] << 16) |
			((uint32_t)(input[52] & 0xfc) << 8);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 422 to 443
	value = ((uint32_t)(input[52] & 0x03) << 30) |
			((uint32_t)input[53] << 22) |
			((uint32_t)input[54] << 14) |
			((uint32_t)(input[55] & 0xf0) << 6);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 444 to 465
	value = ((uint32_t)(input[55] & 0x0f) << 28) |
			((uint32_t)input[56] << 20) |
			((uint32_t)input[57] << 12) |
			((uint32_t)(input[58] & 0xc0) << 4);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 466 to 487
	value = ((uint32_t)(input[58] & 0x3f) << 26) |
			((uint32_t)input[59] << 18) |
			((uint32_t)input[60] << 10);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 5 bits, read 484 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 423 to 444
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xf8) << 7);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 445 to 466
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xe0) << 5);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 467 to 488
	value = ((uint32_t)(input[58] & 0x1f) << 27) |
			((uint32_t)input[59] << 19) |
			((uint32_t)input[60] << 11) |
			((uint32_t)(input[61] & 0x80) << 3);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_5off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 5 bits, read 484 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 5 to 26
	value = ((uint32_t)(input[0] & 0x07) << 29) |
			((uint32_t)input[1] << 21) |
			((uint32_t)input[2] << 13) |
			((uint32_t)(input[3] & 0xe0) << 5);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 27 to 48
	value = ((uint32_t)(input[3] & 0x1f) << 27) |
			((uint32_t)input[4] << 19) |
			((uint32_t)input[5] << 11) |
			((uint32_t)(input[6] & 0x80) << 3);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 49 to 70
	value = ((uint32_t)(input[6] & 0x7f) << 25) |
			((uint32_t)input[7] << 17) |
			((uint32_t)(input[8] & 0xfe) << 9);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 71 to 92
	value = ((uint32_t)(input[8] & 0x01) << 31) |
			((uint32_t)input[9] << 23) |
			((uint32_t)input[10] << 15) |
			((uint32_t)(input[11] & 0xf8) << 7);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 93 to 114
	value = ((uint32_t)(input[11] & 0x07) << 29) |
			((uint32_t)input[12] << 21) |
			((uint32_t)input[13] << 13) |
			((uint32_t)(input[14] & 0xe0) << 5);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 115 to 136
	value = ((uint32_t)(input[14] & 0x1f) << 27) |
			((uint32_t)input[15] << 19) |
			((uint32_t)input[16] << 11) |
			((uint32_t)(input[17] & 0x80) << 3);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 137 to 158
	value = ((uint32_t)(input[17] & 0x7f) << 25) |
			((uint32_t)input[18] << 17) |
			((uint32_t)(input[19] & 0xfe) << 9);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 159 to 180
	value = ((uint32_t)(input[19] & 0x01) << 31) |
			((uint32_t)input[20] << 23) |
			((uint32_t)input[21] << 15) |
			((uint32_t)(input[22] & 0xf8) << 7);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 181 to 202
	value = ((uint32_t)(input[22] & 0x07) << 29) |
			((uint32_t)input[23] << 21) |
			((uint32_t)input[24] << 13) |
			((uint32_t)(input[25] & 0xe0) << 5);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 203 to 224
	value = ((uint32_t)(input[25] & 0x1f) << 27) |
			((uint32_t)input[26] << 19) |
			((uint32_t)input[27] << 11) |
			((uint32_t)(input[28] & 0x80) << 3);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 225 to 246
	value = ((uint32_t)(input[28] & 0x7f) << 25) |
			((uint32_t)input[29] << 17) |
			((uint32_t)(input[30] & 0xfe) << 9);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 247 to 268
	value = ((uint32_t)(input[30] & 0x01) << 31) |
			((uint32_t)input[31] << 23) |
			((uint32_t)input[32] << 15) |
			((uint32_t)(input[33] & 0xf8) << 7);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 269 to 290
	value = ((uint32_t)(input[33] & 0x07) << 29) |
			((uint32_t)input[34] << 21) |
			((uint32_t)input[35] << 13) |
			((uint32_t)(input[36] & 0xe0) << 5);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 291 to 312
	value = ((uint32_t)(input[36] & 0x1f) << 27) |
			((uint32_t)input[37] << 19) |
			((uint32_t)input[38] << 11) |
			((uint32_t)(input[39] & 0x80) << 3);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 313 to 334
	value = ((uint32_t)(input[39] & 0x7f) << 25) |
			((uint32_t)input[40] << 17) |
			((uint32_t)(input[41] & 0xfe) << 9);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 335 to 356
	value = ((uint32_t)(input[41] & 0x01) << 31) |
			((uint32_t)input[42] << 23) |
			((uint32_t)input[43] << 15) |
			((uint32_t)(input[44] & 0xf8) << 7);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 357 to 378
	value = ((uint32_t)(input[44] & 0x07) << 29) |
			((uint32_t)input[45] << 21) |
			((uint32_t)input[46] << 13) |
			((uint32_t)(input[47] & 0xe0) << 5);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 379 to 400
	value = ((uint32_t)(input[47] & 0x1f) << 27) |
			((uint32_t)input[48] << 19) |
			((uint32_t)input[49] << 11) |
			((uint32_t)(input[50] & 0x80) << 3);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 401 to 422
	value = ((uint32_t)(input[50] & 0x7f) << 25) |
			((uint32_t)input[51] << 17) |
			((uint32_t)(input[52] & 0xfe) << 9);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 423 to 444
	value = ((uint32_t)(input[52] & 0x01) << 31) |
			((uint32_t)input[53] << 23) |
			((uint32_t)input[54] << 15) |
			((uint32_t)(input[55] & 0xf8) << 7);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 445 to 466
	value = ((uint32_t)(input[55] & 0x07) << 29) |
			((uint32_t)input[56] << 21) |
			((uint32_t)input[57] << 13) |
			((uint32_t)(input[58] & 0xe0) << 5);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 467 to 488
	value = ((uint32_t)(input[58] & 0x1f) << 27) |
			((uint32_t)input[59] << 19) |
			((uint32_t)input[60] << 11) |
			((uint32_t)(input[61] & 0x80) << 3);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 6 bits, read 484 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 424 to 445
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xfc) << 8);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 446 to 467
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)(input[58] & 0xf0) << 6);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 468 to 489
	value = ((uint32_t)(input[58] & 0x0f) << 28) |
			((uint32_t)input[59] << 20) |
			((uint32_t)input[60] << 12) |
			((uint32_t)(input[61] & 0xc0) << 4);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_6off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 6 bits, read 484 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 6 to 27
	value = ((uint32_t)(input[0] & 0x03) << 30) |
			((uint32_t)input[1] << 22) |
			((uint32_t)input[2] << 14) |
			((uint32_t)(input[3] & 0xf0) << 6);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 28 to 49
	value = ((uint32_t)(input[3] & 0x0f) << 28) |
			((uint32_t)input[4] << 20) |
			((uint32_t)input[5] << 12) |
			((uint32_t)(input[6] & 0xc0) << 4);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 50 to 71
	value = ((uint32_t)(input[6] & 0x3f) << 26) |
			((uint32_t)input[7] << 18) |
			((uint32_t)input[8] << 10);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 72 to 93
	value = ((uint32_t)input[9] << 24) |
			((uint32_t)input[10] << 16) |
			((uint32_t)(input[11] & 0xfc) << 8);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 94 to 115
	value = ((uint32_t)(input[11] & 0x03) << 30) |
			((uint32_t)input[12] << 22) |
			((uint32_t)input[13] << 14) |
			((uint32_t)(input[14] & 0xf0) << 6);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 116 to 137
	value = ((uint32_t)(input[14] & 0x0f) << 28) |
			((uint32_t)input[15] << 20) |
			((uint32_t)input[16] << 12) |
			((uint32_t)(input[17] & 0xc0) << 4);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 138 to 159
	value = ((uint32_t)(input[17] & 0x3f) << 26) |
			((uint32_t)input[18] << 18) |
			((uint32_t)input[19] << 10);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 160 to 181
	value = ((uint32_t)input[20] << 24) |
			((uint32_t)input[21] << 16) |
			((uint32_t)(input[22] & 0xfc) << 8);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 182 to 203
	value = ((uint32_t)(input[22] & 0x03) << 30) |
			((uint32_t)input[23] << 22) |
			((uint32_t)input[24] << 14) |
			((uint32_t)(input[25] & 0xf0) << 6);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 204 to 225
	value = ((uint32_t)(input[25] & 0x0f) << 28) |
			((uint32_t)input[26] << 20) |
			((uint32_t)input[27] << 12) |
			((uint32_t)(input[28] & 0xc0) << 4);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 226 to 247
	value = ((uint32_t)(input[28] & 0x3f) << 26) |
			((uint32_t)input[29] << 18) |
			((uint32_t)input[30] << 10);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 248 to 269
	value = ((uint32_t)input[31] << 24) |
			((uint32_t)input[32] << 16) |
			((uint32_t)(input[33] & 0xfc) << 8);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 270 to 291
	value = ((uint32_t)(input[33] & 0x03) << 30) |
			((uint32_t)input[34] << 22) |
			((uint32_t)input[35] << 14) |
			((uint32_t)(input[36] & 0xf0) << 6);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 292 to 313
	value = ((uint32_t)(input[36] & 0x0f) << 28) |
			((uint32_t)input[37] << 20) |
			((uint32_t)input[38] << 12) |
			((uint32_t)(input[39] & 0xc0) << 4);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 314 to 335
	value = ((uint32_t)(input[39] & 0x3f) << 26) |
			((uint32_t)input[40] << 18) |
			((uint32_t)input[41] << 10);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 336 to 357
	value = ((uint32_t)input[42] << 24) |
			((uint32_t)input[43] << 16) |
			((uint32_t)(input[44] & 0xfc) << 8);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 358 to 379
	value = ((uint32_t)(input[44] & 0x03) << 30) |
			((uint32_t)input[45] << 22) |
			((uint32_t)input[46] << 14) |
			((uint32_t)(input[47] & 0xf0) << 6);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 380 to 401
	value = ((uint32_t)(input[47] & 0x0f) << 28) |
			((uint32_t)input[48] << 20) |
			((uint32_t)input[49] << 12) |
			((uint32_t)(input[50] & 0xc0) << 4);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 402 to 423
	value = ((uint32_t)(input[50] & 0x3f) << 26) |
			((uint32_t)input[51] << 18) |
			((uint32_t)input[52] << 10);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 424 to 445
	value = ((uint32_t)input[53] << 24) |
			((uint32_t)input[54] << 16) |
			((uint32_t)(input[55] & 0xfc) << 8);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 446 to 467
	value = ((uint32_t)(input[55] & 0x03) << 30) |
			((uint32_t)input[56] << 22) |
			((uint32_t)input[57] << 14) |
			((uint32_t)(input[58] & 0xf0) << 6);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 468 to 489
	value = ((uint32_t)(input[58] & 0x0f) << 28) |
			((uint32_t)input[59] << 20) |
			((uint32_t)input[60] << 12) |
			((uint32_t)(input[61] & 0xc0) << 4);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_signed_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit signed
	// Skip 7 bits, read 484 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 425 to 446
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xfe) << 9);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 447 to 468
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)(input[58] & 0xf8) << 7);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 469 to 490
	value = ((uint32_t)(input[58] & 0x07) << 29) |
			((uint32_t)input[59] << 21) |
			((uint32_t)input[60] << 13) |
			((uint32_t)(input[61] & 0xe0) << 5);
	output[21] = (double)(value >> 10);
}

static void unpack_22_22bit_unsigned_7off(const uint8_t * input, double * output, void *closure) {
	// Unpack 22 values into output
	// Values are 22-bit unsigned
	// Skip 7 bits, read 484 bits of data.
	// Input must be at least 62 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 7 to 28
	value = ((uint32_t)(input[0] & 0x01) << 31) |
			((uint32_t)input[1] << 23) |
			((uint32_t)input[2] << 15) |
			((uint32_t)(input[3] & 0xf8) << 7);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 29 to 50
	value = ((uint32_t)(input[3] & 0x07) << 29) |
			((uint32_t)input[4] << 21) |
			((uint32_t)input[5] << 13) |
			((uint32_t)(input[6] & 0xe0) << 5);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 51 to 72
	value = ((uint32_t)(input[6] & 0x1f) << 27) |
			((uint32_t)input[7] << 19) |
			((uint32_t)input[8] << 11) |
			((uint32_t)(input[9] & 0x80) << 3);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 73 to 94
	value = ((uint32_t)(input[9] & 0x7f) << 25) |
			((uint32_t)input[10] << 17) |
			((uint32_t)(input[11] & 0xfe) << 9);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 95 to 116
	value = ((uint32_t)(input[11] & 0x01) << 31) |
			((uint32_t)input[12] << 23) |
			((uint32_t)input[13] << 15) |
			((uint32_t)(input[14] & 0xf8) << 7);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 117 to 138
	value = ((uint32_t)(input[14] & 0x07) << 29) |
			((uint32_t)input[15] << 21) |
			((uint32_t)input[16] << 13) |
			((uint32_t)(input[17] & 0xe0) << 5);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 139 to 160
	value = ((uint32_t)(input[17] & 0x1f) << 27) |
			((uint32_t)input[18] << 19) |
			((uint32_t)input[19] << 11) |
			((uint32_t)(input[20] & 0x80) << 3);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 161 to 182
	value = ((uint32_t)(input[20] & 0x7f) << 25) |
			((uint32_t)input[21] << 17) |
			((uint32_t)(input[22] & 0xfe) << 9);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 183 to 204
	value = ((uint32_t)(input[22] & 0x01) << 31) |
			((uint32_t)input[23] << 23) |
			((uint32_t)input[24] << 15) |
			((uint32_t)(input[25] & 0xf8) << 7);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 205 to 226
	value = ((uint32_t)(input[25] & 0x07) << 29) |
			((uint32_t)input[26] << 21) |
			((uint32_t)input[27] << 13) |
			((uint32_t)(input[28] & 0xe0) << 5);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 227 to 248
	value = ((uint32_t)(input[28] & 0x1f) << 27) |
			((uint32_t)input[29] << 19) |
			((uint32_t)input[30] << 11) |
			((uint32_t)(input[31] & 0x80) << 3);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 249 to 270
	value = ((uint32_t)(input[31] & 0x7f) << 25) |
			((uint32_t)input[32] << 17) |
			((uint32_t)(input[33] & 0xfe) << 9);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 271 to 292
	value = ((uint32_t)(input[33] & 0x01) << 31) |
			((uint32_t)input[34] << 23) |
			((uint32_t)input[35] << 15) |
			((uint32_t)(input[36] & 0xf8) << 7);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 293 to 314
	value = ((uint32_t)(input[36] & 0x07) << 29) |
			((uint32_t)input[37] << 21) |
			((uint32_t)input[38] << 13) |
			((uint32_t)(input[39] & 0xe0) << 5);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 315 to 336
	value = ((uint32_t)(input[39] & 0x1f) << 27) |
			((uint32_t)input[40] << 19) |
			((uint32_t)input[41] << 11) |
			((uint32_t)(input[42] & 0x80) << 3);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 337 to 358
	value = ((uint32_t)(input[42] & 0x7f) << 25) |
			((uint32_t)input[43] << 17) |
			((uint32_t)(input[44] & 0xfe) << 9);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 359 to 380
	value = ((uint32_t)(input[44] & 0x01) << 31) |
			((uint32_t)input[45] << 23) |
			((uint32_t)input[46] << 15) |
			((uint32_t)(input[47] & 0xf8) << 7);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 381 to 402
	value = ((uint32_t)(input[47] & 0x07) << 29) |
			((uint32_t)input[48] << 21) |
			((uint32_t)input[49] << 13) |
			((uint32_t)(input[50] & 0xe0) << 5);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 403 to 424
	value = ((uint32_t)(input[50] & 0x1f) << 27) |
			((uint32_t)input[51] << 19) |
			((uint32_t)input[52] << 11) |
			((uint32_t)(input[53] & 0x80) << 3);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 425 to 446
	value = ((uint32_t)(input[53] & 0x7f) << 25) |
			((uint32_t)input[54] << 17) |
			((uint32_t)(input[55] & 0xfe) << 9);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 447 to 468
	value = ((uint32_t)(input[55] & 0x01) << 31) |
			((uint32_t)input[56] << 23) |
			((uint32_t)input[57] << 15) |
			((uint32_t)(input[58] & 0xf8) << 7);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 469 to 490
	value = ((uint32_t)(input[58] & 0x07) << 29) |
			((uint32_t)input[59] << 21) |
			((uint32_t)input[60] << 13) |
			((uint32_t)(input[61] & 0xe0) << 5);
	output[21] = (double)(value >> 10);
}

static void unpack_23_22bit_signed_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 22-bit signed
	// Skip 0 bits, read 506 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 440 to 461
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xfc) << 8);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 462 to 483
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xf0) << 6);
	output[21] = (double)(value >> 10);

	// read output[22]: from bit 484 to 505
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)(input[63] & 0xc0) << 4);
	output[22] = (double)(value >> 10);
}

static void unpack_23_22bit_unsigned_0off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 22-bit unsigned
	// Skip 0 bits, read 506 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 0 to 21
	value = ((uint32_t)input[0] << 24) |
			((uint32_t)input[1] << 16) |
			((uint32_t)(input[2] & 0xfc) << 8);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 22 to 43
	value = ((uint32_t)(input[2] & 0x03) << 30) |
			((uint32_t)input[3] << 22) |
			((uint32_t)input[4] << 14) |
			((uint32_t)(input[5] & 0xf0) << 6);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 44 to 65
	value = ((uint32_t)(input[5] & 0x0f) << 28) |
			((uint32_t)input[6] << 20) |
			((uint32_t)input[7] << 12) |
			((uint32_t)(input[8] & 0xc0) << 4);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 66 to 87
	value = ((uint32_t)(input[8] & 0x3f) << 26) |
			((uint32_t)input[9] << 18) |
			((uint32_t)input[10] << 10);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 88 to 109
	value = ((uint32_t)input[11] << 24) |
			((uint32_t)input[12] << 16) |
			((uint32_t)(input[13] & 0xfc) << 8);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 110 to 131
	value = ((uint32_t)(input[13] & 0x03) << 30) |
			((uint32_t)input[14] << 22) |
			((uint32_t)input[15] << 14) |
			((uint32_t)(input[16] & 0xf0) << 6);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 132 to 153
	value = ((uint32_t)(input[16] & 0x0f) << 28) |
			((uint32_t)input[17] << 20) |
			((uint32_t)input[18] << 12) |
			((uint32_t)(input[19] & 0xc0) << 4);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 154 to 175
	value = ((uint32_t)(input[19] & 0x3f) << 26) |
			((uint32_t)input[20] << 18) |
			((uint32_t)input[21] << 10);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 176 to 197
	value = ((uint32_t)input[22] << 24) |
			((uint32_t)input[23] << 16) |
			((uint32_t)(input[24] & 0xfc) << 8);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 198 to 219
	value = ((uint32_t)(input[24] & 0x03) << 30) |
			((uint32_t)input[25] << 22) |
			((uint32_t)input[26] << 14) |
			((uint32_t)(input[27] & 0xf0) << 6);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 220 to 241
	value = ((uint32_t)(input[27] & 0x0f) << 28) |
			((uint32_t)input[28] << 20) |
			((uint32_t)input[29] << 12) |
			((uint32_t)(input[30] & 0xc0) << 4);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 242 to 263
	value = ((uint32_t)(input[30] & 0x3f) << 26) |
			((uint32_t)input[31] << 18) |
			((uint32_t)input[32] << 10);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 264 to 285
	value = ((uint32_t)input[33] << 24) |
			((uint32_t)input[34] << 16) |
			((uint32_t)(input[35] & 0xfc) << 8);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 286 to 307
	value = ((uint32_t)(input[35] & 0x03) << 30) |
			((uint32_t)input[36] << 22) |
			((uint32_t)input[37] << 14) |
			((uint32_t)(input[38] & 0xf0) << 6);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 308 to 329
	value = ((uint32_t)(input[38] & 0x0f) << 28) |
			((uint32_t)input[39] << 20) |
			((uint32_t)input[40] << 12) |
			((uint32_t)(input[41] & 0xc0) << 4);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 330 to 351
	value = ((uint32_t)(input[41] & 0x3f) << 26) |
			((uint32_t)input[42] << 18) |
			((uint32_t)input[43] << 10);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 352 to 373
	value = ((uint32_t)input[44] << 24) |
			((uint32_t)input[45] << 16) |
			((uint32_t)(input[46] & 0xfc) << 8);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 374 to 395
	value = ((uint32_t)(input[46] & 0x03) << 30) |
			((uint32_t)input[47] << 22) |
			((uint32_t)input[48] << 14) |
			((uint32_t)(input[49] & 0xf0) << 6);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 396 to 417
	value = ((uint32_t)(input[49] & 0x0f) << 28) |
			((uint32_t)input[50] << 20) |
			((uint32_t)input[51] << 12) |
			((uint32_t)(input[52] & 0xc0) << 4);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 418 to 439
	value = ((uint32_t)(input[52] & 0x3f) << 26) |
			((uint32_t)input[53] << 18) |
			((uint32_t)input[54] << 10);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 440 to 461
	value = ((uint32_t)input[55] << 24) |
			((uint32_t)input[56] << 16) |
			((uint32_t)(input[57] & 0xfc) << 8);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 462 to 483
	value = ((uint32_t)(input[57] & 0x03) << 30) |
			((uint32_t)input[58] << 22) |
			((uint32_t)input[59] << 14) |
			((uint32_t)(input[60] & 0xf0) << 6);
	output[21] = (double)(value >> 10);

	// read output[22]: from bit 484 to 505
	value = ((uint32_t)(input[60] & 0x0f) << 28) |
			((uint32_t)input[61] << 20) |
			((uint32_t)input[62] << 12) |
			((uint32_t)(input[63] & 0xc0) << 4);
	output[22] = (double)(value >> 10);
}

static void unpack_23_22bit_signed_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 22-bit signed
	// Skip 1 bits, read 506 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	int32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = ((uint32_t)(input[16] & 0x07) << 29) |
			((uint32_t)input[17] << 21) |
			((uint32_t)input[18] << 13) |
			((uint32_t)(input[19] & 0xe0) << 5);
	output[6] = (double)(value >> 10);

	// read output[7]: from bit 155 to 176
	value = ((uint32_t)(input[19] & 0x1f) << 27) |
			((uint32_t)input[20] << 19) |
			((uint32_t)input[21] << 11) |
			((uint32_t)(input[22] & 0x80) << 3);
	output[7] = (double)(value >> 10);

	// read output[8]: from bit 177 to 198
	value = ((uint32_t)(input[22] & 0x7f) << 25) |
			((uint32_t)input[23] << 17) |
			((uint32_t)(input[24] & 0xfe) << 9);
	output[8] = (double)(value >> 10);

	// read output[9]: from bit 199 to 220
	value = ((uint32_t)(input[24] & 0x01) << 31) |
			((uint32_t)input[25] << 23) |
			((uint32_t)input[26] << 15) |
			((uint32_t)(input[27] & 0xf8) << 7);
	output[9] = (double)(value >> 10);

	// read output[10]: from bit 221 to 242
	value = ((uint32_t)(input[27] & 0x07) << 29) |
			((uint32_t)input[28] << 21) |
			((uint32_t)input[29] << 13) |
			((uint32_t)(input[30] & 0xe0) << 5);
	output[10] = (double)(value >> 10);

	// read output[11]: from bit 243 to 264
	value = ((uint32_t)(input[30] & 0x1f) << 27) |
			((uint32_t)input[31] << 19) |
			((uint32_t)input[32] << 11) |
			((uint32_t)(input[33] & 0x80) << 3);
	output[11] = (double)(value >> 10);

	// read output[12]: from bit 265 to 286
	value = ((uint32_t)(input[33] & 0x7f) << 25) |
			((uint32_t)input[34] << 17) |
			((uint32_t)(input[35] & 0xfe) << 9);
	output[12] = (double)(value >> 10);

	// read output[13]: from bit 287 to 308
	value = ((uint32_t)(input[35] & 0x01) << 31) |
			((uint32_t)input[36] << 23) |
			((uint32_t)input[37] << 15) |
			((uint32_t)(input[38] & 0xf8) << 7);
	output[13] = (double)(value >> 10);

	// read output[14]: from bit 309 to 330
	value = ((uint32_t)(input[38] & 0x07) << 29) |
			((uint32_t)input[39] << 21) |
			((uint32_t)input[40] << 13) |
			((uint32_t)(input[41] & 0xe0) << 5);
	output[14] = (double)(value >> 10);

	// read output[15]: from bit 331 to 352
	value = ((uint32_t)(input[41] & 0x1f) << 27) |
			((uint32_t)input[42] << 19) |
			((uint32_t)input[43] << 11) |
			((uint32_t)(input[44] & 0x80) << 3);
	output[15] = (double)(value >> 10);

	// read output[16]: from bit 353 to 374
	value = ((uint32_t)(input[44] & 0x7f) << 25) |
			((uint32_t)input[45] << 17) |
			((uint32_t)(input[46] & 0xfe) << 9);
	output[16] = (double)(value >> 10);

	// read output[17]: from bit 375 to 396
	value = ((uint32_t)(input[46] & 0x01) << 31) |
			((uint32_t)input[47] << 23) |
			((uint32_t)input[48] << 15) |
			((uint32_t)(input[49] & 0xf8) << 7);
	output[17] = (double)(value >> 10);

	// read output[18]: from bit 397 to 418
	value = ((uint32_t)(input[49] & 0x07) << 29) |
			((uint32_t)input[50] << 21) |
			((uint32_t)input[51] << 13) |
			((uint32_t)(input[52] & 0xe0) << 5);
	output[18] = (double)(value >> 10);

	// read output[19]: from bit 419 to 440
	value = ((uint32_t)(input[52] & 0x1f) << 27) |
			((uint32_t)input[53] << 19) |
			((uint32_t)input[54] << 11) |
			((uint32_t)(input[55] & 0x80) << 3);
	output[19] = (double)(value >> 10);

	// read output[20]: from bit 441 to 462
	value = ((uint32_t)(input[55] & 0x7f) << 25) |
			((uint32_t)input[56] << 17) |
			((uint32_t)(input[57] & 0xfe) << 9);
	output[20] = (double)(value >> 10);

	// read output[21]: from bit 463 to 484
	value = ((uint32_t)(input[57] & 0x01) << 31) |
			((uint32_t)input[58] << 23) |
			((uint32_t)input[59] << 15) |
			((uint32_t)(input[60] & 0xf8) << 7);
	output[21] = (double)(value >> 10);

	// read output[22]: from bit 485 to 506
	value = ((uint32_t)(input[60] & 0x07) << 29) |
			((uint32_t)input[61] << 21) |
			((uint32_t)input[62] << 13) |
			((uint32_t)(input[63] & 0xe0) << 5);
	output[22] = (double)(value >> 10);
}

static void unpack_23_22bit_unsigned_1off(const uint8_t * input, double * output, void *closure) {
	// Unpack 23 values into output
	// Values are 22-bit unsigned
	// Skip 1 bits, read 506 bits of data.
	// Input must be at least 64 bytes long

	(void)closure; // suppress unused parameter warning

	uint32_t value;

	// read output[0]: from bit 1 to 22
	value = ((uint32_t)(input[0] & 0x7f) << 25) |
			((uint32_t)input[1] << 17) |
			((uint32_t)(input[2] & 0xfe) << 9);
	output[0] = (double)(value >> 10);

	// read output[1]: from bit 23 to 44
	value = ((uint32_t)(input[2] & 0x01) << 31) |
			((uint32_t)input[3] << 23) |
			((uint32_t)input[4] << 15) |
			((uint32_t)(input[5] & 0xf8) << 7);
	output[1] = (double)(value >> 10);

	// read output[2]: from bit 45 to 66
	value = ((uint32_t)(input[5] & 0x07) << 29) |
			((uint32_t)input[6] << 21) |
			((uint32_t)input[7] << 13) |
			((uint32_t)(input[8] & 0xe0) << 5);
	output[2] = (double)(value >> 10);

	// read output[3]: from bit 67 to 88
	value = ((uint32_t)(input[8] & 0x1f) << 27) |
			((uint32_t)input[9] << 19) |
			((uint32_t)input[10] << 11) |
			((uint32_t)(input[11] & 0x80) << 3);
	output[3] = (double)(value >> 10);

	// read output[4]: from bit 89 to 110
	value = ((uint32_t)(input[11] & 0x7f) << 25) |
			((uint32_t)input[12] << 17) |
			((uint32_t)(input[13] & 0xfe) << 9);
	output[4] = (double)(value >> 10);

	// read output[5]: from bit 111 to 132
	value = ((uint32_t)(input[13] & 0x01) << 31) |
			((uint32_t)input[14] << 23) |
			((uint32_t)input[15] << 15) |
			((uint32_t)(input[16] & 0xf8) << 7);
	output[5] = (double)(value >> 10);

	// read output[6]: from bit 133 to 154
	value = (